/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetProjectConfiguration
implements IWorkingSetProjectConfiguration {
    private final IWorkingSetConfiguration workingSetConfig;
    private String projectName;
    private String selectedConfiguration;

    protected WorkingSetProjectConfiguration(IWorkingSetConfiguration parent) {
        this.workingSetConfig = parent;
    }

    @Override
    public IWorkingSetConfiguration getWorkingSetConfiguration() {
        return this.workingSetConfig;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    protected void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public IProject resolveProject() {
        IProject result = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        if (result != null && !result.isAccessible()) {
            result = null;
        }
        return result;
    }

    @Override
    public String getSelectedConfigurationID() {
        return this.selectedConfiguration;
    }

    protected void setSelectedConfigurationID(String id) {
        this.selectedConfiguration = id;
    }

    @Override
    public ICConfigurationDescription resolveSelectedConfiguration() {
        ICProjectDescription desc;
        ICConfigurationDescription result = null;
        IProject project = this.resolveProject();
        if (project != null && (desc = CoreModel.getDefault().getProjectDescription(project)) != null) {
            result = desc.getConfigurationById(this.getSelectedConfigurationID());
        }
        return result;
    }

    @Override
    public Collection<ICConfigurationDescription> resolveConfigurations() {
        ICProjectDescription desc;
        ICConfigurationDescription[] result = null;
        IProject project = this.resolveProject();
        if (project != null && (desc = CoreModel.getDefault().getProjectDescription(project)) != null) {
            result = desc.getConfigurations();
        }
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    @Override
    public boolean isActive() {
        ICConfigurationDescription desc = this.resolveSelectedConfiguration();
        return desc != null && desc.isActive();
    }

    @Override
    public void activate() {
        ICProjectDescription desc;
        ICConfigurationDescription config = this.resolveSelectedConfiguration();
        if (config != null && (desc = config.getProjectDescription()).getActiveConfiguration() != config) {
            try {
                IProject project = desc.getProject();
                desc.setActiveConfiguration(config);
                CoreModel.getDefault().setProjectDescription(project, desc);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
    }

    @Override
    public IStatus build(IProgressMonitor monitor) {
        Object result = Status.OK_STATUS;
        ICConfigurationDescription config = this.resolveSelectedConfiguration();
        if (config == null) {
            result = new Status(2, "org.eclipse.cdt.ui", NLS.bind((String)WorkingSetMessages.WSProjConfig_noConfig, (Object)this.getProjectName()));
        } else {
            if (!this.isActive()) {
                this.activate();
                result = new Status(2, "org.eclipse.cdt.ui", NLS.bind((String)WorkingSetMessages.WSProjConfig_activatedWarning, (Object)config.getName(), (Object)this.getProjectName()));
            }
            monitor = SubMonitor.convert((IProgressMonitor)monitor);
            try {
                this.resolveProject().build(10, monitor);
            }
            catch (CoreException e) {
                result = result.isOK() ? e.getStatus() : new MultiStatus("org.eclipse.cdt.ui", 0, new IStatus[]{result, e.getStatus()}, NLS.bind((String)WorkingSetMessages.WSProjConfig_buildProblem, (Object)this.getProjectName()), null);
            }
        }
        return result;
    }

    public void saveState(IMemento memento) {
        memento.putString("name", this.getProjectName());
        if (this.getSelectedConfigurationID() != null) {
            memento.putString("config", this.getSelectedConfigurationID());
        }
    }

    @Override
    public void loadState(IMemento memento) {
        this.projectName = memento.getString("name");
        this.selectedConfiguration = memento.getString("config");
    }

    @Override
    public IWorkingSetProjectConfiguration.ISnapshot createSnapshot(IWorkingSetConfiguration.ISnapshot workingSetConfig, WorkspaceSnapshot workspace) {
        return new Snapshot(workingSetConfig, this, workspace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Snapshot
    extends WorkingSetProjectConfiguration
    implements IWorkingSetProjectConfiguration.ISnapshot {
        private final IProject project;
        private final WorkspaceSnapshot workspace;

        protected Snapshot(IWorkingSetConfiguration parent, IWorkingSetProjectConfiguration projectConfig, WorkspaceSnapshot workspace) {
            super(parent);
            this.project = projectConfig.resolveProject();
            this.workspace = workspace;
            String selected = projectConfig.getSelectedConfigurationID();
            if (selected == null) {
                selected = workspace.getActiveConfigurationID(this.project);
            }
            this.setSelectedConfigurationID(selected);
        }

        @Override
        public IWorkingSetConfiguration.ISnapshot getWorkingSetConfiguration() {
            return (IWorkingSetConfiguration.ISnapshot)super.getWorkingSetConfiguration();
        }

        @Override
        public final WorkspaceSnapshot getWorkspaceSnapshot() {
            return this.workspace;
        }

        @Override
        public final IProject resolveProject() {
            return this.project;
        }

        @Override
        public final String getProjectName() {
            return this.resolveProject().getName();
        }

        @Override
        public void setSelectedConfigurationID(String id) {
            super.setSelectedConfigurationID(id);
        }

        @Override
        public boolean isActive() {
            return this.workspace.isActive(this);
        }

        @Override
        public void activate() {
            this.workspace.activate(this.resolveProject(), this.getSelectedConfigurationID());
        }

        @Override
        public IStatus build(IProgressMonitor monitor) {
            return this.workspace.build(this.resolveProject(), this.getSelectedConfigurationID(), monitor);
        }

        @Override
        public Collection<ICConfigurationDescription> resolveConfigurations() {
            return this.workspace.getConfigurations(this.resolveProject());
        }

        @Override
        public ICConfigurationDescription resolveSelectedConfiguration() {
            return this.workspace.getConfiguration(this.resolveProject(), this.getSelectedConfigurationID());
        }
    }
}

