/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTPrefUtil {
    public static final String KEY_NOSUPP = "wizard.show.unsupported.disable";
    public static final String KEY_OTHERS = "wizard.group.others.enable";
    public static final String KEY_NOMNG = "properties.manage.config.disable";
    public static final String KEY_DTREE = "properties.data.hierarchy.enable";
    public static final String KEY_NOTOOLM = "properties.toolchain.modification.disable";
    public static final String KEY_EXPORT = "properties.export.page.enable";
    public static final String KEY_SHOW_INC_FILES = "properties.includefiles.page.enable";
    public static final String KEY_TIPBOX = "properties.option.tipbox.enable";
    public static final String KEY_PREFTC = "wizard.preferred.toolchains";
    public static final String KEY_CONFSET = "workingsets.selected.configs";
    public static final String KEY_POSSAVE = "properties.save.position";
    public static final int POSITION_SAVE_SIZE = 0;
    public static final int POSITION_SAVE_NONE = 2;
    public static final int POSITION_SAVE_BOTH = 3;
    public static final String KEY_DISC_NAMES = "properties.discovery.naming";
    public static final int DISC_NAMING_UNIQUE_OR_BOTH = 0;
    public static final int DISC_NAMING_UNIQUE_OR_IDS = 1;
    public static final int DISC_NAMING_ALWAYS_BOTH = 2;
    public static final int DISC_NAMING_ALWAYS_IDS = 3;
    public static final int DISC_NAMING_DEFAULT = 0;
    public static final String KEY_DMODE = "properties.multi.displ.mode";
    public static final int DMODE_CONJUNCTION = 1;
    public static final int DMODE_DISJUNCTION = 2;
    public static final String KEY_WMODE = "properties.multi.write.mode";
    public static final int WMODE_MODIFY = 4;
    public static final int WMODE_REPLACE = 8;
    public static final String NULL = "NULL";
    private static final IPreferenceStore pref = CUIPlugin.getDefault().getPreferenceStore();
    private static final String DELIMITER = " ";
    public static final String CONFSETDEL = "\f";
    private static LinkedList<String> preferredTCs = null;
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static boolean getBool(String key) {
        return pref.getBoolean(key);
    }

    public static void setBool(String key, boolean val) {
        pref.setValue(key, val);
    }

    public static int getInt(String key) {
        return pref.getInt(key);
    }

    public static void setInt(String key, int val) {
        pref.setValue(key, val);
    }

    public static String getStr(String key) {
        return pref.getString(key);
    }

    public static void setStr(String key, String val) {
        pref.setValue(key, val);
    }

    public static void readPreferredTCs() {
        preferredTCs = new LinkedList<String>(Arrays.asList(CDTPrefUtil.getStr(KEY_PREFTC).split(DELIMITER)));
    }

    public static List<String> getPreferredTCs() {
        if (preferredTCs == null) {
            CDTPrefUtil.readPreferredTCs();
        }
        return preferredTCs;
    }

    public static void delPreferredTC(String s) {
        if (preferredTCs == null) {
            CDTPrefUtil.readPreferredTCs();
        }
        preferredTCs.remove(s);
    }

    public static void addPreferredTC(String s) {
        if (preferredTCs == null) {
            CDTPrefUtil.readPreferredTCs();
        }
        if (!preferredTCs.contains(s)) {
            preferredTCs.add(s);
        }
    }

    public static void cleanPreferredTCs() {
        CDTPrefUtil.setStr(KEY_PREFTC, "");
        CDTPrefUtil.readPreferredTCs();
    }

    public static void savePreferredTCs() {
        if (preferredTCs == null) {
            return;
        }
        Iterator it = preferredTCs.iterator();
        StringBuilder b = new StringBuilder();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s == null) continue;
            b.append(s);
            b.append(DELIMITER);
        }
        CDTPrefUtil.setStr(KEY_PREFTC, b.toString().trim());
    }

    public static String getDMode() {
        String s = null;
        switch (CDTPrefUtil.getInt(KEY_DMODE)) {
            default: {
                CDTPrefUtil.setInt(KEY_DMODE, 1);
            }
            case 1: {
                s = UIMessages.getString("EnvironmentTab.17");
                break;
            }
            case 2: {
                s = UIMessages.getString("EnvironmentTab.18");
            }
        }
        return String.valueOf(UIMessages.getString("EnvironmentTab.19")) + s;
    }

    public static String getWMode() {
        String s = null;
        switch (CDTPrefUtil.getInt(KEY_WMODE)) {
            default: {
                CDTPrefUtil.setInt(KEY_WMODE, 4);
            }
            case 4: {
                s = UIMessages.getString("EnvironmentTab.24");
                break;
            }
            case 8: {
                s = UIMessages.getString("EnvironmentTab.21");
            }
        }
        return String.valueOf(UIMessages.getString("EnvironmentTab.22")) + s;
    }

    public static void spinDMode() {
        CDTPrefUtil.setInt(KEY_DMODE, CDTPrefUtil.getInt(KEY_DMODE) == 1 ? 2 : 1);
    }

    public static void spinWMode() {
        CDTPrefUtil.setInt(KEY_WMODE, CDTPrefUtil.getInt(KEY_WMODE) == 4 ? 8 : 4);
    }

    public static final String[] getStrListForDisplay(String[][] input) {
        return CDTPrefUtil.getStrListForDisplay(input, CDTPrefUtil.getInt(KEY_DMODE));
    }

    private static final String[] getStrListForDisplay(String[][] input, int mode) {
        Object[] ob = CDTPrefUtil.getListForDisplay(input, CDTPrefUtil.getInt(KEY_DMODE), null);
        String[] ss = new String[ob.length];
        System.arraycopy(ob, 0, ss, 0, ob.length);
        return ss;
    }

    public static final Object[] getListForDisplay(Object[][] input, Comparator<Object> cmp) {
        return CDTPrefUtil.getListForDisplay(input, CDTPrefUtil.getInt(KEY_DMODE), cmp);
    }

    private static final Object[] getListForDisplay(Object[][] input, int mode, Comparator<Object> cmp) {
        if (input == null || input.length == 0) {
            return EMPTY_ARRAY;
        }
        if (input.length == 1) {
            return input[0] == null ? EMPTY_ARRAY : input[0];
        }
        Object[] s1 = input[0];
        if (s1 == null || s1.length == 0) {
            return EMPTY_ARRAY;
        }
        if (CDTPrefUtil.getInt(KEY_DMODE) == 1) {
            ArrayList<Object> lst = new ArrayList<Object>();
            int i = 0;
            while (i < s1.length) {
                if (s1[i] != null) {
                    boolean found = true;
                    int k = 1;
                    while (k < input.length) {
                        Object[] s2 = input[k];
                        if (s2 == null || s2.length == 0) {
                            return EMPTY_ARRAY;
                        }
                        if (i == 0) {
                            Arrays.sort(s2, cmp);
                        }
                        if (Arrays.binarySearch(s2, s1[i], cmp) < 0) {
                            found = false;
                            break;
                        }
                        ++k;
                    }
                    if (found) {
                        lst.add(s1[i]);
                    }
                }
                ++i;
            }
            return lst.toArray();
        }
        TreeSet<Object> lst = new TreeSet<Object>(cmp);
        Object[][] objectArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] element = objectArray[n2];
            if (element != null && element.length != 0) {
                Object[] objectArray2 = element;
                int n3 = element.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object element2 = objectArray2[n4];
                    lst.add(element2);
                    ++n4;
                }
            }
            ++n2;
        }
        s1 = lst.toArray();
        Arrays.sort(s1, cmp);
        return s1;
    }

    @Deprecated
    public static List<String> readConfigSets() {
        return new LinkedList<String>(Arrays.asList(CDTPrefUtil.getStr(KEY_CONFSET).split(CONFSETDEL)));
    }

    @Deprecated
    public static void saveConfigSets(List<String> out) {
        StringBuilder b = new StringBuilder();
        for (String s : out) {
            if (s == null) continue;
            b.append(s);
            b.append(CONFSETDEL);
        }
        CDTPrefUtil.setStr(KEY_CONFSET, b.toString());
    }
}

