/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import com.ibm.icu.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.dialogs.IInputStatusValidator;
import org.eclipse.cdt.ui.dialogs.InputStatusDialog;
import org.eclipse.cdt.ui.dialogs.RegexErrorParserOptionPage;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ErrorParsTab
extends AbstractCPropertyTab {
    private static final int DEFAULT_HEIGHT = 130;
    private static final int BUTTON_ADD = 0;
    private static final int BUTTON_EDIT = 1;
    private static final int BUTTON_DELETE = 2;
    private static final int BUTTON_MOVEUP = 4;
    private static final int BUTTON_MOVEDOWN = 5;
    private static final String[] BUTTONS;
    private static final String OOPS = "OOPS";
    private Table fTable;
    private CheckboxTableViewer fTableViewer;
    private ICConfigurationDescription fCfgDesc;
    private final Map<String, IErrorParserNamed> fAvailableErrorParsers = new LinkedHashMap<String, IErrorParserNamed>();
    private final Map<String, ICOptionPage> fOptionsPageMap = new HashMap<String, ICOptionPage>();
    private ICOptionPage fCurrentOptionsPage = null;
    private Composite fCompositeForOptionsPage;

    static {
        String[] stringArray = new String[6];
        stringArray[0] = ADD_STR;
        stringArray[1] = EDIT_STR;
        stringArray[2] = DEL_STR;
        stringArray[4] = MOVEUP_STR;
        stringArray[5] = MOVEDOWN_STR;
        BUTTONS = stringArray;
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.usercomp, "org.eclipse.cdt.ui.newproj_parser_error");
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        SashForm sashForm = new SashForm(this.usercomp, 0);
        sashForm.setBackground(sashForm.getDisplay().getSystemColor(15));
        sashForm.setOrientation(512);
        sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        sashForm.setLayout((Layout)layout);
        Composite compositeSashForm = new Composite((Composite)sashForm, 0);
        compositeSashForm.setLayout((Layout)new GridLayout(2, false));
        this.fTable = new Table(compositeSashForm, 2084);
        this.fTable.setLayoutData((Object)new GridData(1808));
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorParsTab.this.displaySelectedOptionPage();
                ErrorParsTab.this.updateButtons();
            }
        });
        this.fTableViewer = new CheckboxTableViewer(this.fTable);
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String name;
                    String id = (String)element;
                    IErrorParserNamed errorParser = (IErrorParserNamed)ErrorParsTab.this.fAvailableErrorParsers.get(id);
                    if (errorParser != null && (name = errorParser.getName()) != null && name.length() > 0) {
                        return name;
                    }
                    return UIMessages.getFormattedString("ErrorParsTab.error.NonAccessibleID", id);
                }
                return ErrorParsTab.OOPS;
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                ErrorParsTab.this.saveChecked();
            }
        });
        Composite compositeButtons = new Composite(compositeSashForm, 0);
        compositeButtons.setLayoutData((Object)new GridData(3));
        this.initButtons(compositeButtons, BUTTONS);
        this.fCompositeForOptionsPage = new Composite((Composite)sashForm, 0);
        GridData gd = new GridData();
        this.fCompositeForOptionsPage.setLayout((Layout)new TabFolderLayout());
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHorizontalDLUsToPixels(130);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.fCompositeForOptionsPage.setLayoutData((Object)gd);
        sashForm.setWeights(new int[]{50, 50});
        ICResourceDescription resDecs = this.getResDesc();
        this.fCfgDesc = resDecs != null ? resDecs.getConfiguration() : null;
        this.initMapParsers();
        this.updateData(this.getResDesc());
    }

    private void initMapParsers() {
        Object[] ids;
        this.fAvailableErrorParsers.clear();
        this.fOptionsPageMap.clear();
        String[] stringArray = ErrorParserManager.getErrorParserAvailableIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IErrorParserNamed errorParser = ErrorParserManager.getErrorParserCopy((String)id);
            this.fAvailableErrorParsers.put(id, errorParser);
            this.initializeOptionsPage(id);
            ++n2;
        }
        if (this.fCfgDesc != null) {
            ICConfigurationDescription srcCfgDesc = this.fCfgDesc.getConfiguration();
            if (srcCfgDesc instanceof ICMultiConfigDescription) {
                String[][] ss = ((ICMultiConfigDescription)srcCfgDesc).getErrorParserIDs();
                ids = CDTPrefUtil.getStrListForDisplay(ss);
            } else {
                ids = srcCfgDesc.getBuildSetting().getErrorParserIDs();
            }
            LinkedHashSet<String> setIds = new LinkedHashSet<String>(Arrays.asList(ids));
            setIds.addAll(this.fAvailableErrorParsers.keySet());
            this.fTableViewer.setInput((Object)setIds.toArray(new String[0]));
        } else {
            this.fTableViewer.setInput((Object)this.fAvailableErrorParsers.keySet().toArray(new String[0]));
            ids = ErrorParserManager.getDefaultErrorParserIds();
        }
        this.fTableViewer.setCheckedElements(ids);
        this.displaySelectedOptionPage();
    }

    private void initializeOptionsPage(String id) {
        String name;
        IErrorParserNamed errorParser = this.fAvailableErrorParsers.get(id);
        if (errorParser != null && (name = errorParser.getName()) != null && name.length() > 0 && errorParser instanceof RegexErrorParser) {
            RegexErrorParserOptionPage optionsPage = new RegexErrorParserOptionPage((RegexErrorParser)errorParser, this.isErrorParsersEditable());
            this.fOptionsPageMap.put(id, optionsPage);
            optionsPage.setContainer(this.page);
            optionsPage.createControl(this.fCompositeForOptionsPage);
            optionsPage.setVisible(false);
            this.fCompositeForOptionsPage.layout(true);
        }
    }

    private void displaySelectedOptionPage() {
        int pos;
        if (this.fCurrentOptionsPage != null) {
            this.fCurrentOptionsPage.setVisible(false);
        }
        if ((pos = this.fTable.getSelectionIndex()) < 0) {
            return;
        }
        String parserId = (String)this.fTable.getItem(pos).getData();
        ICOptionPage optionsPage = this.fOptionsPageMap.get(parserId);
        if (optionsPage != null) {
            optionsPage.setVisible(true);
        }
        this.fCurrentOptionsPage = optionsPage;
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.addErrorParser();
                break;
            }
            case 1: {
                this.editErrorParser();
                break;
            }
            case 2: {
                this.deleteErrorParser();
                break;
            }
            case 4: {
                this.moveItem(true);
                break;
            }
            case 5: {
                this.moveItem(false);
                break;
            }
        }
        this.updateButtons();
    }

    private void moveItem(boolean up) {
        int n = this.fTable.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.fTable.getItemCount()) {
            return;
        }
        String id = (String)this.fTableViewer.getElementAt(n);
        boolean checked = this.fTableViewer.getChecked((Object)id);
        this.fTableViewer.remove((Object)id);
        n = up ? n - 1 : n + 1;
        this.fTableViewer.insert((Object)id, n);
        this.fTableViewer.setChecked((Object)id, checked);
        this.fTable.setSelection(n);
        this.saveChecked();
    }

    private String makeId(String name) {
        return "org.eclipse.cdt.ui." + name;
    }

    private void addErrorParser() {
        IInputStatusValidator inputValidator = new IInputStatusValidator(){

            public IStatus isValid(String newText) {
                StatusInfo status = new StatusInfo();
                if (newText.trim().length() == 0) {
                    status.setError(UIMessages.getString("ErrorParsTab.error.NonEmptyName"));
                } else if (newText.indexOf(59) >= 0) {
                    String message = MessageFormat.format((String)UIMessages.getString("ErrorParsTab.error.IllegalCharacter"), (Object[])new Object[]{Character.valueOf(';')});
                    status.setError(message);
                } else if (ErrorParsTab.this.fAvailableErrorParsers.containsKey(ErrorParsTab.this.makeId(newText))) {
                    status.setError(UIMessages.getString("ErrorParsTab.error.NonUniqueID"));
                }
                return status;
            }
        };
        InputStatusDialog addDialog = new InputStatusDialog(this.usercomp.getShell(), UIMessages.getString("ErrorParsTab.title.Add"), UIMessages.getString("ErrorParsTab.label.EnterName"), UIMessages.getString("ErrorParsTab.label.DefaultRegexErrorParserName"), inputValidator);
        addDialog.setHelpAvailable(false);
        if (addDialog.open() == 0) {
            String newName = addDialog.getValue();
            String newId = this.makeId(newName);
            RegexErrorParser errorParser = new RegexErrorParser(newId, newName);
            this.fAvailableErrorParsers.put(newId, (IErrorParserNamed)errorParser);
            this.fTableViewer.add((Object)newId);
            this.fTableViewer.setChecked((Object)newId, true);
            this.fTable.setSelection(this.fTable.getItemCount() - 1);
            this.initializeOptionsPage(newId);
            this.displaySelectedOptionPage();
            this.updateButtons();
        }
    }

    private void editErrorParser() {
        int n = this.fTable.getSelectionIndex();
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        String id = (String)this.fTableViewer.getElementAt(n);
        IErrorParserNamed errorParser = this.fAvailableErrorParsers.get(id);
        IInputStatusValidator inputValidator = new IInputStatusValidator(){

            public IStatus isValid(String newText) {
                StatusInfo status = new StatusInfo();
                if (newText.trim().length() == 0) {
                    status.setError(UIMessages.getString("ErrorParsTab.error.NonEmptyName"));
                } else if (newText.indexOf(59) >= 0) {
                    String message = MessageFormat.format((String)UIMessages.getString("ErrorParsTab.error.IllegalCharacter"), (Object[])new Object[]{Character.valueOf(';')});
                    status.setError(message);
                }
                return status;
            }
        };
        InputStatusDialog addDialog = new InputStatusDialog(this.usercomp.getShell(), UIMessages.getString("ErrorParsTab.title.Edit"), UIMessages.getString("ErrorParsTab.label.EnterName"), errorParser.getName(), inputValidator);
        addDialog.setHelpAvailable(false);
        if (addDialog.open() == 0) {
            errorParser.setName(addDialog.getValue());
            this.fTableViewer.refresh((Object)id);
        }
    }

    private void deleteErrorParser() {
        int n = this.fTable.getSelectionIndex();
        if (n < 0) {
            return;
        }
        this.fTableViewer.remove(this.fTableViewer.getElementAt(n));
        int last = this.fTable.getItemCount() - 1;
        if (n > last) {
            n = last;
        }
        if (n >= 0) {
            this.fTable.setSelection(n);
        }
        this.saveChecked();
    }

    public void updateData(ICResourceDescription resDecs) {
        ICConfigurationDescription oldCfgDesc = this.fCfgDesc;
        ICConfigurationDescription iCConfigurationDescription = this.fCfgDesc = resDecs != null ? resDecs.getConfiguration() : null;
        if (oldCfgDesc != this.fCfgDesc) {
            this.initMapParsers();
        }
        this.displaySelectedOptionPage();
        this.updateButtons();
    }

    private static boolean isExtensionId(String id) {
        String[] stringArray = ErrorParserManager.getErrorParserExtensionIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extId = stringArray[n2];
            if (extId.equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void updateButtons() {
        int pos = this.fTable.getSelectionIndex();
        int count = this.fTable.getItemCount();
        int last = count - 1;
        boolean selected = pos >= 0 && pos <= last;
        String id = (String)this.fTableViewer.getElementAt(pos);
        this.buttonSetEnabled(0, this.isErrorParsersEditable());
        this.buttonSetEnabled(1, this.isErrorParsersEditable() && selected);
        this.buttonSetEnabled(2, this.isErrorParsersEditable() && selected && !ErrorParsTab.isExtensionId(id));
        this.buttonSetEnabled(4, selected && pos != 0);
        this.buttonSetEnabled(5, selected && pos != last);
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOK();
        if (!this.page.isForPrefs()) {
            ICConfigurationDescription sd = src.getConfiguration();
            ICConfigurationDescription dd = dst.getConfiguration();
            String[] s = null;
            if (sd instanceof ICMultiConfigDescription) {
                String[][] ss = ((ICMultiConfigDescription)sd).getErrorParserIDs();
                s = CDTPrefUtil.getStrListForDisplay(ss);
            } else {
                s = sd.getBuildSetting().getErrorParserIDs();
            }
            if (dd instanceof ICMultiConfigDescription) {
                ((ICMultiConfigDescription)dd).setErrorParserIDs(s);
            } else {
                dd.getBuildSetting().setErrorParserIDs(s);
            }
            this.initMapParsers();
        }
    }

    protected void performOK() {
        this.informPages(true);
        if (this.page.isForPrefs()) {
            if (this.fCfgDesc == null) {
                try {
                    IErrorParserNamed[] errorParsers = new IErrorParserNamed[this.fTable.getItemCount()];
                    int i = 0;
                    TableItem[] tableItemArray = this.fTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getData() instanceof String) {
                            String id = (String)item.getData();
                            errorParsers[i] = this.fAvailableErrorParsers.get(id);
                            ++i;
                        }
                        ++n2;
                    }
                    Object[] checkedElements = this.fTableViewer.getCheckedElements();
                    String[] checkedErrorParserIds = new String[checkedElements.length];
                    System.arraycopy(checkedElements, 0, checkedErrorParserIds, 0, checkedElements.length);
                    ErrorParserManager.setUserDefinedErrorParsers((IErrorParserNamed[])errorParsers);
                    ErrorParserManager.setDefaultErrorParserIds((String[])checkedErrorParserIds);
                }
                catch (BackingStoreException e) {
                    CUIPlugin.log(UIMessages.getString("ErrorParsTab.error.OnApplyingSettings"), e);
                }
                catch (CoreException e) {
                    CUIPlugin.log(UIMessages.getString("ErrorParsTab.error.OnApplyingSettings"), e);
                }
            }
            this.initMapParsers();
        }
    }

    private void saveChecked() {
        if (this.fCfgDesc != null) {
            Object[] objs = this.fTableViewer.getCheckedElements();
            String[] ids = new String[objs.length];
            System.arraycopy(objs, 0, ids, 0, objs.length);
            if (this.fCfgDesc instanceof ICMultiConfigDescription) {
                ((ICMultiConfigDescription)this.fCfgDesc).setErrorParserIDs(ids);
            } else {
                this.fCfgDesc.getBuildSetting().setErrorParserIDs(ids);
            }
        }
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    private boolean isErrorParsersEditable() {
        return this.fCfgDesc == null;
    }

    protected void performDefaults() {
        if (this.isErrorParsersEditable()) {
            if (MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)UIMessages.getString("ErrorParsTab.title.ConfirmReset"), (String)UIMessages.getString("ErrorParsTab.message.ConfirmReset"))) {
                try {
                    ErrorParserManager.setUserDefinedErrorParsers(null);
                    ErrorParserManager.setDefaultErrorParserIds(null);
                }
                catch (BackingStoreException e) {
                    CUIPlugin.log(UIMessages.getString("ErrorParsTab.error.OnRestoring"), e);
                }
                catch (CoreException e) {
                    CUIPlugin.log(UIMessages.getString("ErrorParsTab.error.OnRestoring"), e);
                }
            }
        } else if (this.fCfgDesc instanceof ICMultiConfigDescription) {
            ((ICMultiConfigDescription)this.fCfgDesc).setErrorParserIDs(null);
        } else {
            this.fCfgDesc.getBuildSetting().setErrorParserIDs(null);
        }
        this.initMapParsers();
        this.updateButtons();
    }

    private void informPages(boolean apply) {
        Collection<ICOptionPage> pages = this.fOptionsPageMap.values();
        for (ICOptionPage dynamicPage : pages) {
            if (dynamicPage == null || !dynamicPage.isValid() || dynamicPage.getControl() == null) continue;
            try {
                if (apply) {
                    dynamicPage.performApply((IProgressMonitor)new NullProgressMonitor());
                    continue;
                }
                dynamicPage.performDefaults();
            }
            catch (CoreException e) {
                CUIPlugin.log(UIMessages.getString("ErrorParsTab.error.OnApplyingSettings"), e);
            }
        }
    }
}

