/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFChildrenSubExpressions
extends TCFChildren {
    private final TCFNode node;
    private final int par_level;
    private final int par_offs;
    private final int par_size;

    TCFChildrenSubExpressions(TCFNode node, int par_level, int par_offs, int par_size) {
        super(node.channel, 128);
        this.node = node;
        this.par_level = par_level;
        this.par_offs = par_offs;
        this.par_size = par_size;
    }

    void onSuspended() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (!(n instanceof TCFNodeExpression)) continue;
            ((TCFNodeExpression)n).onSuspended();
        }
    }

    void onCastToTypeChanged() {
        this.cancel();
        TCFNode[] a = this.getNodes().toArray(new TCFNode[this.getNodes().size()]);
        int i = 0;
        while (i < a.length) {
            a[i].dispose();
            ++i;
        }
    }

    private TCFNodeExpression findField(TCFDataCache<ISymbols.Symbol> field, boolean deref) {
        assert (field != null);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (field != e.getField() || e.isDeref() != deref) continue;
            return e;
        }
        return null;
    }

    private HashMap<String, TCFNode> findFields(ISymbols.Symbol type, String[] children, boolean deref) {
        int cnt = 0;
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> field = this.node.getModel().getSymbolInfoCache(id);
            TCFNodeExpression n3 = this.findField(field, deref);
            if (n3 == null) {
                n3 = new TCFNodeExpression(this.node, null, field, null, -1, deref);
            }
            n3.setSortPosition(cnt++);
            data.put(n3.id, n3);
            ++n2;
        }
        return data;
    }

    private TCFNodeExpression findIndex(int index, boolean deref) {
        assert (index >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (e.getIndex() != index || e.isDeref() != deref) continue;
            return e;
        }
        return null;
    }

    private TCFNodeArrayPartition findPartition(int offs, int size) {
        assert (offs >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeArrayPartition e = (TCFNodeArrayPartition)n;
            if (e.getOffset() != offs || e.getSize() != size) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        assert (!this.isDisposed());
        TCFNode exp = this.node;
        while (exp != null) {
            if (exp instanceof TCFNodeExpression) break;
            exp = exp.parent;
        }
        TCFDataCache<ISymbols.Symbol> type_cache = ((TCFNodeExpression)exp).getType();
        if (!type_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
        if (type_data == null) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        ISymbols.TypeClass type_class = type_data.getTypeClass();
        if (this.par_level > 0 && type_class != ISymbols.TypeClass.array) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        if (type_class == ISymbols.TypeClass.composite) {
            TCFDataCache<String[]> children_cache = this.node.model.getSymbolChildrenCache(type_data.getID());
            if (children_cache == null) {
                this.set(null, null, new HashMap<String, TCFNode>());
                return true;
            }
            if (!children_cache.validate((Runnable)((Object)this))) {
                return false;
            }
            String[] children_data = (String[])children_cache.getData();
            HashMap<String, TCFNode> data = null;
            if (children_data != null) {
                data = this.findFields(type_data, children_data, false);
            }
            this.set(null, children_cache.getError(), data);
            return true;
        }
        if (type_class == ISymbols.TypeClass.array) {
            int size;
            HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
            int offs = this.par_level > 0 ? this.par_offs : 0;
            int n = size = this.par_level > 0 ? this.par_size : type_data.getLength();
            if (size <= 100) {
                int i = offs;
                while (i < offs + size) {
                    TCFNodeExpression n2 = this.findIndex(i, false);
                    if (n2 == null) {
                        n2 = new TCFNodeExpression(this.node, null, null, null, i, false);
                    }
                    n2.setSortPosition(i);
                    data.put(n2.id, n2);
                    ++i;
                }
            } else {
                int next_size = 100;
                while (size / next_size > 100) {
                    next_size *= 100;
                }
                int i = offs;
                while (i < offs + size) {
                    TCFNodeArrayPartition n3;
                    int sz = next_size;
                    if (i + sz > offs + size) {
                        sz = offs + size - i;
                    }
                    if ((n3 = this.findPartition(i, sz)) == null) {
                        n3 = new TCFNodeArrayPartition(this.node, this.par_level + 1, i, sz);
                    }
                    data.put(n3.id, n3);
                    i += next_size;
                }
            }
            this.set(null, null, data);
            return true;
        }
        if (type_class == ISymbols.TypeClass.pointer) {
            TCFDataCache<ISymbols.Symbol> base_type_cache;
            HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
            TCFDataCache<IExpressions.Value> value = ((TCFNodeExpression)exp).getValue();
            if (!value.validate((Runnable)((Object)this))) {
                return false;
            }
            IExpressions.Value v = (IExpressions.Value)value.getData();
            if (v != null && !this.isNull(v.getValue()) && (base_type_cache = this.node.model.getSymbolInfoCache(type_data.getBaseTypeID())) != null) {
                if (!base_type_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                if (base_type_data == null || base_type_data.getSize() != 0) {
                    if (base_type_data.getTypeClass() == ISymbols.TypeClass.composite) {
                        TCFDataCache<String[]> children_cache = this.node.model.getSymbolChildrenCache(base_type_data.getID());
                        if (children_cache != null) {
                            if (!children_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            String[] children_data = (String[])children_cache.getData();
                            if (children_data != null) {
                                data = this.findFields(type_data, children_data, true);
                            }
                        }
                    } else {
                        TCFNodeExpression n = this.findIndex(0, true);
                        if (n == null) {
                            n = new TCFNodeExpression(this.node, null, null, null, 0, true);
                        }
                        n.setSortPosition(0);
                        data.put(n.id, n);
                    }
                }
            }
            this.set(null, null, data);
            return true;
        }
        this.set(null, null, new HashMap<String, TCFNode>());
        return true;
    }

    private boolean isNull(byte[] data) {
        if (data == null) {
            return true;
        }
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

