/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.ICastToType;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNumberFormat;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeExpression
extends TCFNode
implements IElementEditor,
ICastToType {
    private final String script;
    private final int index;
    private final boolean deref;
    private final TCFDataCache<ISymbols.Symbol> field;
    private final TCFDataCache<IExpressions.Expression> var_expression;
    private final TCFDataCache<String> text;
    private final TCFDataCache<Expression> expression;
    private final TCFDataCache<IExpressions.Value> value;
    private final TCFDataCache<ISymbols.Symbol> type;
    private final TCFChildrenSubExpressions children;
    private final TCFDataCache<String> type_name;
    private final TCFDataCache<String> string;
    private int sort_pos;
    private IExpressions.Value prev_value;
    private IExpressions.Value next_value;
    private static int expr_cnt;
    private static final ICellModifier cell_modifier;

    static {
        cell_modifier = new ICellModifier(){

            public boolean canModify(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return (Boolean)new TCFTask<Boolean>(){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.script != null);
                            return;
                        }
                        if (!node.expression.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.expression.getData() != null && ((Expression)((TCFNodeExpression)node).expression.getData()).expression.canAssign()) {
                            if ("HexValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                return;
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                }.getE();
            }

            public Object getValue(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return new TCFTask<String>(){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.script);
                            return;
                        }
                        if (!node.value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.value.getData() != null) {
                            if ("HexValue".equals(property)) {
                                this.done(node.toNumberString(16));
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(node.toNumberString(10));
                                return;
                            }
                        }
                        this.done(null);
                    }
                }.getE();
            }

            public void modify(Object element, final String property, final Object value) {
                if (value == null) {
                    return;
                }
                final TCFNodeExpression node = (TCFNodeExpression)element;
                new TCFTask<Boolean>(){

                    public void run() {
                        try {
                            IExpressions.Expression exp;
                            if ("Name".equals(property)) {
                                if (!node.script.equals(value)) {
                                    IExpression e;
                                    IExpressionManager m = DebugPlugin.getDefault().getExpressionManager();
                                    IExpression[] iExpressionArray = m.getExpressions();
                                    int n = iExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        e = iExpressionArray[n2];
                                        if (node.script.equals(e.getExpressionText())) {
                                            m.removeExpression(e);
                                        }
                                        ++n2;
                                    }
                                    e = m.newWatchExpression((String)value);
                                    m.addExpression(e);
                                }
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (!node.expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.expression.getData() != null && (exp = ((Expression)((TCFNodeExpression)node).expression.getData()).expression).canAssign()) {
                                byte[] bf = null;
                                int size = exp.getSize();
                                boolean is_float = false;
                                boolean big_endian = false;
                                boolean signed = false;
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                IExpressions.Value eval = (IExpressions.Value)node.value.getData();
                                if (eval != null) {
                                    switch (eval.getTypeClass()) {
                                        case real: {
                                            is_float = true;
                                        }
                                        case integer: {
                                            signed = true;
                                        }
                                    }
                                    big_endian = eval.isBigEndian();
                                    size = eval.getValue().length;
                                }
                                String input = (String)value;
                                String error = null;
                                if ("HexValue".equals(property)) {
                                    error = TCFNumberFormat.isValidHexNumber(input);
                                    if (error == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 16, false, size, signed, big_endian);
                                    }
                                } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, signed, big_endian);
                                }
                                if (error != null) {
                                    throw new Exception("Invalid value: " + value, new Exception(error));
                                }
                                if (bf != null) {
                                    IExpressions exps = (IExpressions)node.model.getLaunch().getService(IExpressions.class);
                                    exps.assign(exp.getID(), bf, new IExpressions.DoneAssign(){

                                        public void doneAssign(IToken token, Exception error) {
                                            TCFNodeExpression n = node;
                                            while (n.parent instanceof TCFNodeExpression) {
                                                n = (TCFNodeExpression)n.parent;
                                            }
                                            n.onSuspended();
                                            if (error != null) {
                                                node.model.showMessageBox("Cannot modify element value", error);
                                                this.done(Boolean.FALSE);
                                            } else {
                                                node.value.reset();
                                                node.addModelDelta(3072);
                                                this.done(Boolean.TRUE);
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            this.done(Boolean.FALSE);
                        }
                        catch (Throwable x) {
                            node.model.showMessageBox("Cannot modify element value", x);
                            this.done(Boolean.FALSE);
                        }
                    }
                }.getE();
            }
        };
    }

    TCFNodeExpression(final TCFNode parent, final String script, final TCFDataCache<ISymbols.Symbol> field, final String var_id, final int index, final boolean deref) {
        super(parent, var_id != null ? var_id : "Expr" + expr_cnt++);
        assert (script != null || field != null || var_id != null || index >= 0);
        this.script = script;
        this.field = field;
        this.index = index;
        this.deref = deref;
        this.var_expression = new TCFDataCache<IExpressions.Expression>(this.channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                if (exps == null || var_id == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = exps.getContext(var_id, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.text = new TCFDataCache<String>(this.channel){

            protected boolean startDataRetrieval() {
                if (script != null) {
                    this.set(null, null, script);
                    return true;
                }
                if (var_id != null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Throwable err = null;
                    String exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() == null) {
                        err = TCFNodeExpression.this.var_expression.getError();
                    } else {
                        exp = ((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData()).getExpression();
                        if (exp == null) {
                            err = new Exception("Missing 'Expression' property");
                        }
                    }
                    this.set(null, err, exp);
                    return true;
                }
                TCFNode n = parent;
                while (n instanceof TCFNodeArrayPartition) {
                    n = n.parent;
                }
                TCFDataCache<String> t = ((TCFNodeExpression)n).getExpressionText();
                if (!t.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)t.getData();
                if (e == null) {
                    this.set(null, t.getError(), null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(n.id);
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if (field != null) {
                    if (!field.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    if (field.getData() == null) {
                        this.set(null, field.getError(), null);
                        return true;
                    }
                    String name = ((ISymbols.Symbol)field.getData()).getName();
                    if (name == null) {
                        this.set(null, new Exception("Field nas no name"), null);
                        return true;
                    }
                    e = deref ? "(" + e + ")->" + name : "(" + e + ")." + name;
                } else if (index == 0) {
                    e = "*(" + e + ")";
                } else if (index > 0) {
                    e = "(" + e + ")[" + index + "]";
                }
                this.set(null, null, e);
                return true;
            }
        };
        this.expression = new TCFDataCache<Expression>(this.channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                if (exps == null) {
                    this.set(null, null, null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id);
                if (var_id != null && cast == null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() != null) {
                        exp = new Expression((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData());
                    }
                    this.set(null, TCFNodeExpression.this.var_expression.getError(), exp);
                    return true;
                }
                if (!TCFNodeExpression.this.text.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)TCFNodeExpression.this.text.getData();
                if (e == null) {
                    this.set(null, TCFNodeExpression.this.text.getError(), null);
                    return true;
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                TCFNode n = parent;
                while (n instanceof TCFNodeExpression || n instanceof TCFNodeArrayPartition) {
                    n = n.parent;
                }
                if (n instanceof TCFNodeStackFrame && ((TCFNodeStackFrame)n).isEmulated()) {
                    n = n.parent;
                }
                this.command = exps.create(n.id, null, e, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                        Expression e = null;
                        if (context != null) {
                            e = new Expression(context);
                            e.must_be_disposed = true;
                        }
                        if (!this.isDisposed()) {
                            this.set(token, error, e);
                        } else if (e != null) {
                            e.dispose();
                        }
                    }
                });
                return false;
            }

            public void cancel() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.cancel();
            }

            public void dispose() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.dispose();
            }
        };
        this.value = new TCFDataCache<IExpressions.Value>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                    return false;
                }
                Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                if (exp == null) {
                    this.set(null, TCFNodeExpression.this.expression.getError(), null);
                    return true;
                }
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                this.command = exps.evaluate(exp.expression.getID(), new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                        this.set(token, error, value);
                    }
                });
                return false;
            }

            public void reset() {
                super.reset();
            }
        };
        this.type = new TCFDataCache<ISymbols.Symbol>(this.channel){

            protected boolean startDataRetrieval() {
                String type_id = null;
                if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                if (val != null) {
                    type_id = val.getTypeID();
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                    if (exp != null) {
                        type_id = exp.expression.getTypeID();
                    }
                }
                if (type_id == null) {
                    this.set(null, TCFNodeExpression.this.value.getError(), null);
                    return true;
                }
                TCFDataCache<ISymbols.Symbol> type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_id);
                if (type_cache == null) {
                    this.set(null, null, null);
                    return true;
                }
                if (!type_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                return true;
            }
        };
        this.string = new TCFDataCache<String>(this.channel){
            IMemory.MemoryContext mem;
            ISymbols.Symbol base_type_data;
            boolean big_endian;
            BigInteger addr;
            byte[] buf;
            int size;
            int offs;

            /*
             * Enabled aggressive block sorting
             */
            protected boolean startDataRetrieval() {
                if (this.addr != null && this.size == 0) {
                    if (this.buf == null) {
                        this.buf = new byte[256];
                    }
                    if (this.offs >= this.buf.length) {
                        byte[] tmp = new byte[this.buf.length * 2];
                        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                        this.buf = tmp;
                    }
                    this.command = this.mem.get((Number)this.addr.add(BigInteger.valueOf(this.offs)), 1, this.buf, this.offs, 1, 0, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            if (error != null) {
                                this.set(command, (Throwable)error, null);
                            } else if (buf[offs] == 0 || offs >= 2048) {
                                this.set(command, null, TCFNodeExpression.this.toASCIIString(buf, 0, offs));
                            } else if (command == token) {
                                command = null;
                                ++offs;
                                this.run();
                            }
                        }
                    });
                    return false;
                }
                if (this.addr != null) {
                    if (this.offs != this.size) {
                        if (this.buf == null || this.buf.length < this.size) {
                            this.buf = new byte[this.size];
                        }
                        this.command = this.mem.get((Number)this.addr, 1, this.buf, 0, this.size, 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                if (error != null) {
                                    this.set(command, (Throwable)error, null);
                                } else if (command == token) {
                                    command = null;
                                    offs = size;
                                    this.run();
                                }
                            }
                        });
                        return false;
                    }
                    StringBuffer bf = new StringBuffer();
                    if (!TCFNodeExpression.this.appendCompositeValueText(bf, 1, this.base_type_data, this.buf, 0, this.size, this.big_endian, (Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, null, bf.toString());
                    return true;
                }
                TCFNode n = parent;
                while (n != null) {
                    if (n instanceof TCFNodeExecContext) {
                        TCFDataCache<IMemory.MemoryContext> mem_cache = ((TCFNodeExecContext)n).getMemoryContext();
                        if (!mem_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        this.mem = (IMemory.MemoryContext)mem_cache.getData();
                        if (this.mem != null) break;
                    }
                    n = n.parent;
                }
                if (this.mem != null) {
                    if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    ISymbols.Symbol type_data = (ISymbols.Symbol)TCFNodeExpression.this.type.getData();
                    if (type_data != null) {
                        switch (type_data.getTypeClass()) {
                            case pointer: 
                            case array: {
                                TCFDataCache<ISymbols.Symbol> base_type_cahce = TCFNodeExpression.this.model.getSymbolInfoCache(type_data.getBaseTypeID());
                                if (base_type_cahce == null) break;
                                if (!base_type_cahce.validate((Runnable)((Object)this))) {
                                    return false;
                                }
                                this.base_type_data = (ISymbols.Symbol)base_type_cahce.getData();
                                if (this.base_type_data == null) break;
                                this.offs = 0;
                                this.size = this.base_type_data.getSize();
                                switch (this.base_type_data.getTypeClass()) {
                                    case cardinal: 
                                    case integer: {
                                        if (this.base_type_data.getSize() != 1) break;
                                        this.size = 0;
                                    }
                                    case composite: {
                                        if (this.base_type_data.getSize() == 0 || type_data.getTypeClass() == ISymbols.TypeClass.array && this.base_type_data.getTypeClass() == ISymbols.TypeClass.composite) break;
                                        if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                                            return false;
                                        }
                                        IExpressions.Value v = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                                        if (v == null) break;
                                        byte[] data = v.getValue();
                                        if (type_data.getTypeClass() == ISymbols.TypeClass.array) {
                                            this.set(null, null, TCFNodeExpression.this.toASCIIString(data, 0, data.length));
                                            return true;
                                        }
                                        this.big_endian = v.isBigEndian();
                                        BigInteger a = TCFNodeExpression.this.toBigInteger(data, 0, data.length, this.big_endian, false);
                                        if (a.equals(BigInteger.valueOf(0L))) break;
                                        this.addr = a;
                                        Protocol.invokeLater((Runnable)((Object)this));
                                        return false;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
                this.set(null, null, null);
                return true;
            }

            public void reset() {
                super.reset();
                this.addr = null;
            }
        };
        this.type_name = new TCFDataCache<String>(this.channel){

            protected boolean startDataRetrieval() {
                String name;
                block32: {
                    ISymbols.Symbol type_symbol;
                    name = null;
                    TCFDataCache<ISymbols.Symbol> type_cache = TCFNodeExpression.this.type;
                    do {
                        String s = null;
                        boolean get_base_type = false;
                        if (!type_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        type_symbol = (ISymbols.Symbol)type_cache.getData();
                        if (type_symbol != null) {
                            s = type_symbol.getName();
                            if (s != null && type_symbol.getTypeClass() == ISymbols.TypeClass.composite) {
                                s = "struct " + s;
                            }
                            if (s == null && type_symbol.getSize() == 0) {
                                s = "void";
                            }
                            if (s == null) {
                                block0 : switch (type_symbol.getTypeClass()) {
                                    case integer: {
                                        switch (type_symbol.getSize()) {
                                            case 1: {
                                                s = "char";
                                                break block0;
                                            }
                                            case 2: {
                                                s = "short";
                                                break block0;
                                            }
                                            case 4: {
                                                s = "int";
                                                break block0;
                                            }
                                            case 8: {
                                                s = "long long";
                                                break block0;
                                            }
                                        }
                                        s = "<Integer>";
                                        break;
                                    }
                                    case cardinal: {
                                        switch (type_symbol.getSize()) {
                                            case 1: {
                                                s = "unsigned char";
                                                break block0;
                                            }
                                            case 2: {
                                                s = "unsigned short";
                                                break block0;
                                            }
                                            case 4: {
                                                s = "unsigned";
                                                break block0;
                                            }
                                            case 8: {
                                                s = "unsigned long long";
                                                break block0;
                                            }
                                        }
                                        s = "<Unsigned>";
                                        break;
                                    }
                                    case real: {
                                        switch (type_symbol.getSize()) {
                                            case 4: {
                                                s = "float";
                                                break block0;
                                            }
                                            case 8: {
                                                s = "double";
                                                break block0;
                                            }
                                        }
                                        s = "<Float>";
                                        break;
                                    }
                                    case pointer: {
                                        s = "*";
                                        get_base_type = true;
                                        break;
                                    }
                                    case array: {
                                        s = "[" + type_symbol.getLength() + "]";
                                        get_base_type = true;
                                        break;
                                    }
                                    case composite: {
                                        s = "<Structure>";
                                        break;
                                    }
                                    case function: {
                                        s = "<Function>";
                                    }
                                }
                            }
                        }
                        if (s == null) {
                            name = "N/A";
                            break block32;
                        }
                        name = name == null ? s : (!get_base_type ? String.valueOf(s) + " " + name : String.valueOf(s) + name);
                        if (!get_base_type) break block32;
                    } while ((type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_symbol.getBaseTypeID())) != null);
                    name = "N/A";
                }
                this.set(null, null, name);
                return true;
            }
        };
        this.children = new TCFChildrenSubExpressions(this, 0, 0, 0);
    }

    @Override
    void dispose() {
        this.var_expression.dispose();
        this.value.dispose();
        this.type.dispose();
        this.type_name.dispose();
        this.string.dispose();
        this.children.dispose();
        this.expression.dispose();
        super.dispose();
    }

    @Override
    void dispose(String id) {
        this.children.dispose(id);
    }

    void onSuspended() {
        this.prev_value = this.next_value;
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onSuspended();
        this.addModelDelta(3072);
    }

    @Override
    public void onCastToTypeChanged() {
        this.expression.cancel();
        this.value.cancel();
        this.type.cancel();
        this.type_name.cancel();
        this.string.cancel();
        this.children.onCastToTypeChanged();
        this.addModelDelta(3072);
    }

    String getScript() {
        return this.script;
    }

    TCFDataCache<ISymbols.Symbol> getField() {
        return this.field;
    }

    int getIndex() {
        return this.index;
    }

    boolean isDeref() {
        return this.deref;
    }

    void setSortPosition(int sort_pos) {
        this.sort_pos = sort_pos;
    }

    TCFDataCache<String> getExpressionText() {
        return this.text;
    }

    TCFDataCache<IExpressions.Value> getValue() {
        return this.value;
    }

    @Override
    public TCFDataCache<ISymbols.Symbol> getType() {
        return this.type;
    }

    private String toASCIIString(byte[] data, int offs, int size) {
        StringBuffer bf = new StringBuffer();
        bf.append('\"');
        int i = 0;
        while (i < size) {
            int ch = data[offs + i] & 0xFF;
            if (ch >= 32 && ch < 127) {
                bf.append((char)ch);
            } else {
                switch (ch) {
                    case 13: {
                        bf.append("\\r");
                        break;
                    }
                    case 10: {
                        bf.append("\\n");
                        break;
                    }
                    case 8: {
                        bf.append("\\b");
                        break;
                    }
                    case 9: {
                        bf.append("\\t");
                        break;
                    }
                    case 12: {
                        bf.append("\\f");
                        break;
                    }
                    default: {
                        bf.append('\\');
                        bf.append((char)(48 + ch / 64));
                        bf.append((char)(48 + ch / 8 % 8));
                        bf.append((char)(48 + ch % 8));
                    }
                }
            }
            ++i;
        }
        if (data.length <= offs + size || data[offs + size] == 0) {
            bf.append('\"');
        } else {
            bf.append("...");
        }
        return bf.toString();
    }

    private BigInteger toBigInteger(byte[] data, int offs, int size, boolean big_endian, boolean sign_extension) {
        assert (offs + size <= data.length);
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[size];
        } else {
            temp = new byte[size + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, offs, temp, sign_extension ? 0 : 1, size);
        } else {
            int i = 0;
            while (i < size) {
                temp[temp.length - i - 1] = data[i + offs];
                ++i;
            }
        }
        return new BigInteger(temp);
    }

    private String toNumberString(int radix, ISymbols.Symbol t, byte[] data, int offs, int size, boolean big_endian) {
        String s = null;
        if (data == null) {
            s = "N/A";
        }
        if (s == null && size == 0) {
            s = "";
        }
        if (s == null && radix == 10 && size <= 16 && t != null) {
            block0 : switch (t.getTypeClass()) {
                case integer: {
                    s = this.toBigInteger(data, offs, size, big_endian, true).toString();
                    break;
                }
                case real: {
                    switch (t.getSize()) {
                        case 4: {
                            s = Float.toString(Float.intBitsToFloat(this.toBigInteger(data, offs, size, big_endian, true).intValue()));
                            break block0;
                        }
                        case 8: {
                            s = Double.toString(Double.longBitsToDouble(this.toBigInteger(data, offs, size, big_endian, true).longValue()));
                        }
                    }
                }
            }
        }
        if (s == null && size <= 16) {
            s = this.toBigInteger(data, offs, size, big_endian, false).toString(radix);
            switch (radix) {
                case 8: {
                    if (s.startsWith("0")) break;
                    s = "0" + s;
                    break;
                }
                case 16: {
                    int l = size * 2 - s.length();
                    if (l < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    s = String.valueOf("0000000000000000".substring(0, l)) + s;
                }
            }
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private String toNumberString(int radix) {
        String s = null;
        IExpressions.Value val = (IExpressions.Value)this.value.getData();
        if (val != null) {
            byte[] data = val.getValue();
            s = this.toNumberString(radix, (ISymbols.Symbol)this.type.getData(), data, 0, data.length, val.isBigEndian());
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private void setLabel(ILabelUpdate result, String name, int col, int radix) {
        String s = this.toNumberString(radix);
        if (name == null) {
            result.setLabel(s, col);
        } else {
            result.setLabel(String.valueOf(name) + " = " + s, col);
        }
    }

    private boolean setTypeLabel(ILabelUpdate result, int col, Runnable done) {
        if (!this.type_name.validate(done)) {
            return false;
        }
        result.setLabel((String)this.type_name.getData(), col);
        return true;
    }

    private boolean isValueChanged(IExpressions.Value x, IExpressions.Value y) {
        if (x == null || y == null) {
            return false;
        }
        byte[] xb = x.getValue();
        byte[] yb = y.getValue();
        if (xb == null || yb == null) {
            return false;
        }
        if (xb.length != yb.length) {
            return true;
        }
        int i = 0;
        while (i < xb.length) {
            if (xb[i] != yb[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        String c;
        int i;
        Throwable error;
        String cast;
        Object pending = null;
        if (this.field != null && !this.field.validate()) {
            pending = this.field;
        }
        if (!this.text.validate()) {
            pending = this.text;
        }
        if (!this.value.validate()) {
            pending = this.value;
        }
        if (!this.type.validate()) {
            pending = this.type;
        }
        if (!this.type_name.validate()) {
            pending = this.type_name;
        }
        if (pending != null) {
            pending.wait(done);
            return false;
        }
        String name = null;
        if (this.index >= 0) {
            name = this.index == 0 && this.deref ? "*" : "[" + this.index + "]";
        }
        if (name == null && this.field != null && this.field.getData() != null) {
            name = ((ISymbols.Symbol)this.field.getData()).getName();
        }
        if (name == null && this.text.getData() != null) {
            name = (String)this.text.getData();
        }
        if (name != null && (cast = this.model.getCastToType(this.id)) != null) {
            name = "(" + cast + ")(" + name + ")";
        }
        if ((error = this.text.getError()) == null) {
            error = this.value.getError();
        }
        String[] cols = result.getColumnIds();
        if (error != null) {
            if (cols == null || cols.length <= 1) {
                result.setForeground(new RGB(255, 0, 0), 0);
                result.setLabel(String.valueOf(name) + ": N/A", 0);
            } else {
                i = 0;
                while (i < cols.length) {
                    c = cols[i];
                    if (c.equals("Name")) {
                        result.setLabel(name, i);
                    } else if (c.equals("Type")) {
                        if (!this.setTypeLabel(result, i, done)) {
                            return false;
                        }
                    } else {
                        result.setForeground(new RGB(255, 0, 0), i);
                        result.setLabel("N/A", i);
                    }
                    ++i;
                }
            }
        } else if (cols == null) {
            this.setLabel(result, name, 0, 16);
        } else {
            i = 0;
            while (i < cols.length) {
                c = cols[i];
                if (c.equals("Name")) {
                    result.setLabel(name, i);
                } else if (c.equals("Type")) {
                    if (!this.setTypeLabel(result, i, done)) {
                        return false;
                    }
                } else if (c.equals("HexValue")) {
                    this.setLabel(result, null, i, 16);
                } else if (c.equals("DecValue")) {
                    this.setLabel(result, null, i, 10);
                }
                ++i;
            }
        }
        this.next_value = (IExpressions.Value)this.value.getData();
        if (this.isValueChanged(this.prev_value, this.next_value)) {
            RGB c2 = new RGB(255, 255, 0);
            result.setBackground(c2, 0);
            if (cols != null) {
                int i2 = 1;
                while (i2 < cols.length) {
                    result.setBackground(c2, i2);
                    ++i2;
                }
            }
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/genericvariable_obj.gif"), 0);
        return true;
    }

    private void appendErrorText(StringBuffer bf, Throwable error) {
        if (error == null) {
            return;
        }
        bf.append("Exception: ");
        bf.append(TCFModel.getErrorMessage(error, true));
    }

    private boolean appendArrayValueText(StringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        assert (offs + size <= data.length);
        int length = type.getLength();
        bf.append('[');
        if (length > 0) {
            int elem_size = size / length;
            int n = 0;
            while (n < length) {
                if (n >= 100) {
                    bf.append("...");
                    break;
                }
                if (n > 0) {
                    bf.append(", ");
                }
                if (!this.appendValueText(bf, level + 1, type.getBaseTypeID(), data, offs + n * elem_size, elem_size, big_endian, done)) {
                    return false;
                }
                ++n;
            }
        }
        bf.append(']');
        return true;
    }

    private boolean appendCompositeValueText(StringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            bf.append("{...}");
            return true;
        }
        if (!children_cache.validate(done)) {
            return false;
        }
        String[] children_data = (String[])children_cache.getData();
        if (children_data == null) {
            bf.append("{...}");
            return true;
        }
        bf.append('{');
        String[] stringArray = children_data;
        int n = children_data.length;
        int n2 = 0;
        while (n2 < n) {
            TCFDataCache<ISymbols.Symbol> field_cache;
            String id = stringArray[n2];
            if (id != children_data[0]) {
                bf.append(", ");
            }
            if (!(field_cache = this.model.getSymbolInfoCache(id)).validate(done)) {
                return false;
            }
            ISymbols.Symbol field_data = (ISymbols.Symbol)field_cache.getData();
            if (field_data == null || offs + field_data.getOffset() + field_data.getSize() > data.length) {
                bf.append('?');
            } else {
                bf.append(field_data.getName());
                bf.append('=');
                if (!this.appendValueText(bf, level + 1, field_data.getTypeID(), data, offs + field_data.getOffset(), field_data.getSize(), big_endian, done)) {
                    return false;
                }
            }
            ++n2;
        }
        bf.append('}');
        return true;
    }

    private boolean appendValueText(StringBuffer bf, int level, String type_id, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        if (data == null) {
            return true;
        }
        ISymbols.Symbol type_data = null;
        if (type_id != null) {
            TCFDataCache<ISymbols.Symbol> type_cache = this.model.getSymbolInfoCache(type_id);
            if (!type_cache.validate(done)) {
                return false;
            }
            type_data = (ISymbols.Symbol)type_cache.getData();
        }
        if (type_data == null) {
            if (level == 0) {
                bf.append("Type: not available\n");
                bf.append("Size: ");
                bf.append(data.length);
                bf.append(data.length == 1 ? " byte\n" : " bytes\n");
                bf.append("Hex: ");
                bf.append(this.toNumberString(16, type_data, data, 0, data.length, big_endian));
                bf.append("\n");
            } else {
                bf.append(this.toNumberString(16, type_data, data, 0, data.length, big_endian));
            }
            return true;
        }
        if (level == 0) {
            if (!this.string.validate(done)) {
                return false;
            }
            Throwable e = this.string.getError();
            String s = (String)this.string.getData();
            if (s != null) {
                bf.append(s);
                bf.append("\n");
            } else if (e != null) {
                bf.append("Cannot read pointed value: ");
                bf.append(TCFModel.getErrorMessage(e, true));
            }
        }
        if (type_data.getSize() > 0) {
            switch (type_data.getTypeClass()) {
                case cardinal: 
                case integer: 
                case real: 
                case enumeration: {
                    if (level == 0) {
                        bf.append("Dec: ");
                        bf.append(this.toNumberString(10, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Oct: ");
                        bf.append(this.toNumberString(8, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Hex: ");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        break;
                    }
                    if (type_data.getTypeClass() == ISymbols.TypeClass.cardinal) {
                        bf.append("0x");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        break;
                    }
                    bf.append(this.toNumberString(10, type_data, data, offs, size, big_endian));
                    break;
                }
                case pointer: 
                case function: {
                    if (level == 0) {
                        bf.append("Oct: ");
                        bf.append(this.toNumberString(8, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Hex: ");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        break;
                    }
                    bf.append("0x");
                    bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                    break;
                }
                case array: {
                    if (!this.appendArrayValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    if (level != 0) break;
                    bf.append("\n");
                    break;
                }
                case composite: {
                    if (!this.appendCompositeValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    if (level != 0) break;
                    bf.append("\n");
                }
            }
        }
        if (level == 0) {
            if (!this.type_name.validate(done)) {
                return false;
            }
            String nm = (String)this.type_name.getData();
            if (nm != null) {
                bf.append("Type: ");
                bf.append(nm);
                bf.append("\n");
            }
            bf.append("Size: ");
            bf.append(type_data.getSize());
            bf.append(type_data.getSize() == 1 ? " byte\n" : " bytes\n");
        }
        return true;
    }

    String getDetailText(Runnable done) {
        IExpressions.Value v;
        if (!this.expression.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        this.appendErrorText(bf, this.expression.getError());
        if (bf.length() == 0) {
            this.appendErrorText(bf, this.value.getError());
        }
        if (bf.length() == 0 && (v = (IExpressions.Value)this.value.getData()) != null) {
            byte[] data = v.getValue();
            boolean big_endian = v.isBigEndian();
            if (!this.appendValueText(bf, 0, v.getTypeID(), data, 0, data.length, big_endian, done)) {
                return null;
            }
        }
        return bf.toString();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        TCFNode[] arr = this.children.toArray();
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setHasChilren(this.children.size() > 0);
        return true;
    }

    @Override
    int getRelevantModelDeltaFlags(IPresentationContext p) {
        if ("org.eclipse.debug.ui.ExpressionView".equals(p.getId()) || "org.eclipse.debug.ui.VariableView".equals(p.getId())) {
            return super.getRelevantModelDeltaFlags(p);
        }
        return 0;
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeExpression e = (TCFNodeExpression)n;
        if (this.sort_pos < e.sort_pos) {
            return -1;
        }
        if (this.sort_pos > e.sort_pos) {
            return 1;
        }
        return 0;
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("Name".equals(column_id) && this.script != null) {
            return new TextCellEditor(parent);
        }
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    private class Expression {
        final IExpressions.Expression expression;
        boolean must_be_disposed;

        Expression(IExpressions.Expression expression) {
            assert (expression != null);
            this.expression = expression;
        }

        void dispose() {
            if (!this.must_be_disposed) {
                return;
            }
            if (TCFNodeExpression.this.channel.getState() == 1) {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.channel.getRemoteService(IExpressions.class);
                exps.dispose(this.expression.getID(), new IExpressions.DoneDispose(){

                    public void doneDispose(IToken token, Exception error) {
                        if (error == null) {
                            return;
                        }
                        if (((Expression)Expression.this).TCFNodeExpression.this.channel.getState() != 1) {
                            return;
                        }
                        Activator.log("Error disposing remote expression evaluator", error);
                    }
                });
            }
            this.must_be_disposed = false;
        }
    }
}

