/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.Arrays;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNumberFormat;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

public class TCFNodeRegister
extends TCFNode
implements IElementEditor {
    private final TCFDataCache<IRegisters.RegistersContext> context;
    private final TCFDataCache<byte[]> value;
    private byte[] prev_value;
    private byte[] next_value;
    private static final RGB rgb_error = new RGB(255, 0, 0);
    private static final RGB rgb_highlight = new RGB(255, 255, 0);
    private int index;
    private static final ICellModifier cell_modifier = new ICellModifier(){

        public boolean canModify(Object element, final String property) {
            final TCFNodeRegister node = (TCFNodeRegister)element;
            return (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    if (!node.context.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (node.context.getData() != null && ((IRegisters.RegistersContext)node.context.getData()).isWriteable()) {
                        if ("HexValue".equals(property)) {
                            this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                            return;
                        }
                        if ("DecValue".equals(property)) {
                            this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                            return;
                        }
                    }
                    this.done(Boolean.FALSE);
                }
            }.getE();
        }

        public Object getValue(Object element, final String property) {
            final TCFNodeRegister node = (TCFNodeRegister)element;
            return new TCFTask<String>(){

                public void run() {
                    if (!node.value.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (node.value.getData() != null) {
                        if ("HexValue".equals(property)) {
                            this.done(node.toNumberString(16));
                            return;
                        }
                        if ("DecValue".equals(property)) {
                            this.done(node.toNumberString(10));
                            return;
                        }
                    }
                    this.done(null);
                }
            }.getE();
        }

        public void modify(Object element, final String property, final Object value) {
            if (value == null) {
                return;
            }
            final TCFNodeRegister node = (TCFNodeRegister)element;
            new TCFTask<Boolean>(){

                public void run() {
                    try {
                        if (!node.context.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                        if (ctx != null && ctx.isWriteable()) {
                            byte[] bf = null;
                            boolean is_float = ctx.isFloat();
                            int size = ctx.getSize();
                            boolean big_endian = ctx.isBigEndian();
                            String input = (String)value;
                            String error = null;
                            if ("HexValue".equals(property)) {
                                error = TCFNumberFormat.isValidHexNumber(input);
                                if (error == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 16, false, size, false, big_endian);
                                }
                            } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, is_float, big_endian);
                            }
                            if (error != null) {
                                throw new Exception("Invalid value: " + value, new Exception(error));
                            }
                            if (bf != null) {
                                ctx.set(bf, new IRegisters.DoneSet(){

                                    public void doneSet(IToken token, Exception error) {
                                        if (error != null) {
                                            node.model.showMessageBox("Cannot modify register value", error);
                                            this.done(Boolean.FALSE);
                                        } else {
                                            node.value.reset();
                                            node.addModelDelta(2048);
                                            this.done(Boolean.TRUE);
                                        }
                                    }
                                });
                                return;
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                    catch (Throwable x) {
                        node.model.showMessageBox("Cannot modify register value", x);
                        this.done(Boolean.FALSE);
                    }
                }
            }.getE();
        }
    };

    TCFNodeRegister(TCFNode parent, final String id) {
        super(parent, id);
        this.context = new TCFDataCache<IRegisters.RegistersContext>(this.channel){

            protected boolean startDataRetrieval() {
                IRegisters regs = (IRegisters)TCFNodeRegister.this.model.getLaunch().getService(IRegisters.class);
                this.command = regs.getContext(id, new IRegisters.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.value = new TCFDataCache<byte[]>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeRegister.this.context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)TCFNodeRegister.this.context.getData();
                if (ctx == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = ctx.get(new IRegisters.DoneGet(){

                    public void doneGet(IToken token, Exception error, byte[] value) {
                        this.set(token, error, value);
                    }
                });
                return false;
            }
        };
    }

    public void dispose() {
        this.context.dispose();
        this.value.dispose();
        super.dispose();
    }

    void setIndex(int index) {
        this.index = index;
    }

    private void appendErrorText(StringBuffer bf, Throwable error) {
        if (error == null) {
            return;
        }
        bf.append("Exception: ");
        bf.append(TCFModel.getErrorMessage(error, true));
    }

    String getDetailText(Runnable done) {
        if (!this.context.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        this.appendErrorText(bf, this.context.getError());
        if (bf.length() == 0) {
            this.appendErrorText(bf, this.value.getError());
        }
        if (bf.length() == 0) {
            byte[] v;
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
            if (ctx != null) {
                if (ctx.getDescription() != null) {
                    bf.append(ctx.getDescription());
                    bf.append('\n');
                }
                int l = bf.length();
                if (ctx.isReadable()) {
                    bf.append("readable");
                }
                if (ctx.isReadOnce()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("read once");
                }
                if (ctx.isWriteable()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("writable");
                }
                if (ctx.isWriteOnce()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("write once");
                }
                if (ctx.hasSideEffects()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("side effects");
                }
                if (l < bf.length()) {
                    bf.append('\n');
                }
            }
            if ((v = (byte[])this.value.getData()) != null) {
                bf.append("Hex: ");
                bf.append(this.toNumberString(16));
                bf.append(", ");
                bf.append("Dec: ");
                bf.append(this.toNumberString(10));
                bf.append(", ");
                bf.append("Oct: ");
                bf.append(this.toNumberString(8));
                bf.append('\n');
            }
        }
        return bf.toString();
    }

    protected boolean getData(ILabelUpdate result, Runnable done) {
        int i;
        TCFDataCache<IRegisters.RegistersContext> pending = null;
        if (!this.context.validate()) {
            pending = this.context;
        }
        if (!this.value.validate()) {
            pending = this.value;
        }
        if (pending != null) {
            pending.wait(done);
            return false;
        }
        String[] cols = result.getColumnIds();
        if (cols == null) {
            this.setLabel(result, -1, 16);
        } else {
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
            i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (ctx == null) {
                    result.setForeground(rgb_error, i);
                    result.setLabel("N/A", i);
                } else if (c.equals("Name")) {
                    result.setLabel(ctx.getName(), i);
                } else if (c.equals("HexValue")) {
                    this.setLabel(result, i, 16);
                } else if (c.equals("DecValue")) {
                    this.setLabel(result, i, 10);
                } else if (c.equals("Description")) {
                    result.setLabel(ctx.getDescription(), i);
                } else if (c.equals("Readable")) {
                    result.setLabel(this.bool(ctx.isReadable()), i);
                } else if (c.equals("ReadOnce")) {
                    result.setLabel(this.bool(ctx.isReadOnce()), i);
                } else if (c.equals("Writeable")) {
                    result.setLabel(this.bool(ctx.isWriteable()), i);
                } else if (c.equals("WriteOnce")) {
                    result.setLabel(this.bool(ctx.isWriteOnce()), i);
                } else if (c.equals("SideEffects")) {
                    result.setLabel(this.bool(ctx.hasSideEffects()), i);
                } else if (c.equals("Volatile")) {
                    result.setLabel(this.bool(ctx.isVolatile()), i);
                } else if (c.equals("Float")) {
                    result.setLabel(this.bool(ctx.isFloat()), i);
                } else if (c.equals("Menimonic")) {
                    result.setLabel(this.getMnemonic(ctx), i);
                }
                ++i;
            }
        }
        boolean changed = false;
        this.next_value = (byte[])this.value.getData();
        if (this.prev_value != null && this.next_value != null) {
            if (this.prev_value.length != this.next_value.length) {
                changed = true;
            } else {
                i = 0;
                while (i < this.prev_value.length) {
                    if (this.prev_value[i] != this.next_value[i]) {
                        changed = true;
                    }
                    ++i;
                }
            }
        }
        if (changed) {
            result.setBackground(rgb_highlight, 0);
            if (cols != null) {
                i = 1;
                while (i < cols.length) {
                    result.setBackground(rgb_highlight, i);
                    ++i;
                }
            }
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/genericregister_obj.gif"), 0);
        return true;
    }

    private void setLabel(ILabelUpdate result, int col, int radix) {
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        Throwable error = this.context.getError();
        if (error == null) {
            error = this.value.getError();
        }
        byte[] data = (byte[])this.value.getData();
        if (error != null || ctx == null || data == null) {
            result.setForeground(rgb_error, col);
            result.setLabel("N/A", col);
        } else {
            String s = this.toNumberString(radix);
            if (col >= 0) {
                result.setLabel(s, col);
            } else {
                result.setLabel(String.valueOf(ctx.getName()) + " = " + s, 0);
            }
        }
    }

    private String toNumberString(int radix) {
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        byte[] data = (byte[])this.value.getData();
        if (ctx == null || data == null) {
            return "N/A";
        }
        byte[] temp = new byte[data.length + 1];
        temp[0] = 0;
        if (ctx.isBigEndian()) {
            System.arraycopy(data, 0, temp, 1, data.length);
        } else {
            int i = 0;
            while (i < data.length) {
                temp[temp.length - i - 1] = data[i];
                ++i;
            }
        }
        String s = new BigInteger(temp).toString(radix);
        switch (radix) {
            case 8: {
                if (s.startsWith("0")) break;
                s = "0" + s;
                break;
            }
            case 16: {
                int l = data.length * 2 - s.length();
                if (l < 0) {
                    l = 0;
                }
                if (l > 16) {
                    l = 16;
                }
                s = String.valueOf("0000000000000000".substring(0, l)) + s;
            }
        }
        return s;
    }

    private String bool(boolean b) {
        return b ? "yes" : "no";
    }

    private String getMnemonic(IRegisters.RegistersContext ctx) {
        IRegisters.NamedValue[] arr;
        if (this.value.getData() != null && (arr = ctx.getNamedValues()) != null) {
            IRegisters.NamedValue[] namedValueArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.NamedValue n3 = namedValueArray[n2];
                if (Arrays.equals(n3.getValue(), (byte[])this.value.getData())) {
                    return n3.getName();
                }
                ++n2;
            }
        }
        return "";
    }

    int getRelevantModelDeltaFlags(IPresentationContext p) {
        if ("org.eclipse.debug.ui.RegisterView".equals(p.getId())) {
            return super.getRelevantModelDeltaFlags(p);
        }
        return 0;
    }

    void onValueChanged() {
        this.prev_value = this.next_value;
        this.value.reset();
        TCFNode n = this.parent;
        while (n != null) {
            if (n instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)n).onRegisterValueChanged();
            }
            n = n.parent;
        }
        this.addModelDelta(2048);
    }

    void onSuspended() {
        this.prev_value = this.next_value;
        this.value.reset();
        this.addModelDelta(2048);
    }

    void onRegistersChanged() {
        this.context.reset();
        this.value.reset();
        this.addModelDelta(2048);
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeRegister) {
            TCFNodeRegister r = (TCFNodeRegister)n;
            if (this.index < r.index) {
                return -1;
            }
            if (this.index > r.index) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }
}

