/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import org.eclipse.tm.internal.tcf.debug.ui.model.ISymbolOwner;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeSymbol
extends TCFNode {
    private final TCFDataCache<ISymbols.Symbol> context;
    private final TCFDataCache<String[]> children;
    private int update_policy;
    private ISymbolOwner owner;
    private TCFNodeSymbol prev;
    private TCFNodeSymbol next;
    private static final int MAX_SYMBOL_COUNT = 1000;
    private static TCFNodeSymbol sym_list;
    private static int sym_count;

    protected TCFNodeSymbol(TCFNode parent, final String id) {
        super(parent, id);
        this.context = new TCFDataCache<ISymbols.Symbol>(this.channel){

            protected boolean startDataRetrieval() {
                ISymbols syms = (ISymbols)TCFNodeSymbol.this.model.getLaunch().getService(ISymbols.class);
                if (id == null || syms == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = syms.getContext(id, new ISymbols.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, ISymbols.Symbol sym) {
                        this.set(token, error, sym);
                        if (error != null || sym == null) {
                            TCFNodeSymbol.this.setUpdatePolicy(null, 0);
                        } else {
                            TCFNodeSymbol.this.setUpdatePolicy(sym.getOwnerID(), sym.getUpdatePolicy());
                        }
                    }
                });
                return false;
            }
        };
        this.children = new TCFDataCache<String[]>(this.channel){

            protected boolean startDataRetrieval() {
                ISymbols syms = (ISymbols)TCFNodeSymbol.this.model.getLaunch().getService(ISymbols.class);
                if (id == null || syms == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = syms.getChildren(id, new ISymbols.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] ids) {
                        this.set(token, error, ids);
                    }
                });
                return false;
            }
        };
        this.setUpdatePolicy(null, 0);
        if (sym_list == null) {
            this.prev = this.next = this;
        } else {
            this.prev = sym_list;
            this.next = TCFNodeSymbol.sym_list.next;
            this.prev.next = this.next.prev = this;
        }
        sym_list = this;
        if (++sym_count > 1000) {
            TCFNodeSymbol.sym_list.next.dispose();
        }
    }

    @Override
    public void dispose() {
        assert (!this.disposed);
        if (this.owner != null) {
            this.owner.removeSymbol(this);
            this.owner = null;
        }
        this.context.dispose();
        this.children.dispose();
        if (sym_list == this) {
            sym_list = this.prev;
        }
        if (sym_list == this) {
            sym_list = null;
        } else {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }
        this.next = null;
        this.prev = null;
        assert (--sym_count == 0 == (sym_list == null));
        super.dispose();
    }

    public TCFDataCache<ISymbols.Symbol> getContext() {
        if (sym_list != this) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = sym_list;
            this.next = TCFNodeSymbol.sym_list.next;
            this.prev.next = this.next.prev = this;
            sym_list = this;
        }
        return this.context;
    }

    public TCFDataCache<String[]> getChildren() {
        if (sym_list != this) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = sym_list;
            this.next = TCFNodeSymbol.sym_list.next;
            this.prev.next = this.next.prev = this;
            sym_list = this;
        }
        return this.children;
    }

    private void setUpdatePolicy(String id, int policy) {
        this.update_policy = policy;
        if (!this.disposed) {
            TCFNode n = this.model.getNode(id);
            if (!(n instanceof ISymbolOwner)) {
                n = this.parent;
            }
            if (n != this.owner) {
                if (this.owner != null) {
                    this.owner.removeSymbol(this);
                }
                this.owner = (ISymbolOwner)((Object)n);
                this.owner.addSymbol(this);
            }
        }
    }

    void onMemoryMapChanged() {
        this.context.reset();
        this.children.reset();
    }

    void onExeStateChange() {
        if (this.update_policy == 0) {
            return;
        }
        this.context.reset();
        this.children.reset();
    }
}

