/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf;

import javax.net.ssl.SSLContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.tcf.EventQueue;
import org.eclipse.tm.tcf.core.ChannelTCP;
import org.eclipse.tm.tcf.internal.extensions.TcfServiceProvidersExtensionPointManager;
import org.eclipse.tm.tcf.protocol.IEventQueue;
import org.eclipse.tm.tcf.protocol.ILogger;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.ssl.TCFSecurityManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.tm.tcf";
    private static Activator plugin;
    private static boolean debug;
    private static final EventQueue queue;
    private static final BundleListener bundle_listener;

    static {
        queue = new EventQueue();
        bundle_listener = new BundleListener(){
            private boolean started = false;

            public void bundleChanged(BundleEvent event) {
                if (plugin != null && !this.started && event.getBundle() == plugin.getBundle() && plugin.getBundle().getState() == 32) {
                    queue.start();
                    this.started = true;
                }
            }
        };
    }

    public Activator() {
        plugin = this;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        debug = Platform.inDebugMode();
        ChannelTCP.setSSLContext((SSLContext)TCFSecurityManager.createSSLContext());
        Protocol.setLogger((ILogger)new ILogger(){

            public void log(String msg, Throwable x) {
                if (debug) {
                    System.err.println(msg);
                    if (x != null) {
                        x.printStackTrace();
                    }
                }
                if (plugin != null && Activator.this.getLog() != null) {
                    Activator.this.getLog().log((IStatus)new Status(4, Activator.this.getBundle().getSymbolicName(), 0, msg, x));
                }
            }
        });
        Protocol.setEventQueue((IEventQueue)queue);
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                Activator.this.runTCFStartup();
            }
        });
        context.addBundleListener(bundle_listener);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener(bundle_listener);
        queue.shutdown();
        plugin = null;
        super.stop(context);
    }

    private void runTCFStartup() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "startup");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                try {
                    Bundle bundle = Platform.getBundle((String)extensions[i].getNamespaceIdentifier());
                    bundle.start(1);
                    IConfigurationElement[] e = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < e.length) {
                        String nm = e[j].getName();
                        if (nm.equals("class")) {
                            Class c = bundle.loadClass(e[j].getAttribute("name"));
                            Class.forName(c.getName(), true, c.getClassLoader());
                        }
                        ++j;
                    }
                }
                catch (Throwable x) {
                    Protocol.log((String)"TCF startup error", (Throwable)x);
                }
                ++i;
            }
        }
        catch (Exception x) {
            Protocol.log((String)"TCF startup error", (Throwable)x);
        }
        TcfServiceProvidersExtensionPointManager.getInstance().registerServiceProviders();
    }
}

