/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.AbstarctCodanCMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class CodanProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final String EXTENSION_POINT_NAME = "codanMarkerResolution";
    private static Map<String, Collection<ConditionalResolution>> resolutions = new HashMap<String, Collection<ConditionalResolution>>();
    private static boolean resolutionsLoaded = false;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String id;
        if (!resolutionsLoaded) {
            CodanProblemMarkerResolutionGenerator.readExtensions();
        }
        if ((id = marker.getAttribute("org.eclipse.core.resources.problemmarker", null)) == null) {
            return new IMarkerResolution[0];
        }
        String message = marker.getAttribute("message", "");
        Collection<ConditionalResolution> collection = resolutions.get(id);
        if (collection != null) {
            ArrayList<IMarkerResolution> list = new ArrayList<IMarkerResolution>();
            for (ConditionalResolution res : collection) {
                if (res.messagePattern != null && !message.matches(res.messagePattern) || res.res instanceof AbstarctCodanCMarkerResolution && !((AbstarctCodanCMarkerResolution)res.res).isApplicable(marker)) continue;
                list.add(res.res);
            }
            if (list.size() > 0) {
                return list.toArray(new IMarkerResolution[list.size()]);
            }
        }
        return new IMarkerResolution[0];
    }

    private static synchronized void readExtensions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.ui", EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        try {
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configurationElement = elements[i];
                CodanProblemMarkerResolutionGenerator.processResolution(configurationElement);
                ++i;
            }
        }
        finally {
            resolutionsLoaded = true;
        }
    }

    private static void processResolution(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals("resolution")) {
            IMarkerResolution res;
            String id = configurationElement.getAttribute("problemId");
            if (id == null) {
                CodanUIActivator.log("Extension for codanMarkerResolution problemId is not defined");
                return;
            }
            try {
                res = (IMarkerResolution)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                CodanUIActivator.log(e);
                return;
            }
            String messagePattern = configurationElement.getAttribute("messagePattern");
            if (messagePattern != null) {
                try {
                    Pattern.compile(messagePattern);
                }
                catch (Exception e) {
                    CodanUIActivator.log("Extension for codanMarkerResolution messagePattern is invalid: " + e.getMessage());
                    return;
                }
            }
            ConditionalResolution co = new ConditionalResolution(res, messagePattern);
            CodanProblemMarkerResolutionGenerator.addResolution(id, co);
        }
    }

    public static void addResolution(String id, IMarkerResolution res, String messagePattern) {
        CodanProblemMarkerResolutionGenerator.addResolution(id, new ConditionalResolution(res, messagePattern));
    }

    private static void addResolution(String id, ConditionalResolution res) {
        Collection<ConditionalResolution> collection = resolutions.get(id);
        if (collection == null) {
            collection = new ArrayList<ConditionalResolution>();
            resolutions.put(id, collection);
        }
        collection.add(res);
    }

    static class ConditionalResolution {
        IMarkerResolution res;
        String messagePattern;

        public ConditionalResolution(IMarkerResolution res2, String messagePattern2) {
            this.res = res2;
            this.messagePattern = messagePattern2;
        }
    }
}

