/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;

public class LRDigraphTrigraphTests
extends TestCase {
    public static TestSuite suite() {
        return new TestSuite(LRDigraphTrigraphTests.class);
    }

    public LRDigraphTrigraphTests() {
    }

    public LRDigraphTrigraphTests(String name) {
        super(name);
    }

    protected IASTTranslationUnit parse(String code) {
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(true);
        options.setCheckPreprocessorProblems(true);
        return ParseHelper.parse(code, this.getCLanguage(), options);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    public void testTrigraphSequences() {
        String code = "??=define SIZE  ??/ \n99 \nint main(void)??<  \n    int arr??(SIZE??);  \n    arr??(4??) = '0' - (??-0 ??' 1 ??! 2);  \n    printf(\"%c??/n\", arr??(4??)); \n??> \n";
        IASTTranslationUnit tu = this.parse(code);
        LRDigraphTrigraphTests.assertNotNull((Object)tu);
        IASTPreprocessorStatement[] defines = tu.getAllPreprocessorStatements();
        LRDigraphTrigraphTests.assertEquals((int)1, (int)defines.length);
        IASTPreprocessorMacroDefinition macro = (IASTPreprocessorMacroDefinition)defines[0];
        LRDigraphTrigraphTests.assertEquals((String)"SIZE", (String)macro.getName().toString());
        IASTFunctionDefinition main = (IASTFunctionDefinition)tu.getDeclarations()[0];
        IASTCompoundStatement body = (IASTCompoundStatement)main.getBody();
        IASTStatement[] statements = body.getStatements();
        LRDigraphTrigraphTests.assertEquals((int)3, (int)statements.length);
        IASTSimpleDeclaration arr = (IASTSimpleDeclaration)((IASTDeclarationStatement)statements[0]).getDeclaration();
        IASTArrayDeclarator arr_decl = (IASTArrayDeclarator)arr.getDeclarators()[0];
        IASTArrayModifier modifier = arr_decl.getArrayModifiers()[0];
        IASTLiteralExpression lit = (IASTLiteralExpression)modifier.getConstantExpression();
        LRDigraphTrigraphTests.assertEquals((int)0, (int)lit.getKind());
        IASTBinaryExpression expr = (IASTBinaryExpression)((IASTExpressionStatement)statements[1]).getExpression();
        LRDigraphTrigraphTests.assertEquals((int)17, (int)expr.getOperator());
        IASTArraySubscriptExpression arr_op = (IASTArraySubscriptExpression)expr.getOperand1();
        LRDigraphTrigraphTests.assertEquals((String)"4", (String)((IASTLiteralExpression)arr_op.getSubscriptExpression()).toString());
        IASTBinaryExpression cond = (IASTBinaryExpression)((IASTUnaryExpression)((IASTBinaryExpression)expr.getOperand2()).getOperand2()).getOperand();
        LRDigraphTrigraphTests.assertEquals((int)14, (int)cond.getOperator());
        IASTBinaryExpression cond2 = (IASTBinaryExpression)cond.getOperand1();
        LRDigraphTrigraphTests.assertEquals((int)13, (int)cond2.getOperator());
        IASTUnaryExpression not = (IASTUnaryExpression)cond2.getOperand1();
        LRDigraphTrigraphTests.assertEquals((int)6, (int)not.getOperator());
        IASTFunctionCallExpression expr2 = (IASTFunctionCallExpression)((IASTExpressionStatement)statements[2]).getExpression();
        IASTExpressionList params = (IASTExpressionList)expr2.getParameterExpression();
        IASTArraySubscriptExpression arr_op2 = (IASTArraySubscriptExpression)params.getExpressions()[1];
        LRDigraphTrigraphTests.assertEquals((String)"4", (String)((IASTLiteralExpression)arr_op2.getSubscriptExpression()).toString());
    }

    public void testTrigraphEscapeSequences() {
        String code = "int main(void)??<  \n   char str[] = \"??/\"??/n\"; \n   char c = '??/u0000'; \n??> \n";
        this.parse(code);
    }

    public void testDigraphSequences() {
        String code = "%:define join(a, b) a %:%: b \nint main() <% \n\t   int arr<:5:>; \n%> \n";
        IASTTranslationUnit tu = this.parse(code);
        IASTFunctionDefinition main = (IASTFunctionDefinition)tu.getDeclarations()[0];
        IASTCompoundStatement body = (IASTCompoundStatement)main.getBody();
        IASTStatement[] statements = body.getStatements();
        LRDigraphTrigraphTests.assertEquals((int)1, (int)statements.length);
        IASTSimpleDeclaration arr = (IASTSimpleDeclaration)((IASTDeclarationStatement)statements[0]).getDeclaration();
        IASTArrayDeclarator arr_decl = (IASTArrayDeclarator)arr.getDeclarators()[0];
        IASTArrayModifier modifier = arr_decl.getArrayModifiers()[0];
        IASTLiteralExpression lit = (IASTLiteralExpression)modifier.getConstantExpression();
        LRDigraphTrigraphTests.assertEquals((String)"5", (String)lit.toString());
    }

    public void testTrigraphAndDigraphSequecesInPreprocessorDirectives() {
        String code = "%:define join1(a, b) a %:%: b \n%:define str1(a) %: a \n??=define join2(a, b) a ??=??= b \n??=define str2(a) ??= a \nint main() <% \n\t   int join1(x, y) = str1(its all good); \n\t   int join2(a, b) = str2(its still good); \n%> \n";
        IASTTranslationUnit tu = this.parse(code);
        IASTFunctionDefinition main = (IASTFunctionDefinition)tu.getDeclarations()[0];
        IASTCompoundStatement body = (IASTCompoundStatement)main.getBody();
        IASTStatement[] statements = body.getStatements();
        LRDigraphTrigraphTests.assertEquals((int)2, (int)statements.length);
        IASTSimpleDeclaration decl1 = (IASTSimpleDeclaration)((IASTDeclarationStatement)statements[0]).getDeclaration();
        IASTDeclarator declarator1 = decl1.getDeclarators()[0];
        LRDigraphTrigraphTests.assertEquals((String)"xy", (String)declarator1.getName().toString());
        IASTLiteralExpression expr1 = (IASTLiteralExpression)((IASTEqualsInitializer)declarator1.getInitializer()).getInitializerClause();
        LRDigraphTrigraphTests.assertEquals((int)3, (int)expr1.getKind());
        LRDigraphTrigraphTests.assertEquals((String)"\"its all good\"", (String)expr1.toString());
        IASTSimpleDeclaration decl2 = (IASTSimpleDeclaration)((IASTDeclarationStatement)statements[1]).getDeclaration();
        IASTDeclarator declarator2 = decl2.getDeclarators()[0];
        LRDigraphTrigraphTests.assertEquals((String)"ab", (String)declarator2.getName().toString());
        IASTLiteralExpression expr2 = (IASTLiteralExpression)((IASTEqualsInitializer)declarator2.getInitializer()).getInitializerClause();
        LRDigraphTrigraphTests.assertEquals((int)3, (int)expr2.getKind());
        LRDigraphTrigraphTests.assertEquals((String)"\"its still good\"", (String)expr2.toString());
    }
}

