/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.io.InputStream;
import java.util.Vector;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLabelStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSwitchStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.OffsetHelper;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NodeCommenter {
    protected CPPASTVisitor visitor;
    protected CommentHandler commHandler;
    protected NodeCommentMap commentMap;
    protected Vector<IASTNode> children;

    public NodeCommenter(CPPASTVisitor visitor, CommentHandler commHandler, NodeCommentMap commentMap) {
        this.visitor = visitor;
        this.commHandler = commHandler;
        this.commentMap = commentMap;
        this.children = new Vector();
    }

    protected void writeNodeList(IASTNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            ++i;
        }
    }

    protected void visitNodeIfNotNull(IASTNode node) {
        if (node != null) {
            node.accept(this.visitor);
        }
    }

    protected boolean appendComment(ASTNode node, IASTComment comment) {
        ASTNode com = (ASTNode)((Object)comment);
        if (node.getFileLocation() == null) {
            return false;
        }
        int nodeLineNumber = OffsetHelper.getEndingLineNumber(node);
        int commentLineNumber = OffsetHelper.getStartingLineNumber(comment);
        if (OffsetHelper.getNodeEndPoint(com) <= OffsetHelper.getNodeOffset(node)) {
            this.addLeadingCommentToMap(node, comment);
            return true;
        }
        if (this.isTrailing(node, com, nodeLineNumber, commentLineNumber)) {
            this.addTrailingCommentToMap(node, comment);
            return true;
        }
        return false;
    }

    protected boolean appendFreestandingComment(ASTNode node, IASTComment comment) {
        ASTNode com = (ASTNode)((Object)comment);
        if (node.getFileLocation() == null) {
            return false;
        }
        if (OffsetHelper.getNodeEndPoint(com) <= OffsetHelper.getNodeEndPoint(node)) {
            this.addFreestandingCommentToMap(node, comment);
            return true;
        }
        return false;
    }

    private void addLeadingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addLeadingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    private void addTrailingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addTrailingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    private void addFreestandingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addFreestandingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTrailing(ASTNode node, ASTNode com, int nodeLineNumber, int commentLineNumber) {
        if (nodeLineNumber == commentLineNumber && OffsetHelper.getNodeOffset(com) >= OffsetHelper.getNodeEndPoint(node) && this.canNotBeAddedToParent(node, com) && !this.mustBeAddToSubnodes(node)) {
            if (OffsetHelper.getNodeOffset(com) < OffsetHelper.getNodeEndPoint(node) + 2) {
                return true;
            }
            Path path = new Path(node.getContainingFilename());
            IFile file = ResourceLookup.selectFileForLocation((IPath)path, null);
            try {
                InputStream is = file.getContents();
                int length = OffsetHelper.getNodeOffset(com) - OffsetHelper.getNodeEndPoint(node);
                byte[] b = new byte[length];
                long count = is.skip(OffsetHelper.getEndOffsetWithoutComments(node));
                if (count < (long)OffsetHelper.getEndOffsetWithoutComments(node)) {
                    return false;
                }
                if (is.read(b, 0, length) == -1) {
                    return false;
                }
                byte[] byArray = b;
                int n = b.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        is.close();
                        return true;
                    }
                    byte bb = byArray[n2];
                    if (!Character.isWhitespace(bb)) {
                        is.close();
                        return false;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private boolean canNotBeAddedToParent(ASTNode node, ASTNode com) {
        ASTNode parent = (ASTNode)node.getParent();
        if (this.hasNodeSameEndingAsSubnode(parent)) {
            return true;
        }
        if (parent instanceof IASTTranslationUnit) {
            return true;
        }
        if (parent instanceof ICPPASTTemplateDeclaration) {
            return true;
        }
        if (parent instanceof CPPASTIfStatement) {
            return true;
        }
        if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            parent = (ASTNode)parent.getParent();
        }
        return OffsetHelper.getNodeOffset(com) < OffsetHelper.getNodeEndPoint(parent);
    }

    private boolean mustBeAddToSubnodes(ASTNode node) {
        return this.hasNodeSameEndingAsSubnode(node);
    }

    private boolean hasNodeSameEndingAsSubnode(ASTNode node) {
        if (node instanceof CPPASTFunctionDefinition) {
            return true;
        }
        if (node instanceof CPPASTDeclarationStatement) {
            return true;
        }
        if (node instanceof CPPASTForStatement) {
            return true;
        }
        if (node instanceof CPPASTLabelStatement) {
            return true;
        }
        if (node instanceof CPPASTIfStatement) {
            return true;
        }
        if (node instanceof CPPASTSwitchStatement) {
            return true;
        }
        if (node instanceof CPPASTWhileStatement) {
            return true;
        }
        if (node instanceof CPPASTTemplateDeclaration) {
            return true;
        }
        if (node instanceof CPPASTLinkageSpecification) {
            return true;
        }
        return node instanceof CPPASTExplicitTemplateInstantiation;
    }

    protected int appendComments(ASTNode node) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.isNotSameFile(node, comment)) {
                return 1;
            }
            if (this.appendComment(node, comment)) continue;
            return 3;
        }
        return 2;
    }

    protected int appendFreestandingComments(ASTNode node) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.isNotSameFile(node, comment)) {
                return 1;
            }
            if (this.appendComment(node, comment)) {
                return 3;
            }
            if (this.appendFreestandingComment(node, comment)) continue;
            return 3;
        }
        return 2;
    }

    public void appendRemainingComments(IASTDeclaration declaration) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.appendComment((ASTNode)((Object)declaration), comment)) continue;
            this.addFreestandingCommentToMap((ASTNode)((Object)declaration), comment);
        }
    }

    private boolean isNotSameFile(IASTNode node, IASTComment comment) {
        if (node.getFileLocation() == null) {
            return true;
        }
        return !node.getFileLocation().getFileName().equals(comment.getFileLocation().getFileName());
    }
}

