/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Template;
import org.eclipse.cdt.internal.core.model.ext.FunctionDeclarationHandle;

public class FunctionTemplateDeclarationHandle
extends FunctionDeclarationHandle
implements IFunctionTemplateDeclaration {
    Template fTemplate;

    public FunctionTemplateDeclarationHandle(ICElement parent, ICPPFunctionTemplate func) throws DOMException {
        this(parent, 88, func);
    }

    public FunctionTemplateDeclarationHandle(ICElement parent, ICPPTemplateInstance func) throws DOMException {
        this(parent, 88, func);
    }

    protected FunctionTemplateDeclarationHandle(ICElement parent, int type, ICPPFunctionTemplate func) throws DOMException {
        super(parent, type, func);
        this.fTemplate = new Template(func.getName());
        ICPPTemplateParameter[] tpars = func.getTemplateParameters();
        String[] args = new String[tpars.length];
        int i = 0;
        while (i < args.length) {
            args[i] = tpars[i].getName();
            ++i;
        }
        this.fTemplate.setTemplateInfo(null, args);
    }

    protected FunctionTemplateDeclarationHandle(ICElement parent, int type, ICPPTemplateInstance func) throws DOMException {
        super(parent, type, (IFunction)((Object)func));
        this.fTemplate = new Template(func.getName());
        ICPPTemplateArgument[] targs = func.getTemplateArguments();
        String[] args = new String[targs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = ASTTypeUtil.getArgumentString(targs[i], false);
            ++i;
        }
        this.fTemplate.setTemplateInfo(null, args);
    }

    public String[] getTemplateArguments() {
        return this.fTemplate.getTemplateArguments();
    }

    public int getNumberOfTemplateParameters() {
        return this.fTemplate.getNumberOfTemplateParameters();
    }

    public String[] getTemplateParameterTypes() {
        return this.fTemplate.getTemplateParameterTypes();
    }

    public String getTemplateSignature() throws CModelException {
        return this.fTemplate.getTemplateSignature();
    }
}

