/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionSpecialization
extends PDOMCPPSpecialization
implements ICPPFunction {
    private static final int NUM_PARAMS = 40;
    private static final int FIRST_PARAM = 44;
    private static final int FUNCTION_TYPE = 48;
    protected static final int EXCEPTION_SPEC = 54;
    protected static final int ANNOTATION_OFFSET = 58;
    private static final int REQUIRED_ARG_COUNT_OFFSET = 60;
    protected static final int RECORD_SIZE = 64;
    private static final short ANNOT_HAS_PACK = 256;
    private ICPPFunctionType fType;
    private short fAnnotation = (short)-1;
    private int fRequiredArgCount = -1;

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPFunction astFunction, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)astFunction), specialized);
        Database db = this.getDB();
        try {
            ICPPFunction origAstFunc;
            ICPPParameter[] origAstParams;
            ICPPParameter[] astParams = astFunction.getParameters();
            ICPPFunctionType astFt = astFunction.getType();
            if (astFt != null) {
                ((PDOMLinkage)this.getLinkage()).storeType(this.record + 48L, astFt);
            }
            if ((origAstParams = (origAstFunc = (ICPPFunction)((ICPPSpecialization)((Object)astFunction)).getSpecializedBinding()).getParameters()).length == 0) {
                db.putInt(this.record + 40L, 0);
                db.putRecPtr(this.record + 44L, 0L);
            } else {
                int length = astParams.length;
                db.putInt(this.record + 40L, length);
                db.putRecPtr(this.record + 44L, 0L);
                PDOMCPPParameter origPar = null;
                PDOMNode next = null;
                int i = length - 1;
                while (i >= 0) {
                    if (i < origAstParams.length - 1) {
                        origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[i], null);
                    } else if (origPar == null) {
                        origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[origAstParams.length - 1], null);
                    }
                    next = new PDOMCPPParameterSpecialization(linkage, this, astParams[i], origPar, (PDOMCPPParameterSpecialization)next);
                    --i;
                }
                db.putRecPtr(this.record + 44L, next == null ? 0L : next.getRecord());
            }
            this.fAnnotation = this.getAnnotation(astFunction);
            db.putShort(this.record + 58L, this.fAnnotation);
            db.putInt(this.record + 60L, astFunction.getRequiredArgumentCount());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        try {
            long typelist = 0L;
            if (!(astFunction instanceof ICPPMethod) || !((ICPPMethod)astFunction).isImplicit()) {
                typelist = PDOMCPPTypeList.putTypes(this, astFunction.getExceptionSpecification());
            }
            db.putRecPtr(this.record + 54L, typelist);
        }
        catch (DOMException dOMException) {}
    }

    private short getAnnotation(ICPPFunction astFunction) throws DOMException {
        int annot = PDOMCPPAnnotation.encodeAnnotation(astFunction);
        if (astFunction.hasParameterPack()) {
            annot |= 0x100;
        }
        return (short)annot;
    }

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 64;
    }

    public int getNodeType() {
        return 34;
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.readAnnotation(), 2);
    }

    private short readAnnotation() {
        if (this.fAnnotation == -1) {
            try {
                this.fAnnotation = this.getDB().getShort(this.record + 58L);
            }
            catch (CoreException coreException) {
                this.fAnnotation = 0;
            }
        }
        return this.fAnnotation;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPParameter[] getParameters() throws DOMException {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            ICPPFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 40L);
            ICPPParameter[] result = new ICPPParameter[n];
            long next = db.getRecPtr(this.record + 44L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCPPParameterSpecialization par = new PDOMCPPParameterSpecialization((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
    }

    public ICPPFunctionType getType() throws DOMException {
        if (this.fType == null) {
            try {
                this.fType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 48L);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
        return this.fType;
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.readAnnotation(), 1);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.readAnnotation(), 6);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.readAnnotation(), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.readAnnotation(), 5);
    }

    public int getRequiredArgumentCount() throws DOMException {
        if (this.fRequiredArgCount == -1) {
            try {
                this.fRequiredArgCount = this.getDB().getInt(this.record + 60L);
            }
            catch (CoreException coreException) {
                this.fRequiredArgCount = 0;
            }
        }
        return this.fRequiredArgCount;
    }

    public boolean hasParameterPack() {
        return this.getBit(this.readAnnotation(), 256);
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    public IType[] getExceptionSpecification() throws DOMException {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 54L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

