/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.CConfigurationStatus;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CSettingEntryFactory;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.settings.model.CBuildSettingCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CFileDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CFolderDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CTargetPlatformSettingCache;
import org.eclipse.cdt.internal.core.settings.model.DescriptionStatus;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CConfigurationDescriptionCache
extends CDefaultConfigurationData
implements ICConfigurationDescription,
IInternalCCfgInfo,
ICachedData {
    private CProjectDescription fParent;
    private PathSettingsContainer fPathSettingContainer = PathSettingsContainer.createRootContainer();
    private ResourceDescriptionHolder fRcHolder = new ResourceDescriptionHolder(this.fPathSettingContainer, true);
    private List<ICSettingObject> fChildList = new ArrayList<ICSettingObject>();
    private CConfigurationSpecSettings fSpecSettings;
    private CConfigurationData fData;
    private CConfigurationDescriptionCache fBaseCache;
    private ICSourceEntry[] fProjSourceEntries;
    private StorableCdtVariables fMacros;
    private boolean fDataLoadded;
    private boolean fInitializing = true;
    private ICConfigurationDescription fBaseDescription;
    private CSettingEntryFactory fSettingsFactory;
    private ICSourceEntry[] fResolvedSourceEntries;

    CConfigurationDescriptionCache(ICStorageElement storage, CProjectDescription parent) throws CoreException {
        super(null);
        this.fParent = parent;
        this.fSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, storage);
        this.fId = this.fSpecSettings.getId();
        this.fName = this.fSpecSettings.getName();
    }

    public boolean isInitializing() {
        return this.fInitializing;
    }

    void loadData(CSettingEntryFactory factory) throws CoreException {
        if (this.fDataLoadded) {
            return;
        }
        this.fDataLoadded = true;
        this.fData = CProjectDescriptionManager.getInstance().loadData(this, null);
        this.fSettingsFactory = factory;
        this.copySettingsFrom(this.fData, true);
        this.fSettingsFactory = null;
        this.fSpecSettings.reconcileExtensionSettings(true);
        ((CBuildSettingCache)this.fBuildData).initEnvironmentCache();
        ICdtVariable[] vars = CdtVariableManager.getDefault().getVariables(this);
        this.fMacros = new StorableCdtVariables(vars, true);
    }

    CConfigurationDescriptionCache(ICConfigurationDescription baseDescription, CConfigurationData base, CConfigurationDescriptionCache baseCache, CConfigurationSpecSettings settingsBase, CProjectDescription parent, ICStorageElement rootEl) throws CoreException {
        super(base.getId(), base.getName(), null);
        this.fParent = parent;
        this.fSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, settingsBase, rootEl);
        this.fSpecSettings.setModified(settingsBase.isModified());
        this.fBaseDescription = baseDescription;
        this.fData = base instanceof CConfigurationDescriptionCache ? ((CConfigurationDescriptionCache)base).getConfigurationData() : base;
        this.fBaseCache = baseCache;
    }

    CConfigurationDescriptionCache getBaseCache() {
        return this.fBaseCache;
    }

    boolean applyData(CSettingEntryFactory factory, SettingsContext context) throws CoreException {
        boolean modified = true;
        if (this.fBaseDescription != null) {
            this.fData = CProjectDescriptionManager.getInstance().applyData(this, this.fBaseDescription, this.fData, context, null);
            this.fDataLoadded = true;
            this.fName = this.fData.getName();
            this.fId = this.fData.getId();
            this.fSettingsFactory = factory;
            if ((context.getAllConfigurationSettingsFlags() & 1) == 0 || this.fBaseCache == null) {
                this.copySettingsFrom(this.fData, true);
            } else {
                this.copySettingsFrom(this.fBaseCache, true);
                modified = this.fSpecSettings.isModified();
                if (!modified) {
                    modified = (context.getAllConfigurationSettingsFlags() & 2) == 0;
                }
            }
            this.fSettingsFactory = null;
            ICdtVariable[] vars = CdtVariableManager.getDefault().getVariables(this);
            this.fMacros = new StorableCdtVariables(vars, true);
            this.fSpecSettings.serialize();
            this.fSpecSettings.setModified(false);
        }
        this.fBaseDescription = null;
        this.fBaseCache = null;
        return modified;
    }

    CSettingEntryFactory getSettingsFactory() {
        return this.fSettingsFactory;
    }

    public StorableCdtVariables getCachedVariables() {
        return this.fMacros;
    }

    protected void setId(String id) throws CoreException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public CFileData copyFileData(IPath path, CFileData base, boolean clone) {
        return new CFileDescriptionCache(base, this);
    }

    @Override
    protected CFileData copyFileData(IPath path, CFolderData base, CLanguageData langData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CFolderData copyFolderData(IPath path, CFolderData base, boolean clone) {
        return new CFolderDescriptionCache(base, this);
    }

    @Override
    protected CBuildData copyBuildData(CBuildData data, boolean clone) {
        return new CBuildSettingCache(data, this);
    }

    void addResourceDescription(ICResourceDescription des) {
        this.fRcHolder.addResourceDescription(des.getPath(), des);
        this.fChildList.add(des);
    }

    void addTargetPlatformSetting(ICTargetPlatformSetting tpS) {
        this.fChildList.add(tpS);
    }

    void addBuildSetting(ICBuildSetting bs) {
        this.fChildList.add(bs);
        this.fBuildData = (CBuildData)((Object)bs);
    }

    @Override
    public ICProjectDescription getProjectDescription() {
        return this.fParent;
    }

    @Override
    public ICResourceDescription getResourceDescription(IPath path, boolean exactPath) {
        return this.fRcHolder.getResourceDescription(path, exactPath);
    }

    public ICResourceDescription[] getResourceDescriptions(int kind) {
        return this.fRcHolder.getResourceDescriptions(kind);
    }

    @Override
    public ICFolderDescription getRootFolderDescription() {
        return (ICFolderDescription)((Object)this.fRootFolderData);
    }

    @Override
    public boolean isActive() {
        if (this.isPreferenceConfiguration()) {
            return false;
        }
        return this.fParent.getActiveConfiguration() == this;
    }

    @Override
    public void removeResourceDescription(ICResourceDescription des) throws CoreException {
        throw new CoreException((IStatus)new DescriptionStatus(SettingsModelMessages.getString("CConfigurationDescriptionCache.0")));
    }

    @Override
    public CFileData createFileData(IPath path, CFileData base) throws CoreException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public CFileData createFileData(IPath path, CFolderData base, CLanguageData baseLangData) throws CoreException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public CFolderData createFolderData(IPath path, CFolderData base) throws CoreException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public void removeResourceData(CResourceData data) throws CoreException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public void setDescription(String description) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public void setName(String name) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public ICSettingObject[] getChildSettings() {
        return this.fChildList.toArray(new ICSettingObject[this.fChildList.size()]);
    }

    @Override
    public ICConfigurationDescription getConfiguration() {
        return this;
    }

    @Override
    public ICSettingContainer getParent() {
        return this.fParent;
    }

    @Override
    public ICResourceDescription[] getResourceDescriptions() {
        return this.fRcHolder.getResourceDescriptions();
    }

    @Override
    public ICStorageElement getStorage(String id, boolean create) throws CoreException {
        return this.getSpecSettings().getStorage(id, create);
    }

    @Override
    public void removeStorage(String id) throws CoreException {
        this.getSpecSettings().removeStorage(id);
    }

    @Override
    public ICStorageElement importStorage(String id, ICStorageElement el) throws UnsupportedOperationException, CoreException {
        return this.getSpecSettings().importStorage(id, el);
    }

    @Override
    public CConfigurationSpecSettings getSpecSettings() {
        return this.fSpecSettings;
    }

    @Override
    public String getBuildSystemId() {
        return this.fSpecSettings.getBuildSystemId();
    }

    @Override
    public CConfigurationData getConfigurationData() {
        return this.fData;
    }

    @Override
    public void setConfigurationData(String bsId, CConfigurationData data) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public CConfigurationData getConfigurationData(boolean write) throws WriteAccessException {
        if (write) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        return this;
    }

    @Override
    public void setActive() throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public ICFileDescription createFileDescription(IPath path, ICResourceDescription base) throws CoreException, WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public ICFolderDescription createFolderDescription(IPath path, ICFolderDescription base) throws CoreException, WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    ResourceDescriptionHolder createHolderForRc(IPath path) {
        return new ResourceDescriptionHolder(this.fPathSettingContainer.getChildContainer(path, true, true), false);
    }

    @Override
    public boolean isReadOnly() {
        return !this.fInitializing;
    }

    @Override
    public void setReadOnly(boolean readOnly, boolean keepModify) {
        if (readOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
    }

    @Override
    public ICTargetPlatformSetting getTargetPlatformSetting() {
        return (ICTargetPlatformSetting)((Object)this.getTargetPlatformData());
    }

    @Override
    protected CTargetPlatformData copyTargetPlatformData(CTargetPlatformData base, boolean clone) {
        return new CTargetPlatformSettingCache(base, this);
    }

    @Override
    public ICFileDescription[] getFileDescriptions() {
        return (ICFileDescription[])this.fRcHolder.getResourceDescriptions(8);
    }

    @Override
    public ICFolderDescription[] getFolderDescriptions() {
        return (ICFolderDescription[])this.fRcHolder.getResourceDescriptions(4);
    }

    public void setSourcePaths(IPath[] paths) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public ICSourceEntry[] getSourceEntries() {
        this.initSourceEntries();
        return (ICSourceEntry[])this.fProjSourceEntries.clone();
    }

    private void initSourceEntries() {
        if (this.fProjSourceEntries == null) {
            IProject project = this.getProject();
            this.fProjSourceEntries = CDataUtil.adjustEntries(this.fSourceEntries, true, project);
        }
    }

    private IProject getProject() {
        return this.isPreferenceConfiguration() ? null : this.getProjectDescription().getProject();
    }

    @Override
    public void setSourceEntries(ICSourceEntry[] entries) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public Map<String, String> getReferenceInfo() {
        return this.getSpecSettings().getReferenceInfo();
    }

    @Override
    public void setReferenceInfo(Map<String, String> refs) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    @Override
    public ICExternalSetting createExternalSetting(String[] languageIDs, String[] contentTypeIds, String[] extensions, ICSettingEntry[] entries) {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        return this.fSpecSettings.createExternalSetting(languageIDs, contentTypeIds, extensions, entries);
    }

    @Override
    public ICExternalSetting[] getExternalSettings() {
        return this.fSpecSettings.getExternalSettings();
    }

    @Override
    public void removeExternalSetting(ICExternalSetting setting) {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.removeExternalSetting(setting);
    }

    @Override
    public void removeExternalSettings() {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.removeExternalSettings();
    }

    @Override
    public ICBuildSetting getBuildSetting() {
        return (ICBuildSetting)((Object)this.getBuildData());
    }

    @Override
    public void setSessionProperty(QualifiedName name, Object value) {
        this.fSpecSettings.setSettionProperty(name, value);
    }

    @Override
    public Object getSessionProperty(QualifiedName name) {
        return this.fSpecSettings.getSettionProperty(name);
    }

    @Override
    public ICdtVariablesContributor getBuildVariablesContributor() {
        return this.fData.getBuildVariablesContributor();
    }

    @Override
    public ICConfigExtensionReference create(String extensionPoint, String extension) throws CoreException {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        return this.fSpecSettings.create(extensionPoint, extension);
    }

    @Override
    public ICConfigExtensionReference[] get(String extensionPointID) {
        return this.fSpecSettings.get(extensionPointID);
    }

    @Override
    public void remove(ICConfigExtensionReference ext) throws CoreException {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.remove(ext);
    }

    @Override
    public void remove(String extensionPoint) throws CoreException {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.remove(extensionPoint);
    }

    @Override
    public boolean isPreferenceConfiguration() {
        return this.getProjectDescription() == null;
    }

    void doneInitialization() {
        CProjectDescriptionManager.getInstance().notifyCached(this, this.fData, null);
        this.fInitializing = false;
        this.fSpecSettings.doneInitialization();
    }

    @Override
    public ICLanguageSetting getLanguageSettingForFile(IPath path, boolean ignoreExcludeStatus) {
        return CProjectDescriptionManager.getLanguageSettingForFile(this, path, ignoreExcludeStatus);
    }

    @Override
    protected CResourceData[] filterRcDatasToCopy(CConfigurationData base) {
        if (!this.isPreferenceConfiguration()) {
            CProjectDescriptionManager.removeNonCustomSettings(this.getProjectDescription().getProject(), base);
        }
        return super.filterRcDatasToCopy(base);
    }

    boolean isExcluded(IPath path) {
        this.initSourceEntries();
        IProject project = this.getProject();
        if (project != null) {
            path = project.getFullPath().append(path);
        }
        return CDataUtil.isExcluded(path, this.fProjSourceEntries);
    }

    @Override
    public String[] getExternalSettingsProviderIds() {
        return this.fSpecSettings.getExternalSettingsProviderIds();
    }

    @Override
    public void setExternalSettingsProviderIds(String[] ids) {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.setExternalSettingsProviderIds(ids);
    }

    @Override
    public void updateExternalSettingsProviders(String[] ids) {
        if (!this.fInitializing) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fSpecSettings.updateExternalSettingsProviders(ids);
    }

    @Override
    public ICSourceEntry[] getResolvedSourceEntries() {
        if (this.fResolvedSourceEntries == null) {
            ICSourceEntry[] entries = this.getSourceEntries();
            this.fResolvedSourceEntries = CDataUtil.resolveEntries(entries, (ICConfigurationDescription)this);
        }
        return this.fResolvedSourceEntries;
    }

    @Override
    public CConfigurationStatus getConfigurationStatus() {
        CConfigurationStatus status = this.getStatus();
        return status != null ? status : CConfigurationStatus.CFG_STATUS_OK;
    }
}

