/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.agent;

import java.util.Map;
import org.eclipse.cdt.debug.edc.tcf.extension.AgentException;
import org.eclipse.cdt.debug.edc.tcf.extension.agent.ContextInAgent;
import org.eclipse.cdt.debug.edc.tcf.extension.agent.ContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInAgent
extends ContextInAgent {
    private final long osID;

    public ProcessInAgent(long osID, Map<String, Object> props, boolean cacheAsDebugged) {
        super(props);
        this.osID = osID;
        Map<String, Object> internalProps = this.getProperties();
        internalProps.put("ID", ProcessInAgent.createInternalID(osID));
        internalProps.put("OSID", Long.toString(osID));
        internalProps.put("IsContainer", Boolean.TRUE);
        internalProps.put("HasState", Boolean.TRUE);
        internalProps.put("CanSuspend", Boolean.FALSE);
        internalProps.put("CanResume", 4);
        internalProps.put("CanTerminate", Boolean.TRUE);
        if (cacheAsDebugged) {
            ContextManager.addDebuggedContext(this);
        } else {
            ContextManager.addRunningContext(this);
        }
    }

    public long getProcessID() {
        return this.osID;
    }

    public static String createInternalID(long osID) {
        return "p" + osID;
    }

    public static long contextID2ProcessID(String contextID) throws AgentException {
        ContextInAgent c = ContextManager.findDebuggedContext(contextID);
        if (c == null || !(c instanceof ProcessInAgent)) {
            throw new AgentException("Invalid process context ID:" + contextID);
        }
        return ((ProcessInAgent)c).getProcessID();
    }
}

