/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ILogging;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleLogManager
implements ILogging.LogListener {
    private static List<ConsoleLogManager> managers;
    private IChannel channel;
    private Map<MessageConsole, MessageConsoleStream> consoleStreamMappings;
    private final String logId;
    private final String consoleType;

    public static ConsoleLogManager create(String consoleType, String logId, IChannel channel) {
        if (managers == null) {
            managers = new ArrayList<ConsoleLogManager>();
        }
        ConsoleLogManager consoleStreamManager = new ConsoleLogManager(consoleType, logId, channel);
        managers.add(consoleStreamManager);
        return consoleStreamManager;
    }

    public static ConsoleLogManager findExisting(String consoleType, String logId, IChannel channel) {
        if (managers != null) {
            for (ConsoleLogManager consoleLogManager : managers) {
                if (!consoleLogManager.consoleType.equals(consoleType) || !consoleLogManager.logId.equals(logId) || !consoleLogManager.channel.equals(channel)) continue;
                return consoleLogManager;
            }
        }
        return null;
    }

    private ConsoleLogManager(final String consoleType, String logId, IChannel channel) {
        this.consoleType = consoleType;
        this.logId = logId;
        this.channel = channel;
        this.hookChannel(channel);
        this.consoleStreamMappings = new HashMap<MessageConsole, MessageConsoleStream>();
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesRemoved(IConsole[] consoles) {
                IConsole[] iConsoleArray = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole console = iConsoleArray[n2];
                    if (console instanceof MessageConsole) {
                        ConsoleLogManager.this.removeConsole((MessageConsole)console);
                    }
                    ++n2;
                }
            }

            public void consolesAdded(IConsole[] consoles) {
                IConsole[] iConsoleArray = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole console = iConsoleArray[n2];
                    String type = console.getType();
                    if (type != null && type.equals(consoleType) && console instanceof MessageConsole) {
                        ConsoleLogManager.this.addConsole((MessageConsole)console);
                    }
                    ++n2;
                }
            }
        });
    }

    private void hookChannel(final IChannel channel) {
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                    }

                    public void onChannelClosed(Throwable error) {
                        managers.remove(ConsoleLogManager.this);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            }
        });
    }

    public void removeConsole(MessageConsole console) {
        if (this.consoleStreamMappings.remove(console) != null && this.consoleStreamMappings.isEmpty() && this.isChannelOpen()) {
            TCFTask<Object> task = new TCFTask<Object>(){

                public void run() {
                    ILogging logging = (ILogging)ConsoleLogManager.this.channel.getRemoteService(ILogging.class);
                    if (!$assertionsDisabled && logging == null) {
                        throw new AssertionError();
                    }
                    logging.removeListener(ConsoleLogManager.this.logId, (ILogging.LogListener)ConsoleLogManager.this, new ILogging.DoneRemoveListener(){

                        public void doneRemoveListener(IToken token, Exception error) {
                            if (error == null) {
                                this.done(this);
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            task.getE();
        }
    }

    public void addConsole(MessageConsole console) {
        if (this.consoleStreamMappings.isEmpty() && this.isChannelOpen()) {
            TCFTask<Object> task = new TCFTask<Object>(){

                public void run() {
                    ILogging logging = (ILogging)ConsoleLogManager.this.channel.getRemoteService(ILogging.class);
                    if (!$assertionsDisabled && logging == null) {
                        throw new AssertionError();
                    }
                    logging.addListener(ConsoleLogManager.this.logId, (ILogging.LogListener)ConsoleLogManager.this, new ILogging.DoneAddListener(){

                        public void doneAddListener(IToken token, Exception error) {
                            if (error == null) {
                                this.done(this);
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            task.getE();
        }
        this.consoleStreamMappings.put(console, console.newMessageStream());
    }

    private boolean isChannelOpen() {
        return ((AbstractChannel)this.channel).getState() == 1;
    }

    public void appendText(MessageConsole console, String text, boolean eol) {
        MessageConsoleStream stream = this.consoleStreamMappings.get(console);
        if (stream.isClosed()) {
            stream = console.newMessageStream();
            this.consoleStreamMappings.put(console, stream);
        }
        if (eol) {
            stream.println(text);
        } else {
            stream.print(text);
        }
    }

    public void write(String msg) {
        for (MessageConsole console : this.consoleStreamMappings.keySet()) {
            this.appendText(console, msg, false);
        }
    }

    public void writeln(String msg) {
        for (MessageConsole console : this.consoleStreamMappings.keySet()) {
            this.appendText(console, msg, true);
        }
    }
}

