/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.IBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryUtils {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    public static final int ENDIANESS_UNKNOWN = 2;

    protected static byte[] fillArray(byte[] array, int size, int endianess, boolean isSigned) {
        byte[] temp = new byte[size];
        int fillByte = 0;
        if (isSigned && (array[array.length - 1] & 0x80) != 0) {
            fillByte = -1;
        }
        if (endianess == 0) {
            int i = 0;
            while (i < array.length) {
                temp[i] = array[i];
                ++i;
            }
            i = array.length;
            while (i < size) {
                temp[i] = fillByte;
                ++i;
            }
            array = temp;
            return array;
        }
        int i = 0;
        while (i < size - array.length) {
            temp[i] = fillByte;
            ++i;
        }
        int j = 0;
        int i2 = size - array.length;
        while (i2 < size) {
            temp[i2] = array[j];
            ++j;
            ++i2;
        }
        array = temp;
        return array;
    }

    public static BigInteger convertByteArrayToUnsignedLong(MemoryByte[] data, int endianess) {
        byte[] array = new byte[data.length];
        int i = 0;
        while (i < array.length) {
            array[i] = data[i].getValue();
            ++i;
        }
        if (array.length < 8) {
            array = MemoryUtils.fillArray(array, 8, endianess, false);
        }
        BigInteger value = new BigInteger("0");
        if (endianess == 0) {
            int i2 = 0;
            while (i2 < 8) {
                byte[] temp = new byte[]{array[i2]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft(i2 * 8);
                value = value.or(b);
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < 8) {
                byte[] temp = new byte[]{array[i3]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((7 - i3) * 8);
                value = value.or(b);
                ++i3;
            }
        }
        return value;
    }

    public static long convertByteArrayToLong(MemoryByte[] data, int endianess) {
        byte[] array = new byte[data.length];
        int i = 0;
        while (i < array.length) {
            array[i] = data[i].getValue();
            ++i;
        }
        if (array.length < 8) {
            array = MemoryUtils.fillArray(array, 8, endianess, true);
        }
        if (endianess == 0) {
            long value = 0L;
            int i2 = 0;
            while (i2 < 8) {
                long b = array[i2];
                value |= (b &= 0xFFL) << i2 * 8;
                ++i2;
            }
            return value;
        }
        long value = 0L;
        int i3 = 0;
        while (i3 < 8) {
            long b = array[i3];
            value |= (b &= 0xFFL) << (7 - i3) * 8;
            ++i3;
        }
        return value;
    }

    public static BigInteger convertByteArrayToSignedBigInt(byte[] array, int endianess) {
        if (array.length < 16) {
            array = MemoryUtils.fillArray(array, 16, endianess, false);
        }
        if (endianess == 0) {
            byte[] holder = new byte[16];
            int j = 15;
            int i = 0;
            while (i < 16) {
                holder[i] = array[j];
                ++i;
                --j;
            }
            BigInteger value = new BigInteger(holder);
            return value;
        }
        BigInteger value = new BigInteger(array);
        return value;
    }

    public static BigInteger convertByteArrayToSignedBigInt(byte[] array, int endianess, int arraySize) {
        if (array.length < arraySize) {
            array = MemoryUtils.fillArray(array, arraySize, endianess, true);
        }
        if (endianess == 0) {
            byte[] holder = new byte[arraySize];
            int j = arraySize - 1;
            int i = 0;
            while (i < arraySize) {
                holder[i] = array[j];
                ++i;
                --j;
            }
            BigInteger value = new BigInteger(holder);
            return value;
        }
        BigInteger value = new BigInteger(array);
        return value;
    }

    public static BigInteger convertByteArrayToUnsignedBigInt(byte[] array, int endianess) {
        if (array.length < 16) {
            array = MemoryUtils.fillArray(array, 16, endianess, false);
        }
        BigInteger value = new BigInteger("0");
        if (endianess == 0) {
            int i = 0;
            while (i < 16) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft(i * 8);
                value = value.or(b);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 16) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((15 - i) * 8);
                value = value.or(b);
                ++i;
            }
        }
        return value;
    }

    public static BigInteger convertByteArrayToUnsignedBigInt(byte[] array, int endianess, int arraySize) {
        if (array.length < arraySize) {
            array = MemoryUtils.fillArray(array, arraySize, endianess, false);
        }
        BigInteger value = new BigInteger("0");
        if (endianess == 0) {
            int i = 0;
            while (i < arraySize) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft(i * 8);
                value = value.or(b);
                ++i;
            }
        } else {
            int i = 0;
            while (i < arraySize) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((arraySize - 1 - i) * 8);
                value = value.or(b);
                ++i;
            }
        }
        return value;
    }

    public static int convertByteArrayToInt(MemoryByte[] data, int endianess) {
        int value;
        byte[] array = new byte[data.length];
        int i = 0;
        while (i < array.length) {
            array[i] = data[i].getValue();
            ++i;
        }
        if (array.length < 4) {
            array = MemoryUtils.fillArray(array, 4, endianess, true);
        }
        if (endianess == 0) {
            value = 0;
            int i2 = 0;
            while (i2 < 4) {
                int b = array[i2];
                value |= (b &= 0xFF) << i2 * 8;
                ++i2;
            }
            return value;
        }
        value = 0;
        int i3 = 0;
        while (i3 < 4) {
            int b = array[i3];
            value |= (b &= 0xFF) << (3 - i3) * 8;
            ++i3;
        }
        return value;
    }

    public static short convertByteArrayToShort(MemoryByte[] data, int endianess) {
        short value;
        byte[] array = new byte[data.length];
        int i = 0;
        while (i < array.length) {
            array[i] = data[i].getValue();
            ++i;
        }
        if (array.length < 2) {
            array = MemoryUtils.fillArray(array, 2, endianess, true);
        }
        if (endianess == 0) {
            value = 0;
            int i2 = 0;
            while (i2 < 2) {
                short b = array[i2];
                b = (short)(b & 0xFF);
                value = (short)(value | b << i2 * 8);
                ++i2;
            }
            return value;
        }
        value = 0;
        int i3 = 0;
        while (i3 < 2) {
            short b = array[i3];
            b = (short)(b & 0xFF);
            value = (short)(value | b << (1 - i3) * 8);
            ++i3;
        }
        return value;
    }

    public static byte[] convertBigIntegerToByteArray(BigInteger i, int endianess) {
        byte[] buf = new byte[16];
        if (endianess == 0) {
            int j = 0;
            while (j < 16) {
                BigInteger x = i.shiftRight(j * 8);
                buf[j] = x.byteValue();
                ++j;
            }
            return buf;
        }
        int j = 15;
        while (j >= 0) {
            BigInteger x = i.shiftRight((15 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertSignedBigIntToByteArray(BigInteger i, int endianess, int arraySize) {
        byte[] buf = new byte[arraySize];
        if (endianess == 0) {
            int j = 0;
            while (j < arraySize) {
                BigInteger x = i.shiftRight(j * 8);
                buf[j] = x.byteValue();
                ++j;
            }
            return buf;
        }
        int j = arraySize - 1;
        while (j >= 0) {
            BigInteger x = i.shiftRight((arraySize - 1 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertUnsignedBigIntegerToByteArray(BigInteger i, int endianess) {
        byte[] buf = new byte[32];
        if (endianess == 0) {
            int j = 0;
            while (j < 32) {
                BigInteger x = i.shiftRight(j * 8);
                buf[j] = x.byteValue();
                ++j;
            }
            return buf;
        }
        int j = 31;
        while (j >= 0) {
            BigInteger x = i.shiftRight((31 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertUnsignedBigIntToByteArray(BigInteger i, int endianess, int arraySize) {
        byte[] buf = new byte[arraySize * 2];
        if (endianess == 0) {
            int j = 0;
            while (j < arraySize * 2) {
                BigInteger x = i.shiftRight(j * 8);
                buf[j] = x.byteValue();
                ++j;
            }
            return buf;
        }
        int j = arraySize * 2 - 1;
        while (j >= 0) {
            BigInteger x = i.shiftRight((arraySize * 2 - 1 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertLongToByteArray(long i, int endianess) {
        byte[] buf = new byte[8];
        if (endianess == 0) {
            int j = 0;
            while (j < 8) {
                buf[j] = new Long(i >> j * 8).byteValue();
                ++j;
            }
            return buf;
        }
        int j = 7;
        while (j >= 0) {
            buf[j] = new Long(i >> (7 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertIntToByteArray(int i, int endianess) {
        byte[] buf = new byte[4];
        if (endianess == 0) {
            int j = 0;
            while (j < 4) {
                buf[j] = new Integer(i >> j * 8).byteValue();
                ++j;
            }
            return buf;
        }
        int j = 3;
        while (j >= 0) {
            buf[j] = new Integer(i >> (3 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertShortToByteArray(short i, int endianess) {
        byte[] buf = new byte[2];
        if (endianess == 0) {
            int j = 0;
            while (j < 2) {
                buf[j] = new Integer(i >> j * 8).byteValue();
                j = (short)(j + 1);
            }
            return buf;
        }
        int j = 1;
        while (j >= 0) {
            buf[j] = new Integer(i >> (1 - j) * 8).byteValue();
            j = (short)(j - 1);
        }
        return buf;
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        StringBuffer strBuffer = new StringBuffer();
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            char[] charArray = MemoryUtils.convertByteToCharArray(element);
            strBuffer.append(charArray);
            ++n2;
        }
        return strBuffer.toString();
    }

    public static char[] convertByteToCharArray(byte aByte) {
        char[] charArray = new char[2];
        int val = aByte;
        if (val < 0) {
            val += 256;
        }
        charArray[0] = Character.forDigit(val / 16, 16);
        charArray[1] = Character.forDigit(val % 16, 16);
        return charArray;
    }

    public static byte[] convertHexStringToByteArray(String str, int numBytes, int numCharsPerByte) throws NumberFormatException {
        if (str.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str);
        int requiredPadding = numBytes * numCharsPerByte - str.length();
        while (requiredPadding > 0) {
            buf.insert(0, "0");
            --requiredPadding;
        }
        byte[] bytes = new byte[numBytes];
        str = buf.toString();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = str.substring(i * 2, i * 2 + 2);
            Integer number = Integer.valueOf(oneByte, 16);
            if (number.compareTo(Integer.valueOf(Byte.toString((byte)127))) > 0) {
                int temp = number;
                String tempStr = Integer.toString(temp -= 256);
                Byte myByte = Byte.valueOf(tempStr);
                bytes[i] = myByte;
            } else {
                Byte myByte = Byte.valueOf(oneByte, 16);
                bytes[i] = myByte;
            }
            ++i;
        }
        return bytes;
    }

    public static String convertMemoryBytesToHexString(MemoryByte[] bytes) {
        StringBuffer strBuffer = new StringBuffer();
        MemoryByte[] memoryByteArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryByte b = memoryByteArray[n2];
            char[] charArray = MemoryUtils.convertByteToCharArray(b.getValue());
            strBuffer.append(charArray);
            ++n2;
        }
        return strBuffer.toString();
    }

    public static MemoryByte[] convertHexStringToMemoryBytes(String str, int numBytes, int numCharsPerByte) throws NumberFormatException {
        if (str.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str);
        int requiredPadding = numBytes * numCharsPerByte - str.length();
        while (requiredPadding > 0) {
            buf.insert(0, "0");
            --requiredPadding;
        }
        MemoryByte[] bytes = new MemoryByte[numBytes];
        str = buf.toString();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = str.substring(i * 2, i * 2 + 2);
            Integer number = Integer.valueOf(oneByte, 16);
            if (number.compareTo(Integer.valueOf(Byte.toString((byte)127))) > 0) {
                int temp = number;
                String tempStr = Integer.toString(temp -= 256);
                Byte myByte = Byte.valueOf(tempStr);
                bytes[i] = new MemoryByte(myByte.byteValue());
            } else {
                Byte myByte = Byte.valueOf(oneByte, 16);
                bytes[i] = new MemoryByte(myByte.byteValue());
            }
            ++i;
        }
        return bytes;
    }

    public static BigInteger convertValueToMemory(IType varType, Number value) throws CoreException {
        BigInteger result = null;
        int varSize = varType.getByteSize();
        if (varSize <= 0) {
            throw EDCDebugger.newCoreException("Type has no size");
        }
        TypeCharacteristics characteristics = new TypeCharacteristics(varType);
        switch (characteristics.basicType) {
            case 4: 
            case 5: {
                if (varSize == 4) {
                    result = BigInteger.valueOf(Float.floatToIntBits(value.floatValue()));
                    break;
                }
                if (varSize != 8) break;
                result = BigInteger.valueOf(Double.doubleToLongBits(value.doubleValue()));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                if (characteristics.isSigned) {
                    if (varSize == 4) {
                        result = BigInteger.valueOf(value.intValue());
                        break;
                    }
                    if (varSize == 2) {
                        int intResult = value.intValue() & 0xFFFF;
                        if ((intResult & 0x8000) != 0) {
                            intResult |= 0xFFFF0000;
                        }
                        result = BigInteger.valueOf(intResult);
                        break;
                    }
                    if (varSize == 1) {
                        int intResult = value.intValue() & 0xFF;
                        if ((intResult & 0x80) != 0) {
                            intResult |= 0xFFFFFF00;
                        }
                        result = BigInteger.valueOf(intResult);
                        break;
                    }
                    result = BigInteger.valueOf(value.longValue());
                    break;
                }
                if (varSize == 4) {
                    result = BigInteger.valueOf(value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                if (varSize == 2) {
                    result = BigInteger.valueOf(value.intValue() & 0xFFFF);
                    break;
                }
                if (varSize == 1) {
                    result = BigInteger.valueOf(value.intValue() & 0xFF);
                    break;
                }
                result = BigInteger.valueOf(value.longValue());
                break;
            }
            default: {
                assert (false);
                throw EDCDebugger.newCoreException("Unhandled type");
            }
        }
        return result;
    }

    public static class TypeCharacteristics {
        public int basicType = 0;
        public boolean isSigned = false;
        public boolean isShort = false;
        public boolean isLong = false;
        public boolean isLongLong = false;
        public boolean isComplex = false;

        public TypeCharacteristics(IType varType) {
            if (varType instanceof IBasicType) {
                IBasicType type = (IBasicType)varType;
                this.basicType = type.getBaseType();
                this.isSigned = type.isSigned();
                this.isShort = type.isShort();
                this.isLong = type.isLong();
                if (varType instanceof ICPPBasicType) {
                    ICPPBasicType cppType = (ICPPBasicType)varType;
                    this.isLongLong = cppType.isLongLong();
                    this.isComplex = cppType.isComplex();
                }
            } else if (varType instanceof IPointerType) {
                this.basicType = 3;
            } else if (varType instanceof IEnumerator) {
                this.basicType = 3;
                this.isSigned = true;
            } else {
                this.basicType = 3;
            }
        }
    }
}

