/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.text.MessageFormat;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.VariableWithValue;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;

public class EvaluateID
extends SimpleInstruction {
    private final String name;

    public EvaluateID(IASTIdExpression idExpression) {
        IASTName lookupName;
        if (idExpression.getName() instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qualifiedName = (ICPPASTQualifiedName)idExpression.getName();
            lookupName = qualifiedName.getLastName();
        } else {
            lookupName = idExpression.getName();
        }
        this.name = new String(lookupName.getLookupKey());
    }

    public EvaluateID(String name) {
        this.name = name;
    }

    public void execute() throws CoreException {
        Stack.EnumeratorDMC enumerator;
        IDMContext context = this.getContext();
        if (!(context instanceof Stack.StackFrameDMC)) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.EvaluateID_CannotResolveName, this.name));
        }
        Stack.StackFrameDMC frame = (Stack.StackFrameDMC)context;
        DsfServicesTracker servicesTracker = frame.getDsfServicesTracker();
        IEDCModules modules = (IEDCModules)servicesTracker.getService(IEDCModules.class);
        Stack.IVariableEnumeratorContext variableOrEnumerator = frame.findVariableOrEnumeratorByName(this.name, false);
        Stack.VariableDMC variable = variableOrEnumerator instanceof Stack.VariableDMC ? (Stack.VariableDMC)variableOrEnumerator : null;
        Stack.EnumeratorDMC enumeratorDMC = enumerator = variableOrEnumerator instanceof Stack.EnumeratorDMC ? (Stack.EnumeratorDMC)variableOrEnumerator : null;
        if (variable != null && modules != null) {
            IVariableLocation valueLocation = null;
            IModules.ISymbolDMContext symContext = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)frame, IModules.ISymbolDMContext.class);
            ILocationProvider provider = variable.getVariable().getLocationProvider();
            IAddress pcValue = frame.getIPAddress();
            IEDCModuleDMContext module = modules.getModuleByAddress(symContext, pcValue);
            if (module != null && provider != null) {
                valueLocation = provider.getLocation(servicesTracker, frame, module.toLinkAddress(pcValue));
            }
            if (valueLocation == null) {
                valueLocation = new InvalidVariableLocation(MessageFormat.format(ASTEvalMessages.EvaluateID_NameHasNoLocation, variable.getName()));
            }
            VariableWithValue varWval = new VariableWithValue(servicesTracker, frame, variable.getVariable());
            varWval.setValueLocation(valueLocation);
            this.push(varWval);
            return;
        }
        if (enumerator != null) {
            this.pushNewValue(this.fInterpreter.getTypeEngine().getIntegerTypeOfSize(4, true), enumerator.getEnumerator().getValue());
            return;
        }
        throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.EvaluateID_VariableNotFound, this.name));
    }
}

