/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class PushLongOrBigInteger
extends SimpleInstruction {
    private boolean isUnsigned;
    private boolean isLong;
    private boolean isLongLong;
    private BigInteger fBigInteger;
    private long fLong;
    private IType type;

    public PushLongOrBigInteger(long value) {
        this.isLong = true;
        this.fLong = value;
    }

    public PushLongOrBigInteger(String value) throws NumberFormatException {
        this.parseLongOrBigInteger(value);
    }

    public long getLong() {
        return this.fLong;
    }

    public void execute() {
        Number number = this.fBigInteger;
        if (number == null) {
            number = this.fLong;
        }
        if (this.type == null) {
            int flags;
            int n = this.isLongLong ? 64 : (flags = this.isLong ? 1 : 0);
            flags = this.isUnsigned ? (flags |= 8) : (flags |= 4);
            int size = this.isLongLong ? this.fInterpreter.getTypeEngine().getTypeSize(10) : (this.isLong ? this.fInterpreter.getTypeEngine().getTypeSize(8) : this.fInterpreter.getTypeEngine().getTypeSize(6));
            this.type = this.fInterpreter.getTypeEngine().getBasicType(3, flags, size);
        }
        this.pushNewValue(this.type, number);
    }

    public String toString() {
        if (this.isLong) {
            return Long.toString(this.fLong);
        }
        return this.fBigInteger.toString();
    }

    public void parseLongOrBigInteger(String value) throws NumberFormatException {
        this.isUnsigned = false;
        String val = value.toLowerCase();
        int length = value.length();
        if (val.endsWith("ull") || val.endsWith("llu")) {
            this.isUnsigned = true;
            this.isLongLong = true;
            this.isLong = false;
            val = val.substring(0, val.length() - 3);
            length -= 3;
        } else if (val.endsWith("ll")) {
            this.isLong = false;
            this.isLongLong = true;
            val = val.substring(0, val.length() - 2);
            length -= 2;
        } else if (val.endsWith("ul") || val.endsWith("lu")) {
            this.isUnsigned = true;
            this.isLong = true;
            val = val.substring(0, val.length() - 2);
            length -= 2;
        } else if (val.endsWith("l")) {
            this.isLong = true;
            val = val.substring(0, val.length() - 1);
            --length;
        } else if (val.endsWith("u")) {
            this.isUnsigned = true;
            val = val.substring(0, val.length() - 1);
            --length;
        }
        if (val.startsWith("0x")) {
            try {
                this.fLong = Long.valueOf(val.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.fBigInteger = new BigInteger(val.substring(2), 16);
                this.fBigInteger.and(Instruction.Mask8Bytes);
                return;
            }
            length -= 2;
        } else if (length > 1 && val.startsWith("0")) {
            try {
                this.fLong = Long.valueOf(val.substring(1), 8);
            }
            catch (NumberFormatException numberFormatException) {
                this.fBigInteger = new BigInteger(val.substring(1), 8);
                this.fBigInteger.and(Instruction.Mask8Bytes);
                return;
            }
            --length;
        } else {
            try {
                this.fLong = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                this.fBigInteger = new BigInteger(val);
                this.fBigInteger.and(Instruction.Mask8Bytes);
                return;
            }
        }
        if (length == 0) {
            this.fLong = 0L;
            return;
        }
        if (this.isUnsigned && this.fBigInteger != null) {
            if (this.fBigInteger.bitLength() < 64) {
                this.fLong = this.fBigInteger.longValue();
                this.fBigInteger = null;
                return;
            }
            this.fBigInteger.and(Instruction.Mask8Bytes);
        }
    }
}

