/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.launch;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.launch.EDCLaunchDelegate;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class SnapshotLaunchDelegate
extends EDCLaunchDelegate {
    public static final String SNAPSHOT_DEBUG_MODEL_ID = "org.eclipse.cdt.debug.edc.internal.snapshot";
    private Album album;
    private ILaunchConfiguration proxyLaunchConfig;

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        ILaunchManager lm;
        ILaunchConfigurationType launchType;
        String albumLocation = configuration.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", "");
        Path albumPath = new Path(albumLocation);
        this.album = Album.getAlbumByLocation((IPath)albumPath);
        if (this.album == null || !this.album.isLoaded()) {
            if (this.album == null) {
                this.album = new Album();
            }
            this.album.setLocation((IPath)albumPath);
            try {
                this.album.loadAlbum(false);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
                return false;
            }
        }
        if ((launchType = (lm = DebugPlugin.getDefault().getLaunchManager()).getLaunchConfigurationType(this.album.getLaunchTypeID())) == null) {
            return false;
        }
        this.proxyLaunchConfig = this.findExistingLaunchForAlbum(albumLocation);
        if (this.proxyLaunchConfig == null) {
            String lcName = lm.generateLaunchConfigurationName(this.album.getDisplayName());
            ILaunchConfigurationWorkingCopy proxyLaunchConfigWC = launchType.newInstance(null, lcName);
            proxyLaunchConfigWC.setAttributes(this.album.getLaunchProperties());
            proxyLaunchConfigWC.setAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", configuration.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", ""));
            this.proxyLaunchConfig = proxyLaunchConfigWC.doSave();
        }
        Job launchJob = new Job("Launching " + configuration.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SnapshotLaunchDelegate.this.proxyLaunchConfig.launch("debug", (IProgressMonitor)new NullProgressMonitor(), false, true);
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        launchJob.schedule();
        return false;
    }

    private ILaunchConfiguration findExistingLaunchForAlbum(String albumLocation) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = lm.getLaunchConfigurationType(this.album.getLaunchTypeID());
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = lm.getLaunchConfigurations(launchType);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (albumLocation.equals(configuration.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", ""))) {
                    return configuration;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        return null;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.proxyLaunchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor(), false, true);
    }

    public String getDebugModelID() {
        return SNAPSHOT_DEBUG_MODEL_ID;
    }

    protected Sequence getLiveLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        return null;
    }

    protected IDsfDebugServicesFactory newServiceFactory() {
        return null;
    }

    protected String getPluginID() {
        return EDCDebugger.getUniqueIdentifier();
    }
}

