/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IAddressExpressionEvaluator;
import org.eclipse.cdt.debug.edc.IJumpToAddress;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IRunControl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunControl
extends AbstractEDCService
implements IRunControl2,
ICachingService,
ISnapshotContributor,
IDSFServiceUsingTCF {
    public static final String EXECUTION_CONTEXT = "execution_context";
    public static final String EXECUTION_CONTEXT_REGISTERS = "execution_context_registers";
    public static final String EXECUTION_CONTEXT_MODULES = "execution_context_modules";
    public static final String EXECUTION_CONTEXT_FRAMES = "execution_context_frames";
    public static final String PROP_PARENT_ID = "ParentID";
    public static final String PROP_IS_CONTAINER = "IsContainer";
    public static final String PROP_HAS_STATE = "HasState";
    public static final String PROP_CAN_RESUME = "CanResume";
    public static final String PROP_CAN_COUNT = "CanCount";
    public static final String PROP_CAN_SUSPEND = "CanSuspend";
    public static final String PROP_CAN_TERMINATE = "CanTerminate";
    public static final String PROP_IS_SUSPENDED = "State";
    public static final String PROP_MESSAGE = "Message";
    public static final String PROP_SUSPEND_PC = "SuspendPC";
    private static final String EXECUTION_CONTEXTS = "execution_contexts";
    private org.eclipse.tm.tcf.services.IRunControl tcfRunService;
    private RootExecutionDMC rootExecutionDMC;
    private final Map<String, ExecutionDMC> dmcsByID = new HashMap<String, ExecutionDMC>();
    private static long steppingStartTime = 0L;
    private final IRunControl.RunControlListener runListener = new IRunControl.RunControlListener(){

        public void containerResumed(String[] context_ids) {
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                ExecutionDMC dmc = RunControl.this.rootExecutionDMC;
                String parentID = ctx.getParentID();
                if (parentID != null) {
                    dmc = (ExecutionDMC)RunControl.this.dmcsByID.get(parentID);
                }
                if (dmc != null) {
                    ((ExecutionDMC)dmc).contextAdded(ctx.getProperties(), ctx);
                }
                ++n2;
            }
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextException(String context, String msg) {
            ExecutionDMC dmc = RunControl.this.getContext(context);
            dmc.contextException(msg);
        }

        public void contextRemoved(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextID = stringArray[n2];
                ExecutionDMC dmc = RunControl.this.getContext(contextID);
                if (!$assertionsDisabled && dmc == null) {
                    throw new AssertionError();
                }
                if (dmc != null) {
                    dmc.detachFromDebugger();
                }
                ++n2;
            }
        }

        public void contextResumed(String context) {
            ExecutionDMC dmc = RunControl.this.getContext(context);
            dmc.contextResumed(true);
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
            ExecutionDMC dmc = RunControl.this.getContext(context);
            if (dmc != null) {
                dmc.contextSuspended(pc, reason, params);
            } else {
                EDCDebugger.getMessageLogger().logError(MessageFormat.format("Unkown context [{0}] is reported in suspended event. Make sure TCF agent has reported contextAdded event first.", context), null);
            }
        }
    };

    private static IRunControl.StateChangeReason toStateChangeReason(String s) {
        if (s == null) {
            return IRunControl.StateChangeReason.UNKNOWN;
        }
        if (s.equals("Suspended")) {
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
        if (s.equals("Step")) {
            return IRunControl.StateChangeReason.STEP;
        }
        if (s.equals("Breakpoint")) {
            return IRunControl.StateChangeReason.BREAKPOINT;
        }
        if (s.equals("Exception")) {
            return IRunControl.StateChangeReason.EXCEPTION;
        }
        if (s.equals("Container")) {
            return IRunControl.StateChangeReason.CONTAINER;
        }
        if (s.equals("Watchpoint")) {
            return IRunControl.StateChangeReason.WATCHPOINT;
        }
        if (s.equals("Signal")) {
            return IRunControl.StateChangeReason.SIGNAL;
        }
        if (s.equals("Shared Library")) {
            return IRunControl.StateChangeReason.SHAREDLIB;
        }
        if (s.equals("Error")) {
            return IRunControl.StateChangeReason.ERROR;
        }
        return IRunControl.StateChangeReason.UNKNOWN;
    }

    public RunControl(DsfSession session) {
        super(session, new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), RunControl.class.getName(), ISnapshotContributor.class.getName()});
        this.initializeRootExecutionDMC();
    }

    private void initializeRootExecutionDMC() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("ID", "root");
        this.rootExecutionDMC = new RootExecutionDMC(props);
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(((ExecutionDMC)context).isSuspended() ? Boolean.TRUE : Boolean.FALSE));
        rm.done();
    }

    public void canStep(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(((ExecutionDMC)context).isSuspended() ? Boolean.TRUE : Boolean.FALSE));
        rm.done();
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(((ExecutionDMC)context).isSuspended() ? Boolean.FALSE : Boolean.TRUE));
        rm.done();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        if (c instanceof ProcessExecutionDMC) {
            ProcessExecutionDMC edmc = (ProcessExecutionDMC)c;
            ExecutionDMC[] threads = edmc.getChildren();
            IRunControl.IExecutionDMContext[] threadArray = new IRunControl.IExecutionDMContext[threads.length];
            System.arraycopy(threads, 0, threadArray, 0, threads.length);
            rm.setData((Object)threadArray);
        }
        rm.done();
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (dmc instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)dmc;
            rm.setData((Object)new ExecutionData(exedmc.isSuspended() ? exedmc.getStateChangeReason() : IRunControl.StateChangeReason.UNKNOWN, exedmc.getStateChangeDetails()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
        }
        rm.done();
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        if (context instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)context;
            return exedmc.isStepping();
        }
        return false;
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        if (context instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)context;
            return exedmc.isSuspended();
        }
        return false;
    }

    public void resume(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)MessageFormat.format("resume context {0}", context));
        if (!(context instanceof ExecutionDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
            rm.done();
        }
        final ExecutionDMC dmc = (ExecutionDMC)context;
        Breakpoints bpService = (Breakpoints)this.getServicesTracker().getService(Breakpoints.class);
        if (bpService.usesTCFBreakpointService()) {
            dmc.resume(rm);
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl", (Object)MessageFormat.format("resume() done on context {0}", dmc));
        } else {
            this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    dmc.resume(rm);
                    EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl", (Object)MessageFormat.format("resume() done on context {0}", dmc));
                }
            });
        }
    }

    private void prepareToRun(final ExecutionDMC dmc, DataRequestMonitor<Boolean> drm) {
        String latestPC = dmc.getPC();
        if (latestPC != null) {
            Breakpoints bpService = (Breakpoints)this.getServicesTracker().getService(Breakpoints.class);
            Breakpoints.BreakpointDMData bp = bpService.findUserBreakpoint((IAddress)new Addr64(latestPC, 16));
            if (bp != null) {
                bpService.disableBreakpoint(bp, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, bpService, bp){
                    private final /* synthetic */ DataRequestMonitor val$drm;
                    private final /* synthetic */ Breakpoints val$bpService;
                    private final /* synthetic */ Breakpoints.BreakpointDMData val$bp;
                    {
                        this.val$drm = dataRequestMonitor;
                        this.val$bpService = breakpoints;
                        this.val$bp = breakpointDMData;
                        super($anonymous0, $anonymous1);
                    }

                    protected void handleSuccess() {
                        dmc.contextResumed(false);
                        dmc.singleStep(true, new RequestMonitor((Executor)RunControl.this.getExecutor(), (RequestMonitor)this.val$drm){

                            protected void handleSuccess() {
                                val$drm.setData((Object)true);
                                val$bpService.enableBreakpoint(val$bp, (RequestMonitor)val$drm);
                            }
                        });
                    }
                });
            } else {
                drm.setData((Object)false);
                drm.done();
            }
        } else {
            drm.setData((Object)false);
            drm.done();
        }
    }

    public static boolean timeStepping() {
        return false;
    }

    public static long getSteppingStartTime() {
        return steppingStartTime;
    }

    public void step(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)MessageFormat.format("{0} context {1}", stepType, context));
        if (!(context instanceof ExecutionDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
            rm.done();
        }
        if (RunControl.timeStepping()) {
            steppingStartTime = System.currentTimeMillis();
        }
        ExecutionDMC dmc = (ExecutionDMC)context;
        dmc.setStepping(true);
        Addr64 pcAddress = null;
        if (dmc.getPC() == null) {
            stepType = IRunControl.StepType.INSTRUCTION_STEP_INTO;
        } else {
            pcAddress = new Addr64(dmc.getPC(), 16);
        }
        if (stepType == IRunControl.StepType.STEP_RETURN) {
            stepType = IRunControl.StepType.INSTRUCTION_STEP_RETURN;
        }
        if (stepType == IRunControl.StepType.STEP_OVER || stepType == IRunControl.StepType.STEP_INTO) {
            IEDCSymbolReader reader;
            IModules.ISymbolDMContext symCtx;
            IEDCModules moduleService = (IEDCModules)this.getServicesTracker().getService(Modules.class);
            IEDCModuleDMContext module = moduleService.getModuleByAddress(symCtx = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class), (IAddress)pcAddress);
            if (module != null && (reader = module.getSymbolReader()) != null) {
                IAddress linkAddress = module.toLinkAddress((IAddress)pcAddress);
                IModuleLineEntryProvider lineEntryProvider = reader.getModuleScope().getModuleLineEntryProvider();
                ILineEntry line = lineEntryProvider.getLineEntryAtAddress(linkAddress);
                if (line != null) {
                    ILineEntry nextLine;
                    IAddress endAddr = module.toRuntimeAddress(line.getHighAddress());
                    if (stepType == IRunControl.StepType.STEP_OVER && (nextLine = lineEntryProvider.getNextLineEntry(line)) != null) {
                        endAddr = module.toRuntimeAddress(nextLine.getLowAddress());
                    }
                    this.stepAddressRange(dmc, stepType == IRunControl.StepType.STEP_INTO, (IAddress)pcAddress, endAddr, rm);
                    EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl", (Object)"source level stepping.");
                    return;
                }
            }
            stepType = stepType == IRunControl.StepType.STEP_INTO ? IRunControl.StepType.INSTRUCTION_STEP_INTO : IRunControl.StepType.INSTRUCTION_STEP_OVER;
        }
        if (stepType == IRunControl.StepType.INSTRUCTION_STEP_OVER) {
            this.stepOverOneInstruction(dmc, (IAddress)pcAddress, rm);
        } else if (stepType == IRunControl.StepType.INSTRUCTION_STEP_INTO) {
            this.stepIntoOneInstruction(dmc, rm);
        } else if (stepType == IRunControl.StepType.INSTRUCTION_STEP_RETURN) {
            this.stepOut(dmc, (IAddress)pcAddress, rm);
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
    }

    private void stepOut(final ExecutionDMC dmc, IAddress pcAddress, final RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)("Step out from address " + pcAddress.toHexAddressString()));
        if (dmc.supportsStepMode(IRunControl.StepType.STEP_RETURN)) {
            dmc.stepOut(rm);
            return;
        }
        Stack stackService = (Stack)((Object)this.getServicesTracker().getService(Stack.class));
        IStack.IFrameDMContext[] frames = stackService.getFramesForDMC(dmc, 0, 1);
        if (frames.length <= 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Cannot step out as no caller frame is available.", null));
            rm.done();
            return;
        }
        if (this.handleSteppingOutOfInLineFunctions(dmc, frames, rm)) {
            return;
        }
        final IAddress stepToAddress = ((Stack.StackFrameDMC)frames[1]).getIPAddress();
        boolean keepgoing = true;
        if (!keepgoing) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Cannot step out as no caller frame is available.", null));
            rm.done();
            return;
        }
        final Breakpoints bpService = (Breakpoints)this.getServicesTracker().getService(Breakpoints.class);
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Addr64 newPC;
                boolean goon = true;
                if (((Boolean)this.getData()).booleanValue() && (newPC = new Addr64(dmc.getPC(), 16)).equals((Object)stepToAddress)) {
                    goon = false;
                }
                if (goon) {
                    bpService.setTempBreakpoint(dmc, stepToAddress, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            dmc.resumeForStepping(rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    protected void handleModuleLoadedEvent(IEDCExecutionDMC dmc, Map<String, Object> moduleProperties) {
        IModules.ISymbolDMContext symbolContext = dmc.getSymbolDMContext();
        if (symbolContext != null) {
            Modules modulesService = (Modules)this.getServicesTracker().getService(Modules.class);
            modulesService.moduleLoaded(symbolContext, dmc, moduleProperties);
        }
    }

    protected void handleModuleUnloadedEvent(IEDCExecutionDMC dmc, Map<String, Object> moduleProperties) {
        IModules.ISymbolDMContext symbolContext = dmc.getSymbolDMContext();
        if (symbolContext != null) {
            Modules modulesService = (Modules)this.getServicesTracker().getService(Modules.class);
            modulesService.moduleUnloaded(symbolContext, dmc, moduleProperties);
        }
    }

    private boolean handleSteppingOutOfInLineFunctions(final ExecutionDMC dmc, IStack.IFrameDMContext[] frames, final RequestMonitor rm) {
        IScope parentScope;
        assert (frames.length > 1 && frames[0] instanceof Stack.StackFrameDMC);
        Stack.StackFrameDMC currentFrame = (Stack.StackFrameDMC)frames[0];
        IEDCSymbols symbolsService = (IEDCSymbols)this.getServicesTracker().getService(Symbols.class);
        IFunctionScope functionScope = symbolsService.getFunctionAtAddress(dmc.getSymbolDMContext(), currentFrame.getIPAddress());
        if (functionScope != null && (parentScope = functionScope.getParent()) instanceof IFunctionScope && currentFrame.getModule() != null && !currentFrame.getModule().toRuntimeAddress(functionScope.getLowAddress()).equals((Object)currentFrame.getIPAddress())) {
            this.stepAddressRange(dmc, false, currentFrame.getIPAddress(), functionScope.getHighAddress(), new RequestMonitor((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    RunControl.this.step(dmc, IRunControl.StepType.STEP_OVER, new RequestMonitor((Executor)RunControl.this.getExecutor(), new RequestMonitor((Executor)RunControl.this.getExecutor(), rm)));
                }
            });
            return true;
        }
        return false;
    }

    private void stepOverOneInstruction(final ExecutionDMC dmc, final IAddress pcAddress, final RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)("address " + pcAddress.toHexAddressString()));
        if (dmc.supportsStepMode(IRunControl.StepType.INSTRUCTION_STEP_OVER)) {
            dmc.singleStep(false, rm);
            return;
        }
        final IDisassembler disassembler = this.getTargetEnvironmentService().getDisassembler();
        if (disassembler == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No disassembler is available yet.", null));
            rm.done();
            return;
        }
        Memory memoryService = (Memory)this.getServicesTracker().getService(Memory.class);
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        int maxInstLength = this.getTargetEnvironmentService().getLongestInstructionLength();
        memoryService.getMemory(mem_dmc, pcAddress, 0L, 1, maxInstLength, new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                IDisassembledInstruction inst;
                MemoryByte[] data = (MemoryByte[])this.getData();
                byte[] bytes = new byte[data.length];
                int i = 0;
                while (i < data.length) {
                    bytes[i] = data[i].getValue();
                    ++i;
                }
                ByteBuffer codeBuf = ByteBuffer.wrap(bytes);
                HashMap<String, Object> options = new HashMap<String, Object>();
                try {
                    inst = disassembler.disassembleOneInstruction(pcAddress, codeBuf, options);
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                final boolean isSubroutineCall = inst.getJumpToAddress() != null && inst.getJumpToAddress().isSubroutineAddress();
                final IAddress nextInstructionAddress = pcAddress.add((long)inst.getSize());
                RunControl.this.stepIntoOneInstruction(dmc, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (!isSubroutineCall) {
                            rm.done();
                        } else {
                            Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                            bpService.setTempBreakpoint(dmc, nextInstructionAddress, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                                protected void handleSuccess() {
                                    dmc.resumeForStepping(rm);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void stepAddressRange(final ExecutionDMC dmc, final boolean stepIn, final IAddress startAddr, final IAddress endAddr, final RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)MessageFormat.format("address range [{0},{1})", startAddr.toHexAddressString(), endAddr.toHexAddressString()));
        if (dmc.supportsStepMode(stepIn ? IRunControl.StepType.STEP_INTO : IRunControl.StepType.STEP_OVER)) {
            dmc.stepRange(stepIn, startAddr, endAddr, rm);
            return;
        }
        final IDisassembler disassembler = this.getTargetEnvironmentService().getDisassembler();
        if (disassembler == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No disassembler is available yet.", null));
            rm.done();
            return;
        }
        final Memory memoryService = (Memory)this.getServicesTracker().getService(Memory.class);
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        int memSize = startAddr.distanceTo(endAddr).intValue();
        final IAddress pcAddress = startAddr;
        memoryService.getMemory(mem_dmc, startAddr, 0L, 1, memSize, new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                List<IDisassembledInstruction> instList;
                MemoryByte[] data = (MemoryByte[])this.getData();
                byte[] bytes = new byte[data.length];
                int i = 0;
                while (i < data.length) {
                    bytes[i] = data[i].getValue();
                    ++i;
                }
                ByteBuffer codeBuf = ByteBuffer.wrap(bytes);
                HashMap<String, Object> options = new HashMap<String, Object>();
                try {
                    instList = disassembler.disassembleInstructions(startAddr, endAddr, codeBuf, options);
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                final ArrayList<IAddress> stopPoints = new ArrayList<IAddress>();
                ArrayList<IAddress> runToAndCheckPoints = new ArrayList<IAddress>();
                for (IDisassembledInstruction inst : instList) {
                    IAddress instAddr = inst.getAddress();
                    IJumpToAddress jta = inst.getJumpToAddress();
                    if (jta == null) continue;
                    if (!jta.isImmediate()) {
                        if (inst.getAddress().equals((Object)pcAddress)) {
                            IAddress addr;
                            String expr = (String)jta.getValue();
                            if (expr.equals("ret-far") || expr.equals("ret-near")) {
                                RunControl.this.stepIntoOneInstruction(dmc, rm);
                                return;
                            }
                            if (jta.isSubroutineAddress() && !stepIn) continue;
                            IAddressExpressionEvaluator evaluator = RunControl.this.getTargetEnvironmentService().getAddressExpressionEvaluator();
                            if (evaluator == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No evaluator for address expression yet.", null));
                                rm.done();
                                return;
                            }
                            Registers regService = (Registers)RunControl.this.getServicesTracker().getService(Registers.class);
                            try {
                                addr = evaluator.evaluate(dmc, expr, regService, memoryService);
                            }
                            catch (CoreException e) {
                                rm.setStatus(e.getStatus());
                                rm.done();
                                return;
                            }
                            stopPoints.add(addr);
                            continue;
                        }
                        runToAndCheckPoints.add(instAddr);
                        continue;
                    }
                    IAddress jumpAddress = (IAddress)jta.getValue();
                    if (jta.isSoleDestination()) {
                        if (jta.isSubroutineAddress()) {
                            if (!stepIn) continue;
                            stopPoints.add(jumpAddress);
                            continue;
                        }
                        if (startAddr.compareTo((Object)jumpAddress) <= 0 && jumpAddress.compareTo((Object)endAddr) < 0) continue;
                        stopPoints.add(jumpAddress);
                        continue;
                    }
                    if (startAddr.compareTo((Object)jumpAddress) <= 0 && jumpAddress.compareTo((Object)endAddr) < 0) continue;
                    stopPoints.add(jumpAddress);
                }
                stopPoints.add(endAddr);
                if (runToAndCheckPoints.size() > 0) {
                    if (runToAndCheckPoints.size() > 1) {
                        EDCDebugger.getMessageLogger().log((IStatus)new Status(2, "org.eclipse.cdt.debug.edc", MessageFormat.format("More than one run-to-check points in the address range [{0},{1}). Stepping might fail.", startAddr.toHexAddressString(), endAddr.toHexAddressString())));
                    }
                    RunControl.this.stepAddressRange(dmc, stepIn, startAddr, (IAddress)runToAndCheckPoints.get(0), new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            Addr64 newPC = new Addr64(dmc.getPC(), 16);
                            boolean doneWithStepping = false;
                            for (IAddress addr : stopPoints) {
                                if (!newPC.equals((Object)addr)) continue;
                                doneWithStepping = true;
                                break;
                            }
                            Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                            if (bpService.findUserBreakpoint((IAddress)newPC) != null) {
                                doneWithStepping = true;
                            }
                            if (!doneWithStepping) {
                                RunControl.this.stepAddressRange(dmc, stepIn, (IAddress)newPC, endAddr, rm);
                            } else {
                                rm.done();
                            }
                        }
                    });
                } else {
                    RunControl.this.prepareToRun(dmc, (DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            boolean goon = true;
                            Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                            if (((Boolean)this.getData()).booleanValue()) {
                                Addr64 newPC = new Addr64(dmc.getPC(), 16);
                                if (bpService.findUserBreakpoint((IAddress)newPC) != null) {
                                    goon = false;
                                } else {
                                    for (IAddress addr : stopPoints) {
                                        if (!newPC.equals((Object)addr)) continue;
                                        goon = false;
                                        break;
                                    }
                                }
                            }
                            if (goon) {
                                CountingRequestMonitor setTempBpRM = new CountingRequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                                    protected void handleSuccess() {
                                        dmc.resumeForStepping(rm);
                                    }
                                };
                                setTempBpRM.setDoneCount(stopPoints.size());
                                for (IAddress addr : stopPoints) {
                                    bpService.setTempBreakpoint(dmc, addr, (RequestMonitor)setTempBpRM);
                                }
                            } else {
                                rm.done();
                            }
                        }
                    }));
                }
            }
        });
    }

    private void stepIntoOneInstruction(final ExecutionDMC dmc, final RequestMonitor rm) {
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    rm.done();
                } else {
                    dmc.setStepping(true);
                    dmc.singleStep(true, rm);
                }
            }
        });
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor requestMonitor) {
        if (context instanceof ExecutionDMC) {
            ((ExecutionDMC)context).suspend(requestMonitor);
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
            requestMonitor.done();
        }
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        rm.done();
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        Registers regService = (Registers)this.getServicesTracker().getService(Registers.class);
        regService.flushCache(context);
    }

    public void shutdown(RequestMonitor monitor) {
        if (this.tcfRunService != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    RunControl.this.tcfRunService.removeListener(RunControl.this.runListener);
                }
            });
        }
        this.unregister();
        super.shutdown(monitor);
    }

    public RootExecutionDMC getRootDMC() {
        return this.rootExecutionDMC;
    }

    @Override
    public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
        ExecutionDMC[] dmcs;
        Element contextsElement = document.createElement(EXECUTION_CONTEXTS);
        ExecutionDMC[] executionDMCArray = dmcs = this.rootExecutionDMC.getChildren();
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionDMC executionDMC = executionDMCArray[n2];
            Element dmcElement = executionDMC.takeShapshot(album, document, monitor);
            contextsElement.appendChild(dmcElement);
            ++n2;
        }
        return contextsElement;
    }

    public ExecutionDMC getContext(String contextID) {
        return this.dmcsByID.get(contextID);
    }

    @Override
    public void loadSnapshot(Element snapshotRoot) throws Exception {
        NodeList ecElements = snapshotRoot.getElementsByTagName(EXECUTION_CONTEXTS);
        this.rootExecutionDMC.resumeAll();
        this.initializeRootExecutionDMC();
        this.rootExecutionDMC.loadSnapshot((Element)ecElements.item(0));
    }

    @Override
    public void tcfServiceReady(IService service) {
        if (service instanceof org.eclipse.tm.tcf.services.IRunControl) {
            this.tcfRunService = (org.eclipse.tm.tcf.services.IRunControl)service;
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    RunControl.this.tcfRunService.addListener(RunControl.this.runListener);
                }
            });
        } else assert (false);
    }

    private void detachAllContexts() {
        this.getRootDMC().detachFromDebugger();
    }

    public void terminateAllContexts(final RequestMonitor rm) {
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleError() {
                RunControl.this.detachAllContexts();
                if (rm != null) {
                    rm.done();
                }
            }
        };
        ExecutionDMC[] processes = this.getRootDMC().getChildren();
        crm.setDoneCount(processes.length);
        ExecutionDMC[] executionDMCArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionDMC e = executionDMCArray[n2];
            e.terminate((RequestMonitor)crm);
            ++n2;
        }
    }

    public void canRunToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void runToLine(final IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean skipBreakpoints, final RequestMonitor rm) {
        this.getLineAddress(context, sourceFile, lineNumber, new DataRequestMonitor<List<IAddress>>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                } else {
                    RunControl.this.runToAddresses(context, (List)this.getData(), rm);
                }
            }
        });
    }

    private void runToAddresses(IRunControl.IExecutionDMContext context, final List<IAddress> addrs, final RequestMonitor rm) {
        final ExecutionDMC dmc = (ExecutionDMC)context;
        assert (dmc != null);
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                    return;
                }
                CountingRequestMonitor settingBP_crm = new CountingRequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            rm.setStatus(this.getStatus());
                            rm.done();
                        } else {
                            dmc.resume(rm);
                        }
                    }
                };
                settingBP_crm.setDoneCount(addrs.size());
                Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                for (IAddress a : addrs) {
                    bpService.setTempBreakpoint(dmc, a, (RequestMonitor)settingBP_crm);
                }
            }
        });
    }

    public void canRunToAddress(IRunControl.IExecutionDMContext context, IAddress address, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void runToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean skipBreakpoints, RequestMonitor rm) {
        ArrayList<IAddress> addrs = new ArrayList<IAddress>(1);
        addrs.add(address);
        this.runToAddresses(context, addrs, rm);
    }

    public void canMoveToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean resume, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void moveToLine(final IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, final boolean resume, final RequestMonitor rm) {
        this.getLineAddress(context, sourceFile, lineNumber, new DataRequestMonitor<List<IAddress>>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                } else {
                    List addrs = (List)this.getData();
                    RunControl.this.moveToAddress(context, (IAddress)addrs.get(0), resume, rm);
                }
            }
        });
    }

    public void canMoveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void moveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, RequestMonitor rm) {
        Registers regService = (Registers)this.getServicesTracker().getService(Registers.class);
        assert (context instanceof ExecutionDMC);
        ExecutionDMC dmc = (ExecutionDMC)context;
        String newPC = address.toString(16);
        if (!newPC.equals(dmc.getPC())) {
            regService.writeRegister(dmc, this.getTargetEnvironmentService().getPCRegisterID(), newPC);
            dmc.setPC(newPC);
        }
        if (resume) {
            this.resume(context, rm);
        } else {
            this.getSession().dispatchEvent((Object)new SuspendedEvent(context, IRunControl.StateChangeReason.USER_REQUEST, new HashMap<String, Object>()), this.getProperties());
            rm.done();
        }
    }

    private void getLineAddress(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<List<IAddress>> drm) {
        ArrayList addrs = new ArrayList(1);
        ExecutionDMC dmc = (ExecutionDMC)context;
        if (dmc == null || !dmc.isSuspended()) {
            drm.setData(addrs);
            drm.done();
            return;
        }
        Modules moduleService = (Modules)this.getServicesTracker().getService(Modules.class);
        moduleService.getLineAddress(dmc, sourceFile, lineNumber, drm);
    }

    public static boolean isNonContainer(IDMContext dmc) {
        return !(dmc instanceof IRunControl.IContainerDMContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BareDeviceExecutionDMC
    extends ThreadExecutionDMC
    implements IProcesses.IProcessDMContext,
    IModules.ISymbolDMContext,
    IBreakpoints.IBreakpointsTargetDMContext {
        public BareDeviceExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
            assert (!((Boolean)properties.get(RunControl.PROP_IS_CONTAINER)).booleanValue());
        }

        @Override
        public boolean canDetach() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ExecutionDMC
    extends DMContext
    implements IRunControl.IExecutionDMContext,
    ISnapshotContributor,
    IEDCExecutionDMC {
        private final List<ExecutionDMC> children;
        private IRunControl.StateChangeReason stateChangeReason;
        private String stateChangeDetails;
        private final IRunControl.RunControlContext tcfContext;
        private final ExecutionDMC parentExecutionDMC;
        private String latestPC;
        private RequestMonitor steppingRM;
        private boolean isStepping;

        public ExecutionDMC(ExecutionDMC parent, Map<String, Object> props, IRunControl.RunControlContext tcfContext) {
            IDMContext[] iDMContextArray;
            if (parent == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = parent;
            }
            super((IDsfService)RunControl.this, iDMContextArray, props);
            this.children = Collections.synchronizedList(new ArrayList());
            this.stateChangeReason = IRunControl.StateChangeReason.UNKNOWN;
            this.stateChangeDetails = null;
            this.latestPC = null;
            this.steppingRM = null;
            this.isStepping = false;
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", new Object[]{parent, this.properties});
            this.parentExecutionDMC = parent;
            this.tcfContext = tcfContext;
            if (props != null) {
                RunControl.this.dmcsByID.put(this.getID(), this);
            }
            if (parent != null) {
                parent.addChild(this);
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addChild(ExecutionDMC executionDMC) {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                this.children.add(executionDMC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeChild(IEDCExecutionDMC executionDMC) {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                this.children.remove(executionDMC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutionDMC[] getChildren() {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                return this.children.toArray(new ExecutionDMC[this.children.size()]);
            }
        }

        public abstract ExecutionDMC contextAdded(Map<String, Object> var1, IRunControl.RunControlContext var2);

        public abstract boolean canDetach();

        @Override
        public void loadSnapshot(Element element) throws Exception {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)element);
            NodeList ecElements = element.getElementsByTagName(RunControl.EXECUTION_CONTEXT);
            int numcontexts = ecElements.getLength();
            int i = 0;
            while (i < numcontexts) {
                Element contextElement = (Element)ecElements.item(i);
                if (contextElement.getParentNode().equals(element)) {
                    try {
                        Element propElement = (Element)contextElement.getElementsByTagName("properties").item(0);
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        SnapshotUtils.initializeFromXML(propElement, properties);
                        ExecutionDMC exeDMC = this.contextAdded(properties, null);
                        exeDMC.loadSnapshot(contextElement);
                    }
                    catch (CoreException e) {
                        EDCDebugger.getMessageLogger().logError(null, e);
                    }
                }
                ++i;
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            ExecutionDMC[] dmcs;
            Element contextElement = document.createElement(RunControl.EXECUTION_CONTEXT);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            ExecutionDMC[] executionDMCArray = dmcs = this.getChildren();
            int n = dmcs.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC executionDMC = executionDMCArray[n2];
                Element dmcElement = executionDMC.takeShapshot(album, document, monitor);
                contextElement.appendChild(dmcElement);
                ++n2;
            }
            return contextElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            Map map = this.properties;
            synchronized (map) {
                Boolean suspended = (Boolean)this.properties.get(RunControl.PROP_IS_SUSPENDED);
                if (suspended != null) {
                    return suspended;
                }
            }
            return false;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.stateChangeReason;
        }

        public String getStateChangeDetails() {
            return this.stateChangeDetails;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsSuspended(boolean isSuspended) {
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_IS_SUSPENDED, isSuspended);
            }
            if (this.getParent() != null) {
                this.getParent().childIsSuspended(isSuspended);
            }
        }

        private void childIsSuspended(boolean isSuspended) {
            if (isSuspended) {
                this.setIsSuspended(true);
            } else {
                boolean anySuspended = false;
                ExecutionDMC[] executionDMCArray = this.getChildren();
                int n = executionDMCArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionDMC childDMC = executionDMCArray[n2];
                    if (childDMC.isSuspended()) {
                        anySuspended = true;
                        break;
                    }
                    ++n2;
                }
                if (!anySuspended) {
                    this.setIsSuspended(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contextException(String msg) {
            this.setIsSuspended(true);
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_MESSAGE, msg);
            }
            this.stateChangeReason = IRunControl.StateChangeReason.EXCEPTION;
            RunControl.this.getSession().dispatchEvent((Object)new SuspendedEvent(this, IRunControl.StateChangeReason.EXCEPTION, new HashMap<String, Object>()), RunControl.this.getProperties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contextSuspended(String pc, String reason, final Map<String, Object> params) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", new Object[]{pc, reason, params});
            if (pc != null) {
                pc = Long.toHexString(Long.parseLong(pc));
            }
            this.latestPC = pc;
            this.setIsSuspended(true);
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_MESSAGE, reason);
                this.properties.put(RunControl.PROP_SUSPEND_PC, pc);
            }
            this.stateChangeReason = RunControl.toStateChangeReason(reason);
            this.stateChangeDetails = (String)params.get("message");
            if (this.stateChangeReason == IRunControl.StateChangeReason.SHAREDLIB) {
                this.handleModuleEvent(this, params);
            } else {
                final ExecutionDMC dmc = this;
                this.preprocessSuspend(pc, new DataRequestMonitor<Boolean>((Executor)RunControl.this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (((Boolean)this.getData()).booleanValue()) {
                            RunControl.this.getSession().dispatchEvent((Object)new SuspendedEvent(dmc, ExecutionDMC.this.stateChangeReason, params), RunControl.this.getProperties());
                            if (ExecutionDMC.this.steppingRM != null) {
                                ExecutionDMC.this.steppingRM.done();
                                ExecutionDMC.this.steppingRM = null;
                            }
                            ExecutionDMC.this.setStepping(false);
                            Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                            bpService.removeAllTempBreakpoints(new RequestMonitor((Executor)RunControl.this.getExecutor(), null));
                        } else {
                            RunControl.this.resume(dmc, new RequestMonitor((Executor)RunControl.this.getExecutor(), null));
                        }
                    }
                });
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        private void handleModuleEvent(final IEDCExecutionDMC dmc, final Map<String, Object> moduleProperties) {
            RunControl.this.getSession().getExecutor().execute(new Runnable(){

                public void run() {
                    boolean loaded = true;
                    Object loadedValue = moduleProperties.get("Loaded");
                    if (loadedValue != null && loadedValue instanceof Boolean) {
                        loaded = (Boolean)loadedValue;
                    }
                    if (loaded) {
                        RunControl.this.handleModuleLoadedEvent(dmc, moduleProperties);
                    } else {
                        RunControl.this.handleModuleUnloadedEvent(dmc, moduleProperties);
                    }
                }
            });
        }

        private void preprocessSuspend(final String pc, final DataRequestMonitor<Boolean> drm) {
            final ExecutionDMC dmc = this;
            RunControl.this.getSession().getExecutor().execute(new Runnable(){

                public void run() {
                    Breakpoints.BreakpointDMData bp;
                    Breakpoints bpService = (Breakpoints)RunControl.this.getServicesTracker().getService(Breakpoints.class);
                    Registers regService = (Registers)RunControl.this.getServicesTracker().getService(Registers.class);
                    String pcString = pc == null ? regService.getRegisterValue((IRunControl.IExecutionDMContext)dmc, RunControl.this.getTargetEnvironmentService().getPCRegisterID()) : pc;
                    ExecutionDMC.this.latestPC = pcString;
                    if (ExecutionDMC.this.stateChangeReason != IRunControl.StateChangeReason.BREAKPOINT) {
                        drm.setData((Object)true);
                        drm.done();
                        return;
                    }
                    if (!bpService.usesTCFBreakpointService()) {
                        long pcValue = Long.valueOf(pcString, 16);
                        pcString = Long.toHexString(pcValue -= (long)RunControl.this.getTargetEnvironmentService().getBreakpointInstruction((IDMContext)dmc, (IAddress)new Addr64(pcString, 16)).length);
                        if (bpService.findBreakpoint((IAddress)new Addr64(pcString, 16)) != null) {
                            regService.writeRegister(dmc, RunControl.this.getTargetEnvironmentService().getPCRegisterID(), pcString);
                            ExecutionDMC.this.latestPC = pcString;
                        }
                    }
                    if ((bp = bpService.findUserBreakpoint((IAddress)new Addr64(ExecutionDMC.this.latestPC, 16))) != null) {
                        bpService.evaluateBreakpointCondition(dmc, bp, (DataRequestMonitor<Boolean>)drm);
                    } else {
                        drm.setData((Object)true);
                        drm.done();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean canTerminate() {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl");
            Boolean result = false;
            Map map = this.properties;
            synchronized (map) {
                try {
                    result = (Boolean)this.properties.get(RunControl.PROP_CAN_TERMINATE);
                }
                catch (Exception e) {
                    EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Error in canTerminate", (Throwable)e);
                }
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl", (Object)result);
            return result;
        }

        public boolean supportsStepMode(IRunControl.StepType type) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
            int mode = 0;
            switch (type) {
                case STEP_OVER: {
                    mode = 12;
                    break;
                }
                case STEP_INTO: {
                    mode = 13;
                    break;
                }
                case STEP_RETURN: {
                    mode = 5;
                    break;
                }
                case INSTRUCTION_STEP_OVER: {
                    mode = 1;
                    break;
                }
                case INSTRUCTION_STEP_INTO: {
                    mode = 2;
                }
            }
            return this.tcfContext.canResume(mode);
        }

        public void resume(final RequestMonitor rm) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
            RunControl.this.flushCache((IDMContext)this);
            this.contextResumed(true);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    ExecutionDMC.this.tcfContext.resume(0, 0, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Resume command succeeded.");
                            } else {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Resume command failed.");
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Resume failed.", null));
                            }
                            rm.done();
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void resumeForStepping(final RequestMonitor rm) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            this.contextResumed(true);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    ExecutionDMC.this.tcfContext.resume(0, 0, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Resume command succeeded.");
                                if (!$assertionsDisabled && ExecutionDMC.this.steppingRM != null) {
                                    throw new AssertionError();
                                }
                                ExecutionDMC.this.steppingRM = rm;
                            } else {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Resume command failed.");
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Resume failed.", null));
                                rm.done();
                            }
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void suspend(final RequestMonitor requestMonitor) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    ExecutionDMC.this.tcfContext.suspend(new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
                            requestMonitor.done();
                            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void terminate(final RequestMonitor requestMonitor) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
            if (this.tcfContext != null) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ExecutionDMC.this.tcfContext.terminate(new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this);
                                if (error != null) {
                                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "terminate() failed.", (Throwable)error));
                                }
                                requestMonitor.done();
                                EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
                            }
                        });
                    }
                });
            } else {
                RunControl.this.detachAllContexts();
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        protected ExecutionDMC getParent() {
            return this.parentExecutionDMC;
        }

        public String getPC() {
            return this.latestPC;
        }

        private void setPC(String pc) {
            this.latestPC = pc;
        }

        public void detachFromDebugger() {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl");
            ExecutionDMC[] executionDMCArray = this.getChildren();
            int n = executionDMCArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC e = executionDMCArray[n2];
                e.detachFromDebugger();
                ++n2;
            }
            ExecutionDMC parent = this.getParent();
            if (parent != null) {
                parent.removeChild(this);
            }
            RunControl.this.getSession().dispatchEvent((Object)new ExitedEvent(this), RunControl.this.getProperties());
            if (RunControl.this.getRootDMC().getChildren().length == 0) {
                RunControl.this.getSession().dispatchEvent((Object)new ExitedEvent(RunControl.this.getRootDMC()), RunControl.this.getProperties());
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void resumeAll() {
            this.contextResumed(true);
            ExecutionDMC[] executionDMCArray = this.getChildren();
            int n = executionDMCArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC e = executionDMCArray[n2];
                e.resumeAll();
                ++n2;
            }
        }

        public void contextResumed(boolean sendEvent) {
            ExecutionDMC[] executionDMCArray = this.getChildren();
            int n = executionDMCArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC e = executionDMCArray[n2];
                e.contextResumed(sendEvent);
                ++n2;
            }
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", new Object[]{this, sendEvent});
            this.setIsSuspended(false);
            if (sendEvent) {
                RunControl.this.getSession().dispatchEvent((Object)new ResumedEvent(this), RunControl.this.getProperties());
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void singleStep(final boolean stepInto, final RequestMonitor rm) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this.getName());
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            this.contextResumed(true);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    int mode = stepInto ? 2 : 1;
                    ExecutionDMC.this.tcfContext.resume(mode, 1, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Single step command succeeded.");
                                if (!$assertionsDisabled && ExecutionDMC.this.steppingRM != null) {
                                    throw new AssertionError();
                                }
                                ExecutionDMC.this.steppingRM = rm;
                            } else {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Single step command failed.");
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "singleStep() failed.", null));
                                rm.done();
                            }
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void stepOut(final RequestMonitor rm) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this.getName());
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            this.contextResumed(true);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    ExecutionDMC.this.tcfContext.resume(5, 0, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Step out command succeeded.");
                                if (!$assertionsDisabled && ExecutionDMC.this.steppingRM != null) {
                                    throw new AssertionError();
                                }
                                ExecutionDMC.this.steppingRM = rm;
                            } else {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Step out command failed.");
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "stepOut() failed.", null));
                                rm.done();
                            }
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void stepRange(final boolean stepInto, final IAddress rangeStart, final IAddress rangeEnd, final RequestMonitor rm) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", (Object)this.getName());
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            this.contextResumed(true);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    int mode = stepInto ? 13 : 12;
                    HashMap<String, BigInteger> params = new HashMap<String, BigInteger>();
                    params.put("RANGE_START", rangeStart.getValue());
                    params.put("RANGE_END", rangeEnd.getValue());
                    ExecutionDMC.this.tcfContext.resume(mode, 0, params, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Step range command succeeded.");
                                if (!$assertionsDisabled && ExecutionDMC.this.steppingRM != null) {
                                    throw new AssertionError();
                                }
                                ExecutionDMC.this.steppingRM = rm;
                            } else {
                                EDCDebugger.getDefault().getTrace().trace("/debug/runControl", "Step range command failed.");
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "stepRange() failed.", null));
                                rm.done();
                            }
                        }
                    });
                }
            });
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        public void setStepping(boolean isStepping) {
            this.isStepping = isStepping;
        }

        public boolean isStepping() {
            return this.isStepping;
        }
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData2 {
        private final IRunControl.StateChangeReason reason;
        private final String details;

        ExecutionData(IRunControl.StateChangeReason reason, String details) {
            this.reason = reason;
            this.details = details;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.reason;
        }

        public String getDetails() {
            return this.details;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExitedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ExitedEvent(IRunControl.IExecutionDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessExecutionDMC
    extends ExecutionDMC
    implements IRunControl.IContainerDMContext,
    IProcesses.IProcessDMContext,
    IModules.ISymbolDMContext,
    IBreakpoints.IBreakpointsTargetDMContext,
    IDisassembly.IDisassemblyDMContext {
        public ProcessExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", properties);
            ThreadExecutionDMC newDMC = new ThreadExecutionDMC(this, properties, tcfContext);
            RunControl.this.getSession().dispatchEvent((Object)new StartedEvent(newDMC), RunControl.this.getProperties());
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl", (Object)newDMC);
            return newDMC;
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return this;
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            Modules modulesService = (Modules)RunControl.this.getServicesTracker().getService(Modules.class);
            modulesService.loadModulesForContext(this, element);
            super.loadSnapshot(element);
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            IModules.IModuleDMContext[] modules;
            Element contextElement = super.takeShapshot(album, document, monitor);
            Element modulesElement = document.createElement(RunControl.EXECUTION_CONTEXT_MODULES);
            Modules modulesService = (Modules)RunControl.this.getServicesTracker().getService(Modules.class);
            IModules.IModuleDMContext[] iModuleDMContextArray = modules = modulesService.getModulesForContext(this.getID());
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModules.IModuleDMContext moduleContext = iModuleDMContextArray[n2];
                Modules.ModuleDMC moduleDMC = (Modules.ModuleDMC)moduleContext;
                modulesElement.appendChild(moduleDMC.takeShapshot(album, document, monitor));
                ++n2;
            }
            contextElement.appendChild(modulesElement);
            return contextElement;
        }

        @Override
        public boolean canDetach() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResumedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IResumedDMEvent {
        public ResumedEvent(IRunControl.IExecutionDMContext dmc) {
            super((IDMContext)dmc);
        }

        public IRunControl.StateChangeReason getReason() {
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RootExecutionDMC
    extends ExecutionDMC
    implements ISourceLookup.ISourceLookupDMContext {
        public RootExecutionDMC(Map<String, Object> props) {
            super(null, props, null);
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            Boolean isContainer = (Boolean)properties.get(RunControl.PROP_IS_CONTAINER);
            ExecutionDMC newDMC = isContainer == null || Boolean.TRUE.equals(isContainer) ? new ProcessExecutionDMC(this, properties, tcfContext) : new BareDeviceExecutionDMC(this, properties, tcfContext);
            RunControl.this.getSession().dispatchEvent((Object)new StartedEvent(newDMC), RunControl.this.getProperties());
            return newDMC;
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return null;
        }

        @Override
        public boolean canDetach() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public StartedEvent(IRunControl.IExecutionDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuspendedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.ISuspendedDMEvent {
        private final IRunControl.StateChangeReason reason;
        private final Map<String, Object> params;

        public SuspendedEvent(IRunControl.IExecutionDMContext dmc, IRunControl.StateChangeReason reason, Map<String, Object> params) {
            super((IDMContext)dmc);
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", new Object[]{dmc, reason, params});
            this.reason = reason;
            this.params = params;
        }

        public IRunControl.StateChangeReason getReason() {
            return this.reason;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThreadExecutionDMC
    extends ExecutionDMC
    implements IProcesses.IThreadDMContext,
    IDisassembly.IDisassemblyDMContext {
        public ThreadExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/runControl", new Object[]{parent, properties});
            EDCDebugger.getDefault().getTrace().traceExit("/debug/runControl");
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)this, IModules.ISymbolDMContext.class);
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            super.loadSnapshot(element);
            Registers regService = (Registers)RunControl.this.getServicesTracker().getService(Registers.class);
            regService.loadGroupsForContext(this, element);
            Stack stackService = (Stack)((Object)RunControl.this.getServicesTracker().getService(Stack.class));
            NodeList frameElements = element.getElementsByTagName(RunControl.EXECUTION_CONTEXT_FRAMES);
            int i = 0;
            while (i < frameElements.getLength()) {
                Element frameElement = (Element)frameElements.item(i);
                stackService.loadFramesForContext(this, frameElement);
                ++i;
            }
            RunControl.this.getSession().dispatchEvent((Object)new SuspendedEvent(this, IRunControl.StateChangeReason.EXCEPTION, new HashMap<String, Object>()), RunControl.this.getProperties());
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            IStack.IFrameDMContext[] frames;
            IRegisters.IRegisterGroupDMContext[] regGroups;
            Element contextElement = super.takeShapshot(album, document, monitor);
            Element registersElement = document.createElement(RunControl.EXECUTION_CONTEXT_REGISTERS);
            Registers regService = (Registers)RunControl.this.getServicesTracker().getService(Registers.class);
            IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = regGroups = regService.getGroupsForContext(this);
            int n = regGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.IRegisterGroupDMContext registerGroupDMContext = iRegisterGroupDMContextArray[n2];
                Registers.RegisterGroupDMC regDMC = (Registers.RegisterGroupDMC)registerGroupDMContext;
                registersElement.appendChild(regDMC.takeShapshot(album, document, monitor));
                ++n2;
            }
            contextElement.appendChild(registersElement);
            Element framesElement = document.createElement(RunControl.EXECUTION_CONTEXT_FRAMES);
            Stack stackService = (Stack)((Object)RunControl.this.getServicesTracker().getService(Stack.class));
            Expressions expressionsService = (Expressions)((Object)RunControl.this.getServicesTracker().getService(Expressions.class));
            IStack.IFrameDMContext[] iFrameDMContextArray = frames = stackService.getFramesForDMC(this, 0, -1);
            int n3 = frames.length;
            int n4 = 0;
            while (n4 < n3) {
                IStack.IVariableDMContext[] variables;
                IStack.IFrameDMContext frameDMContext = iFrameDMContextArray[n4];
                Stack.StackFrameDMC frameDMC = (Stack.StackFrameDMC)frameDMContext;
                IStack.IVariableDMContext[] iVariableDMContextArray = variables = frameDMC.getLocals();
                int n5 = variables.length;
                int n6 = 0;
                while (n6 < n5) {
                    IStack.IVariableDMContext iVariableDMContext = iVariableDMContextArray[n6];
                    Stack.VariableDMC varDMC = (Stack.VariableDMC)iVariableDMContext;
                    IExpressions.IExpressionDMContext expression = expressionsService.createExpression((IDMContext)frameDMContext, varDMC.getName());
                    boolean wasEnabled = FormatExtensionManager.instance().isEnabled();
                    FormatExtensionManager.instance().setEnabled(true);
                    expressionsService.loadExpressionValues(expression, Album.getVariableCaptureDepth());
                    FormatExtensionManager.instance().setEnabled(wasEnabled);
                    ++n6;
                }
                framesElement.appendChild(frameDMC.takeShapshot(album, document, monitor));
                ++n4;
            }
            contextElement.appendChild(framesElement);
            return contextElement;
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            assert (false);
            return null;
        }

        @Override
        public boolean canDetach() {
            return false;
        }
    }
}

