/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ILexicalBlockScope;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionScope
extends Scope
implements IFunctionScope {
    protected ILocationProvider frameBaseLocationProvider;
    protected List<IVariable> parameters = new ArrayList<IVariable>();
    private int declLine;
    private int declColumn;
    private IPath declFile;

    public FunctionScope(String name, IScope parent, IAddress lowAddress, IAddress highAddress, ILocationProvider frameBaseLocationProvider) {
        super(name, lowAddress, highAddress, parent);
        this.frameBaseLocationProvider = frameBaseLocationProvider;
    }

    @Override
    public Collection<IVariable> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    @Override
    public ILocationProvider getFrameBaseLocation() {
        return this.frameBaseLocationProvider;
    }

    @Override
    public Collection<IVariable> getVariablesInTree() {
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        variables.addAll(super.getVariables());
        for (IScope child : this.children) {
            if (child instanceof IFunctionScope) {
                variables.addAll(((IFunctionScope)child).getVariablesInTree());
                continue;
            }
            if (child instanceof ILexicalBlockScope) {
                variables.addAll(((ILexicalBlockScope)child).getVariablesInTree());
                continue;
            }
            variables.addAll(child.getVariables());
        }
        return variables;
    }

    @Override
    public Collection<IVariable> getScopedVariables(IAddress linkAddress) {
        ArrayList<IVariable> scoped = new ArrayList<IVariable>();
        FunctionScope.recurseGetScopedVariables(this, scoped, linkAddress);
        return scoped;
    }

    protected static void recurseGetScopedVariables(IScope scope, List<IVariable> scoped, IAddress linkAddress) {
        if (scope.getLowAddress().compareTo((Object)linkAddress) > 0 || scope.getHighAddress().compareTo((Object)linkAddress) < 0) {
            return;
        }
        long scopeOffset = linkAddress.add(scope.getLowAddress().getValue().negate()).getValue().longValue();
        for (IVariable var : scope.getVariables()) {
            if (scopeOffset < var.getStartScope() || !var.getLocationProvider().isLocationKnown(linkAddress)) continue;
            scoped.add(var);
        }
        if (scope instanceof IFunctionScope) {
            for (IVariable var : ((FunctionScope)scope).getParameters()) {
                if (scopeOffset < var.getStartScope() || !var.getLocationProvider().isLocationKnown(linkAddress)) continue;
                scoped.add(var);
            }
        }
        for (IScope kid : scope.getChildren()) {
            FunctionScope.recurseGetScopedVariables(kid, scoped, linkAddress);
        }
    }

    public void addParameter(IVariable parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public IPath getDeclFile() {
        return this.declFile;
    }

    public void setDeclFile(IPath declFile) {
        this.declFile = declFile;
    }

    @Override
    public int getDeclLine() {
        return this.declLine;
    }

    public void setDeclLine(int declLine) {
        this.declLine = declLine;
    }

    @Override
    public int getDeclColumn() {
        return this.declColumn;
    }

    public void setDeclColumn(int declColumn) {
        this.declColumn = declColumn;
    }

    @Override
    public void addChild(IScope scope) {
        super.addChild(scope);
        if (scope instanceof IFunctionScope) {
            this.addLineInfoToParent(scope);
        }
    }

    public void setLocationProvider(ILocationProvider locationProvider) {
        this.frameBaseLocationProvider = locationProvider;
    }
}

