/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.IForwardTypeReference;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFileHelper;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfInfoReader;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfModuleScope;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfDebugInfoProvider
implements IDebugInfoProvider {
    protected HashMap<IPath, List<ICompileUnitScope>> compileUnitsPerFile = new HashMap();
    protected ArrayList<DwarfCompileUnit> compileUnits = new ArrayList();
    protected Map<Long, AttributeList> functionsByOffset = new HashMap<Long, AttributeList>();
    protected Map<Long, IType> typesByOffset = new HashMap<Long, IType>();
    protected Map<String, List<IType>> typesByName = new HashMap<String, List<IType>>();
    protected Map<Long, Scope> scopesByOffset = new HashMap<Long, Scope>();
    protected TreeMap<Long, CompilationUnitHeader> debugOffsetsToCompileUnits = new TreeMap();
    protected Map<String, List<IFunctionScope>> functionsByName = new HashMap<String, List<IFunctionScope>>();
    protected Map<String, List<IVariable>> variablesByName = new HashMap<String, List<IVariable>>();
    protected Map<String, List<PublicNameInfo>> publicFunctions = new HashMap<String, List<PublicNameInfo>>();
    protected Map<String, List<PublicNameInfo>> publicVariables = new HashMap<String, List<PublicNameInfo>>();
    protected Map<Integer, Map<Long, AbbreviationEntry>> abbreviationMaps = new HashMap<Integer, Map<Long, AbbreviationEntry>>();
    protected TreeMap<IRangeList.Entry, DwarfFrameRegisterProvider.FrameDescriptionEntry> frameDescEntries = new TreeMap();
    protected Map<Long, DwarfFrameRegisterProvider.CommonInformationEntry> commonInfoEntries = new HashMap<Long, DwarfFrameRegisterProvider.CommonInformationEntry>();
    protected Set<String> referencedFiles = new HashSet<String>();
    protected boolean buildReferencedFilesList = true;
    private IPath symbolFilePath;
    private long symbolFileLastModified;
    private boolean parsedInitially = false;
    private boolean parsedForVarsAndAddresses = false;
    private boolean parsedForTypes = false;
    private boolean parsedForGlobalVars = false;
    private final IExecutableSymbolicsReader exeReader;
    private final DwarfModuleScope moduleScope;
    final DwarfFileHelper fileHelper;
    private IFrameRegisterProvider frameRegisterProvider;
    private static String SOURCE_FILES_CACHE = "_source_files";

    public DwarfDebugInfoProvider(IExecutableSymbolicsReader exeReader) {
        this.exeReader = exeReader;
        this.symbolFilePath = exeReader.getSymbolFile();
        this.symbolFileLastModified = this.symbolFilePath.toFile().lastModified();
        this.moduleScope = new DwarfModuleScope(this);
        this.fileHelper = new DwarfFileHelper(this.symbolFilePath);
        this.frameRegisterProvider = new DwarfFrameRegisterProvider(this);
    }

    public String toString() {
        return String.valueOf(DwarfMessages.DwarfDebugInfoProvider_DwarfProviderFor) + this.symbolFilePath;
    }

    @Override
    public void dispose() {
        if (this.moduleScope != null) {
            this.moduleScope.dispose();
        }
        this.compileUnitsPerFile.clear();
        this.compileUnits.clear();
        this.functionsByOffset.clear();
        this.typesByOffset.clear();
        this.scopesByOffset.clear();
        this.debugOffsetsToCompileUnits.clear();
        this.functionsByName.clear();
        this.variablesByName.clear();
        this.publicFunctions.clear();
        this.publicVariables.clear();
        this.abbreviationMaps.clear();
        this.referencedFiles.clear();
        this.moduleScope.dispose();
        this.parsedInitially = false;
        this.parsedForTypes = false;
        this.parsedForVarsAndAddresses = false;
        this.fileHelper.dispose();
        this.frameRegisterProvider.dispose();
    }

    synchronized void ensureParsedInitially() {
        if (!this.parsedInitially) {
            DwarfInfoReader reader = new DwarfInfoReader(this);
            this.parsedInitially = true;
            reader.parseInitial();
        }
    }

    synchronized void ensureParsedForAddresses() {
        if (!this.parsedForVarsAndAddresses) {
            DwarfInfoReader reader = new DwarfInfoReader(this);
            if (!this.parsedInitially) {
                this.parsedInitially = true;
                reader.parseInitial();
            }
            this.parsedForVarsAndAddresses = true;
            reader.parseForAddresses();
        }
    }

    synchronized void ensureParsedForVariables() {
        if (!this.parsedForVarsAndAddresses) {
            DwarfInfoReader reader = new DwarfInfoReader(this);
            if (!this.parsedInitially) {
                this.parsedInitially = true;
                reader.parseInitial();
            }
            this.parsedForVarsAndAddresses = true;
            reader.parseForAddresses();
        }
    }

    private synchronized void ensureParsedForGlobalVariables() {
        if (this.parsedForGlobalVars) {
            return;
        }
        this.parsedForGlobalVars = true;
        if (this.publicVariables.size() == 0) {
            return;
        }
        HashSet<CompilationUnitHeader> cuWithGlobalsArray = new HashSet<CompilationUnitHeader>(this.publicVariables.size());
        for (List<PublicNameInfo> infoList : this.publicVariables.values()) {
            for (PublicNameInfo info : infoList) {
                cuWithGlobalsArray.add(info.cuHeader);
            }
        }
        DwarfInfoReader reader = new DwarfInfoReader(this);
        for (CompilationUnitHeader cuHeader : cuWithGlobalsArray) {
            reader.parseCompilationUnitForAddresses(cuHeader.scope);
        }
    }

    synchronized void ensureParsedForTypes() {
        if (!this.parsedForTypes) {
            DwarfInfoReader reader = new DwarfInfoReader(this);
            if (!this.parsedInitially) {
                this.parsedInitially = true;
                reader.parseInitial();
            }
            this.parsedForTypes = true;
            reader.parseForTypes();
        }
    }

    public void setParsedInitially() {
        this.parsedInitially = true;
    }

    public void setParsedForAddresses() {
        this.parsedForVarsAndAddresses = true;
    }

    @Override
    public IPath getSymbolFile() {
        return this.symbolFilePath;
    }

    @Override
    public IModuleScope getModuleScope() {
        return this.moduleScope;
    }

    public IAddress getBaseLinkAddress() {
        return this.exeReader.getBaseLinkAddress();
    }

    @Override
    public Collection<IFunctionScope> getFunctionsByName(String name) {
        List<IFunctionScope> result;
        this.ensureParsedInitially();
        String baseName = name;
        if (this.publicFunctions.size() > 0) {
            if (name != null) {
                DwarfInfoReader reader = new DwarfInfoReader(this);
                List<PublicNameInfo> nameMatches = this.publicFunctions.get(baseName);
                if (nameMatches != null) {
                    if (nameMatches.size() == 1) {
                        reader.parseCompilationUnitForAddresses(nameMatches.get((int)0).cuHeader.scope);
                    } else {
                        ArrayList<DwarfCompileUnit> cuList = new ArrayList<DwarfCompileUnit>();
                        for (PublicNameInfo info : nameMatches) {
                            if (cuList.contains(info.cuHeader.scope)) continue;
                            cuList.add(info.cuHeader.scope);
                        }
                        for (DwarfCompileUnit cu : cuList) {
                            reader.parseCompilationUnitForAddresses(cu);
                        }
                    }
                } else {
                    this.ensureParsedForAddresses();
                }
            } else {
                this.ensureParsedForAddresses();
            }
        } else {
            this.ensureParsedForAddresses();
        }
        if (name != null) {
            result = this.functionsByName.get(baseName);
            if (result == null) {
                return new ArrayList<IFunctionScope>(0);
            }
        } else {
            result = new ArrayList<IFunctionScope>(this.functionsByName.size());
            for (List<IFunctionScope> functions : this.functionsByName.values()) {
                result.addAll(functions);
            }
            ((ArrayList)result).trimToSize();
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<IVariable> getVariablesByName(String name, boolean globalsOnly) {
        List<IVariable> result;
        this.ensureParsedInitially();
        if (this.publicVariables.size() > 0) {
            if (name != null) {
                DwarfInfoReader reader = new DwarfInfoReader(this);
                List<PublicNameInfo> nameMatches = this.publicVariables.get(name);
                if (nameMatches != null) {
                    if (nameMatches.size() == 1) {
                        reader.parseCompilationUnitForAddresses(nameMatches.get((int)0).cuHeader.scope);
                    } else {
                        ArrayList<DwarfCompileUnit> cuList = new ArrayList<DwarfCompileUnit>();
                        for (PublicNameInfo info : nameMatches) {
                            if (cuList.contains(info.cuHeader.scope)) continue;
                            cuList.add(info.cuHeader.scope);
                        }
                        for (DwarfCompileUnit cu : cuList) {
                            reader.parseCompilationUnitForAddresses(cu);
                        }
                    }
                } else if (!globalsOnly) {
                    this.ensureParsedForVariables();
                }
            } else if (globalsOnly) {
                this.ensureParsedForGlobalVariables();
            } else {
                this.ensureParsedForVariables();
            }
        }
        if (name != null) {
            result = this.variablesByName.get(name);
            if (result == null) {
                return new ArrayList<IVariable>(0);
            }
        } else {
            result = new ArrayList<IVariable>(this.variablesByName.size());
            for (List<IVariable> variables : this.variablesByName.values()) {
                result.addAll(variables);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public Map<String, List<PublicNameInfo>> getPublicFunctions() {
        this.ensureParsedInitially();
        return this.publicFunctions;
    }

    public Map<String, List<PublicNameInfo>> getPublicVariables() {
        this.ensureParsedInitially();
        return this.publicVariables;
    }

    @Override
    public ICompileUnitScope getCompileUnitForAddress(IAddress linkAddress) {
        this.ensureParsedForAddresses();
        IScope scope = this.moduleScope.getScopeAtAddress(linkAddress);
        while (scope != null && !(scope instanceof ICompileUnitScope)) {
            scope = scope.getParent();
        }
        return (ICompileUnitScope)scope;
    }

    @Override
    public List<ICompileUnitScope> getCompileUnitsForFile(IPath filePath) {
        this.ensureParsedInitially();
        List<ICompileUnitScope> cuList = this.compileUnitsPerFile.get(filePath);
        if (cuList != null) {
            return cuList;
        }
        for (Map.Entry<IPath, List<ICompileUnitScope>> entry : this.compileUnitsPerFile.entrySet()) {
            if (!entry.getKey().setDevice(null).equals((Object)filePath.setDevice(null))) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized String[] getSourceFiles(IProgressMonitor monitor) {
        if (this.referencedFiles.isEmpty()) {
            String cacheKey = String.valueOf(this.getSymbolFile().toOSString()) + SOURCE_FILES_CACHE;
            Set cachedFiles = EDCDebugger.getDefault().getCache().getCachedData(cacheKey, Set.class, this.symbolFileLastModified);
            if (cachedFiles == null) {
                DwarfInfoReader reader = new DwarfInfoReader(this);
                reader.quickParseDebugInfo(monitor);
                assert (this.referencedFiles.size() > 0);
                EDCDebugger.getDefault().getCache().putCachedData(cacheKey, new HashSet<String>(this.referencedFiles), this.symbolFileLastModified);
            } else {
                this.referencedFiles = cachedFiles;
            }
        }
        return this.referencedFiles.toArray(new String[this.referencedFiles.size()]);
    }

    @Override
    public Collection<IType> getTypes() {
        this.ensureParsedForTypes();
        ArrayList<IType> types = new ArrayList<IType>(this.typesByOffset.values());
        return types;
    }

    public IType readType(long offset_) {
        Long offset = offset_;
        IType type = this.typesByOffset.get(offset);
        if (type == null) {
            CompilationUnitHeader header = this.fetchCompileUnitHeader(offset_);
            if (header != null) {
                DwarfInfoReader reader = new DwarfInfoReader(this);
                reader.parseCompilationUnitForTypes(header.scope);
                type = this.typesByOffset.get(offset);
                if (type == null) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfDebugInfoProvider_NotParsingType1) + Long.toHexString(offset_) + DwarfMessages.DwarfDebugInfoProvider_NotParsingType2 + this.symbolFilePath, null);
                }
            } else {
                EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfDebugInfoProvider_CannotResolveCompUnit1) + Long.toHexString(offset_) + DwarfMessages.DwarfDebugInfoProvider_CannotResolveCompUnit2 + this.symbolFilePath, null);
            }
        }
        return type;
    }

    public CompilationUnitHeader scanCompilationHeader(long offset_) {
        CompilationUnitHeader header = this.fetchCompileUnitHeader(offset_);
        if (header != null) {
            DwarfInfoReader reader = new DwarfInfoReader(this);
            reader.parseCompilationUnitForAddresses(header.scope);
        }
        return header;
    }

    IType resolveTypeReference(ForwardTypeReference ref) {
        IType type = this.typesByOffset.get(ref.offset);
        if (type == null) {
            type = this.readType(ref.offset);
        }
        return type;
    }

    @Override
    public IExecutableSymbolicsReader getExecutableSymbolicsReader() {
        return this.exeReader;
    }

    public void registerCompileUnitHeader(int debugInfoOffset, CompilationUnitHeader currentCUHeader) {
        this.debugOffsetsToCompileUnits.put(Long.valueOf(debugInfoOffset), currentCUHeader);
    }

    public CompilationUnitHeader fetchCompileUnitHeader(long debugInfoOffset) {
        CompilationUnitHeader match = this.debugOffsetsToCompileUnits.get(debugInfoOffset);
        if (match != null) {
            return match;
        }
        SortedMap<Long, CompilationUnitHeader> headMap = this.debugOffsetsToCompileUnits.headMap(debugInfoOffset);
        Iterator<CompilationUnitHeader> iterator = headMap.values().iterator();
        while (iterator.hasNext()) {
            CompilationUnitHeader header;
            match = header = iterator.next();
        }
        return match;
    }

    public DwarfFrameRegisterProvider.FrameDescriptionEntry findFrameDescriptionEntry(IAddress framePC) {
        long pc;
        SortedMap<IRangeList.Entry, DwarfFrameRegisterProvider.FrameDescriptionEntry> tailMap;
        DwarfInfoReader reader = new DwarfInfoReader(this);
        if (this.frameDescEntries.isEmpty()) {
            reader.parseForFrameIndices();
        }
        if ((tailMap = this.frameDescEntries.tailMap(new IRangeList.Entry(pc = framePC.getValue().longValue(), pc))).isEmpty()) {
            return null;
        }
        DwarfFrameRegisterProvider.FrameDescriptionEntry entry = tailMap.values().iterator().next();
        if (entry.getCIE() == null) {
            DwarfFrameRegisterProvider.CommonInformationEntry cie = null;
            if (!this.commonInfoEntries.containsKey(entry.ciePtr)) {
                try {
                    cie = reader.parseCommonInfoEntry(entry.ciePtr, entry.addressSize, framePC);
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfDebugInfoProvider_FailedToReadCIE) + entry.ciePtr, e);
                }
                this.commonInfoEntries.put(entry.ciePtr, cie);
            } else {
                cie = this.commonInfoEntries.get(entry.ciePtr);
            }
            entry.setCIE(cie);
        }
        return entry;
    }

    public IFrameRegisterProvider getFrameRegisterProvider() {
        return this.frameRegisterProvider;
    }

    @Override
    public Collection<IType> getTypesByName(String name) {
        String baseName = name = name.trim();
        TypeAggregate aggregate = TypeAggregate.None;
        if (baseName.startsWith("class ")) {
            aggregate = TypeAggregate.Class;
            baseName = baseName.replace("class ", "");
        } else if (baseName.startsWith("struct ")) {
            aggregate = TypeAggregate.Struct;
            baseName = baseName.replace("struct ", "");
        } else if (baseName.startsWith("union ")) {
            aggregate = TypeAggregate.Union;
            baseName = baseName.replace("union ", "");
        }
        Collection types = this.typesByName.get(baseName);
        if (types == null) {
            if (!this.parsedForTypes) {
                this.ensureParsedForTypes();
                return this.getTypesByName(baseName);
            }
            return new ArrayList<IType>(0);
        }
        if (aggregate == TypeAggregate.None) {
            return Collections.unmodifiableCollection(types);
        }
        for (IType nextType : types) {
            if (!(aggregate == TypeAggregate.Class && !nextType.getName().contains("class ") || aggregate == TypeAggregate.Struct && !nextType.getName().contains("struct ")) && (aggregate != TypeAggregate.Union || nextType.getName().contains("union "))) continue;
            types.remove(nextType);
        }
        if (types.isEmpty()) {
            return new ArrayList<IType>(0);
        }
        return Collections.unmodifiableCollection(types);
    }

    static class AbbreviationEntry {
        short tag;
        ArrayList<Attribute> attributes;
        boolean hasChildren;

        AbbreviationEntry(long code, short tag, boolean hasChildren) {
            this.tag = tag;
            this.hasChildren = hasChildren;
            this.attributes = new ArrayList();
        }
    }

    static class Attribute {
        short tag;
        byte form;

        Attribute(short tag, byte form) {
            this.tag = tag;
            this.form = form;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("tag: " + Long.toHexString(this.tag));
            sb.append(" form: " + Long.toHexString(this.form));
            return sb.toString();
        }
    }

    static class AttributeList {
        Map<Short, AttributeValue> attributeMap;

        AttributeList(AbbreviationEntry entry, IStreamBuffer in, byte addressSize, IStreamBuffer debugStrings) {
            int len = entry.attributes.size();
            this.attributeMap = new HashMap<Short, AttributeValue>(len);
            int i = 0;
            while (i < len) {
                Attribute attr = entry.attributes.get(i);
                this.attributeMap.put(attr.tag, new AttributeValue(attr.form, in, addressSize, debugStrings));
                ++i;
            }
        }

        public static void skipAttributes(AbbreviationEntry entry, IStreamBuffer in, byte addressSize) {
            int len = entry.attributes.size();
            int i = 0;
            while (i < len) {
                Attribute attr = entry.attributes.get(i);
                try {
                    AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                    break;
                }
                ++i;
            }
        }

        public long getAttributeValueAsLong(short attributeName) {
            AttributeValue attr = this.attributeMap.get(attributeName);
            if (attr != null) {
                return attr.getValueAsLong();
            }
            return 0L;
        }

        public int getAttributeValueAsInt(short attributeName) {
            AttributeValue attr = this.attributeMap.get(attributeName);
            if (attr != null) {
                return attr.getValueAsInt();
            }
            return 0;
        }

        public long getAttributeValueAsSignedLong(short attributeName) {
            AttributeValue attr = this.attributeMap.get(attributeName);
            if (attr != null) {
                return attr.getValueAsSignedLong();
            }
            return 0L;
        }

        public String getAttributeValueAsString(short attributeName) {
            AttributeValue attr = this.attributeMap.get(attributeName);
            if (attr != null) {
                return attr.getValueAsString();
            }
            return "";
        }

        public byte[] getAttributeValueAsBytes(short attributeName) {
            AttributeValue attr = this.attributeMap.get(attributeName);
            if (attr != null) {
                return attr.getValueAsBytes();
            }
            return new byte[0];
        }

        public AttributeValue getAttribute(short attributeName) {
            return this.attributeMap.get(attributeName);
        }

        public boolean hasCodeRangeAttributes() {
            return this.attributeMap.containsKey((short)18) || this.attributeMap.containsKey((short)85);
        }
    }

    static class AttributeValue {
        private Object value;
        private byte actualForm;

        AttributeValue(byte form, IStreamBuffer in, byte addressSize, IStreamBuffer debugStrings) {
            this.actualForm = form;
            try {
                this.value = this.readAttribute(in, addressSize, debugStrings);
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.value != null) {
                Class<?> clazz = this.value.getClass();
                if (clazz.isArray()) {
                    int len = Array.getLength(this.value);
                    sb.append(len).append(' ');
                    sb.append(clazz.getComponentType().toString());
                    sb.append(':');
                    int i = 0;
                    while (i < len) {
                        byte b = Array.getByte(this.value, i);
                        sb.append(' ').append(Integer.toHexString(b));
                        ++i;
                    }
                } else if (this.value instanceof Number) {
                    Number n = (Number)this.value;
                    sb.append(Long.toHexString(n.longValue()));
                } else if (this.value instanceof String) {
                    sb.append(this.value);
                } else {
                    sb.append(this.value);
                }
            }
            return sb.toString();
        }

        private Object readAttribute(IStreamBuffer in, byte addressSize, IStreamBuffer debugStrings) throws IOException {
            Object obj = null;
            switch (this.actualForm) {
                case 1: 
                case 16: {
                    obj = DwarfInfoReader.readAddress(in, addressSize);
                    break;
                }
                case 9: {
                    int size = (int)DwarfInfoReader.read_unsigned_leb128(in);
                    byte[] bytes = new byte[size];
                    in.get(bytes);
                    obj = bytes;
                    break;
                }
                case 10: {
                    int size = in.get() & 0xFF;
                    byte[] bytes = new byte[size];
                    in.get(bytes);
                    obj = bytes;
                    break;
                }
                case 3: {
                    short size = in.getShort();
                    byte[] bytes = new byte[size];
                    in.get(bytes);
                    obj = bytes;
                    break;
                }
                case 4: {
                    int size = in.getInt();
                    byte[] bytes = new byte[size];
                    in.get(bytes);
                    obj = bytes;
                    break;
                }
                case 11: {
                    obj = new Byte(in.get());
                    break;
                }
                case 5: {
                    obj = new Short(in.getShort());
                    break;
                }
                case 6: {
                    obj = new Integer(in.getInt());
                    break;
                }
                case 7: {
                    obj = new Long(in.getLong());
                    break;
                }
                case 13: {
                    obj = new Long(DwarfInfoReader.read_signed_leb128(in));
                    break;
                }
                case 15: {
                    obj = new Long(DwarfInfoReader.read_unsigned_leb128(in));
                    break;
                }
                case 8: {
                    int c;
                    StringBuffer sb = new StringBuffer();
                    while ((c = in.get() & 0xFF) != -1) {
                        if (c == 0) break;
                        sb.append((char)c);
                    }
                    obj = sb.toString();
                    break;
                }
                case 12: {
                    obj = new Byte(in.get());
                    break;
                }
                case 14: {
                    int offset = in.getInt();
                    if (debugStrings == null) {
                        obj = new String();
                        break;
                    }
                    if (offset < 0 || (long)offset > debugStrings.capacity()) {
                        obj = new String();
                        break;
                    }
                    debugStrings.position(offset);
                    obj = DwarfInfoReader.readString(debugStrings);
                    break;
                }
                case 17: {
                    obj = new Integer(in.get() & 0xFF);
                    break;
                }
                case 18: {
                    obj = new Integer(in.getShort() & 0xFFFF);
                    break;
                }
                case 19: {
                    obj = new Integer(in.getInt());
                    break;
                }
                case 20: {
                    obj = new Long(in.getLong());
                    break;
                }
                case 21: {
                    obj = new Long(DwarfInfoReader.read_unsigned_leb128(in));
                    break;
                }
                case 22: {
                    this.actualForm = (byte)DwarfInfoReader.read_unsigned_leb128(in);
                    return this.readAttribute(in, addressSize, debugStrings);
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return obj;
        }

        public static void skipAttributeValue(short form, IStreamBuffer in, byte addressSize) throws IOException {
            block0 : switch (form) {
                case 1: 
                case 16: {
                    in.position(in.position() + (long)addressSize);
                    break;
                }
                case 9: {
                    int size = (int)DwarfInfoReader.read_unsigned_leb128(in);
                    in.position(in.position() + (long)size);
                    break;
                }
                case 10: {
                    int size = in.get() & 0xFF;
                    in.position(in.position() + (long)size);
                    break;
                }
                case 3: {
                    short size = in.getShort();
                    in.position(in.position() + (long)size);
                    break;
                }
                case 4: {
                    int size = in.getInt();
                    in.position(in.position() + (long)size);
                    break;
                }
                case 11: {
                    in.position(in.position() + 1L);
                    break;
                }
                case 5: {
                    in.position(in.position() + 2L);
                    break;
                }
                case 6: {
                    in.position(in.position() + 4L);
                    break;
                }
                case 7: {
                    in.position(in.position() + 8L);
                    break;
                }
                case 13: {
                    DwarfInfoReader.read_signed_leb128(in);
                    break;
                }
                case 15: {
                    DwarfInfoReader.read_unsigned_leb128(in);
                    break;
                }
                case 8: {
                    int c;
                    while ((c = in.get() & 0xFF) != -1) {
                        if (c == 0) break block0;
                    }
                    break;
                }
                case 12: {
                    in.position(in.position() + 1L);
                    break;
                }
                case 14: {
                    in.position(in.position() + 4L);
                    break;
                }
                case 17: {
                    in.position(in.position() + 1L);
                    break;
                }
                case 18: {
                    in.position(in.position() + 2L);
                    break;
                }
                case 19: {
                    in.position(in.position() + 4L);
                    break;
                }
                case 20: {
                    in.position(in.position() + 8L);
                    break;
                }
                case 21: {
                    DwarfInfoReader.read_unsigned_leb128(in);
                    break;
                }
                case 22: {
                    form = (short)DwarfInfoReader.read_unsigned_leb128(in);
                    AttributeValue.skipAttributeValue(form, in, addressSize);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public static void skipAttributesToSibling(AbbreviationEntry entry, IStreamBuffer in, byte addressSize) {
            long sibling = -1L;
            int len = entry.attributes.size();
            int i = 0;
            while (i < len) {
                Attribute attr = entry.attributes.get(i);
                try {
                    if (attr.tag == 1) {
                        if (attr.form == 21) {
                            sibling = DwarfInfoReader.read_unsigned_leb128(in);
                        } else if (attr.form == 19) {
                            sibling = in.getInt();
                        } else {
                            AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                        }
                    } else {
                        AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                    }
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                    break;
                }
                ++i;
            }
            if (sibling != -1L) {
                in.position(sibling);
            }
        }

        public byte getActualForm() {
            return this.actualForm;
        }

        public long getValueAsSignedLong() {
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue();
            }
            return 0L;
        }

        public long getValueAsLong() {
            if (this.value instanceof Byte) {
                return (Byte)this.value & 0xFF;
            }
            if (this.value instanceof Short) {
                return (Short)this.value & 0xFFFF;
            }
            if (this.value instanceof Integer) {
                return (Integer)this.value & 0xFFFFFFFF;
            }
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue();
            }
            return 0L;
        }

        public int getValueAsInt() {
            if (this.value instanceof Byte) {
                return (Byte)this.value & 0xFF;
            }
            if (this.value instanceof Short) {
                return (Short)this.value & 0xFFFF;
            }
            if (this.value instanceof Number) {
                return ((Number)this.value).intValue();
            }
            return 0;
        }

        public String getValueAsString() {
            if (this.value != null) {
                return this.value.toString();
            }
            return null;
        }

        public byte[] getValueAsBytes() {
            if (this.value instanceof byte[]) {
                return (byte[])this.value;
            }
            return new byte[0];
        }
    }

    public static class CompilationUnitHeader {
        int length;
        short version;
        int abbreviationOffset;
        byte addressSize;
        int debugInfoOffset;
        DwarfCompileUnit scope;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Length: " + this.length).append("\n");
            sb.append("Version: " + this.version).append("\n");
            sb.append("Abbreviation: " + this.abbreviationOffset).append("\n");
            sb.append("Address size: " + this.addressSize).append("\n");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForwardTypeReference
    implements IType,
    IForwardTypeReference {
        public static final IType NULL_TYPE_ENTRY = new IType(){

            @Override
            public int getByteSize() {
                return 0;
            }

            @Override
            public String getName() {
                return DwarfMessages.DwarfDebugInfoProvider_UnhandledType;
            }

            @Override
            public Map<Object, Object> getProperties() {
                return Collections.emptyMap();
            }

            @Override
            public IScope getScope() {
                return null;
            }

            @Override
            public IType getType() {
                return null;
            }

            @Override
            public void setType(IType type) {
                throw new IllegalStateException();
            }

            @Override
            public void dispose() {
            }
        };
        private DwarfDebugInfoProvider provider;
        private IType type = null;
        private final long offset;

        public ForwardTypeReference(DwarfDebugInfoProvider provider, long offset) {
            this.provider = provider;
            this.offset = offset;
        }

        @Override
        public IType getReferencedType() {
            if (this.type == null) {
                this.type = NULL_TYPE_ENTRY;
                this.type = this.provider.resolveTypeReference(this);
                if (this.type == null) {
                    this.type = NULL_TYPE_ENTRY;
                }
            }
            return this.type;
        }

        @Override
        public int getByteSize() {
            return this.getReferencedType().getByteSize();
        }

        @Override
        public String getName() {
            return this.getReferencedType().getName();
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this.getReferencedType().getProperties();
        }

        @Override
        public IScope getScope() {
            return this.getReferencedType().getScope();
        }

        @Override
        public IType getType() {
            return this.getReferencedType().getType();
        }

        @Override
        public void setType(IType type_) {
            this.getReferencedType().setType(type_);
        }

        @Override
        public void dispose() {
            this.type = null;
            this.provider = null;
        }
    }

    public static class PublicNameInfo {
        public final String nameWithNameSpace;
        public final CompilationUnitHeader cuHeader;
        public final short tag;

        public PublicNameInfo(String nameWithNameSpace, CompilationUnitHeader cuHeader, short tag) {
            this.nameWithNameSpace = nameWithNameSpace;
            this.cuHeader = cuHeader;
            this.tag = tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TypeAggregate {
        Class,
        Struct,
        Union,
        None;

    }
}

