/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.HostOS;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DwarfFileHelper {
    private boolean DEBUG = false;
    private final IPath symbolFile;
    private Map<String, IPath> compDirAndNameMap;
    private int hits;
    private long nextDump;

    public DwarfFileHelper(IPath symbolFile) {
        this.symbolFile = symbolFile;
        this.compDirAndNameMap = new HashMap<String, IPath>();
    }

    protected String getKey(String compDir, String name) {
        return String.valueOf(compDir) + "/" + name;
    }

    public IPath normalizeFilePath(String compDir, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.charAt(0) == '<') {
            return null;
        }
        String key = this.getKey(compDir, name);
        IPath path = this.compDirAndNameMap.get(key);
        if (path == null) {
            path = this.normalizePath(compDir, name);
            this.compDirAndNameMap.put(key, path);
        } else {
            ++this.hits;
        }
        if (this.DEBUG && System.currentTimeMillis() > this.nextDump) {
            System.out.println("DwarfFileHelper entries: " + this.compDirAndNameMap.size() + "; hits: " + this.hits);
            this.nextDump = System.currentTimeMillis() + 1000L;
        }
        return path;
    }

    private IPath normalizePath(String compDir, String name) {
        String fullName = name;
        IPath path = PathUtils.createPath(name);
        if (!path.isAbsolute() && compDir.length() > 0) {
            fullName = compDir;
            if (!compDir.endsWith(File.separator)) {
                fullName = String.valueOf(fullName) + File.separatorChar;
            }
            fullName = String.valueOf(fullName) + name;
        }
        path = this.fixUpPath(fullName);
        if (HostOS.IS_WIN32 && path.isAbsolute() && path.getDevice() == null) {
            Path dirPa = new Path(compDir);
            if (dirPa.getDevice() != null) {
                path = path.setDevice(dirPa.getDevice());
            } else {
                String exeWinVolume = this.symbolFile.getDevice();
                if (exeWinVolume != null && exeWinVolume.length() > 0) {
                    path = path.setDevice(exeWinVolume);
                }
            }
        }
        if (path.isAbsolute() && (HostOS.IS_WIN32 || path.getDevice() == null)) {
            try {
                path = new Path(path.toFile().getCanonicalPath());
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    public IPath fixUpPath(String path) {
        boolean isCygwin = false;
        int deleteTill = 0;
        if (path.length() > 12 && path.startsWith("/cygdrive/") && '/' == path.charAt(11)) {
            isCygwin = true;
            deleteTill = 10;
        }
        if (path.length() > 4 && path.startsWith("//") && '/' == path.charAt(3)) {
            isCygwin = true;
            deleteTill = 2;
        }
        if (HostOS.IS_WIN32 && path.length() > 3 && path.charAt(0) == '/' && Character.isLetter(path.charAt(1)) && path.charAt(2) == '/') {
            isCygwin = true;
            deleteTill = 1;
        }
        if (isCygwin) {
            StringBuilder buf = new StringBuilder(path);
            buf.delete(0, deleteTill);
            buf.insert(1, ':');
            path = buf.toString();
        }
        return PathUtils.createPath(path);
    }

    public void dispose() {
        this.compDirAndNameMap.clear();
    }
}

