/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.MemoryStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.CPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ClassType;
import org.eclipse.cdt.debug.edc.internal.symbols.ConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.Enumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.Enumerator;
import org.eclipse.cdt.debug.edc.internal.symbols.FieldType;
import org.eclipse.cdt.debug.edc.internal.symbols.FunctionScope;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.InheritanceType;
import org.eclipse.cdt.debug.edc.internal.symbols.LexicalBlockScope;
import org.eclipse.cdt.debug.edc.internal.symbols.LineEntry;
import org.eclipse.cdt.debug.edc.internal.symbols.PointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.internal.symbols.StructType;
import org.eclipse.cdt.debug.edc.internal.symbols.SubroutineType;
import org.eclipse.cdt.debug.edc.internal.symbols.TypedefType;
import org.eclipse.cdt.debug.edc.internal.symbols.UnionType;
import org.eclipse.cdt.debug.edc.internal.symbols.VolatileType;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFileHelper;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFunctionScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfModuleScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfVariable;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationEntry;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationExpression;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationList;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.RangeList;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSection;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfInfoReader {
    private BaseAndScopedNames baseAndScopedNames = new BaseAndScopedNames();
    private static boolean DEBUG = false;
    private String dumpFileName = "C:\\temp\\_EDC_DwarfReaderDump.txt";
    public static final String DWARF_DEBUG_INFO = ".debug_info";
    public static final String DWARF_DEBUG_RANGES = ".debug_ranges";
    public static final String DWARF_DEBUG_ABBREV = ".debug_abbrev";
    public static final String DWARF_DEBUG_ARANGES = ".debug_aranges";
    public static final String DWARF_DEBUG_LINE = ".debug_line";
    public static final String DWARF_DEBUG_FRAME = ".debug_frame";
    public static final String DWARF_EH_FRAME = ".eh_frame";
    public static final String DWARF_DEBUG_LOC = ".debug_loc";
    public static final String DWARF_DEBUG_PUBNAMES = ".debug_pubnames";
    public static final String DWARF_DEBUG_STR = ".debug_str";
    public static final String DWARF_DEBUG_FUNCNAMES = ".debug_funcnames";
    public static final String DWARF_DEBUG_TYPENAMES = ".debug_typenames";
    public static final String DWARF_DEBUG_VARNAMES = ".debug_varnames";
    public static final String DWARF_DEBUG_WEAKNAMES = ".debug_weaknames";
    public static final String DWARF_DEBUG_MACINFO = ".debug_macinfo";
    private Map<Long, Collection<LocationEntry>> locationEntriesByOffset = new HashMap<Long, Collection<LocationEntry>>();
    private DwarfDebugInfoProvider provider;
    private IExecutableSymbolicsReader exeReader;
    private DwarfModuleScope moduleScope;
    private IPath symbolFilePath;
    private IExecutableSection debugInfoSection;
    private IExecutableSection publicNamesSection;
    private DwarfDebugInfoProvider.CompilationUnitHeader currentCUHeader;
    private Map<IType, IType> typeToParentMap;
    private IType currentParentType;
    private Scope currentParentScope;
    private DwarfCompileUnit currentCompileUnitScope;
    private DwarfFileHelper fileHelper;
    private RangeList codeRanges;

    public DwarfInfoReader(DwarfDebugInfoProvider provider) {
        this.provider = provider;
        this.exeReader = provider.getExecutableSymbolicsReader();
        this.symbolFilePath = provider.getSymbolFile();
        this.fileHelper = provider.fileHelper;
        this.moduleScope = (DwarfModuleScope)provider.getModuleScope();
        this.debugInfoSection = this.exeReader.findExecutableSection(DWARF_DEBUG_INFO);
        this.publicNamesSection = this.exeReader.findExecutableSection(DWARF_DEBUG_PUBNAMES);
        this.codeRanges = this.getCodeRanges();
    }

    private RangeList getCodeRanges() {
        RangeList codeRanges = new RangeList();
        for (ISection section : this.exeReader.getSections()) {
            if (!section.getProperties().get("name").equals(".text")) continue;
            long start = section.getLinkAddress().getValue().longValue();
            long size = section.getSize();
            codeRanges.addRange(start, start + size);
        }
        return codeRanges;
    }

    protected IStreamBuffer getDwarfSection(String sectionName) {
        IStreamBuffer buffer = null;
        IExecutableSection section = this.exeReader.findExecutableSection(sectionName);
        if (section != null) {
            buffer = section.getBuffer();
        }
        return buffer;
    }

    public void parseInitial() {
        Job parseInitialJob = new Job("Reading Debug Symbol Information: " + this.symbolFilePath){

            protected IStatus run(IProgressMonitor monitor) {
                DwarfInfoReader.this.traceEntry("/debug/symbolReader", "Initial parse for " + DwarfInfoReader.this.symbolFilePath);
                DwarfInfoReader.this.parseCUDebugInfo(monitor);
                DwarfInfoReader.this.parsePublicNames();
                DwarfInfoReader.this.traceExit("/debug/symbolReader", "Finished initial parse");
                return Status.OK_STATUS;
            }
        };
        try {
            parseInitialJob.schedule();
            parseInitialJob.join();
        }
        catch (InterruptedException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public void parseForAddresses() {
        this.traceEntry("/debug/symbolReader", "Address parse for " + this.symbolFilePath);
        for (DwarfCompileUnit compileUnit : this.provider.compileUnits) {
            this.parseCompilationUnitForAddresses(compileUnit);
            if (DEBUG && (compileUnit.getHighAddress().isZero() ? !$assertionsDisabled && compileUnit.getChildren().size() != 0 : !$assertionsDisabled && compileUnit.getChildren().size() < 0)) {
                throw new AssertionError();
            }
        }
        this.traceExit("/debug/symbolReader", "Finished address parse");
        this.moduleScope.fixupRanges((IAddress)Addr32.ZERO);
        if (DEBUG) {
            this.dumpSymbols();
        }
    }

    private void parsePublicNames() {
        if (this.publicNamesSection == null || this.debugInfoSection == null) {
            return;
        }
        IStreamBuffer bufferPublicNames = this.publicNamesSection.getBuffer();
        if (bufferPublicNames == null) {
            return;
        }
        IStreamBuffer bufferDebuginfo = this.debugInfoSection.getBuffer();
        if (bufferDebuginfo == null) {
            return;
        }
        long fileIndex = 0L;
        long fileEndIndex = bufferPublicNames.capacity();
        while (fileIndex < fileEndIndex) {
            fileIndex = this.parsePublicNamesSet(bufferPublicNames, fileIndex, bufferDebuginfo);
        }
    }

    private long parsePublicNamesSet(IStreamBuffer bufferPublicNames, long fileIndex, IStreamBuffer bufferDebugInfo) {
        bufferPublicNames.position(fileIndex);
        int setLength = bufferPublicNames.getInt();
        IStreamBuffer dataPublicNames = bufferPublicNames.wrapSubsection(setLength);
        dataPublicNames.position(2L);
        int debugInfoOffset = dataPublicNames.getInt();
        int debugInfoLength = dataPublicNames.getInt();
        try {
            bufferDebugInfo.position(debugInfoOffset);
            IStreamBuffer dataInfoBytes = bufferDebugInfo.wrapSubsection(debugInfoLength);
            DwarfDebugInfoProvider.CompilationUnitHeader header = this.provider.debugOffsetsToCompileUnits.get(debugInfoOffset);
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
            while (dataPublicNames.remaining() > 4L) {
                int objectOffset = dataPublicNames.getInt();
                String name = DwarfInfoReader.readString(dataPublicNames);
                dataInfoBytes.position(objectOffset);
                long code = DwarfInfoReader.read_unsigned_leb128(dataInfoBytes);
                DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                if (entry == null || name.length() <= 0) continue;
                String baseName = name;
                int baseStart = name.lastIndexOf("::");
                if (baseStart != -1) {
                    baseName = name.substring(baseStart + 2);
                }
                if (entry.tag == 52) {
                    List<DwarfDebugInfoProvider.PublicNameInfo> variables = this.provider.publicVariables.get(baseName);
                    if (variables == null) {
                        variables = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
                    }
                    variables.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                    this.provider.publicVariables.put(baseName, variables);
                    continue;
                }
                if (entry.tag != 46) continue;
                List<DwarfDebugInfoProvider.PublicNameInfo> functions = this.provider.publicFunctions.get(baseName);
                if (functions == null) {
                    functions = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
                    functions.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                } else {
                    ArrayList arrayList = (ArrayList)functions;
                    boolean found = false;
                    int i = arrayList.size() - 1;
                    while (!found && i >= 0 && ((DwarfDebugInfoProvider.PublicNameInfo)arrayList.get((int)i)).cuHeader == header) {
                        found = ((DwarfDebugInfoProvider.PublicNameInfo)arrayList.get((int)i)).nameWithNameSpace.equals(name);
                        --i;
                    }
                    if (!found) {
                        functions.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                    }
                }
                this.provider.publicFunctions.put(baseName, functions);
            }
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        return fileIndex + (long)setLength + 4L;
    }

    public void parseForTypes() {
        for (DwarfCompileUnit compileUnit : this.provider.compileUnits) {
            this.parseCompilationUnitForTypes(compileUnit);
        }
    }

    private void parseCUDebugInfo(IProgressMonitor monitor) {
        if (this.debugInfoSection == null) {
            return;
        }
        if (this.provider.referencedFiles.isEmpty()) {
            this.provider.buildReferencedFilesList = true;
        }
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        IStreamBuffer debugStrings = this.getDebugStrings();
        boolean havePubNames = this.publicNamesSection != null && this.publicNamesSection.getBuffer() != null;
        int totalWork = (int)(buffer.capacity() / 1024L);
        monitor.beginTask("Read Debug Info", totalWork);
        long fileIndex = 0L;
        long fileEndIndex = buffer.capacity();
        while (fileIndex < fileEndIndex) {
            long oldIndex = fileIndex;
            fileIndex = this.parseCompilationUnitForNames(buffer, fileIndex, debugStrings, havePubNames);
            monitor.worked((int)((fileIndex - oldIndex) / 1024L));
        }
        monitor.done();
        this.provider.compileUnits.trimToSize();
        this.provider.buildReferencedFilesList = false;
    }

    public long parseCompilationUnitShallow(IStreamBuffer buffer, long fileIndex) {
        buffer.position(fileIndex);
        this.currentCUHeader = new DwarfDebugInfoProvider.CompilationUnitHeader();
        this.currentCUHeader.length = buffer.getInt();
        buffer.position(fileIndex);
        IStreamBuffer data = buffer.wrapSubsection(this.currentCUHeader.length + 4);
        data.position(4L);
        this.currentCUHeader.version = data.getShort();
        this.currentCUHeader.abbreviationOffset = data.getInt();
        this.currentCUHeader.addressSize = data.get();
        this.currentCUHeader.debugInfoOffset = (int)fileIndex;
        try {
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(this.currentCUHeader.abbreviationOffset);
            long code = DwarfInfoReader.read_unsigned_leb128(data);
            DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(code);
            DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, data, this.currentCUHeader.addressSize, this.getDebugStrings());
            this.processCompileUnit(this.currentCUHeader, entry.hasChildren, attributeList);
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError("Failed to parse debug info from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
        }
        return fileIndex += (long)(this.currentCUHeader.length + 4);
    }

    public long parseCompilationUnitForNames(IStreamBuffer buffer, long fileIndex, IStreamBuffer debugStrings, boolean havePubNames) {
        buffer.position(fileIndex);
        this.currentCUHeader = new DwarfDebugInfoProvider.CompilationUnitHeader();
        this.currentCUHeader.length = buffer.getInt();
        buffer.position(fileIndex);
        IStreamBuffer in = buffer.wrapSubsection(this.currentCUHeader.length + 4);
        in.position(4L);
        this.currentCUHeader.version = in.getShort();
        this.currentCUHeader.abbreviationOffset = in.getInt();
        this.currentCUHeader.addressSize = in.get();
        this.currentCUHeader.debugInfoOffset = (int)fileIndex;
        try {
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(this.currentCUHeader.abbreviationOffset);
            long code = DwarfInfoReader.read_unsigned_leb128(in);
            DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(code);
            DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, in, this.currentCUHeader.addressSize, debugStrings);
            this.processCompileUnit(this.currentCUHeader, entry.hasChildren, attributeList);
            if (!havePubNames) {
                byte addressSize = this.currentCUHeader.addressSize;
                block6: while (in.remaining() > 0L) {
                    code = DwarfInfoReader.read_unsigned_leb128(in);
                    if (code == 0L) continue;
                    entry = abbrevs.get(code);
                    switch (entry.tag) {
                        case 52: {
                            this.parseAttributesForNames(true, this.baseAndScopedNames, entry, in, addressSize, debugStrings);
                            if (this.baseAndScopedNames.baseName == null) continue block6;
                            this.storePublicNames(this.provider.publicVariables, this.baseAndScopedNames, this.currentCUHeader, (short)52);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 63: 
                        case 64: {
                            DwarfDebugInfoProvider.AttributeValue.skipAttributesToSibling(entry, in, addressSize);
                            break;
                        }
                        default: {
                            DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, addressSize);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError("Failed to parse debug info from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
        }
        return fileIndex += (long)(this.currentCUHeader.length + 4);
    }

    private void parseAttributesForNames(boolean onlyExternal, BaseAndScopedNames baseAndScopedNames, DwarfDebugInfoProvider.AbbreviationEntry entry, IStreamBuffer in, byte addressSize, IStreamBuffer debugStrings) {
        String name = null;
        baseAndScopedNames.baseName = null;
        baseAndScopedNames.nameWithScope = null;
        boolean isExternal = false;
        int len = entry.attributes.size();
        int i = 0;
        while (i < len) {
            block21: {
                DwarfDebugInfoProvider.Attribute attr = entry.attributes.get(i);
                try {
                    if (attr.tag == 3 || attr.tag == 8199) {
                        if (attr.form == 8) {
                            int c;
                            StringBuffer sb = new StringBuffer();
                            while ((c = in.get() & 0xFF) != -1) {
                                if (c == 0) break;
                                sb.append((char)c);
                            }
                            name = sb.toString();
                        } else if (attr.form == 14) {
                            int debugStringOffset = in.getInt();
                            if (debugStrings != null && debugStringOffset >= 0 && (long)debugStringOffset < debugStrings.capacity()) {
                                debugStrings.position(debugStringOffset);
                                name = DwarfInfoReader.readString(debugStrings);
                            }
                        }
                        if (name == null) break block21;
                        if (attr.tag == 3) {
                            baseAndScopedNames.baseName = name;
                            baseAndScopedNames.nameWithScope = name;
                        } else {
                            IUnmangler unmangler = null;
                            if (this.exeReader instanceof BaseExecutableSymbolicsReader) {
                                unmangler = ((BaseExecutableSymbolicsReader)this.exeReader).getUnmangler();
                            }
                            try {
                                baseAndScopedNames.nameWithScope = unmangler.unmangle(unmangler.undecorate(name));
                            }
                            catch (UnmanglingException unmanglingException) {}
                        }
                        name = null;
                        break block21;
                    }
                    if (attr.tag == 63) {
                        if (attr.form == 12) {
                            isExternal = in.get() != 0;
                        } else {
                            DwarfDebugInfoProvider.AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                        }
                    } else {
                        DwarfDebugInfoProvider.AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                    }
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                    break;
                }
            }
            ++i;
        }
        if (onlyExternal && !isExternal) {
            baseAndScopedNames.baseName = null;
            baseAndScopedNames.nameWithScope = null;
        } else if (baseAndScopedNames.nameWithScope != null && baseAndScopedNames.baseName == null) {
            int baseStart = baseAndScopedNames.nameWithScope.lastIndexOf("::");
            baseAndScopedNames.baseName = baseStart != -1 ? baseAndScopedNames.nameWithScope.substring(baseStart + 2) : baseAndScopedNames.nameWithScope;
        }
    }

    private void storePublicNames(Map<String, List<DwarfDebugInfoProvider.PublicNameInfo>> namesStore, BaseAndScopedNames baseAndScopedNames, DwarfDebugInfoProvider.CompilationUnitHeader cuHeader, short tag) {
        List<DwarfDebugInfoProvider.PublicNameInfo> currentNames = namesStore.get(baseAndScopedNames.baseName);
        if (currentNames == null) {
            currentNames = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
            namesStore.put(baseAndScopedNames.baseName, currentNames);
        }
        currentNames.add(new DwarfDebugInfoProvider.PublicNameInfo(baseAndScopedNames.nameWithScope, cuHeader, tag));
    }

    public void parseCompilationUnitForAddresses(DwarfCompileUnit compileUnit) {
        if (compileUnit.isParsedForAddresses()) {
            return;
        }
        compileUnit.setParsedForAddresses(true);
        DwarfDebugInfoProvider.CompilationUnitHeader header = compileUnit.header;
        if (header == null) {
            return;
        }
        this.trace("/debug/symbolReader", "Address parse for " + Integer.toHexString(header.debugInfoOffset) + " : " + header.scope.getFilePath());
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        if (buffer == null) {
            return;
        }
        int fileIndex = header.debugInfoOffset;
        buffer.position(fileIndex);
        IStreamBuffer data = buffer.wrapSubsection(header.length + 4);
        data.position(11L);
        this.currentCompileUnitScope = compileUnit;
        this.currentParentScope = compileUnit;
        this.registerScope(header.debugInfoOffset, compileUnit);
        this.currentCUHeader = header;
        try {
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
            this.parseForAddresses(data, abbrevs, header, new Stack<Scope>());
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError("Failed to parse debug info from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
        }
    }

    public void parseCompilationUnitForTypes(DwarfCompileUnit compileUnit) {
        if (compileUnit.isParsedForTypes()) {
            return;
        }
        compileUnit.setParsedForTypes(true);
        DwarfDebugInfoProvider.CompilationUnitHeader header = compileUnit.header;
        if (header == null) {
            return;
        }
        this.trace("/debug/symbolReader", "Type parse of " + Integer.toHexString(header.debugInfoOffset) + " : " + header.scope.getFilePath());
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        if (buffer == null) {
            return;
        }
        int fileIndex = header.debugInfoOffset;
        buffer.position(fileIndex);
        IStreamBuffer data = buffer.wrapSubsection(header.length + 4);
        data.position(11L);
        this.currentCompileUnitScope = compileUnit;
        this.currentParentScope = compileUnit;
        this.registerScope(header.debugInfoOffset, compileUnit);
        this.currentCUHeader = header;
        try {
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
            this.parseForTypes(data, abbrevs, header, new Stack<Scope>());
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError("Failed to parse type debug info from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
        }
    }

    public void quickParseDebugInfo(IProgressMonitor monitor) {
        this.traceEntry("/debug/symbolReader", "Quick parse for " + this.symbolFilePath);
        this.doQuickParseDebugInfo(monitor);
        this.traceExit("/debug/symbolReader", "Finished quick parse");
    }

    private void doQuickParseDebugInfo(IProgressMonitor monitor) {
        if (this.debugInfoSection == null) {
            return;
        }
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        if (buffer == null) {
            return;
        }
        try {
            try {
                long fileIndex = 0L;
                long fileEndIndex = buffer.capacity();
                monitor.beginTask("Read Debug Info", (int)(fileEndIndex / 1024L));
                buffer.position(0L);
                while (fileIndex < fileEndIndex) {
                    buffer.position(fileIndex);
                    int unit_length = buffer.getInt();
                    buffer.position(fileIndex + 4L);
                    IStreamBuffer data = buffer.wrapSubsection(unit_length);
                    data.position(2L);
                    int debug_abbrev_offset = data.getInt();
                    byte address_size = data.get();
                    Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(debug_abbrev_offset);
                    long code = DwarfInfoReader.read_unsigned_leb128(data);
                    DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(code);
                    DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, data, address_size, this.getDebugStrings());
                    String name = attributeList.getAttributeValueAsString((short)3);
                    String compDir = attributeList.getAttributeValueAsString((short)27);
                    IPath filePath = this.fileHelper.normalizeFilePath(compDir, name);
                    this.provider.referencedFiles.add(filePath.toOSString());
                    DwarfDebugInfoProvider.AttributeValue a = attributeList.getAttribute((short)16);
                    if (a != null) {
                        int stmtList = a.getValueAsInt();
                        this.quickParseLineInfo(stmtList, compDir);
                    }
                    long oldIndex = fileIndex;
                    monitor.worked((int)(((fileIndex += (long)(unit_length + 4)) - oldIndex) / 1024L));
                }
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError("Failed to parse source files from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private IStreamBuffer getDebugStrings() {
        return this.getDwarfSection(DWARF_DEBUG_STR);
    }

    private void quickParseLineInfo(int lineTableOffset, String compileUnitDirectory) {
        IPath compileUnitDirectoryPath = PathUtils.createPath(compileUnitDirectory);
        try {
            IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LINE);
            if (data != null) {
                String fileName;
                String str;
                data.position(lineTableOffset);
                data.position(data.position() + 14L);
                int opcode_base = data.get() & 0xFF;
                data.position(data.position() + (long)opcode_base - 1L);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(compileUnitDirectory);
                while ((str = DwarfInfoReader.readString(data)).length() != 0) {
                    IPath dir = PathUtils.createPath(str);
                    if (!dir.isAbsolute() && dir.getDevice() == null) {
                        dir = compileUnitDirectoryPath.append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = DwarfInfoReader.readString(data)).length() != 0) {
                    long leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)leb128), fileName);
                    if (fullPath != null) {
                        this.provider.referencedFiles.add(fullPath.toOSString());
                    }
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                }
            }
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public Collection<ILineEntry> parseLineTable(IScope scope, DwarfDebugInfoProvider.AttributeList attributes, List<IPath> fileList) {
        ArrayList<ILineEntry> lineEntries = new ArrayList<ILineEntry>();
        try {
            IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LINE);
            DwarfDebugInfoProvider.AttributeValue a = attributes.getAttribute((short)16);
            if (data != null && a != null) {
                String fileName;
                String str;
                int stmtList = a.getValueAsInt();
                data.position(stmtList);
                int length = data.getInt() + 4;
                data.getShort();
                data.getInt();
                int minimum_instruction_length = data.get() & 0xFF;
                boolean is_stmt = data.get() > 0;
                byte line_base = data.get();
                int line_range = data.get() & 0xFF;
                int opcode_base = data.get() & 0xFF;
                byte[] opcodes = new byte[opcode_base - 1];
                data.get(opcodes);
                ArrayList<String> dirList = new ArrayList<String>();
                String compDir = attributes.getAttributeValueAsString((short)27);
                dirList.add(compDir);
                IPath compDirPath = PathUtils.createPath(compDir);
                while ((str = DwarfInfoReader.readString(data)).length() != 0) {
                    IPath dir = PathUtils.createPath(str);
                    if (!dir.isAbsolute() && dir.getDevice() == null) {
                        dir = compDirPath.append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = DwarfInfoReader.readString(data)).length() != 0) {
                    long leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)leb128), fileName);
                    if (fullPath != null) {
                        fileList.add(fullPath);
                    }
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                }
                int info_line = 1;
                long info_address = 0L;
                int info_flags = 0;
                long info_file = 1L;
                int info_column = 0;
                long lineInfoEnd = stmtList + length;
                while (data.position() < lineInfoEnd) {
                    byte opcodeB = data.get();
                    int opcode = 0xFF & opcodeB;
                    if (opcode >= opcode_base) {
                        info_line += (opcode - opcode_base) % line_range + line_base;
                        info_address += (long)((opcode - opcode_base) / line_range * minimum_instruction_length);
                        if (is_stmt) {
                            lineEntries.add(new LineEntry(fileList.get((int)info_file - 1), info_line, info_column, (IAddress)new Addr32(info_address), null));
                        }
                        info_flags &= 0xFFFFFFF1;
                        continue;
                    }
                    if (opcode == 0) {
                        long op_size = DwarfInfoReader.read_unsigned_leb128(data);
                        long op_pos = data.position();
                        int code = data.get() & 0xFF;
                        switch (code) {
                            case 3: {
                                fileName = DwarfInfoReader.readString(data);
                                long dir = DwarfInfoReader.read_unsigned_leb128(data);
                                DwarfInfoReader.read_unsigned_leb128(data);
                                DwarfInfoReader.read_unsigned_leb128(data);
                                IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)dir), fileName);
                                if (fullPath == null) break;
                                fileList.add(fullPath);
                                break;
                            }
                            case 1: {
                                info_flags |= 0x10;
                                if (lineEntries.size() > 0) {
                                    ((ILineEntry)lineEntries.get(lineEntries.size() - 1)).setHighAddress((IAddress)new Addr32(info_address));
                                }
                                info_file = 1L;
                                info_line = 1;
                                info_address = 0L;
                                info_flags = 0;
                                info_column = 0;
                                break;
                            }
                            case 2: {
                                info_address = data.getInt();
                                break;
                            }
                            default: {
                                data.position((int)(data.position() + op_size - 1L));
                            }
                        }
                        assert (data.position() == op_pos + op_size);
                        continue;
                    }
                    switch (opcode) {
                        case 1: {
                            if (is_stmt) {
                                lineEntries.add(new LineEntry(fileList.get((int)info_file - 1), info_line, info_column, (IAddress)new Addr32(info_address), null));
                            }
                            info_flags &= 0xFFFFFFF1;
                            break;
                        }
                        case 2: {
                            info_address += DwarfInfoReader.read_unsigned_leb128(data) * (long)minimum_instruction_length;
                            break;
                        }
                        case 3: {
                            info_line = (int)((long)info_line + DwarfInfoReader.read_signed_leb128(data));
                            break;
                        }
                        case 4: {
                            info_file = DwarfInfoReader.read_unsigned_leb128(data);
                            break;
                        }
                        case 5: {
                            info_column = (int)DwarfInfoReader.read_unsigned_leb128(data);
                            break;
                        }
                        case 6: {
                            is_stmt = !is_stmt;
                            break;
                        }
                        case 7: {
                            info_flags |= 2;
                            break;
                        }
                        case 8: {
                            info_address += (long)((255 - opcode_base) / line_range * minimum_instruction_length);
                            break;
                        }
                        case 9: {
                            info_address += (long)data.getShort();
                            break;
                        }
                        case 10: {
                            info_flags |= 4;
                            break;
                        }
                        case 11: {
                            info_flags |= 8;
                            break;
                        }
                        case 12: {
                            DwarfInfoReader.read_unsigned_leb128(data);
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        Collections.sort(lineEntries);
        ILineEntry previousEntry = null;
        for (ILineEntry line : lineEntries) {
            if (previousEntry != null && previousEntry.getHighAddress() == null) {
                previousEntry.setHighAddress(line.getLowAddress());
            }
            previousEntry = line;
        }
        if (previousEntry != null && previousEntry.getHighAddress() == null) {
            previousEntry.setHighAddress(scope.getHighAddress());
        }
        return lineEntries;
    }

    private void parseForAddresses(IStreamBuffer in, Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs, DwarfDebugInfoProvider.CompilationUnitHeader header, Stack<Scope> nestingStack) throws IOException {
        this.trace("/debug/symbolReader", "Address parse of " + header.scope.getName() + " @ " + Long.toHexString(header.debugInfoOffset));
        while (in.remaining() > 0L) {
            long offset = in.position() + (long)this.currentCUHeader.debugInfoOffset;
            long code = DwarfInfoReader.read_unsigned_leb128(in);
            if (code != 0L) {
                DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                if (entry == null) {
                    assert (false);
                    continue;
                }
                if (entry.hasChildren) {
                    nestingStack.push(this.currentParentScope);
                }
                if (this.isDebugInfoEntryWithAddressRange(entry.tag)) {
                    this.processDebugInfoEntry(offset, entry, new DwarfDebugInfoProvider.AttributeList(entry, in, header.addressSize, this.getDebugStrings()), header);
                    continue;
                }
                DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, header.addressSize);
                continue;
            }
            if (code != 0L) continue;
            this.currentParentScope = nestingStack.isEmpty() ? null : nestingStack.pop();
        }
    }

    private void parseForTypes(IStreamBuffer in, Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs, DwarfDebugInfoProvider.CompilationUnitHeader header, Stack<Scope> nestingStack) throws IOException {
        this.trace("/debug/symbolReader", "Parsing types for " + header.scope.getName() + " @ " + Long.toHexString(header.debugInfoOffset));
        Stack<IType> typeStack = new Stack<IType>();
        this.typeToParentMap = new HashMap<IType, IType>();
        this.currentParentScope = this.currentCompileUnitScope;
        while (in.remaining() > 0L) {
            long offset = in.position() + (long)this.currentCUHeader.debugInfoOffset;
            long code = DwarfInfoReader.read_unsigned_leb128(in);
            if (code != 0L) {
                DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                if (entry == null) {
                    assert (false);
                    continue;
                }
                if (entry.hasChildren) {
                    nestingStack.push(this.currentParentScope);
                    typeStack.push(this.currentParentType);
                }
                if (this.isForwardTypeTag(entry.tag) || this.isForwardTypeChildTag(entry.tag)) {
                    this.processDebugInfoEntry(offset, entry, new DwarfDebugInfoProvider.AttributeList(entry, in, header.addressSize, this.getDebugStrings()), header);
                    continue;
                }
                switch (entry.tag) {
                    case 11: 
                    case 29: 
                    case 46: 
                    case 52: {
                        Scope scope = this.provider.scopesByOffset.get(offset);
                        if (scope == null) break;
                        this.currentParentScope = scope;
                    }
                }
                DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, header.addressSize);
                continue;
            }
            if (code != 0L) continue;
            if (nestingStack.isEmpty()) {
                this.currentParentType = null;
                this.currentParentScope = null;
                continue;
            }
            this.currentParentScope = nestingStack.pop();
            this.currentParentType = (IType)typeStack.pop();
        }
    }

    private boolean isForwardTypeTag(short tag) {
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 33: 
            case 36: 
            case 38: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private boolean isForwardTypeChildTag(short tag) {
        switch (tag) {
            case 13: 
            case 28: 
            case 33: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private void processDebugInfoEntry(long offset, DwarfDebugInfoProvider.AbbreviationEntry entry, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        short tag = entry.tag;
        switch (tag) {
            case 1: {
                this.processArrayType(offset, attributeList);
                break;
            }
            case 2: {
                this.processClassType(offset, attributeList, header);
                break;
            }
            case 4: {
                this.processEnumType(offset, attributeList);
                break;
            }
            case 5: {
                this.processVariable(offset, attributeList, true);
                break;
            }
            case 11: {
                this.processLexicalBlock(offset, attributeList, entry.hasChildren);
                break;
            }
            case 13: {
                this.processField(offset, attributeList, header);
                break;
            }
            case 15: {
                this.processPointerType(offset, attributeList);
                break;
            }
            case 16: {
                this.processReferenceType(offset, attributeList);
                break;
            }
            case 19: {
                this.processStructType(offset, attributeList, header);
                break;
            }
            case 21: {
                this.processSubroutineType(offset, attributeList, header);
                break;
            }
            case 22: {
                this.processTypeDef(offset, attributeList);
                break;
            }
            case 23: {
                this.processUnionType(offset, attributeList, header);
                break;
            }
            case 24: {
                break;
            }
            case 28: {
                this.processInheritance(offset, attributeList, header);
                break;
            }
            case 31: {
                break;
            }
            case 34: {
                break;
            }
            case 36: {
                this.processBasicType(offset, attributeList);
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                this.processConstType(offset, attributeList);
                break;
            }
            case 40: {
                this.processEnumerator(offset, attributeList);
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 46: {
                this.processSubProgram(offset, attributeList, entry.hasChildren);
                break;
            }
            case 29: {
                this.processInlinedSubroutine(offset, attributeList, entry.hasChildren);
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                break;
            }
            case 52: {
                this.processVariable(offset, attributeList, false);
                break;
            }
            case 53: {
                this.processVolatileType(offset, attributeList);
                break;
            }
            case 33: {
                this.processArrayBoundType(offset, attributeList);
            }
        }
    }

    private boolean isDebugInfoEntryWithAddressRange(short tag) {
        switch (tag) {
            case 11: 
            case 29: 
            case 30: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 60: {
                return true;
            }
            case 5: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    static long readAddress(IStreamBuffer in, int addressSize) throws IOException {
        long value = 0L;
        switch (addressSize) {
            case 2: {
                value = in.getShort();
                break;
            }
            case 4: {
                value = in.getInt();
                break;
            }
            case 8: {
                value = in.getLong();
            }
        }
        return value;
    }

    static long read_unsigned_leb128(IStreamBuffer in) throws IOException {
        long result = 0L;
        int shift = 0;
        while (in.hasRemaining()) {
            byte b = in.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public static long read_signed_leb128(IStreamBuffer in) throws IOException {
        byte b;
        long result = 0L;
        int shift = 0;
        int size = 32;
        do {
            if (!in.hasRemaining()) {
                throw new IOException(CCorePlugin.getResourceString((String)"Util.exception.noData"));
            }
            b = in.get();
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < size && (b & 0x40) != 0) {
            result |= (long)(-(1 << shift));
        }
        return result;
    }

    public static String readString(IStreamBuffer data) {
        StringBuilder sb = new StringBuilder();
        while (data.hasRemaining()) {
            byte c = data.get();
            if (c == 0) break;
            sb.append((char)c);
        }
        String str = sb.toString();
        return str;
    }

    private Collection<LocationEntry> getLocationRecord(long offset) {
        Collection<LocationEntry> entries = this.locationEntriesByOffset.get(offset);
        if (entries == null) {
            TreeMap<IRangeList.Entry, LocationEntry> entryMap = new TreeMap<IRangeList.Entry, LocationEntry>();
            try {
                IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LOC);
                if (data != null) {
                    data.position(offset);
                    boolean first = true;
                    long base = 0L;
                    while (data.hasRemaining()) {
                        long lowPC = DwarfInfoReader.readAddress(data, this.currentCUHeader.addressSize);
                        long highPC = DwarfInfoReader.readAddress(data, this.currentCUHeader.addressSize);
                        if (lowPC == 0L && highPC == 0L) break;
                        if (first) {
                            long maxaddress;
                            first = false;
                            long l = maxaddress = this.currentCUHeader.addressSize == 4 ? Integer.MAX_VALUE : Long.MAX_VALUE;
                            if (lowPC == maxaddress) {
                                base = highPC;
                                continue;
                            }
                            if (this.currentCompileUnitScope.getRangeList() == null) {
                                base = this.currentCompileUnitScope.getLowAddress().getValue().longValue();
                            }
                        }
                        short numOpCodes = data.getShort();
                        byte[] bytes = new byte[numOpCodes];
                        data.get(bytes);
                        LocationEntry entry = new LocationEntry(lowPC + base, highPC + base, bytes);
                        entryMap.put(new IRangeList.Entry(lowPC + base, highPC + base), entry);
                    }
                    entries = entryMap.values();
                    this.locationEntriesByOffset.put(offset, entries);
                }
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
        }
        return entries;
    }

    private Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> parseDebugAbbreviation(int abbreviationOffset) throws IOException {
        Integer key = abbreviationOffset;
        Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.provider.abbreviationMaps.get(key);
        if (abbrevs == null) {
            abbrevs = new HashMap<Long, DwarfDebugInfoProvider.AbbreviationEntry>();
            this.provider.abbreviationMaps.put(key, abbrevs);
            IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_ABBREV);
            if (data != null) {
                data.position(abbreviationOffset);
                while (data.remaining() > 0L) {
                    long code = DwarfInfoReader.read_unsigned_leb128(data);
                    if (code == 0L) break;
                    short tag = (short)DwarfInfoReader.read_unsigned_leb128(data);
                    boolean hasChildren = data.get() == 1;
                    DwarfDebugInfoProvider.AbbreviationEntry entry = new DwarfDebugInfoProvider.AbbreviationEntry(code, tag, hasChildren);
                    short name = 0;
                    byte form = 0;
                    do {
                        name = (short)DwarfInfoReader.read_unsigned_leb128(data);
                        form = (byte)DwarfInfoReader.read_unsigned_leb128(data);
                        if (name == 0) continue;
                        entry.attributes.add(new DwarfDebugInfoProvider.Attribute(name, form));
                    } while (name != 0 && form != 0);
                    entry.attributes.trimToSize();
                    abbrevs.put(code, entry);
                }
            }
        }
        return abbrevs;
    }

    private void registerType(long offset, IType type) {
        Long typeKey = offset;
        this.provider.typesByOffset.put(typeKey, type);
        this.typeToParentMap.put(type, this.currentParentType);
        this.currentParentType = type;
        if (DEBUG && type != null) {
            System.out.print("Read type " + type.getName());
            while (type.getType() != null) {
                type = type.getType();
                System.out.print(" " + type.getName());
            }
            System.out.println();
        }
    }

    private void registerScope(long offset, Scope scope) {
        this.provider.scopesByOffset.put(offset, scope);
    }

    public RangeList readRangeList(int offset, DwarfDebugInfoProvider.AttributeValue baseValue) {
        IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_RANGES);
        if (data == null) {
            return null;
        }
        try {
            data.position(offset);
            RangeList list = new RangeList();
            long base = 0L;
            long start = data.getInt();
            long end = data.getInt();
            if (start == -1L) {
                base = end;
                start = data.getInt();
                end = data.getInt();
            } else if (baseValue != null) {
                base = baseValue.getValueAsLong();
            } else if (this.currentCompileUnitScope != null && this.currentCompileUnitScope.getRangeList() == null) {
                base = this.currentCompileUnitScope.getLowAddress().getValue().longValue();
            }
            while (start != 0L || end != 0L) {
                if (start != end && base + start >= this.codeRanges.getLowAddress()) {
                    list.addRange(base + start, base + end);
                }
                start = data.getInt();
                end = data.getInt();
            }
            return list;
        }
        catch (BufferUnderflowException e) {
            EDCDebugger.getMessageLogger().logError("Failed to read ranges", e);
            return null;
        }
    }

    private void setupAddresses(DwarfDebugInfoProvider.AttributeList attributeList, Scope scope) {
        DwarfDebugInfoProvider.AttributeValue value = attributeList.getAttribute((short)18);
        if (value != null) {
            Addr32 high;
            Addr32 low = new Addr32(attributeList.getAttributeValueAsLong((short)17));
            if (low.compareTo((Object)(high = new Addr32(attributeList.getAttributeValueAsLong((short)18)))) > 0) {
                if (scope.getParent() != null && scope.getParent().getHighAddress() != null) {
                    high = scope.getParent().getHighAddress();
                }
                if (low.compareTo((Object)high) > 0) {
                    Addr32 t = high;
                    high = low;
                    low = t;
                }
            }
            scope.setLowAddress((IAddress)low);
            scope.setHighAddress((IAddress)high);
            return;
        }
        value = attributeList.getAttribute((short)85);
        if (value != null) {
            DwarfDebugInfoProvider.AttributeValue baseValue = attributeList.getAttribute((short)17);
            RangeList ranges = this.readRangeList(value.getValueAsInt(), baseValue);
            if (ranges != null) {
                scope.setRangeList(ranges);
                if (ranges.getLowAddress() < scope.getParent().getLowAddress().getValue().longValue() && scope.getParent() instanceof Scope) {
                    ((Scope)scope.getParent()).setLowAddress((IAddress)new Addr32(ranges.getLowAddress()));
                }
                if (ranges.getHighAddress() > scope.getParent().getHighAddress().getValue().longValue() && scope.getParent() instanceof Scope) {
                    ((Scope)scope.getParent()).setHighAddress((IAddress)new Addr32(ranges.getHighAddress()));
                }
                return;
            }
        }
        if (scope instanceof ICompileUnitScope && (value = attributeList.getAttribute((short)16)) != null) {
            RangeList ranges = new RangeList();
            for (ILineEntry entry : ((ICompileUnitScope)((Object)scope)).getLineEntries()) {
                if (entry.getLowAddress().getValue().longValue() < this.codeRanges.getLowAddress()) continue;
                ranges.addRange(entry.getLowAddress().getValue().longValue(), entry.getHighAddress().getValue().longValue());
            }
            scope.setRangeList(ranges);
            return;
        }
        scope.setLowAddress((IAddress)new Addr32(0L));
        scope.setHighAddress((IAddress)new Addr32(0L));
    }

    private void processCompileUnit(DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren, DwarfDebugInfoProvider.AttributeList attributeList) {
        String name = attributeList.getAttributeValueAsString((short)3);
        String compDir = attributeList.getAttributeValueAsString((short)27);
        IPath filePath = this.fileHelper.normalizeFilePath(compDir, name);
        header.scope = this.currentCompileUnitScope = new DwarfCompileUnit(this.provider, this.moduleScope, filePath, null, null, header, hasChildren, attributeList);
        this.currentParentScope = this.currentCompileUnitScope;
        this.setupAddresses(attributeList, this.currentCompileUnitScope);
        List<ICompileUnitScope> matchingCompileUnits = this.provider.compileUnitsPerFile.get(filePath);
        if (matchingCompileUnits == null) {
            matchingCompileUnits = new ArrayList<ICompileUnitScope>();
        }
        matchingCompileUnits.add(this.currentCompileUnitScope);
        this.provider.compileUnitsPerFile.put(filePath, matchingCompileUnits);
        this.provider.compileUnits.add(this.currentCompileUnitScope);
        this.moduleScope.addChild(this.currentCompileUnitScope);
        this.provider.registerCompileUnitHeader(this.currentCUHeader.debugInfoOffset, this.currentCUHeader);
        if (this.provider.buildReferencedFilesList) {
            this.provider.referencedFiles.add(filePath.toOSString());
            DwarfDebugInfoProvider.AttributeValue a = attributeList.getAttribute((short)16);
            if (a != null) {
                int stmtList = a.getValueAsInt();
                this.quickParseLineInfo(stmtList, compDir);
            }
        }
        attributeList.attributeMap.remove((short)3);
        attributeList.attributeMap.remove((short)17);
        attributeList.attributeMap.remove((short)18);
        attributeList.attributeMap.remove((short)85);
    }

    private void processLexicalBlock(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        String name = attributeList.getAttributeValueAsString((short)3);
        if (!attributeList.hasCodeRangeAttributes()) {
            return;
        }
        LexicalBlockScope lb = new LexicalBlockScope(name, this.currentParentScope, null, null);
        this.setupAddresses(attributeList, lb);
        this.currentParentScope.addChild(lb);
        this.registerScope(offset, lb);
        if (hasChildren) {
            this.currentParentScope = lb;
        }
    }

    private DereferencedAttributes getDereferencedAttributes(DwarfDebugInfoProvider.AttributeList attributeList, short tag) {
        DwarfDebugInfoProvider.AttributeList attributes;
        DwarfDebugInfoProvider.CompilationUnitHeader providingCU = this.currentCUHeader;
        DwarfDebugInfoProvider.AttributeValue derefLocation = attributeList.getAttribute(tag);
        if (derefLocation == null) {
            return null;
        }
        long debugInfoOffset = derefLocation.getValueAsLong();
        if (derefLocation.getActualForm() != 16) {
            debugInfoOffset += (long)providingCU.debugInfoOffset;
        }
        if ((attributes = this.provider.functionsByOffset.get(debugInfoOffset)) == null) {
            IStreamBuffer buffer;
            providingCU = this.provider.scanCompilationHeader(debugInfoOffset);
            attributes = this.provider.functionsByOffset.get(debugInfoOffset);
            if (attributes == null && (buffer = this.getDwarfSection(DWARF_DEBUG_INFO)) != null) {
                buffer.position(debugInfoOffset);
                try {
                    DwarfDebugInfoProvider.AbbreviationEntry entry;
                    Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(providingCU.abbreviationOffset);
                    long code = DwarfInfoReader.read_unsigned_leb128(buffer);
                    if (code != 0L && (entry = abbrevs.get(new Long(code))) != null) {
                        attributes = new DwarfDebugInfoProvider.AttributeList(entry, buffer, providingCU.addressSize, this.getDebugStrings());
                    }
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError("Failed to parse debug info from section " + this.debugInfoSection.getName() + " in file " + this.symbolFilePath, e);
                }
            }
        } else {
            providingCU = this.provider.fetchCompileUnitHeader(debugInfoOffset);
            if (providingCU == null) {
                assert (false);
                return null;
            }
        }
        if (attributes == null) {
            return null;
        }
        return new DereferencedAttributes(providingCU, attributes);
    }

    private void processSubProgram(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        DwarfDebugInfoProvider.AttributeList attributes;
        DereferencedAttributes deref;
        if (attributeList.getAttributeValueAsInt((short)60) > 0) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        if (!attributeList.hasCodeRangeAttributes()) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = null;
        boolean isArtifical = attributeList.getAttributeValueAsInt((short)52) > 0;
        String name = attributeList.getAttributeValueAsString((short)3);
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributeList, (short)49)) != null) {
            otherCU = deref.header;
            attributes = deref.attributeList;
            name = attributes.getAttributeValueAsString((short)3);
            isArtifical |= attributes.getAttributeValueAsInt((short)52) > 0;
            if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributes, (short)71)) != null) {
                otherCU = deref.header;
                attributes = deref.attributeList;
                name = attributes.getAttributeValueAsString((short)3);
                isArtifical |= attributes.getAttributeValueAsInt((short)52) > 0;
            }
        }
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributeList, (short)71)) != null) {
            otherCU = deref.header;
            attributes = deref.attributeList;
            name = attributes.getAttributeValueAsString((short)3);
        }
        if (name.length() == 0) {
            return;
        }
        DwarfFunctionScope function = new DwarfFunctionScope(name, this.currentCompileUnitScope, null, null, null);
        this.setupAddresses(attributeList, function);
        Scope originalParentScope = this.currentParentScope;
        this.registerScope(offset, function);
        this.currentParentScope = function;
        DwarfDebugInfoProvider.AttributeValue frameBaseAttribute = attributeList.getAttribute((short)64);
        ILocationProvider locationProvider = this.getLocationProvider(frameBaseAttribute);
        function.setLocationProvider(locationProvider);
        if (!(function.getLowAddress().isZero() || function.getHighAddress().isZero() || isArtifical)) {
            int declLine = attributeList.getAttributeValueAsInt((short)59);
            int declColumn = attributeList.getAttributeValueAsInt((short)57);
            int declFileNum = attributeList.getAttributeValueAsInt((short)58);
            if (otherCU != null) {
                function.setDeclFile(otherCU.scope.getFileEntry(declFileNum));
            } else {
                function.setDeclFileNum(declFileNum);
            }
            function.setDeclLine(declLine);
            function.setDeclColumn(declColumn);
            this.currentCompileUnitScope.addChild(function);
            List<IFunctionScope> functions = this.provider.functionsByName.get(name);
            if (functions == null) {
                functions = new ArrayList<IFunctionScope>();
                this.provider.functionsByName.put(name, functions);
            }
            functions.add(function);
        }
        if (!hasChildren) {
            this.currentParentScope = originalParentScope;
        }
    }

    private IType getTypeOrReference(DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        DwarfDebugInfoProvider.AttributeValue typeAttribute = attributeList.getAttribute((short)73);
        if (typeAttribute == null) {
            return null;
        }
        return this.getTypeOrReference(typeAttribute, header);
    }

    private IType getTypeOrReference(DwarfDebugInfoProvider.AttributeValue typeAttribute, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        IType type;
        if (typeAttribute == null) {
            return null;
        }
        long debugInfoOffset = typeAttribute.getValueAsLong();
        if (typeAttribute.getActualForm() != 16) {
            debugInfoOffset += (long)header.debugInfoOffset;
        }
        if ((type = this.provider.typesByOffset.get(debugInfoOffset)) == null) {
            type = new DwarfDebugInfoProvider.ForwardTypeReference(this.provider, debugInfoOffset);
        }
        return type;
    }

    private void processInlinedSubroutine(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        List<IFunctionScope> functions;
        if (!attributeList.hasCodeRangeAttributes()) {
            return;
        }
        DereferencedAttributes deref = this.getDereferencedAttributes(attributeList, (short)49);
        if (deref == null) {
            if (attributeList.getAttribute((short)49) == null) assert (false);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = deref.header;
        DwarfDebugInfoProvider.AttributeList origAttributes = deref.attributeList;
        String name = origAttributes.getAttributeValueAsString((short)3);
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(origAttributes, (short)71)) != null) {
            DwarfDebugInfoProvider.AttributeList declarationAttributes = deref.attributeList;
            name = declarationAttributes.getAttributeValueAsString((short)3);
        }
        if (name.length() == 0) {
            return;
        }
        int declLine = origAttributes.getAttributeValueAsInt((short)59);
        int declColumn = origAttributes.getAttributeValueAsInt((short)57);
        int declFileNum = origAttributes.getAttributeValueAsInt((short)58);
        if (declFileNum == 0) {
            assert (false);
            return;
        }
        DwarfFunctionScope function = new DwarfFunctionScope(name, this.currentParentScope, null, null, null);
        this.setupAddresses(attributeList, function);
        function.setDeclFile(otherCU.scope.getFileEntry(declFileNum));
        function.setDeclLine(declLine);
        function.setDeclColumn(declColumn);
        this.currentParentScope.addChild(function);
        this.registerScope(offset, function);
        if (hasChildren) {
            this.currentParentScope = function;
        }
        if ((functions = this.provider.functionsByName.get(name)) == null) {
            functions = new ArrayList<IFunctionScope>();
            this.provider.functionsByName.put(name, functions);
        }
        functions.add(function);
    }

    private void processSubroutineType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        SubroutineType type = new SubroutineType(this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processClassType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        ClassType type = new ClassType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processStructType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        StructType type = new StructType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processUnionType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        UnionType type = new UnionType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processInheritance(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        ICompositeType compositeType = null;
        compositeType = this.getCompositeParent();
        long fieldsOffset = 0L;
        byte[] offsetBlock = attributeList.getAttributeValueAsBytes((short)56);
        if (offsetBlock.length > 0 && offsetBlock[0] == 35) {
            int i = 1;
            int shift = 0;
            while (i < offsetBlock.length) {
                fieldsOffset += (long)((offsetBlock[i] & 0x7F) << shift);
                shift += 7;
                ++i;
            }
        }
        int accessibility = 2;
        if (attributeList.getAttribute((short)50) != null) {
            accessibility = attributeList.getAttributeValueAsInt((short)50);
            accessibility = accessibility == 1 ? 0 : (accessibility == 3 ? 2 : 1);
        }
        InheritanceType type = new InheritanceType(this.currentParentScope, accessibility, fieldsOffset, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        if (compositeType != null) {
            compositeType.addInheritance(type);
        }
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processField(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        name = name.replace('.', '$');
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        int bitSize = attributeList.getAttributeValueAsInt((short)13);
        int bitOffset = attributeList.getAttributeValueAsInt((short)12);
        long fieldOffset = 0L;
        byte[] offsetBlock = attributeList.getAttributeValueAsBytes((short)56);
        if (offsetBlock.length > 0 && offsetBlock[0] == 35) {
            int i = 1;
            int shift = 0;
            while (i < offsetBlock.length) {
                fieldOffset += (long)((offsetBlock[i] & 0x7F) << shift);
                shift += 7;
                ++i;
            }
        }
        ICompositeType compositeType = null;
        compositeType = this.getCompositeParent();
        int accessibility = 0;
        if (attributeList.getAttribute((short)50) != null) {
            accessibility = attributeList.getAttributeValueAsInt((short)50);
            accessibility = accessibility == 1 ? 0 : (accessibility == 3 ? 2 : 1);
        } else if (compositeType != null && compositeType instanceof ClassType) {
            accessibility = 2;
        }
        if (name.length() == 0) {
            name = compositeType != null ? "$unnamed$" + (compositeType.fieldCount() + 1) : "$unnamed$";
        }
        FieldType type = new FieldType(name, this.currentParentScope, compositeType, fieldOffset, bitSize, bitOffset, byteSize, accessibility, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        if (compositeType != null) {
            compositeType.addField(type);
        }
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private ICompositeType getCompositeParent() {
        IType parent = this.currentParentType;
        while (parent != null) {
            if (parent instanceof ICompositeType) {
                return (ICompositeType)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processArrayType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        ArrayType type = new ArrayType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private IArrayType getArrayParent() {
        IType parent = this.currentParentType;
        while (parent != null) {
            if (parent instanceof IArrayType) {
                return (IArrayType)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processArrayBoundType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        long arrayBound = 0L;
        if (attributeList.getAttribute((short)47) != null) {
            arrayBound = attributeList.getAttributeValueAsLong((short)47) + 1L;
        }
        ArrayBoundType type = new ArrayBoundType(this.currentParentScope, arrayBound);
        IArrayType array = this.getArrayParent();
        if (array == null) {
            throw new IllegalStateException();
        }
        array.addBound(type);
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processReferenceType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        if (byteSize == 0) {
            byteSize = this.currentCUHeader.addressSize;
        }
        ReferenceType type = new ReferenceType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processPointerType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        if (byteSize == 0) {
            byteSize = this.currentCUHeader.addressSize;
        }
        PointerType type = new PointerType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processConstType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        ConstType type = new ConstType(this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processVolatileType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        VolatileType type = new VolatileType(this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processEnumType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        Enumeration type = new Enumeration(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private Enumeration getEnumerationParent() {
        IType parent = this.currentParentType;
        while (parent != null) {
            if (parent instanceof Enumeration) {
                return (Enumeration)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processEnumerator(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        long value = attributeList.getAttributeValueAsSignedLong((short)28);
        Enumerator enumerator = new Enumerator(name, value);
        Enumeration enumeration = this.getEnumerationParent();
        if (enumeration == null) {
            throw new IllegalStateException();
        }
        enumeration.addEnumerator(enumerator);
        ((Scope)enumeration.getScope()).addEnumerator(enumerator);
        this.traceExit("/debug/symbolReader/verbose", enumerator);
    }

    private void processTypeDef(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        TypedefType type = new TypedefType(name, this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processBasicType(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        this.traceEntry("/debug/symbolReader/verbose", offset);
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        int baseType = 0;
        int qualifierBits = 0;
        int encoding = attributeList.getAttributeValueAsInt((short)62);
        switch (encoding) {
            case 2: {
                baseType = 6;
                break;
            }
            case 4: {
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 5: {
                baseType = 3;
                qualifierBits |= 4;
                if (name.contains("short")) {
                    qualifierBits |= 2;
                    break;
                }
                if (name.contains("long long")) {
                    qualifierBits |= 0x40;
                    break;
                }
                if (!name.contains("long")) break;
                qualifierBits |= 1;
                break;
            }
            case 6: {
                baseType = 2;
                qualifierBits |= 4;
                break;
            }
            case 7: {
                baseType = 3;
                qualifierBits |= 8;
                if (name.contains("short")) {
                    qualifierBits |= 2;
                    break;
                }
                if (name.contains("long long")) {
                    qualifierBits |= 0x40;
                    break;
                }
                if (!name.contains("long")) break;
                qualifierBits |= 1;
                break;
            }
            case 8: {
                baseType = 2;
                qualifierBits |= 8;
                break;
            }
            case 3: {
                qualifierBits |= 0x10;
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 9: {
                qualifierBits |= 0x20;
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 0: {
                baseType = 1;
                break;
            }
        }
        if (name.equals("void") && byteSize == 0) {
            baseType = 1;
        }
        CPPBasicType type = new CPPBasicType(name, this.currentParentScope, baseType, qualifierBits, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type);
        this.storeTypeByName(name, type);
        this.traceExit("/debug/symbolReader/verbose", type);
    }

    private void processVariable(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean isParameter) {
        IType type;
        DereferencedAttributes deref;
        this.traceEntry("/debug/symbolReader/verbose", attributeList);
        DwarfDebugInfoProvider.AttributeValue locationAttribute = attributeList.getAttribute((short)2);
        ILocationProvider locationProvider = this.getLocationProvider(locationAttribute);
        if (locationProvider == null) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = this.currentCUHeader;
        DwarfDebugInfoProvider.AttributeList otherAttributes = attributeList;
        String name = attributeList.getAttributeValueAsString((short)3);
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributeList, (short)49)) != null) {
            otherCU = deref.header;
            otherAttributes = deref.attributeList;
            name = otherAttributes.getAttributeValueAsString((short)3);
        }
        if ((type = this.getTypeOrReference(otherAttributes.getAttribute((short)73), otherCU)) != null) {
            boolean global = otherAttributes.getAttributeValueAsInt((short)63) == 1;
            long startScope = attributeList.getAttributeValueAsLong((short)44);
            DwarfVariable variable = new DwarfVariable(name, (IScope)(global ? this.moduleScope : this.currentParentScope), locationProvider, type);
            variable.setStartScope(startScope);
            if (isParameter) {
                if (this.currentParentScope instanceof FunctionScope) {
                    ((FunctionScope)this.currentParentScope).addParameter(variable);
                } else assert (false);
            } else {
                List<IVariable> variables;
                if (global) {
                    this.moduleScope.addVariable(variable);
                    if (this.currentCompileUnitScope != null) {
                        this.currentCompileUnitScope.addVariable(variable);
                    }
                } else {
                    this.currentParentScope.addVariable(variable);
                }
                if ((variables = this.provider.variablesByName.get(name)) == null) {
                    variables = new ArrayList<IVariable>();
                    this.provider.variablesByName.put(name, variables);
                }
                variables.add(variable);
            }
            this.traceExit("/debug/symbolReader/verbose", variable);
        }
    }

    private ILocationProvider getLocationProvider(DwarfDebugInfoProvider.AttributeValue locationValue) {
        if (locationValue != null) {
            byte actualForm = locationValue.getActualForm();
            if (actualForm == 6) {
                Collection<LocationEntry> entryList = this.getLocationRecord(locationValue.getValueAsLong());
                return new LocationList(entryList.toArray(new LocationEntry[entryList.size()]), this.exeReader.getByteOrder(), this.currentCUHeader.addressSize, this.currentParentScope);
            }
            if (actualForm == 9 || actualForm == 10 || actualForm == 3 || actualForm == 4) {
                MemoryStreamBuffer locationData = new MemoryStreamBuffer(locationValue.getValueAsBytes(), this.exeReader.getByteOrder());
                return new LocationExpression(locationData, this.currentCUHeader.addressSize, this.currentParentScope);
            }
            assert (false);
        }
        return null;
    }

    private void dumpSymbols() {
        if (DEBUG) {
            PrintStream out = null;
            try {
                out = new PrintStream(new File(this.dumpFileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Failed to open or create the dump file: " + this.dumpFileName);
                return;
            }
            out.println("Module - " + this.symbolFilePath);
            out.println("\tVariables - " + this.moduleScope.getVariables().size());
            out.println("\tCompile units - " + this.moduleScope.getChildren().size());
            out.println();
            for (IScope cu : this.moduleScope.getChildren()) {
                out.println("\tCompile unit - " + cu.toString());
                out.println("\t\tVariables - " + cu.getVariables().size());
                out.println("\t\tFunctions - " + cu.getChildren().size());
                out.println();
                for (IScope func : cu.getChildren()) {
                    out.println("\t\tFunction - " + func.toString());
                    out.println("\t\t\tVariables - " + func.getVariables().size());
                    out.println("\t\t\tParameters - " + ((IFunctionScope)func).getParameters().size());
                    out.println("\t\t\tLexical blocks - " + func.getChildren().size());
                    out.println();
                    for (IScope block : func.getChildren()) {
                        out.println("\t\t\tLexical block - " + block.toString());
                        out.println("\t\t\t\tVariables - " + block.getVariables().size());
                        out.println();
                    }
                }
            }
            out.close();
        }
    }

    private void trace(String option, Object methodArgument) {
        if (EDCDebugger.getDefault() != null) {
            EDCDebugger.getDefault().getTrace().trace(option, methodArgument.toString());
        }
    }

    private void traceEntry(String option, Object methodArgument) {
        if (EDCDebugger.getDefault() != null) {
            EDCDebugger.getDefault().getTrace().traceEntry(option, methodArgument);
        }
    }

    private void traceExit(String option, Object methodArgument) {
        if (EDCDebugger.getDefault() != null) {
            EDCDebugger.getDefault().getTrace().traceExit(option, methodArgument);
        }
    }

    public void parseForFrameIndices() {
        if (!this.provider.frameDescEntries.isEmpty()) {
            return;
        }
        IExecutableSection frameSection = this.exeReader.findExecutableSection(DWARF_DEBUG_FRAME);
        if (frameSection == null) {
            return;
        }
        IStreamBuffer buffer = frameSection.getBuffer();
        buffer.position(0L);
        int addressSize = 4;
        long cie_id = addressSize == 4 ? -1L : -1L;
        while (buffer.position() < buffer.capacity()) {
            try {
                long fdePtr = buffer.position();
                long headerLength = DwarfInfoReader.readAddress(buffer, addressSize);
                long nextPosition = buffer.position() + headerLength;
                long ciePtr = DwarfInfoReader.readAddress(buffer, addressSize);
                if (ciePtr != cie_id) {
                    long initialLocation = DwarfInfoReader.readAddress(buffer, addressSize);
                    long addressRange = DwarfInfoReader.readAddress(buffer, addressSize);
                    IStreamBuffer instructions = buffer.wrapSubsection(nextPosition - buffer.position());
                    IRangeList.Entry entry = new IRangeList.Entry(initialLocation, initialLocation + addressRange);
                    DwarfFrameRegisterProvider.FrameDescriptionEntry fde = new DwarfFrameRegisterProvider.FrameDescriptionEntry(fdePtr, ciePtr, entry.low, entry.high, instructions, addressSize);
                    this.provider.frameDescEntries.put(entry, fde);
                }
                buffer.position(nextPosition);
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError("Failed to read frame indices", e);
                break;
            }
        }
    }

    public DwarfFrameRegisterProvider.CommonInformationEntry parseCommonInfoEntry(Long ciePtr, int addressSize, IAddress framePC) throws IOException {
        IExecutableSection frameSection = this.exeReader.findExecutableSection(DWARF_DEBUG_FRAME);
        if (frameSection == null) {
            return null;
        }
        IStreamBuffer buffer = frameSection.getBuffer();
        buffer.position(ciePtr);
        long headerLength = DwarfInfoReader.readAddress(buffer, addressSize);
        if (headerLength > buffer.capacity()) {
            assert (false);
            return null;
        }
        long nextPosition = buffer.position() + headerLength;
        DwarfInfoReader.readAddress(buffer, addressSize);
        byte version = buffer.get();
        String augmentation = DwarfInfoReader.readString(buffer);
        long codeAlignmentFactor = DwarfInfoReader.read_unsigned_leb128(buffer);
        long dataAlignmentFactor = DwarfInfoReader.read_signed_leb128(buffer);
        int returnAddressRegister = version < 3 ? buffer.get() & 0xFF : (int)DwarfInfoReader.read_unsigned_leb128(buffer);
        IStreamBuffer instructions = buffer.wrapSubsection(nextPosition - buffer.position());
        String producer = null;
        ICompileUnitScope cuScope = this.provider.getCompileUnitForAddress(framePC);
        if (cuScope instanceof DwarfCompileUnit) {
            producer = ((DwarfCompileUnit)cuScope).getAttributeList().getAttributeValueAsString((short)37);
        }
        return new DwarfFrameRegisterProvider.CommonInformationEntry(codeAlignmentFactor, dataAlignmentFactor, returnAddressRegister, version, instructions, addressSize, producer, augmentation);
    }

    private void storeTypeByName(String name, IType type) {
        if (name.length() == 0) {
            return;
        }
        List<IType> typeList = this.provider.typesByName.get(name);
        if (typeList == null) {
            typeList = new ArrayList<IType>();
            this.provider.typesByName.put(name, typeList);
        }
        typeList.add(type);
    }

    private class BaseAndScopedNames {
        public String baseName;
        public String nameWithScope;

        private BaseAndScopedNames() {
        }
    }

    static class DereferencedAttributes {
        public DwarfDebugInfoProvider.CompilationUnitHeader header;
        public DwarfDebugInfoProvider.AttributeList attributeList;

        public DereferencedAttributes(DwarfDebugInfoProvider.CompilationUnitHeader header, DwarfDebugInfoProvider.AttributeList attributeList) {
            this.header = header;
            this.attributeList = attributeList;
        }
    }
}

