/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.Section;
import org.eclipse.cdt.debug.edc.internal.symbols.Symbol;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSection;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionInfo;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;

public class ElfExecutableSymbolicsReader
extends BaseExecutableSymbolicsReader {
    protected boolean isLE;

    public ElfExecutableSymbolicsReader(IPath binaryFile, Elf elf) throws IOException {
        super(binaryFile);
        Elf.ELFhdr header = elf.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        this.exeBaseAddress = this.getExeSegment((Elf)elf).p_vaddr;
        this.modificationDate = binaryFile.toFile().lastModified();
        this.sectionMapper = new SectionMapper(binaryFile, this.isLE);
        this.recordSections(elf);
        this.readSymbols(elf);
        this.unmangler = new UnmanglerEABI();
    }

    public String toString() {
        return "ELF symbolics reader for " + this.binaryFile;
    }

    private void recordSections(Elf elfFile) throws IOException {
        Elf.Section[] sections;
        Elf.PHdr[] segments;
        int id = 0;
        Elf.PHdr[] pHdrArray = segments = elfFile.getPHdrs();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.PHdr s = pHdrArray[n2];
            if (s.p_type == 1L) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if ((s.p_flags & 1L) != 0L) {
                    props.put("name", ".text");
                } else {
                    props.put("name", ".data");
                }
                Section section = new Section(id++, s.p_memsz, s.p_vaddr, props);
                this.sections.add(section);
            }
            ++n2;
        }
        Elf.Section[] sectionArray = sections = elfFile.getSections();
        int n3 = sections.length;
        n = 0;
        while (n < n3) {
            Elf.Section section = sectionArray[n];
            String name = section.toString();
            if (name.length() > 0) {
                if (this.executableSections.containsKey(name)) {
                    throw new IllegalStateException("duplicate section " + name);
                }
                ExecutableSection exeSection = new ExecutableSection(this.sectionMapper, name, new SectionInfo(section.sh_offset, section.sh_size));
                this.executableSections.put(name, exeSection);
            }
            ++n;
        }
    }

    private void readSymbols(Elf elfFile) throws IOException {
        elfFile.loadSymbols();
        TreeSet<IAddress> symbolAddressSet = new TreeSet<IAddress>();
        Elf.Symbol[] symbolArray = elfFile.getSymtabSymbols();
        int n = symbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.Symbol symbol = symbolArray[n2];
            String name = symbol.toString();
            if (!(name.length() <= 0 || symbol.st_size == 0L && symbolAddressSet.contains(symbol.st_value) || symbol.st_size == 0L && name.startsWith("|"))) {
                Symbol sym = new Symbol(symbol.toString(), symbol.st_value, symbol.st_size);
                this.symbols.add(sym);
                symbolAddressSet.add(symbol.st_value);
            }
            ++n2;
        }
        Collections.sort(this.symbols);
    }

    private Elf.PHdr getExeSegment(Elf elf) throws IOException {
        Elf.PHdr[] segments;
        Elf.PHdr[] pHdrArray = segments = elf.getPHdrs();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.PHdr s = pHdrArray[n2];
            if (s.p_type == 1L && (s.p_flags & 1L) != 0L) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    public ByteOrder getByteOrder() {
        return this.isLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

