/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReaderFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ExecutableSymbolicsReaderFactory {
    private static final String SYM_EXTENSION = "sym";
    private static final String DBG_EXTENSION = "dbg";
    private static Map<String, IExecutableSymbolicsReaderFactory> providerMap = new HashMap<String, IExecutableSymbolicsReaderFactory>();

    static {
        ExecutableSymbolicsReaderFactory.initializeExtensions();
    }

    public static IExecutableSymbolicsReader createFor(IPath binaryFile) {
        for (Map.Entry<String, IExecutableSymbolicsReaderFactory> entry : providerMap.entrySet()) {
            String name = entry.getKey();
            IExecutableSymbolicsReaderFactory provider = entry.getValue();
            try {
                IExecutableSymbolicsReader reader = provider.createExecutableSymbolicsReader(binaryFile);
                if (reader == null) continue;
                return reader;
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError("Executable reader " + name + " failed", t);
            }
        }
        return null;
    }

    public static IPath findSymbolicsFile(IPath binaryFile) {
        IPath symFile = binaryFile.removeFileExtension().addFileExtension(SYM_EXTENSION);
        if (symFile.toFile().exists()) {
            return symFile;
        }
        symFile = binaryFile.removeFileExtension().addFileExtension(DBG_EXTENSION);
        if (symFile.toFile().exists()) {
            return symFile;
        }
        symFile = binaryFile.addFileExtension(SYM_EXTENSION);
        if (symFile.toFile().exists()) {
            return symFile;
        }
        symFile = binaryFile.addFileExtension(DBG_EXTENSION);
        if (symFile.toFile().exists()) {
            return symFile;
        }
        return null;
    }

    protected static void initializeExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.debug.edc.executableSymbolicsReaderFactory");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String name = element.getAttribute("name");
                IExecutableSymbolicsReaderFactory formatProvider = (IExecutableSymbolicsReaderFactory)element.createExecutableExtension("class");
                providerMap.put(name, formatProvider);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Could not create executable symbolics provider extension", e);
            }
            ++n2;
        }
    }
}

