/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.io.FileNotFoundException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.launch.LaunchMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static ICProject verifyCProject(ILaunchConfiguration configuration) throws CoreException {
        String name = LaunchUtils.getProjectName(configuration);
        if (name == null) {
            LaunchUtils.abort(LaunchMessages.getString("LaunchUtils.C_Project_not_specified"), null, 102);
            return null;
        }
        ICProject cproject = LaunchUtils.getCProject(configuration);
        if (cproject == null && name.length() > 0) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("LaunchUtils.Project_NAME_does_not_exist", name), null, 103);
            } else if (!proj.isOpen()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("LaunchUtils.Project_NAME_is_closed", name), null, 103);
            }
            LaunchUtils.abort(LaunchMessages.getString("LaunchUtils.Not_a_C_CPP_project"), null, 103);
        }
        return cproject;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
        Path programPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName == null) {
            LaunchUtils.abort(LaunchMessages.getString("LaunchUtils.Program_file_not_specified"), null, 103);
        }
        if ((programPath = new Path(programName)).isEmpty()) {
            LaunchUtils.abort(LaunchMessages.getString("LaunchUtils.Program_file_does_not_exist"), null, 103);
        }
        if (!programPath.isAbsolute() && cproject != null) {
            IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            LaunchUtils.abort(LaunchMessages.getString("LaunchUtils.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("LaunchUtils.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
        }
        return programPath;
    }

    private static void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus(EDCDebugger.getUniqueIdentifier(), code, message, exception);
        status.add((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = LaunchUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static String getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String expandedLocation;
        String location = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
        if (location != null && (expandedLocation = LaunchUtils.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            return expandedLocation;
        }
        return "";
    }
}

