/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

public abstract class AbstractEDCService
extends AbstractDsfService {
    private final String[] classNames;
    private ITargetEnvironment targetEnvironmentService = null;
    private final boolean snapshot;

    public AbstractEDCService(DsfSession session, String[] classNames) {
        super(session);
        this.classNames = classNames;
        this.snapshot = Album.isSnapshotSession(session.getId());
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                AbstractEDCService.this.doInitialize(requestMonitor);
            }
        });
    }

    protected void doInitialize(RequestMonitor requestMonitor) {
        this.register(this.classNames, new Hashtable());
        if (this.targetEnvironmentService == null) {
            this.targetEnvironmentService = (ITargetEnvironment)this.getServicesTracker().getService(ITargetEnvironment.class);
        }
        requestMonitor.done();
    }

    protected BundleContext getBundleContext() {
        return EDCDebugger.getBundleContext();
    }

    public ITargetEnvironment getTargetEnvironmentService() {
        return this.targetEnvironmentService;
    }
}

