/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.launch.CSourceLookup;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.MemoryVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.EDCSymbolReader;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.services.IFrameRegisters;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stack
extends AbstractEDCService
implements IStack,
ICachingService {
    public static final String STACK_FRAME = "stack_frame";
    public Boolean showAllVariablesEnabled = null;
    private final Map<String, List<StackFrameDMC>> stackFrames = Collections.synchronizedMap(new HashMap());
    private final Map<String, Boolean> allFramesCached = Collections.synchronizedMap(new HashMap());

    public Stack(DsfSession session, String[] classNames) {
        super(session, classNames);
    }

    public static String createFrameID(IEDCExecutionDMC executionDMC, Map<String, Object> frameProperties) {
        int level = (Integer)frameProperties.get("Level");
        String parentID = executionDMC.getID();
        return String.valueOf(parentID) + ".frame[" + level + "]";
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public void getArguments(IStack.IFrameDMContext frameCtx, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        rm.done();
    }

    public void getFrameData(IStack.IFrameDMContext frameDmc, DataRequestMonitor<IStack.IFrameDMData> rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", (Object)frameDmc);
        rm.setData((Object)new StackFrameData((StackFrameDMC)frameDmc));
        EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
        rm.done();
    }

    public void getFrames(IDMContext execContext, DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", (Object)execContext);
        RunControl.ExecutionDMC execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)execContext, RunControl.ExecutionDMC.class);
        if (execDmc != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            rm.setData((Object)this.getFramesForDMC((RunControl.ExecutionDMC)execContext, 0, -1));
            if (((IStack.IFrameDMContext[])rm.getData()).length == 0) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execDmc, null));
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
    }

    public void getLocals(IStack.IFrameDMContext frameCtx, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        StackFrameDMC frameContext = (StackFrameDMC)frameCtx;
        rm.setData((Object)frameContext.getLocals());
        rm.done();
    }

    public void getStackDepth(IDMContext dmc, int maxDepth, DataRequestMonitor<Integer> rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", new Object[]{dmc, maxDepth});
        RunControl.ExecutionDMC execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)dmc, RunControl.ExecutionDMC.class);
        if (execDmc != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            int startFrame = 0;
            int endFrame = -1;
            if (maxDepth > 0) {
                endFrame = maxDepth - 1;
            }
            rm.setData((Object)this.getFramesForDMC(execDmc, startFrame, endFrame).length);
            if ((Integer)rm.getData() == 0) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execDmc, null));
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
    }

    public void getTopFrame(IDMContext execContext, DataRequestMonitor<IStack.IFrameDMContext> rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", (Object)execContext);
        IStack.IFrameDMContext[] frames = this.getFramesForDMC((RunControl.ExecutionDMC)execContext, 0, 0);
        if (frames.length == 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No top stack frame available", null));
            rm.done();
            return;
        }
        rm.setData((Object)frames[0]);
        EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
        rm.done();
    }

    public void getVariableData(IStack.IVariableDMContext variableDmc, DataRequestMonitor<IStack.IVariableDMData> rm) {
        rm.setData((Object)new VariableData((VariableDMC)variableDmc));
        rm.done();
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IStack.IFrameDMContext) {
            this.getFrameData((IStack.IFrameDMContext)dmc, rm);
        } else if (dmc instanceof IStack.IVariableDMContext) {
            this.getVariableData((IStack.IVariableDMContext)dmc, rm);
        } else {
            rm.done();
        }
    }

    public void getFrames(IDMContext execContext, int startIndex, int endIndex, DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", new Object[]{execContext, startIndex, endIndex});
        RunControl.ExecutionDMC execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)execContext, RunControl.ExecutionDMC.class);
        if (execDmc != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            rm.setData((Object)this.getFramesForDMC((RunControl.ExecutionDMC)execContext, startIndex, endIndex));
            if (((IStack.IFrameDMContext[])rm.getData()).length == 0) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execContext, null));
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", rm.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStack.IFrameDMContext[] getFramesForDMC(IEDCExecutionDMC context, int startIndex, int endIndex) {
        List<StackFrameDMC> frames;
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/stack", new Object[]{context, startIndex, endIndex});
        if (!context.isSuspended() || !RunControl.isNonContainer((IDMContext)context)) {
            return new IStack.IFrameDMContext[0];
        }
        boolean needsUpdate = false;
        Map<String, List<StackFrameDMC>> map = this.stackFrames;
        synchronized (map) {
            frames = this.stackFrames.get(context.getID());
            needsUpdate = frames == null || frames.get(0).getLevel() > startIndex || frames.get(frames.size() - 1).getLevel() < endIndex || endIndex == -1 && this.allFramesCached.get(context.getID()) == false;
        }
        if (needsUpdate) {
            this.updateFrames(context, startIndex, endIndex);
        }
        map = this.stackFrames;
        synchronized (map) {
            frames = this.stackFrames.get(context.getID());
            if (endIndex >= 0) {
                frames = startIndex < frames.size() && startIndex <= endIndex ? frames.subList(startIndex, Math.min(endIndex + 1, frames.size())) : Collections.emptyList();
            }
            IStack.IFrameDMContext[] result = frames.toArray(new IStack.IFrameDMContext[frames.size()]);
            EDCDebugger.getDefault().getTrace().traceExit("/debug/stack", (Object)result);
            return result;
        }
    }

    private void updateFrames(IEDCExecutionDMC context, int startIndex, int endIndex) {
        ArrayList<StackFrameDMC> frames = new ArrayList<StackFrameDMC>();
        List<Map<String, Object>> frameProperties = this.computeStackFrames(context, startIndex, endIndex);
        StackFrameDMC previous = null;
        for (Map<String, Object> props : frameProperties) {
            StackFrameDMC frame = new StackFrameDMC(context, props);
            if (previous != null) {
                frame.calledFrame = previous;
            }
            frames.add(frame);
            previous = frame;
        }
        this.stackFrames.put(context.getID(), frames);
        this.allFramesCached.put(context.getID(), startIndex == 0 && endIndex == -1);
    }

    protected abstract List<Map<String, Object>> computeStackFrames(IEDCExecutionDMC var1, int var2, int var3);

    public void loadFramesForContext(IEDCExecutionDMC exeDmc, Element allFrames) throws Exception {
        this.flushCache(null);
        List<StackFrameDMC> frames = Collections.synchronizedList(new ArrayList());
        NodeList frameElements = allFrames.getElementsByTagName(STACK_FRAME);
        int numFrames = frameElements.getLength();
        StackFrameDMC previousFrameDMC = null;
        int i = 0;
        while (i < numFrames) {
            Element groupElement = (Element)frameElements.item(i);
            Element propElement = (Element)groupElement.getElementsByTagName("properties").item(0);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            SnapshotUtils.initializeFromXML(propElement, properties);
            properties.put("Level", i);
            StackFrameDMC frameDMC = new StackFrameDMC(exeDmc, properties);
            frameDMC.loadSnapshot(groupElement);
            if (previousFrameDMC != null) {
                frameDMC.calledFrame = previousFrameDMC;
            }
            frames.add(frameDMC);
            previousFrameDMC = frameDMC;
            ++i;
        }
        this.stackFrames.put(exeDmc.getID(), frames);
        this.allFramesCached.put(exeDmc.getID(), true);
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        if (context != null && context instanceof IEDCDMContext) {
            String contextID = ((IEDCDMContext)context).getID();
            this.stackFrames.remove(contextID);
            this.allFramesCached.remove(contextID);
        } else {
            this.stackFrames.clear();
            this.allFramesCached.clear();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.flushCache(e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.flushCache(e.getDMContext());
    }

    public static class AlwaysFailingFrameRegisters
    implements IFrameRegisters {
        private final CoreException e;

        public AlwaysFailingFrameRegisters(CoreException e) {
            this.e = e;
        }

        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            throw this.e;
        }

        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            throw this.e;
        }
    }

    public static final class CurrentFrameRegisters
    implements IFrameRegisters {
        private final Registers registers;
        private final IEDCExecutionDMC executionDMC;

        public CurrentFrameRegisters(IEDCExecutionDMC executionDMC, Registers registers) {
            this.executionDMC = executionDMC;
            this.registers = registers;
        }

        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            String value = this.registers.getRegisterValue(this.executionDMC, regnum);
            if (value == null || value.equals("badbadba")) {
                throw EDCDebugger.newCoreException("failed to read register");
            }
            return new BigInteger(value, 16);
        }

        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            String id = this.registers.getRegisterNameFromCommonID(regnum);
            if (id == null) {
                throw EDCDebugger.newCoreException(MessageFormat.format("could not find register number {0}", regnum));
            }
            this.registers.writeRegister(this.executionDMC, id, value.toString(16));
        }
    }

    public class EnumeratorDMC
    extends DMContext
    implements IEnumeratorDMContext,
    IVariableEnumeratorContext {
        private final IEnumerator enumerator;

        public EnumeratorDMC(StackFrameDMC frame, IEnumerator enumerator) {
            super((IDsfService)Stack.this, new IDMContext[]{frame}, enumerator.getName(), enumerator.getName());
            this.enumerator = enumerator;
        }

        public IEnumerator getEnumerator() {
            return this.enumerator;
        }
    }

    public static interface IEnumeratorDMContext {
    }

    public static interface IVariableEnumeratorContext {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreservedFrameRegisters
    implements IFrameRegisters {
        private final Map<Integer, BigInteger> preservedRegisters;
        private final DsfServicesTracker dsfServicesTracker;
        private final StackFrameDMC context;

        public PreservedFrameRegisters(DsfServicesTracker dsfServicesTracker, StackFrameDMC context, Map<Integer, BigInteger> preservedRegisters) {
            this.dsfServicesTracker = dsfServicesTracker;
            this.context = context;
            this.preservedRegisters = preservedRegisters;
        }

        @Override
        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            BigInteger addrVal = this.preservedRegisters.get(regnum);
            if (addrVal != null) {
                MemoryVariableLocation location = new MemoryVariableLocation(this.dsfServicesTracker, (IDMContext)this.context, addrVal, true);
                return location.readValue(bytes);
            }
            throw EDCDebugger.newCoreException("cannot read $R" + regnum + " from frame");
        }

        @Override
        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            BigInteger addrVal = this.preservedRegisters.get(regnum);
            if (addrVal != null) {
                MemoryVariableLocation location = new MemoryVariableLocation(this.dsfServicesTracker, (IDMContext)this.context, addrVal, true);
                location.writeValue(bytes, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StackFrameDMC
    extends DMContext
    implements IStack.IFrameDMContext,
    Comparable<StackFrameDMC>,
    ISnapshotContributor {
        public static final String LEVEL_INDEX = "Level";
        public static final String ROOT_FRAME = "root_frame";
        public static final String BASE_ADDR = "Base_address";
        public static final String IP_ADDR = "Instruction_address";
        public static final String MODULE_NAME = "module_name";
        public static final String SOURCE_FILE = "source_file";
        public static final String FUNCTION_NAME = "function_name";
        public static final String LINE_NUMBER = "line_number";
        public static final String IN_PROLOGUE = "in_prologue";
        public static final String PRESERVED_REGISTERS = "preserved_registers";
        private static final String FRAME_PROPERTY_CACHE = "_frame_properties";
        private final DsfServicesTracker dsfServicesTracker;
        private final IEDCExecutionDMC executionDMC;
        private final int level;
        private IAddress baseAddress;
        private IAddress ipAddress;
        private String moduleName;
        private String sourceFile;
        private String functionName;
        private int lineNumber;
        private IScope variableScope;
        private List<VariableDMC> locals;
        private List<EnumeratorDMC> enumerators;
        private final Map<String, VariableDMC> localsByName;
        private final Map<String, EnumeratorDMC> enumeratorsByName;
        private IFunctionScope functionScope;
        private IFrameRegisters frameRegisters;
        public StackFrameDMC calledFrame;
        private TypeEngine typeEngine;
        private IEDCModuleDMContext module;

        public StackFrameDMC(IEDCExecutionDMC executionDMC, Map<String, Object> frameProperties) {
            String cacheKey;
            Object ipAddr;
            super((IDsfService)Stack.this, new IDMContext[]{executionDMC}, Stack.createFrameID(executionDMC, frameProperties), frameProperties);
            this.dsfServicesTracker = Stack.this.getServicesTracker();
            this.moduleName = "";
            this.sourceFile = "";
            this.functionName = "";
            this.variableScope = null;
            this.localsByName = Collections.synchronizedMap(new HashMap());
            this.enumeratorsByName = Collections.synchronizedMap(new HashMap());
            this.executionDMC = executionDMC;
            this.level = (Integer)frameProperties.get(LEVEL_INDEX);
            this.moduleName = (String)frameProperties.get(MODULE_NAME);
            Object base = frameProperties.get(BASE_ADDR);
            if (base instanceof Integer) {
                this.baseAddress = new Addr64(base.toString());
            }
            if (base instanceof Long) {
                this.baseAddress = new Addr64(base.toString());
            }
            if (base instanceof String) {
                this.baseAddress = new Addr64((String)base, 16);
            }
            if ((ipAddr = frameProperties.get(IP_ADDR)) instanceof Integer) {
                this.ipAddress = new Addr64(ipAddr.toString());
            }
            if (ipAddr instanceof Long) {
                this.ipAddress = new Addr64(ipAddr.toString());
            }
            if (ipAddr instanceof String) {
                this.ipAddress = new Addr64((String)ipAddr, 16);
            }
            boolean usingCachedProperties = false;
            IEDCModules modules = (IEDCModules)this.dsfServicesTracker.getService(IEDCModules.class);
            Map<IAddress, Map<String, Object>> cachedFrameProperties = new HashMap();
            if (modules != null) {
                IPath symbolFile;
                IEDCSymbolReader reader;
                this.module = modules.getModuleByAddress(executionDMC.getSymbolDMContext(), this.ipAddress);
                if (this.module != null && (reader = this.module.getSymbolReader()) != null && (symbolFile = reader.getSymbolFile()) != null) {
                    Map cachedProperties;
                    cacheKey = String.valueOf(reader.getSymbolFile().toOSString()) + FRAME_PROPERTY_CACHE;
                    Map cachedData = EDCDebugger.getDefault().getCache().getCachedData(cacheKey, Map.class, reader.getModificationDate());
                    if (cachedData != null && (cachedProperties = (Map)(cachedFrameProperties = cachedData).get(this.module.toLinkAddress(this.ipAddress))) != null) {
                        if (cachedProperties.containsKey(SOURCE_FILE)) {
                            frameProperties.put(SOURCE_FILE, cachedProperties.get(SOURCE_FILE));
                        }
                        if (cachedProperties.containsKey(FUNCTION_NAME)) {
                            frameProperties.put(FUNCTION_NAME, cachedProperties.get(FUNCTION_NAME));
                        }
                        if (cachedProperties.containsKey(LINE_NUMBER)) {
                            frameProperties.put(LINE_NUMBER, cachedProperties.get(LINE_NUMBER));
                        }
                        usingCachedProperties = true;
                    }
                }
            }
            if (frameProperties.containsKey(SOURCE_FILE)) {
                this.sourceFile = (String)frameProperties.get(SOURCE_FILE);
                this.functionName = (String)frameProperties.get(FUNCTION_NAME);
                this.lineNumber = (Integer)frameProperties.get(LINE_NUMBER);
            } else if (!usingCachedProperties) {
                IEDCSymbols symbolsService = (IEDCSymbols)Stack.this.getServicesTracker().getService(Symbols.class);
                ILineEntry line = symbolsService.getLineEntryForAddress(executionDMC.getSymbolDMContext(), this.ipAddress);
                if (line != null) {
                    this.sourceFile = line.getFilePath().toOSString();
                    frameProperties.put(SOURCE_FILE, this.sourceFile);
                    this.lineNumber = line.getLineNumber();
                    frameProperties.put(LINE_NUMBER, this.lineNumber);
                }
                this.functionScope = symbolsService.getFunctionAtAddress(executionDMC.getSymbolDMContext(), this.ipAddress);
                if (this.functionScope != null) {
                    while (this.functionScope.getParent() instanceof IFunctionScope) {
                        this.functionScope = (IFunctionScope)this.functionScope.getParent();
                    }
                    this.functionName = this.functionScope.getName();
                    frameProperties.put(FUNCTION_NAME, this.functionName);
                }
            }
            this.properties.putAll(frameProperties);
            IDebugInfoProvider debugInfoProvider = null;
            if (modules != null) {
                IEDCSymbolReader symbolReader;
                this.module = modules.getModuleByAddress(executionDMC.getSymbolDMContext(), this.ipAddress);
                if (this.module != null && (symbolReader = this.module.getSymbolReader()) != null) {
                    if (symbolReader instanceof EDCSymbolReader) {
                        debugInfoProvider = ((EDCSymbolReader)symbolReader).getDebugInfoProvider();
                    }
                    if (symbolReader.getSymbolFile() != null) {
                        cacheKey = String.valueOf(symbolReader.getSymbolFile().toOSString()) + FRAME_PROPERTY_CACHE;
                        cachedFrameProperties.put(this.module.toLinkAddress(this.ipAddress), frameProperties);
                        EDCDebugger.getDefault().getCache().putCachedData(cacheKey, (Serializable)((Object)cachedFrameProperties), symbolReader.getModificationDate());
                    }
                }
            }
            this.typeEngine = new TypeEngine(this.dsfServicesTracker, debugInfoProvider);
        }

        public IFunctionScope getFunctionScope() {
            return this.functionScope;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public IEDCExecutionDMC getExecutionDMC() {
            return this.executionDMC;
        }

        public IAddress getBaseAddress() {
            return this.baseAddress;
        }

        public IAddress getIPAddress() {
            return this.ipAddress;
        }

        public int getLevel() {
            return this.level;
        }

        public DsfServicesTracker getDsfServicesTracker() {
            return this.dsfServicesTracker;
        }

        @Override
        public int compareTo(StackFrameDMC f) {
            if (this.level < f.level) {
                return -1;
            }
            if (this.level > f.level) {
                return 1;
            }
            return 0;
        }

        @Override
        public String toString() {
            return "StackFrameDMC [baseAddress=" + this.baseAddress.toHexAddressString() + ", ipAddress=" + this.ipAddress.toHexAddressString() + ", sourceFile=" + this.sourceFile + ", functionName=" + this.functionName + ", lineNumber=" + this.lineNumber + "]";
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.baseAddress == null ? 0 : this.baseAddress.hashCode());
            result = 31 * result + (this.executionDMC == null ? 0 : this.executionDMC.hashCode());
            result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
            result = 31 * result + this.level;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackFrameDMC other = (StackFrameDMC)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.baseAddress == null ? other.baseAddress != null : !this.baseAddress.equals((Object)other.baseAddress)) {
                return false;
            }
            if (this.executionDMC == null ? other.executionDMC != null : !this.executionDMC.equals(other.executionDMC)) {
                return false;
            }
            if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals((Object)other.ipAddress)) {
                return false;
            }
            return this.level == other.level;
        }

        private String findSourceFile(String sourceFile) {
            String result = "";
            CSourceLookup lookup = (CSourceLookup)((Object)Stack.this.getServicesTracker().getService(CSourceLookup.class));
            RunControl runControl = (RunControl)Stack.this.getServicesTracker().getService(RunControl.class);
            CSourceLookupDirector director = lookup.getSourceLookupDirector(runControl.getRootDMC());
            try {
                Object[] elements = director.findSourceElements((Object)sourceFile);
                if (elements != null && elements.length > 0) {
                    Object element = elements[0];
                    if (element instanceof File) {
                        try {
                            result = ((File)element).getCanonicalPath();
                        }
                        catch (IOException e) {
                            EDCDebugger.getMessageLogger().logError(null, e);
                        }
                    } else if (element instanceof IFile) {
                        result = ((IFile)element).getLocation().toOSString();
                    } else if (element instanceof IStorage) {
                        result = ((IStorage)element).getFullPath().toOSString();
                    } else if (element instanceof ITranslationUnit) {
                        result = ((ITranslationUnit)element).getLocation().toOSString();
                    }
                }
            }
            catch (CoreException e1) {
                EDCDebugger.getMessageLogger().logError(sourceFile, e1);
            }
            return result;
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            Element contextElement = document.createElement(Stack.STACK_FRAME);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            if (this.sourceFile.length() > 0) {
                album.addFile((IPath)new Path(this.findSourceFile(this.sourceFile)));
            }
            return contextElement;
        }

        @Override
        public void loadSnapshot(Element element) {
            Map preservedRegisters = (Map)this.properties.get(PRESERVED_REGISTERS);
            if (preservedRegisters != null) {
                HashMap<Integer, BigInteger> newPreservedRegisters = new HashMap<Integer, BigInteger>();
                for (Map.Entry entry : preservedRegisters.entrySet()) {
                    newPreservedRegisters.put(Integer.valueOf(((String)entry.getKey()).toString()), new BigInteger(((String)entry.getValue()).toString()));
                }
                this.properties.put(PRESERVED_REGISTERS, newPreservedRegisters);
            }
        }

        public IStack.IVariableDMContext[] getLocals() {
            if (Stack.this.showAllVariablesEnabled == null) {
                IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
                Stack.this.showAllVariablesEnabled = scope.getBoolean("show_all_variables_enabled", false);
            }
            Boolean enabled = Stack.this.showAllVariablesEnabled;
            if (this.locals != null) {
                IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
                enabled = scope.getBoolean("show_all_variables_enabled", Stack.this.showAllVariablesEnabled.booleanValue());
            }
            if (this.locals == null || this.locals != null && enabled != Stack.this.showAllVariablesEnabled) {
                Stack.this.showAllVariablesEnabled = enabled;
                this.locals = new ArrayList<VariableDMC>();
                IEDCSymbols symbolsService = (IEDCSymbols)Stack.this.getServicesTracker().getService(Symbols.class);
                IFunctionScope scope = symbolsService.getFunctionAtAddress(this.executionDMC.getSymbolDMContext(), this.ipAddress);
                if (scope != null) {
                    this.variableScope = scope;
                }
                IEDCModules modulesService = (IEDCModules)Stack.this.getServicesTracker().getService(Modules.class);
                IEDCModuleDMContext module = modulesService.getModuleByAddress(this.executionDMC.getSymbolDMContext(), this.ipAddress);
                IAddress linkAddress = null;
                if (module != null) {
                    linkAddress = module.toLinkAddress(this.ipAddress);
                }
                while (scope != null) {
                    Collection<IVariable> scopedVariables = scope.getScopedVariables(linkAddress);
                    for (IVariable variable : scopedVariables) {
                        VariableDMC var = new VariableDMC((IDsfService)Stack.this, this, variable);
                        this.locals.add(var);
                        this.localsByName.put(var.getName(), var);
                    }
                    IScope parentScope = null;
                    if (Stack.this.showAllVariablesEnabled.booleanValue()) {
                        parentScope = scope.getParent();
                    }
                    while (parentScope != null) {
                        if (parentScope instanceof ICompileUnitScope) {
                            ICompileUnitScope cuScope = (ICompileUnitScope)parentScope;
                            IDebugInfoProvider debugInfoProvider = null;
                            IEDCSymbolReader symbolReader = module.getSymbolReader();
                            if (symbolReader instanceof EDCSymbolReader) {
                                debugInfoProvider = ((EDCSymbolReader)symbolReader).getDebugInfoProvider();
                            }
                            List<ICompileUnitScope> cuScopes = null;
                            if (debugInfoProvider != null) {
                                cuScopes = debugInfoProvider.getCompileUnitsForFile(cuScope.getFilePath());
                            } else {
                                cuScopes = new ArrayList<ICompileUnitScope>(1);
                                cuScopes.add(cuScope);
                            }
                            for (ICompileUnitScope nextCuScope : cuScopes) {
                                Collection<IVariable> globals = nextCuScope.getVariables();
                                if (globals == null) continue;
                                for (IVariable variable : globals) {
                                    VariableDMC var = new VariableDMC((IDsfService)Stack.this, this, variable);
                                    this.locals.add(var);
                                    this.localsByName.put(var.getName(), var);
                                }
                            }
                        }
                        parentScope = parentScope.getParent();
                    }
                    if (!(scope.getParent() instanceof IFunctionScope)) break;
                    scope = (IFunctionScope)scope.getParent();
                }
            }
            return this.locals.toArray(new VariableDMC[this.locals.size()]);
        }

        public IVariableEnumeratorContext findVariableOrEnumeratorByName(String name, boolean localsOnly) {
            IVariableEnumeratorContext variableOrEnumerator;
            if (this.locals == null) {
                this.getLocals();
            }
            if ((variableOrEnumerator = (IVariableEnumeratorContext)this.localsByName.get(name)) != null) {
                return variableOrEnumerator;
            }
            if (this.enumerators == null) {
                this.getEnumerators();
            }
            if ((variableOrEnumerator = (IVariableEnumeratorContext)this.enumeratorsByName.get(name)) != null) {
                return variableOrEnumerator;
            }
            if (localsOnly || this.getVariableScope() == null) {
                return null;
            }
            IScope variableScope = this.getVariableScope().getParent();
            while (variableOrEnumerator == null && variableScope != null) {
                Object[] variableArray;
                if (variableScope instanceof IModuleScope) {
                    Collection<IVariable> variables = ((IModuleScope)variableScope).getVariablesByName(name, true);
                    if (variables.size() <= 0 || !((variableArray = variables.toArray())[0] instanceof IVariable)) break;
                    variableOrEnumerator = new VariableDMC((IDsfService)Stack.this, this, (IVariable)variableArray[0]);
                    break;
                }
                variableArray = variableScope.getVariables().iterator();
                while (variableArray.hasNext()) {
                    IVariable scopeVariable = variableArray.next();
                    if (!scopeVariable.getName().equals(name)) continue;
                    variableOrEnumerator = new VariableDMC((IDsfService)Stack.this, this, scopeVariable);
                    break;
                }
                if (variableOrEnumerator == null && variableScope instanceof IFunctionScope) {
                    IFunctionScope functionScope = (IFunctionScope)variableScope;
                    for (IVariable scopeVariable : functionScope.getParameters()) {
                        if (!scopeVariable.getName().equals(name)) continue;
                        variableOrEnumerator = new VariableDMC((IDsfService)Stack.this, this, scopeVariable);
                        break;
                    }
                }
                if (variableOrEnumerator == null) {
                    for (IEnumerator scopeEnumerator : variableScope.getEnumerators()) {
                        if (!scopeEnumerator.getName().equals(name)) continue;
                        variableOrEnumerator = new EnumeratorDMC(this, scopeEnumerator);
                        break;
                    }
                }
                variableScope = variableScope.getParent();
            }
            return variableOrEnumerator;
        }

        public IScope getVariableScope() {
            return this.variableScope;
        }

        public EnumeratorDMC[] getEnumerators() {
            if (this.enumerators == null) {
                this.enumerators = new ArrayList<EnumeratorDMC>();
                if (Stack.this.getServicesTracker() != null) {
                    IEDCSymbols symbolsService = (IEDCSymbols)Stack.this.getServicesTracker().getService(Symbols.class);
                    if (this.executionDMC != null && symbolsService != null) {
                        IFunctionScope scope = symbolsService.getFunctionAtAddress(this.executionDMC.getSymbolDMContext(), this.ipAddress);
                        while (scope != null) {
                            Collection<IEnumerator> localEnumerators = scope.getEnumerators();
                            for (IEnumerator enumerator : localEnumerators) {
                                EnumeratorDMC enumeratorDMC = new EnumeratorDMC(this, enumerator);
                                this.enumerators.add(enumeratorDMC);
                                this.enumeratorsByName.put(enumerator.getName(), enumeratorDMC);
                            }
                            if (!(scope.getParent() instanceof IFunctionScope)) break;
                            scope = (IFunctionScope)scope.getParent();
                        }
                    }
                }
            }
            return this.enumerators.toArray(new EnumeratorDMC[this.enumerators.size()]);
        }

        public EnumeratorDMC findEnumeratorbyName(String name) {
            if (this.enumerators == null) {
                this.getEnumerators();
            }
            return this.enumeratorsByName.get(name);
        }

        public IFrameRegisters getFrameRegisters() {
            if (this.frameRegisters == null) {
                if (this.level == 0) {
                    Registers registers = (Registers)this.getDsfServicesTracker().getService(Registers.class);
                    this.frameRegisters = new CurrentFrameRegisters(this.executionDMC, registers);
                } else {
                    Map preservedRegisters;
                    Symbols symbolsService;
                    IFrameRegisterProvider frameRegisterProvider;
                    Modules modulesService = (Modules)Stack.this.getServicesTracker().getService(Modules.class);
                    Modules.ModuleDMC module = modulesService.getModuleByAddress(this.executionDMC.getSymbolDMContext(), this.ipAddress);
                    if (module != null && (frameRegisterProvider = (symbolsService = (Symbols)Stack.this.getServicesTracker().getService(Symbols.class)).getFrameRegisterProvider(this.executionDMC.getSymbolDMContext(), this.ipAddress)) != null) {
                        try {
                            this.frameRegisters = frameRegisterProvider.getFrameRegisters(Stack.this.getSession(), Stack.this.getServicesTracker(), this);
                        }
                        catch (CoreException e) {
                            this.frameRegisters = new AlwaysFailingFrameRegisters(e);
                        }
                    }
                    if (this.frameRegisters == null && (preservedRegisters = (Map)this.properties.get(PRESERVED_REGISTERS)) != null) {
                        this.frameRegisters = new PreservedFrameRegisters(this.dsfServicesTracker, this, preservedRegisters);
                    }
                    if (this.frameRegisters == null) {
                        this.frameRegisters = new AlwaysFailingFrameRegisters(EDCDebugger.newCoreException("cannot read variables in this frame"));
                    }
                }
            }
            return this.frameRegisters;
        }

        public StackFrameDMC getCalledFrame() throws CoreException {
            return this.calledFrame;
        }

        public TypeEngine getTypeEngine() {
            return this.typeEngine;
        }

        public IEDCModuleDMContext getModule() {
            return this.module;
        }

        private Stack getOuterType() {
            return Stack.this;
        }
    }

    public static class StackFrameData
    implements IStack.IFrameDMData {
        public final IAddress address;
        public final int level;
        public final String function;
        public final String module;
        private final String file;
        private final int lineNumber;

        StackFrameData(StackFrameDMC dmc) {
            this.level = dmc.getLevel();
            this.address = dmc.getIPAddress();
            this.module = dmc.getModuleName();
            this.file = dmc.getSourceFile();
            this.lineNumber = dmc.getLineNumber();
            this.function = dmc.getFunctionName();
        }

        public IAddress getAddress() {
            return this.address;
        }

        public String getFunction() {
            return this.function;
        }

        public int getLevel() {
            return this.level;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.lineNumber;
        }

        public int getColumn() {
            return 0;
        }

        public String getModule() {
            return this.module;
        }
    }

    public class VariableDMC
    extends DMContext
    implements IStack.IVariableDMContext,
    IVariableEnumeratorContext {
        public static final String PROP_LOCATION = "Location";
        private final IVariable variable;

        public VariableDMC(IDsfService service, StackFrameDMC frame, IVariable variable) {
            super((IDsfService)Stack.this, new IDMContext[]{frame}, variable.getName(), variable.getName());
            this.variable = variable;
        }

        public IVariable getVariable() {
            return this.variable;
        }
    }

    public class VariableData
    implements IStack.IVariableDMData {
        private final String name;

        public VariableData(VariableDMC variableDMC) {
            this.name = variableDMC.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return "0";
        }
    }
}

