/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional;

import java.math.BigInteger;
import java.net.URI;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.SourcePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;

public class DisassemblySelection
implements IDisassemblySelection {
    private final ITextSelection fTextSelection;
    private IStorage fSourceFile;
    private int fSourceLine;
    private IAddress fStartAddress;

    public DisassemblySelection(ITextSelection selection, IDisassemblyPart part) {
        this(selection, (DisassemblyDocument)part.getTextViewer().getDocument());
    }

    DisassemblySelection(ITextSelection selection, DisassemblyDocument document) {
        SourcePosition sourcePosition;
        this.fTextSelection = selection;
        int offset = selection.getOffset();
        try {
            sourcePosition = document.getSourcePosition(offset);
        }
        catch (BadLocationException badLocationException) {
            sourcePosition = null;
        }
        BigInteger docAddress = null;
        if (sourcePosition != null) {
            docAddress = sourcePosition.fAddressOffset;
            if (sourcePosition.length > 0) {
                this.fSourceFile = sourcePosition.fFileInfo.fFile;
                AddressRangePosition pos = document.getDisassemblyPosition(docAddress);
                if (pos instanceof DisassemblyPosition) {
                    this.fSourceLine = ((DisassemblyPosition)pos).getLine();
                }
            }
        } else {
            docAddress = document.getAddressOfOffset(offset);
        }
        if (docAddress != null) {
            try {
                this.fStartAddress = new Addr64(docAddress);
            }
            catch (RuntimeException runtimeException) {
                this.fStartAddress = null;
            }
        }
    }

    public boolean isEmpty() {
        return this.fTextSelection.isEmpty();
    }

    public int getEndLine() {
        return this.fTextSelection.getEndLine();
    }

    public int getLength() {
        return this.fTextSelection.getLength();
    }

    public int getOffset() {
        return this.fTextSelection.getOffset();
    }

    public int getStartLine() {
        return this.fTextSelection.getStartLine();
    }

    public String getText() {
        return this.fTextSelection.getText();
    }

    public IFile getSourceFile() {
        IResource resource;
        if (this.fSourceFile != null && (resource = (IResource)this.fSourceFile.getAdapter(IResource.class)) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public int getSourceLine() {
        if (this.fSourceFile != null) {
            return this.fSourceLine;
        }
        return -1;
    }

    public URI getSourceLocationURI() {
        if (this.fSourceFile != null) {
            IResource resource = (IResource)this.fSourceFile.getAdapter(IResource.class);
            if (resource instanceof IFile) {
                return resource.getLocationURI();
            }
            IPath location = this.fSourceFile.getFullPath();
            if (location != null) {
                return URIUtil.toURI((IPath)location);
            }
        }
        return null;
    }

    public IAddress getStartAddress() {
        return this.fStartAddress;
    }
}

