/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.variable;

import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class VariableCellModifier
extends WatchExpressionCellModifier {
    private AbstractCachingVMProvider fProvider;
    private SyncVariableDataAccess fDataAccess = null;

    public VariableCellModifier(AbstractCachingVMProvider provider, SyncVariableDataAccess access) {
        this.fProvider = provider;
        this.fDataAccess = access;
    }

    private IExpressions.IExpressionDMContext getVariableDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IExpressions.IExpressionDMContext)((IAdaptable)element).getAdapter(IExpressions.IExpressionDMContext.class);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getVariableDMC(element) == null) {
                return false;
            }
            return this.fDataAccess.canWriteExpression(element);
        }
        return super.canModify(element, property);
    }

    public Object getValue(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            String formatId;
            if (element instanceof IVMContext) {
                IVMContext ctx = (IVMContext)element;
                IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                formatId = FormattedValueVMUtil.getPreferredFormat(presCtx);
            } else {
                formatId = "NATURAL.Format";
            }
            String value = this.fDataAccess.getEditableValue(element, formatId);
            if (value == null) {
                return "...";
            }
            return value;
        }
        return super.getValue(element, property);
    }

    public void modify(final Object element, String property, Object value) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (value instanceof String) {
                String formatId;
                if (element instanceof IVMContext) {
                    IVMContext ctx = (IVMContext)element;
                    IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                    formatId = FormattedValueVMUtil.getPreferredFormat(presCtx);
                } else {
                    formatId = "NATURAL.Format";
                }
                this.fDataAccess.writeVariable(element, (String)value, formatId);
                this.fProvider.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        VariableCellModifier.this.fProvider.handleEvent(new UserEditEvent(element));
                    }
                });
            }
        } else {
            super.modify(element, property, value);
        }
    }
}

