/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.actions;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.actions.AbstractTargetAction;
import org.eclipse.cdt.make.ui.dialogs.BuildTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class BuildTargetAction
extends AbstractTargetAction {
    private static final String TARGET_BUILD_COMMAND = "org.eclipse.cdt.make.ui.targetBuildCommand";
    private IBindingService bindingService = null;
    private IAction InitAction = null;
    private IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent event) {
            String keyBinding;
            if (event.isActiveBindingsChanged() && (keyBinding = BuildTargetAction.this.bindingService.getBestActiveBindingFormattedFor(BuildTargetAction.TARGET_BUILD_COMMAND)) != null) {
                BuildTargetAction.this.InitAction.setText(String.valueOf(MakeUIPlugin.getResourceString("ActionMakeBuildTarget.label")) + "\t" + keyBinding);
            }
        }
    };

    public void init(IAction action) {
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (this.bindingService != null) {
            this.bindingService.addBindingManagerListener(this.bindingManagerListener);
            String keyBinding = this.bindingService.getBestActiveBindingFormattedFor(TARGET_BUILD_COMMAND);
            if (keyBinding != null) {
                action.setText(String.valueOf(MakeUIPlugin.getResourceString("ActionMakeBuildTarget.label")) + "\t" + keyBinding);
            }
        }
        this.InitAction = action;
    }

    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            BuildTargetDialog dialog = new BuildTargetDialog(this.getShell(), container, true);
            String name = null;
            try {
                name = (String)container.getSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"));
            }
            catch (CoreException coreException) {}
            try {
                IMakeTarget target;
                if (name != null) {
                    IContainer targetContainer;
                    Path path = new Path(name);
                    name = path.segment(path.segmentCount() - 1);
                    if (path.segmentCount() > 1) {
                        path = path.removeLastSegments(1);
                        targetContainer = (IContainer)container.findMember((IPath)path);
                    } else {
                        targetContainer = container;
                    }
                    IMakeTarget target2 = MakeCorePlugin.getDefault().getTargetManager().findTarget(targetContainer, name);
                    if (target2 != null) {
                        dialog.setTarget(target2);
                    }
                }
                if (dialog.open() == 0 && (target = dialog.getTarget()) != null) {
                    IPath path = target.getContainer().getProjectRelativePath().removeFirstSegments(container.getProjectRelativePath().segmentCount());
                    path = path.append(target.getName());
                    container.setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"), (Object)path.toString());
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void dispose() {
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
            this.bindingService = null;
        }
        super.dispose();
    }
}

