/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig;

import com.ibm.icu.text.MessageFormat;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfgScannerConfigUtil {
    public static CfgInfoContext adjustPerRcTypeContext(CfgInfoContext context) {
        if (((Configuration)context.getConfiguration()).isPreference()) {
            return context;
        }
        Tool tool = (Tool)context.getTool();
        IResourceInfo rcInfo = context.getResourceInfo();
        IInputType inType = context.getInputType();
        boolean adjust = false;
        CfgInfoContext newContext = context;
        if (tool != null) {
            if (inType != null && !tool.hasScannerConfigSettings(inType)) {
                inType = null;
                adjust = true;
            }
            if (inType == null && !tool.hasScannerConfigSettings(null)) {
                tool = null;
                adjust = true;
            }
        }
        if (tool == null) {
            ToolChain tc;
            if (inType != null) {
                inType = null;
                adjust = true;
            }
            if (rcInfo != null && (tc = CfgScannerConfigUtil.getToolChain(rcInfo)) != null && !tc.hasScannerConfigSettings()) {
                adjust = true;
                rcInfo = null;
            }
        }
        if (adjust) {
            newContext = rcInfo == null ? new CfgInfoContext(context.getConfiguration()) : new CfgInfoContext(rcInfo, tool, inType);
        }
        return newContext;
    }

    private static ToolChain getToolChain(IResourceInfo rcInfo) {
        return rcInfo instanceof FolderInfo ? (ToolChain)((FolderInfo)rcInfo).getToolChain() : (ToolChain)((ResourceConfiguration)rcInfo).getBaseToolChain();
    }

    public static String getDefaultProfileId(CfgInfoContext context, boolean searchFirstIfNone) {
        ToolChain tCh;
        String id = null;
        if (context.getInputType() != null) {
            id = context.getInputType().getDiscoveryProfileId(context.getTool());
        }
        if (id == null && context.getTool() != null) {
            id = ((Tool)context.getTool()).getDiscoveryProfileId();
        }
        if (id == null && context.getResourceInfo() != null && (tCh = CfgScannerConfigUtil.getToolChain(context.getResourceInfo())) != null) {
            id = tCh.getScannerConfigDiscoveryProfileId();
        }
        if (id == null) {
            id = ((Configuration)context.getConfiguration()).getDiscoveryProfileId();
        }
        if (id == null && searchFirstIfNone) {
            id = CfgScannerConfigUtil.getFirstProfileId(context.getConfiguration().getFilteredTools());
        }
        return id;
    }

    public static String getFirstProfileId(ITool[] tools) {
        String id = null;
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IInputType[] types = tool.getInputTypes();
            if (types.length != 0) {
                int k = 0;
                while (k < types.length) {
                    id = types[k].getDiscoveryProfileId(tool);
                    if (id == null) {
                        ++k;
                        continue;
                    }
                    break;
                }
            } else {
                id = ((Tool)tool).getDiscoveryProfileId();
            }
            if (id != null) break;
            ++i;
        }
        return id;
    }

    public static Set<String> getAllScannerDiscoveryProfileIds(IToolChain toolchain) {
        Assert.isNotNull((Object)toolchain);
        TreeSet<String> profiles = new TreeSet<String>();
        if (toolchain != null) {
            ITool[] tools;
            String toolchainProfileId = toolchain.getScannerConfigDiscoveryProfileId();
            if (toolchainProfileId != null && toolchainProfileId.length() > 0) {
                profiles.add(toolchainProfileId);
            }
            ITool[] iToolArray = tools = toolchain.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                profiles.addAll(CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds(tool));
                ++n2;
            }
            IToolChain superClass = toolchain.getSuperClass();
            if (superClass != null) {
                profiles.addAll(CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds(superClass));
            }
        }
        return profiles;
    }

    public static Set<String> getAllScannerDiscoveryProfileIds(ITool tool) {
        Assert.isNotNull((Object)tool);
        if (!(tool instanceof Tool)) {
            String msg = MessageFormat.format((String)ManagedMakeMessages.getString("CfgScannerConfigUtil_ErrorNotSupported"), (Object[])new String[]{Tool.class.getName()});
            throw new UnsupportedOperationException(msg);
        }
        TreeSet<String> profiles = new TreeSet<String>();
        IInputType[] iInputTypeArray = ((Tool)tool).getAllInputTypes();
        int n = iInputTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType inputType = iInputTypeArray[n2];
            for (String profileId : CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds(inputType)) {
                profiles.add(profileId);
            }
            ++n2;
        }
        ITool superClass = tool.getSuperClass();
        if (superClass != null) {
            profiles.addAll(CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds(superClass));
        }
        return profiles;
    }

    private static Set<String> getAllScannerDiscoveryProfileIds(IInputType inputType) {
        IInputType superClass;
        Assert.isNotNull((Object)inputType);
        if (!(inputType instanceof InputType)) {
            String msg = MessageFormat.format((String)ManagedMakeMessages.getString("CfgScannerConfigUtil_ErrorNotSupported"), (Object[])new String[]{InputType.class.getName()});
            throw new UnsupportedOperationException(msg);
        }
        TreeSet<String> profiles = new TreeSet<String>();
        String attribute = ((InputType)inputType).getDiscoveryProfileIdAttribute();
        if (attribute != null) {
            String[] stringArray = attribute.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String profileId = stringArray[n2];
                profiles.add(profileId);
                ++n2;
            }
        }
        if ((superClass = inputType.getSuperClass()) != null) {
            profiles.addAll(CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds(superClass));
        }
        return profiles;
    }
}

