/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;

public class FunctionFactory {
    public static IASTFunctionDefinition createGetterDefinition(String varName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTFunctionDefinition getter = new CPPASTFunctionDefinition();
        getter.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy());
        getter.setDeclarator((IASTFunctionDeclarator)FunctionFactory.getGetterDeclarator(varName, fieldDeclaration, name));
        getter.setBody((IASTStatement)FunctionFactory.getGetterBody(varName));
        return getter;
    }

    private static CPPASTCompoundStatement getGetterBody(String varName) {
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        CPPASTReturnStatement returnStatement = new CPPASTReturnStatement();
        CPPASTIdExpression idExpr = new CPPASTIdExpression();
        CPPASTName returnVal = new CPPASTName();
        returnVal.setName(varName.toCharArray());
        idExpr.setName((IASTName)returnVal);
        returnStatement.setReturnValue((IASTExpression)idExpr);
        compound.addStatement((IASTStatement)returnStatement);
        return compound;
    }

    private static CPPASTFunctionDeclarator getGetterDeclarator(String varName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTName getterName = new CPPASTName();
        String varPartOfGetterName = NameHelper.makeFirstCharUpper(NameHelper.trimFieldName(varName));
        getterName.setName("get".concat(varPartOfGetterName).toCharArray());
        CPPASTFunctionDeclarator declarator = new CPPASTFunctionDeclarator();
        declarator.setConst(true);
        if (name != null) {
            name.addName((IASTName)getterName);
            declarator.setName((IASTName)name);
        } else {
            declarator.setName((IASTName)getterName);
        }
        IASTPointerOperator[] iASTPointerOperatorArray = fieldDeclaration.getDeclarators()[0].getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            declarator.addPointerOperator(pointer.copy());
            ++n2;
        }
        return declarator;
    }

    public static IASTFunctionDefinition createSetterDefinition(String varName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTFunctionDefinition setter = new CPPASTFunctionDefinition();
        setter.setDeclSpecifier((IASTDeclSpecifier)FunctionFactory.getVoidDeclSpec());
        setter.setDeclarator((IASTFunctionDeclarator)FunctionFactory.getSetterDeclarator(varName, fieldDeclaration, name));
        setter.setBody((IASTStatement)FunctionFactory.getSetterBody(fieldDeclaration));
        return setter;
    }

    private static CPPASTCompoundStatement getSetterBody(IASTSimpleDeclaration fieldDeclaration) {
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        CPPASTExpressionStatement exprStmt = new CPPASTExpressionStatement();
        CPPASTBinaryExpression binExpr = new CPPASTBinaryExpression();
        CPPASTFieldReference fieldRef = new CPPASTFieldReference();
        CPPASTLiteralExpression litExpr = new CPPASTLiteralExpression();
        litExpr.setValue(Keywords.cTHIS);
        fieldRef.setFieldOwner((IASTExpression)litExpr);
        fieldRef.setFieldName(fieldDeclaration.getDeclarators()[0].getName().copy());
        fieldRef.setIsPointerDereference(true);
        binExpr.setOperand1((IASTExpression)fieldRef);
        binExpr.setOperator(17);
        CPPASTIdExpression idExpr = new CPPASTIdExpression();
        idExpr.setName(fieldDeclaration.getDeclarators()[0].getName().copy());
        binExpr.setOperand2((IASTExpression)idExpr);
        exprStmt.setExpression((IASTExpression)binExpr);
        compound.addStatement((IASTStatement)exprStmt);
        return compound;
    }

    private static CPPASTFunctionDeclarator getSetterDeclarator(String varName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTName setterName = new CPPASTName();
        String varPartOfSetterName = NameHelper.makeFirstCharUpper(NameHelper.trimFieldName(varName));
        setterName.setName("set".concat(varPartOfSetterName).toCharArray());
        CPPASTFunctionDeclarator declarator = new CPPASTFunctionDeclarator();
        if (name != null) {
            name.addName((IASTName)setterName);
            declarator.setName((IASTName)name);
        } else {
            declarator.setName((IASTName)setterName);
        }
        CPPASTParameterDeclaration parameterDeclaration = new CPPASTParameterDeclaration();
        parameterDeclaration.setDeclarator(fieldDeclaration.getDeclarators()[0].copy());
        parameterDeclaration.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy());
        declarator.addParameterDeclaration((IASTParameterDeclaration)parameterDeclaration.copy());
        return declarator;
    }

    private static CPPASTSimpleDeclSpecifier getVoidDeclSpec() {
        CPPASTSimpleDeclSpecifier declSpecifier = new CPPASTSimpleDeclSpecifier();
        declSpecifier.setType(1);
        return declSpecifier;
    }

    public static IASTSimpleDeclaration createGetterDeclaration(String name, IASTSimpleDeclaration fieldDeclaration) {
        CPPASTSimpleDeclaration getter = new CPPASTSimpleDeclaration();
        getter.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy());
        getter.addDeclarator((IASTDeclarator)FunctionFactory.getGetterDeclarator(name, fieldDeclaration, null));
        return getter;
    }

    public static IASTSimpleDeclaration createSetterDeclaration(String name, IASTSimpleDeclaration fieldDeclaration) {
        CPPASTSimpleDeclaration setter = new CPPASTSimpleDeclaration();
        setter.setDeclSpecifier((IASTDeclSpecifier)FunctionFactory.getVoidDeclSpec());
        setter.addDeclarator((IASTDeclarator)FunctionFactory.getSetterDeclarator(name, fieldDeclaration, null));
        return setter;
    }
}

