/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RefsTab
extends AbstractCPropertyTab {
    private final Color GRAY_COLOR = new Color((Device)Display.getDefault(), 100, 100, 100);
    public Composite comp;
    private Tree tree;
    private static final String ACTIVE = "[" + UIMessages.getString("RefsTab.3") + "]";
    private static final int EXPAND_ALL_BUTTON = 0;
    private static final int COLLAPSE_ALL_BUTTON = 1;
    private static final int MOVEUP_BUTTON = 3;
    private static final int MOVEDOWN_BUTTON = 4;

    public void createControls(Composite parent) {
        super.createControls(parent);
        String[] stringArray = new String[5];
        stringArray[0] = UIMessages.getString("RefsTab.0");
        stringArray[1] = UIMessages.getString("RefsTab.2");
        stringArray[3] = MOVEUP_STR;
        stringArray[4] = MOVEDOWN_STR;
        this.initButtons(stringArray, 120);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.tree = new Tree(this.usercomp, 2084);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("RefsTab.4");
            }
        });
        this.initData();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((e.detail & 0x20) == 32 && e.item != null && e.item instanceof TreeItem) {
                    TreeItem sel = (TreeItem)e.item;
                    Object data = sel.getData();
                    if (data == null) {
                        sel.setChecked(false);
                        return;
                    }
                    boolean checked = sel.getChecked();
                    TreeItem parent = sel.getParentItem();
                    if (parent == null) {
                        if (checked) {
                            sel.setExpanded(true);
                        }
                        TreeItem[] treeItemArray = sel.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem child = treeItemArray[n2];
                            if (checked) {
                                if (child.getData() != null) {
                                    child.setChecked(true);
                                    break;
                                }
                            } else {
                                child.setChecked(false);
                            }
                            ++n2;
                        }
                    } else {
                        if (parent.getChecked()) {
                            TreeItem[] treeItemArray = parent.getItems();
                            int n = treeItemArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                TreeItem obj = treeItemArray[n3];
                                obj.setChecked(false);
                                ++n3;
                            }
                            sel.setChecked(checked);
                        }
                        parent.setChecked(checked);
                    }
                    RefsTab.this.saveChecked();
                }
                RefsTab.this.updateButtons();
            }
        });
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                RefsTab.this.updateExpandButtons(e, false, true);
            }

            public void treeExpanded(TreeEvent e) {
                RefsTab.this.updateExpandButtons(e, true, false);
            }
        });
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: 
            case 1: {
                TreeItem[] treeItemArray = this.tree.getItems();
                int n2 = treeItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem item = treeItemArray[n3];
                    item.setExpanded(n == 0);
                    ++n3;
                }
                this.updateButtons();
                break;
            }
            case 3: 
            case 4: {
                Map oldMapping = this.getResDesc().getConfiguration().getReferenceInfo();
                TreeItem ti = this.tree.getSelection()[0];
                String projectName = ti.getText();
                ArrayList projNames = new ArrayList(oldMapping.keySet());
                int index = projNames.indexOf(projectName);
                if (n == 3) {
                    if (index > 0) {
                        projNames.set(index, (String)projNames.get(index - 1));
                        projNames.set(index - 1, projectName);
                    }
                } else if (index < projNames.size() - 1) {
                    projNames.set(index, (String)projNames.get(index + 1));
                    projNames.set(index + 1, projectName);
                }
                LinkedHashMap<String, String> newMapping = new LinkedHashMap<String, String>(oldMapping.size());
                for (String name : projNames) {
                    newMapping.put(name, (String)oldMapping.get(name));
                }
                this.getResDesc().getConfiguration().setReferenceInfo(newMapping);
                this.initData();
            }
        }
    }

    protected void updateData(ICResourceDescription cfgd) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
        } else {
            if (!this.usercomp.isVisible()) {
                this.setAllVisible(true, null);
            }
            this.initData();
        }
    }

    private void saveChecked() {
        LinkedHashMap<String, String> refs = new LinkedHashMap<String, String>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem project = treeItemArray[n2];
            if (project.getChecked()) {
                if (project.getData() instanceof String) {
                    assert (project.getData() != null);
                    refs.put(project.getText(), (String)project.getData());
                } else {
                    TreeItem[] treeItemArray2 = project.getItems();
                    int n3 = treeItemArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem config = treeItemArray2[n4];
                        if (config.getChecked()) {
                            assert (config.getData() != null);
                            refs.put(project.getText(), (String)config.getData());
                            break;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        this.getResDesc().getConfiguration().setReferenceInfo(refs);
    }

    private void initData() {
        IProject ti;
        String currentSelection = this.tree.getSelectionCount() == 1 ? this.tree.getSelection()[0].getText() : null;
        HashSet<String> currentExpanded = new HashSet<String>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti2 = treeItemArray[n2];
            if (ti2.getExpanded()) {
                currentExpanded.add(ti2.getText());
            }
            ++n2;
        }
        this.tree.removeAll();
        IProject p = this.page.getProject();
        if (p == null) {
            return;
        }
        Map refs = this.getResDesc().getConfiguration().getReferenceInfo();
        LinkedHashSet projects = new LinkedHashSet(refs.keySet());
        IProject[] iProjectArray = p.getWorkspace().getRoot().getProjects();
        int n3 = iProjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IProject prj = iProjectArray[n4];
            projects.add(prj.getName());
            ++n4;
        }
        for (String pname : projects) {
            TreeItem ti1;
            TreeItem ti3;
            ICConfigurationDescription[] cfgs;
            IProject prj;
            String ref = (String)refs.get(pname);
            try {
                prj = p.getWorkspace().getRoot().getProject(pname);
                cfgs = this.page.getCfgsReadOnly(prj);
            }
            catch (Exception e) {
                CUIPlugin.log(String.valueOf(UIMessages.getString("RefsTab_ConfigurationsAccessError")) + pname, e);
                continue;
            }
            if (cfgs == null || cfgs.length == 0) {
                if (ref == null) continue;
                ti3 = new TreeItem(this.tree, 0);
                ti3.setChecked(true);
                ti3.setText(pname);
                ti3.setData(refs.get(pname));
                ti3.setForeground(this.GRAY_COLOR);
                continue;
            }
            if (this.page.getProject().equals((Object)prj) && cfgs.length < 2) continue;
            ti3 = new TreeItem(this.tree, 0);
            ti3.setText(pname);
            ti3.setData((Object)prj);
            if (ref != null) {
                ti3.setChecked(true);
            }
            if (!prj.equals((Object)p)) {
                ti1 = new TreeItem(ti3, 0);
                ti1.setText(ACTIVE);
                ti1.setData((Object)"");
                if ("".equals(ref)) {
                    ti1.setChecked(true);
                    ti1.setData((Object)ref);
                }
            }
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
            int n5 = cfgs.length;
            int n6 = 0;
            while (n6 < n5) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n6];
                ti1 = new TreeItem(ti3, 0);
                ti1.setText(cfg.getName());
                if (prj.equals((Object)p) && cfg.getId().equals(this.page.getResDesc().getConfiguration().getId())) {
                    ti1.setForeground(this.GRAY_COLOR);
                } else {
                    if (cfg.getId().equals(ref)) {
                        ti1.setChecked(true);
                    }
                    ti1.setData((Object)cfg.getId());
                }
                ++n6;
            }
        }
        if (currentSelection != null) {
            iProjectArray = this.tree.getItems();
            n3 = iProjectArray.length;
            int n7 = 0;
            while (n7 < n3) {
                ti = iProjectArray[n7];
                if (ti.getText().equals(currentSelection)) {
                    this.tree.setSelection((TreeItem)ti);
                    break;
                }
                ++n7;
            }
        }
        iProjectArray = this.tree.getItems();
        n3 = iProjectArray.length;
        int n8 = 0;
        while (n8 < n3) {
            ti = iProjectArray[n8];
            if (currentExpanded.contains(ti.getText())) {
                ti.setExpanded(true);
            }
            ++n8;
        }
        this.updateButtons();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        dst.getConfiguration().setReferenceInfo(src.getConfiguration().getReferenceInfo());
    }

    public boolean canBeVisible() {
        return this.page.isForProject();
    }

    protected void performDefaults() {
        if (!this.usercomp.isVisible()) {
            return;
        }
        this.getResDesc().getConfiguration().setReferenceInfo(new HashMap());
        this.initData();
    }

    protected void updateButtons() {
        this.updateExpandButtons(null, false, false);
        this.updateMoveButtons();
    }

    public void dispose() {
        super.dispose();
        this.GRAY_COLOR.dispose();
    }

    private void updateExpandButtons(TreeEvent e, boolean stateE, boolean stateC) {
        boolean cntE = stateE;
        boolean cntC = stateC;
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (e == null || !e.widget.equals(item)) {
                if (item.getExpanded()) {
                    cntE = true;
                } else {
                    cntC = true;
                }
            }
            ++n2;
        }
        this.buttonSetEnabled(0, cntC);
        this.buttonSetEnabled(1, cntE);
    }

    private void updateMoveButtons() {
        TreeItem ti;
        if (this.tree.getSelectionCount() == 1 && (ti = this.tree.getSelection()[0]).getParentItem() == null && ti.getChecked()) {
            int index = this.tree.indexOf(ti);
            this.buttonSetEnabled(3, index > 0);
            this.buttonSetEnabled(4, index < this.tree.getItemCount() - 1);
            return;
        }
        this.buttonSetEnabled(3, false);
        this.buttonSetEnabled(4, false);
    }
}

