/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.ServiceManager;
import org.eclipse.tm.internal.tcf.core.Token;
import org.eclipse.tm.internal.tcf.core.TransportManager;
import org.eclipse.tm.internal.tcf.services.local.LocatorService;
import org.eclipse.tm.internal.tcf.services.remote.GenericProxy;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.core.ErrorReport;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChannel
implements IChannel {
    private static IChannel.IChannelListener[] listeners_array = new IChannel.IChannelListener[4];
    private final LinkedList<String> redirect_queue = new LinkedList();
    private final Map<Class<?>, IService> local_service_by_class = new HashMap();
    private final Map<Class<?>, IService> remote_service_by_class = new HashMap();
    private final Map<String, IService> local_service_by_name = new HashMap<String, IService>();
    private final Map<String, IService> remote_service_by_name = new HashMap<String, IService>();
    private final LinkedList<Message> out_queue = new LinkedList();
    private final Collection<IChannel.IChannelListener> channel_listeners = new ArrayList<IChannel.IChannelListener>();
    private final Map<String, IChannel.IEventListener[]> event_listeners = new HashMap<String, IChannel.IEventListener[]>();
    private final Map<String, IChannel.ICommandServer> command_servers = new HashMap<String, IChannel.ICommandServer>();
    private final Map<String, Message> out_tokens = new HashMap<String, Message>();
    private final Thread inp_thread;
    private final Thread out_thread;
    private boolean notifying_channel_opened;
    private boolean registered_with_trasport;
    private boolean shutdown;
    private int state = 0;
    private IToken redirect_command;
    private final IPeer local_peer;
    private IPeer remote_peer;
    private Proxy proxy;
    private boolean zero_copy;
    private static final int pending_command_limit = 32;
    private int local_congestion_level = -100;
    private int remote_congestion_level = -100;
    private long local_congestion_time;
    private int local_congestion_cnt;
    private Collection<TraceListener> trace_listeners;
    public static final int EOS = -1;
    public static final int EOM = -2;

    protected AbstractChannel(IPeer remote_peer) {
        this(LocatorService.getLocalPeer(), remote_peer);
    }

    protected AbstractChannel(IPeer local_peer, IPeer remote_peer) {
        assert (Protocol.isDispatchThread());
        this.remote_peer = remote_peer;
        this.local_peer = local_peer;
        this.inp_thread = new Thread(){
            final byte[] empty_byte_array = new byte[0];
            byte[] buf = new byte[1024];
            byte[] eos;

            private void error() throws IOException {
                throw new IOException("Protocol syntax error");
            }

            private byte[] readBytes(int end) throws IOException {
                int len = 0;
                while (true) {
                    int n;
                    if ((n = AbstractChannel.this.read()) <= 0) {
                        if (n == end) break;
                        if (n == -2) {
                            throw new IOException("Unexpected end of message");
                        }
                        if (n < 0) {
                            throw new IOException("Communication channel is closed by remote peer");
                        }
                    }
                    if (len >= this.buf.length) {
                        byte[] tmp = new byte[this.buf.length * 2];
                        System.arraycopy(this.buf, 0, tmp, 0, len);
                        this.buf = tmp;
                    }
                    this.buf[len++] = (byte)n;
                }
                if (len == 0) {
                    return this.empty_byte_array;
                }
                byte[] res = new byte[len];
                System.arraycopy(this.buf, 0, res, 0, len);
                return res;
            }

            private String readString() throws IOException {
                int len = 0;
                while (true) {
                    int n;
                    if ((n = AbstractChannel.this.read()) <= 0) {
                        if (n == 0) break;
                        if (n == -2) {
                            throw new IOException("Unexpected end of message");
                        }
                        if (n < 0) {
                            throw new IOException("Communication channel is closed by remote peer");
                        }
                    }
                    if (len >= this.buf.length) {
                        byte[] tmp = new byte[this.buf.length * 2];
                        System.arraycopy(this.buf, 0, tmp, 0, len);
                        this.buf = tmp;
                    }
                    this.buf[len++] = (byte)n;
                }
                return new String(this.buf, 0, len, "UTF8");
            }

            public void run() {
                try {
                    while (true) {
                        int n;
                        if ((n = AbstractChannel.this.read()) == -2) continue;
                        if (n == -1) break;
                        final Message msg = new Message((char)n);
                        if (AbstractChannel.this.read() != 0) {
                            this.error();
                        }
                        switch (msg.type) {
                            case 'C': {
                                msg.token = new Token(this.readBytes(0));
                                msg.service = this.readString();
                                msg.name = this.readString();
                                msg.data = this.readBytes(-2);
                                break;
                            }
                            case 'N': 
                            case 'P': 
                            case 'R': {
                                msg.token = new Token(this.readBytes(0));
                                msg.data = this.readBytes(-2);
                                break;
                            }
                            case 'E': {
                                msg.service = this.readString();
                                msg.name = this.readString();
                                msg.data = this.readBytes(-2);
                                break;
                            }
                            case 'F': {
                                msg.data = this.readBytes(-2);
                                break;
                            }
                            default: {
                                this.error();
                            }
                        }
                        Protocol.invokeLater(new Runnable(){

                            public void run() {
                                AbstractChannel.this.handleInput(msg);
                            }
                        });
                        int delay = AbstractChannel.this.local_congestion_level;
                        if (delay <= 0) continue;
                        1.sleep(delay);
                    }
                    this.eos = this.readBytes(-2);
                    Protocol.invokeLater(new Runnable(){

                        public void run() {
                            if (AbstractChannel.this.out_tokens.isEmpty()) {
                                AbstractChannel.this.close();
                            } else {
                                IOException x = new IOException("Connection reset by peer");
                                try {
                                    Object[] args = JSON.parseSequence(eos);
                                    if (args.length > 0 && args[0] != null) {
                                        x = new IOException(Command.toErrorString(args[0]));
                                    }
                                }
                                catch (IOException e) {
                                    x = e;
                                }
                                AbstractChannel.this.terminate(x);
                            }
                        }
                    });
                }
                catch (Throwable x) {
                    try {
                        Protocol.invokeLater(new Runnable(){

                            public void run() {
                                AbstractChannel.this.terminate(x);
                            }
                        });
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        };
        this.out_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (true) {
                        Message msg = null;
                        boolean last = false;
                        LinkedList linkedList = AbstractChannel.this.out_queue;
                        synchronized (linkedList) {
                            while (AbstractChannel.this.out_queue.isEmpty()) {
                                AbstractChannel.this.out_queue.wait();
                            }
                            msg = (Message)AbstractChannel.this.out_queue.removeFirst();
                            if (msg == null) {
                                break;
                            }
                            last = AbstractChannel.this.out_queue.isEmpty();
                            if (msg.is_canceled) {
                                if (last) {
                                    AbstractChannel.this.flush();
                                }
                                continue;
                            }
                            msg.is_sent = true;
                        }
                        if (msg.trace != null) {
                            final Message m = msg;
                            Protocol.invokeLater(new Runnable(){

                                public void run() {
                                    for (TraceListener l : m.trace) {
                                        try {
                                            l.onMessageSent(m.type, m.token == null ? null : m.token.getID(), m.service, m.name, m.data);
                                        }
                                        catch (Throwable x) {
                                            Protocol.log("Exception in channel listener", x);
                                        }
                                    }
                                }
                            });
                        }
                        AbstractChannel.this.write(msg.type);
                        AbstractChannel.this.write(0);
                        if (msg.token != null) {
                            AbstractChannel.this.write(msg.token.getBytes());
                            AbstractChannel.this.write(0);
                        }
                        if (msg.service != null) {
                            AbstractChannel.this.write(msg.service.getBytes("UTF8"));
                            AbstractChannel.this.write(0);
                        }
                        if (msg.name != null) {
                            AbstractChannel.this.write(msg.name.getBytes("UTF8"));
                            AbstractChannel.this.write(0);
                        }
                        if (msg.data != null) {
                            AbstractChannel.this.write(msg.data);
                        }
                        AbstractChannel.this.write(-2);
                        int delay = 0;
                        int level = AbstractChannel.this.remote_congestion_level;
                        if (level > 0) {
                            delay = level * 10;
                        }
                        if (last || delay > 0) {
                            AbstractChannel.this.flush();
                        }
                        if (delay > 0) {
                            2.sleep(delay);
                            continue;
                        }
                        2.yield();
                    }
                    AbstractChannel.this.write(-1);
                    AbstractChannel.this.write(-2);
                    AbstractChannel.this.flush();
                }
                catch (Throwable x) {
                    try {
                        Protocol.invokeLater(new Runnable(){

                            public void run() {
                                AbstractChannel.this.terminate(x);
                            }
                        });
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        };
        this.inp_thread.setName("TCF Channel Receiver");
        this.out_thread.setName("TCF Channel Transmitter");
    }

    protected void start() {
        assert (Protocol.isDispatchThread());
        Protocol.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (AbstractChannel.this.proxy != null) {
                        return;
                    }
                    if (AbstractChannel.this.state == 2) {
                        return;
                    }
                    ServiceManager.onChannelCreated(AbstractChannel.this, AbstractChannel.this.local_service_by_name);
                    AbstractChannel.this.makeServiceByClassMap(AbstractChannel.this.local_service_by_name, AbstractChannel.this.local_service_by_class);
                    Object[] args = new Object[]{AbstractChannel.this.local_service_by_name.keySet()};
                    AbstractChannel.this.sendEvent(Protocol.getLocator(), "Hello", JSON.toJSONSequence(args));
                }
                catch (IOException x) {
                    AbstractChannel.this.terminate(x);
                }
            }
        });
        this.inp_thread.start();
        this.out_thread.start();
    }

    @Override
    public void redirect(final String peer_id) {
        assert (Protocol.isDispatchThread());
        if (this.state == 0) {
            this.redirect_queue.add(peer_id);
        } else {
            assert (this.state == 1);
            assert (this.redirect_command == null);
            try {
                final ILocator l = (ILocator)this.remote_service_by_class.get(ILocator.class);
                if (l == null) {
                    throw new IOException("Cannot redirect channel: peer " + this.remote_peer.getID() + " has no locator service");
                }
                final IPeer peer = l.getPeers().get(peer_id);
                if (peer == null) {
                    final boolean[] found = new boolean[1];
                    Protocol.invokeLater(20000L, new Runnable(){

                        public void run() {
                            if (found[0]) {
                                return;
                            }
                            AbstractChannel.this.terminate(new Exception("Peer " + peer_id + " not found"));
                        }
                    });
                    l.addListener(new ILocator.LocatorListener(){

                        public void peerAdded(IPeer peer) {
                            if (peer.getID().equals(peer_id)) {
                                found[0] = true;
                                AbstractChannel.this.state = 1;
                                l.removeListener(this);
                                AbstractChannel.this.redirect(peer_id);
                            }
                        }

                        public void peerChanged(IPeer peer) {
                        }

                        public void peerHeartBeat(String id) {
                        }

                        public void peerRemoved(String id) {
                        }
                    });
                } else {
                    this.redirect_command = l.redirect(peer_id, new ILocator.DoneRedirect(){

                        public void doneRedirect(IToken token, Exception x) {
                            if (!$assertionsDisabled && AbstractChannel.this.redirect_command != token) {
                                throw new AssertionError();
                            }
                            AbstractChannel.this.redirect_command = null;
                            if (AbstractChannel.this.state != 0) {
                                return;
                            }
                            if (x != null) {
                                AbstractChannel.this.terminate(x);
                            }
                            AbstractChannel.this.remote_peer = peer;
                            AbstractChannel.this.remote_service_by_class.clear();
                            AbstractChannel.this.remote_service_by_name.clear();
                            AbstractChannel.this.event_listeners.clear();
                        }
                    });
                }
                this.state = 0;
            }
            catch (Throwable x) {
                this.terminate(x);
            }
        }
    }

    private void makeServiceByClassMap(Map<String, IService> by_name, Map<Class<?>, IService> by_class) {
        for (IService service : by_name.values()) {
            Class<?>[] classArray = service.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> fs = classArray[n2];
                if (!fs.equals(IService.class) && IService.class.isAssignableFrom(fs)) {
                    by_class.put(fs, service);
                }
                ++n2;
            }
        }
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public void addChannelListener(IChannel.IChannelListener listener) {
        assert (Protocol.isDispatchThread());
        assert (listener != null);
        this.channel_listeners.add(listener);
    }

    @Override
    public void removeChannelListener(IChannel.IChannelListener listener) {
        assert (Protocol.isDispatchThread());
        this.channel_listeners.remove(listener);
    }

    public void addTraceListener(TraceListener listener) {
        this.trace_listeners = this.trace_listeners == null ? new ArrayList<TraceListener>() : new ArrayList<TraceListener>(this.trace_listeners);
        this.trace_listeners.add(listener);
    }

    public void removeTraceListener(TraceListener listener) {
        this.trace_listeners = new ArrayList<TraceListener>(this.trace_listeners);
        this.trace_listeners.remove(listener);
        if (this.trace_listeners.isEmpty()) {
            this.trace_listeners = null;
        }
    }

    @Override
    public void addEventListener(IService service, IChannel.IEventListener listener) {
        assert (Protocol.isDispatchThread());
        IChannel.IEventListener[] list = this.event_listeners.get(service.getName());
        IChannel.IEventListener[] next = new IChannel.IEventListener[list == null ? 1 : list.length + 1];
        if (list != null) {
            System.arraycopy(list, 0, next, 0, list.length);
        }
        next[next.length - 1] = listener;
        this.event_listeners.put(service.getName(), next);
    }

    @Override
    public void removeEventListener(IService service, IChannel.IEventListener listener) {
        assert (Protocol.isDispatchThread());
        IChannel.IEventListener[] list = this.event_listeners.get(service.getName());
        int i = 0;
        while (i < list.length) {
            if (list[i] == listener) {
                if (list.length == 1) {
                    this.event_listeners.remove(service.getName());
                } else {
                    IChannel.IEventListener[] next = new IChannel.IEventListener[list.length - 1];
                    System.arraycopy(list, 0, next, 0, i);
                    System.arraycopy(list, i + 1, next, i, next.length - i);
                    this.event_listeners.put(service.getName(), next);
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void addCommandServer(IService service, IChannel.ICommandServer listener) {
        assert (Protocol.isDispatchThread());
        if (this.command_servers.put(service.getName(), listener) != null) {
            throw new Error("Only one command server per service is allowed");
        }
    }

    @Override
    public void removeCommandServer(IService service, IChannel.ICommandServer listener) {
        assert (Protocol.isDispatchThread());
        if (this.command_servers.remove(service.getName()) != listener) {
            throw new Error("Invalid command server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEndOfStream() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            this.out_queue.clear();
            this.out_queue.add(0, null);
            this.out_queue.notify();
        }
    }

    @Override
    public void close() {
        assert (Protocol.isDispatchThread());
        try {
            this.sendEndOfStream();
            this.out_thread.join(10000L);
            this.stop();
            this.inp_thread.join(10000L);
            this.terminate(null);
        }
        catch (Exception x) {
            this.terminate(x);
        }
    }

    @Override
    public void terminate(final Throwable error) {
        assert (Protocol.isDispatchThread());
        this.sendEndOfStream();
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        if (error != null && this.remote_peer instanceof AbstractPeer) {
            ((AbstractPeer)this.remote_peer).onChannelTerminated();
        }
        if (this.registered_with_trasport) {
            this.registered_with_trasport = false;
            TransportManager.channelClosed(this, error);
        }
        if (this.proxy != null) {
            try {
                this.proxy.onChannelClosed(error);
            }
            catch (Throwable x) {
                Protocol.log("Exception in channel listener", x);
            }
        }
        Protocol.invokeLater(new Runnable(){

            public void run() {
                if (!AbstractChannel.this.out_tokens.isEmpty()) {
                    Exception x = null;
                    x = error instanceof Exception ? (Exception)error : (error != null ? new Exception(error) : new IOException("Channel is closed"));
                    for (Message msg : AbstractChannel.this.out_tokens.values()) {
                        try {
                            String s = msg.toString();
                            if (s.length() > 72) {
                                s = String.valueOf(s.substring(0, 72)) + "...]";
                            }
                            IOException y = new IOException("Command " + s + " aborted");
                            y.initCause(x);
                            msg.token.getListener().terminated(msg.token, y);
                        }
                        catch (Throwable e) {
                            Protocol.log("Exception in command listener", e);
                        }
                    }
                    AbstractChannel.this.out_tokens.clear();
                }
                if (AbstractChannel.this.channel_listeners.isEmpty()) {
                    Protocol.log("TCF channel terminated", error);
                } else {
                    listeners_array = AbstractChannel.this.channel_listeners.toArray(listeners_array);
                    IChannel.IChannelListener[] iChannelListenerArray = listeners_array;
                    int n = iChannelListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object l = iChannelListenerArray[n2];
                        if (l == null) break;
                        try {
                            l.onChannelClosed(error);
                        }
                        catch (Throwable x) {
                            Protocol.log("Exception in channel listener", x);
                        }
                        ++n2;
                    }
                }
                if (AbstractChannel.this.trace_listeners != null) {
                    for (Object l : AbstractChannel.this.trace_listeners) {
                        try {
                            l.onChannelClosed(error);
                        }
                        catch (Throwable x) {
                            Protocol.log("Exception in channel listener", x);
                        }
                    }
                }
            }
        });
    }

    @Override
    public int getCongestion() {
        assert (Protocol.isDispatchThread());
        int level = this.out_tokens.size() * 100 / 32 - 100;
        if (this.remote_congestion_level > level) {
            level = this.remote_congestion_level;
        }
        if (level > 100) {
            level = 100;
        }
        return level;
    }

    @Override
    public IPeer getLocalPeer() {
        assert (Protocol.isDispatchThread());
        return this.local_peer;
    }

    @Override
    public IPeer getRemotePeer() {
        assert (Protocol.isDispatchThread());
        return this.remote_peer;
    }

    @Override
    public Collection<String> getLocalServices() {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return this.local_service_by_name.keySet();
    }

    @Override
    public Collection<String> getRemoteServices() {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return this.remote_service_by_name.keySet();
    }

    @Override
    public <V extends IService> V getLocalService(Class<V> cls) {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return (V)this.local_service_by_class.get(cls);
    }

    @Override
    public <V extends IService> V getRemoteService(Class<V> cls) {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return (V)this.remote_service_by_class.get(cls);
    }

    @Override
    public <V extends IService> void setServiceProxy(Class<V> service_interface, IService service_proxy) {
        if (!this.notifying_channel_opened) {
            new Error("setServiceProxe() can be called only from channel open call-back");
        }
        if (!(this.remote_service_by_name.get(service_proxy.getName()) instanceof GenericProxy)) {
            throw new Error("Proxy already set");
        }
        if (this.remote_service_by_class.get(service_interface) != null) {
            throw new Error("Proxy already set");
        }
        this.remote_service_by_class.put(service_interface, service_proxy);
        this.remote_service_by_name.put(service_proxy.getName(), service_proxy);
    }

    @Override
    public IService getLocalService(String service_name) {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return this.local_service_by_name.get(service_name);
    }

    @Override
    public IService getRemoteService(String service_name) {
        assert (Protocol.isDispatchThread());
        assert (this.state != 0);
        return this.remote_service_by_name.get(service_name);
    }

    public void setProxy(Proxy proxy, Collection<String> services) throws IOException {
        this.proxy = proxy;
        this.sendEvent(Protocol.getLocator(), "Hello", JSON.toJSONSequence(new Object[]{services}));
        this.local_service_by_class.clear();
        this.local_service_by_name.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToOutQueue(Message msg) {
        msg.trace = this.trace_listeners;
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            this.out_queue.add(msg);
            this.out_queue.notify();
        }
    }

    @Override
    public IToken sendCommand(IService service, String name, byte[] args, IChannel.ICommandListener listener) {
        Token token;
        assert (Protocol.isDispatchThread());
        if (this.state == 0) {
            throw new Error("Channel is waiting for Hello message");
        }
        if (this.state == 2) {
            throw new Error("Channel is closed");
        }
        final Message msg = new Message('C');
        msg.service = service.getName();
        msg.name = name;
        msg.data = args;
        msg.token = token = new Token(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                    throw new AssertionError();
                }
                if (AbstractChannel.this.state != 1) {
                    return false;
                }
                LinkedList linkedList = AbstractChannel.this.out_queue;
                synchronized (linkedList) {
                    block6: {
                        if (!msg.is_sent) break block6;
                        return false;
                    }
                    msg.is_canceled = true;
                }
                AbstractChannel.this.out_tokens.remove(msg.token.getID());
                return true;
            }
        };
        this.out_tokens.put(token.getID(), msg);
        this.addToOutQueue(msg);
        return token;
    }

    public void sendProgress(IToken token, byte[] results) {
        assert (Protocol.isDispatchThread());
        if (this.state != 1) {
            throw new Error("Channel is closed");
        }
        Message msg = new Message('P');
        msg.data = results;
        msg.token = (Token)token;
        this.addToOutQueue(msg);
    }

    @Override
    public void sendResult(IToken token, byte[] results) {
        assert (Protocol.isDispatchThread());
        if (this.state != 1) {
            throw new Error("Channel is closed");
        }
        Message msg = new Message('R');
        msg.data = results;
        msg.token = (Token)token;
        this.addToOutQueue(msg);
    }

    @Override
    public void rejectCommand(IToken token) {
        assert (Protocol.isDispatchThread());
        if (this.state != 1) {
            throw new Error("Channel is closed");
        }
        Message msg = new Message('N');
        msg.token = (Token)token;
        this.addToOutQueue(msg);
    }

    public void sendEvent(IService service, String name, byte[] args) {
        assert (Protocol.isDispatchThread());
        if (!(this.state == 1 || this.state == 0 && service instanceof ILocator)) {
            throw new Error("Channel is closed");
        }
        Message msg = new Message('E');
        msg.service = service.getName();
        msg.name = name;
        msg.data = args;
        this.addToOutQueue(msg);
    }

    public boolean isZeroCopySupported() {
        return this.zero_copy;
    }

    private void handleInput(Message msg) {
        assert (Protocol.isDispatchThread());
        if (this.state == 2) {
            return;
        }
        if (this.trace_listeners != null) {
            for (TraceListener l : this.trace_listeners) {
                try {
                    l.onMessageReceived(msg.type, msg.token != null ? msg.token.getID() : null, msg.service, msg.name, msg.data);
                }
                catch (Throwable x) {
                    Protocol.log("Exception in trace listener", x);
                }
            }
        }
        try {
            Token token = null;
            switch (msg.type) {
                case 'N': 
                case 'P': 
                case 'R': {
                    Message cmd;
                    String token_id = msg.token.getID();
                    Message message = cmd = msg.type == 'P' ? this.out_tokens.get(token_id) : this.out_tokens.remove(token_id);
                    if (cmd == null) {
                        throw new Exception("Invalid token received: " + token_id);
                    }
                    token = cmd.token;
                }
            }
            switch (msg.type) {
                case 'C': {
                    if (this.state == 0) {
                        throw new IOException("Received command " + msg.service + "." + msg.name + " before Hello message");
                    }
                    if (this.proxy != null) {
                        this.proxy.onCommand(msg.token, msg.service, msg.name, msg.data);
                    } else {
                        token = msg.token;
                        IChannel.ICommandServer cmds = this.command_servers.get(msg.service);
                        if (cmds != null) {
                            cmds.command(token, msg.name, msg.data);
                        } else {
                            this.rejectCommand(token);
                        }
                    }
                    break;
                }
                case 'P': {
                    token.getListener().progress(token, msg.data);
                    this.sendCongestionLevel();
                    break;
                }
                case 'R': {
                    token.getListener().result(token, msg.data);
                    this.sendCongestionLevel();
                    break;
                }
                case 'N': {
                    token.getListener().terminated(token, new ErrorReport("Command is not recognized", 25));
                    break;
                }
                case 'E': {
                    boolean hello;
                    boolean bl = hello = msg.service.equals("Locator") && msg.name.equals("Hello");
                    if (hello) {
                        this.remote_service_by_name.clear();
                        this.remote_service_by_class.clear();
                        ServiceManager.onChannelOpened(this, (Collection)JSON.parseSequence(msg.data)[0], this.remote_service_by_name);
                        this.makeServiceByClassMap(this.remote_service_by_name, this.remote_service_by_class);
                        this.zero_copy = this.remote_service_by_name.containsKey("ZeroCopy");
                    }
                    if (this.proxy != null && this.state == 1) {
                        this.proxy.onEvent(msg.service, msg.name, msg.data);
                        break;
                    }
                    if (hello) {
                        assert (this.state == 0);
                        this.state = 1;
                        assert (this.redirect_command == null);
                        if (this.redirect_queue.size() > 0) {
                            this.redirect(this.redirect_queue.removeFirst());
                            break;
                        }
                        this.notifying_channel_opened = true;
                        if (!this.registered_with_trasport) {
                            TransportManager.channelOpened(this);
                            this.registered_with_trasport = true;
                        }
                        IChannel.IChannelListener[] iChannelListenerArray = listeners_array = this.channel_listeners.toArray(listeners_array);
                        int n = listeners_array.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IChannel.IChannelListener l = iChannelListenerArray[n2];
                            if (l == null) break;
                            try {
                                l.onChannelOpened();
                            }
                            catch (Throwable x) {
                                Protocol.log("Exception in channel listener", x);
                            }
                            ++n2;
                        }
                        this.notifying_channel_opened = false;
                        break;
                    }
                    IChannel.IEventListener[] list = this.event_listeners.get(msg.service);
                    if (list != null) {
                        int i = 0;
                        while (i < list.length) {
                            list[i].event(msg.name, msg.data);
                            ++i;
                        }
                    }
                    this.sendCongestionLevel();
                    break;
                }
                case 'F': {
                    int len = msg.data.length;
                    if (len > 0 && msg.data[len - 1] == 0) {
                        --len;
                    }
                    this.remote_congestion_level = Integer.parseInt(new String(msg.data, 0, len, "ASCII"));
                    break;
                }
                default: {
                    assert (false);
                }
            }
        }
        catch (Throwable x) {
            this.terminate(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCongestionLevel() throws IOException {
        if (++this.local_congestion_cnt < 8) {
            return;
        }
        this.local_congestion_cnt = 0;
        if (this.state != 1) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.local_congestion_time < 500L) {
            return;
        }
        assert (Protocol.isDispatchThread());
        int level = Protocol.getCongestionLevel();
        if (level == this.local_congestion_level) {
            return;
        }
        int i = (level - this.local_congestion_level) / 8;
        if (i != 0) {
            level = this.local_congestion_level + i;
        }
        this.local_congestion_time = time;
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            Message msg;
            Message message = msg = this.out_queue.isEmpty() ? null : this.out_queue.get(0);
            if (msg == null || msg.type != 'F') {
                msg = new Message('F');
                this.out_queue.add(0, msg);
                this.out_queue.notify();
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.local_congestion_level);
            buffer.append('\u0000');
            msg.data = buffer.toString().getBytes("ASCII");
            msg.trace = this.trace_listeners;
            this.local_congestion_level = level;
        }
    }

    protected abstract int read() throws IOException;

    protected abstract void write(int var1) throws IOException;

    protected abstract void flush() throws IOException;

    protected abstract void stop() throws IOException;

    protected void write(byte[] buf) throws IOException {
        assert (Thread.currentThread() == this.out_thread);
        int i = 0;
        while (i < buf.length) {
            this.write(buf[i] & 0xFF);
            ++i;
        }
    }

    private static class Message {
        final char type;
        Token token;
        String service;
        String name;
        byte[] data;
        boolean is_sent;
        boolean is_canceled;
        Collection<TraceListener> trace;

        Message(char type) {
            this.type = type;
        }

        public String toString() {
            try {
                StringBuffer bf = new StringBuffer();
                bf.append('[');
                bf.append(this.type);
                if (this.token != null) {
                    bf.append(' ');
                    bf.append(this.token.getID());
                }
                if (this.service != null) {
                    bf.append(' ');
                    bf.append(this.service);
                }
                if (this.name != null) {
                    bf.append(' ');
                    bf.append(this.name);
                }
                if (this.data != null) {
                    int i = 0;
                    while (i < this.data.length) {
                        int j = i;
                        while (j < this.data.length && this.data[j] != 0) {
                            ++j;
                        }
                        bf.append(' ');
                        bf.append(new String(this.data, i, j - i, "UTF8"));
                        if (j >= this.data.length || this.data[j] == 0) {
                            // empty if block
                        }
                        i = ++j;
                    }
                }
                bf.append(']');
                return bf.toString();
            }
            catch (Exception x) {
                return x.toString();
            }
        }
    }

    public static interface Proxy {
        public void onCommand(IToken var1, String var2, String var3, byte[] var4);

        public void onEvent(String var1, String var2, byte[] var3);

        public void onChannelClosed(Throwable var1);
    }

    public static interface TraceListener {
        public void onMessageReceived(char var1, String var2, String var3, String var4, byte[] var5);

        public void onMessageSent(char var1, String var2, String var3, String var4, byte[] var5);

        public void onChannelClosed(Throwable var1);
    }
}

