/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFAnnotationManager;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelManager;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tm.tcf.debug.ui";
    private static final Object lock = new Object();
    private static Activator plugin;
    private static TCFModelManager model_manager;
    private static TCFAnnotationManager annotation_manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        Object object = lock;
        synchronized (object) {
            super.start(context);
            plugin = this;
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    if (model_manager == null) {
                        model_manager = new TCFModelManager();
                    }
                    if (annotation_manager == null) {
                        annotation_manager = new TCFAnnotationManager();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = lock;
        synchronized (object) {
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    if (model_manager != null) {
                        model_manager.dispose();
                        model_manager = null;
                    }
                    if (annotation_manager != null) {
                        annotation_manager.dispose();
                        annotation_manager = null;
                    }
                }
            });
            plugin = null;
            super.stop(context);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static TCFModelManager getModelManager() {
        return model_manager;
    }

    public static TCFAnnotationManager getAnnotationManager() {
        return annotation_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String msg, Throwable err) {
        Object object = lock;
        synchronized (object) {
            if (plugin == null || plugin.getLog() == null) {
                err.printStackTrace();
            } else {
                plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, msg, err));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Throwable err) {
        Object object = lock;
        synchronized (object) {
            if (plugin == null || plugin.getLog() == null) {
                err.printStackTrace();
            } else {
                plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, "Unhandled exception in TCF UI", err));
            }
        }
    }
}

