/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch.setup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.IRemoteShell;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.SSHClient;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.SetupWizardDialog;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.TelnetClient;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.WizardLoginPage;
import org.eclipse.tm.tcf.core.Base64;
import org.eclipse.tm.tcf.ssl.TCFSecurityManager;
import org.osgi.framework.Bundle;

class WizardLogPage
extends WizardPage
implements Runnable {
    private final SetupWizardDialog wizard;
    private Thread thread;
    private String protocol;
    private String host;
    private String user;
    private String user_password;
    private String root_password;
    private Text log_text;
    private Display display;
    private Shell parent;
    private IRemoteShell shell;

    WizardLogPage(SetupWizardDialog wizard) {
        super("LogPage");
        this.wizard = wizard;
        this.setTitle("Remote host login");
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.parent = parent.getShell();
        ((WizardDialog)this.getContainer()).addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getCurrentPage() instanceof WizardLoginPage && event.getTargetPage() == WizardLogPage.this) {
                    WizardLogPage.this.runSetupJob((WizardLoginPage)((Object)event.getCurrentPage()));
                }
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        new Label(composite, 64).setText("Agent installation log:");
        this.log_text = new Text(composite, 2826);
        GridData gd = new GridData(1808);
        this.log_text.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    private void runSetupJob(WizardLoginPage login) {
        assert (this.display != null);
        assert (this.display.getThread() == Thread.currentThread());
        if (this.thread != null) {
            return;
        }
        this.setErrorMessage(null);
        this.protocol = login.protocol.getText();
        this.host = login.host.getText();
        this.user = login.user.getText();
        this.user_password = login.user_password.getText();
        this.root_password = login.root_password.getText();
        this.log_text.setText("Connect to " + this.host + "\n");
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        Throwable error;
        block31: {
            error = null;
            try {
                int len;
                String s;
                if ("Telnet".equals(this.protocol)) {
                    this.shell = new TelnetClient(InetAddress.getByName(this.host), 23, this.user, this.user_password);
                } else if ("SSH".equals(this.protocol)) {
                    this.shell = new SSHClient(this.parent, this.host, this.user, this.user_password);
                } else {
                    throw new Exception("Invalid protocol name: " + this.protocol);
                }
                if (!this.user.equals("root")) {
                    this.send("su", true);
                    this.expect("Password: ", true);
                    this.send(this.root_password, false);
                    s = this.waitPrompt();
                    if (s.length() > 0) {
                        throw new Exception(s);
                    }
                }
                this.exec("cd /tmp");
                this.send("uname -o", true);
                String os = this.waitPrompt().replace('\n', ' ').trim();
                this.send("uname -m", true);
                String machine = this.waitPrompt().replace('\n', ' ').trim();
                String version = "0.3.0";
                Bundle bundle = Platform.getBundle((String)"org.eclipse.tm.tcf.debug.ui");
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("agent/get-os-tag"), null);
                if (url == null) {
                    throw new Exception("Cannot find get-os-tag script");
                }
                this.send("cat >get-os-tag", true);
                InputStream inp = url.openStream();
                byte[] buf = new byte[256];
                while ((len = inp.read(buf)) >= 0) {
                    this.shell.write(new String(buf, 0, len, "ASCII"));
                    int i = 0;
                    while (i < len) {
                        if (buf[i] == 10) {
                            this.shell.expect("\n");
                        }
                        ++i;
                    }
                }
                inp.close();
                this.shell.write("\u0004");
                s = this.waitPrompt();
                if (s.length() > 0) {
                    throw new Exception(s);
                }
                this.exec("chmod u+x get-os-tag");
                this.send("./get-os-tag", true);
                String os_tag = this.waitPrompt().replace('\n', ' ').trim();
                this.exec("rm -f get-os-tag");
                url = null;
                String fnm = null;
                String machine0 = machine;
                while (true) {
                    int n;
                    int release = 16;
                    while (url == null && release > 0) {
                        fnm = "tcf-agent-" + version + "-" + release + "." + os_tag + "." + machine + ".rpm";
                        url = FileLocator.find((Bundle)bundle, (IPath)new Path("agent/" + os + "/" + machine + "/" + fnm), null);
                        --release;
                    }
                    if (url != null) break;
                    if (machine.equals("i686")) {
                        machine = "i586";
                        continue;
                    }
                    if (machine.equals("i586")) {
                        machine = "i486";
                        continue;
                    }
                    if (machine.equals("i486")) {
                        machine = "i386";
                        continue;
                    }
                    machine = machine0;
                    if (os_tag.startsWith("fc")) {
                        n = Integer.parseInt(os_tag.substring(2)) - 1;
                        if (n <= 0) break;
                        os_tag = "fc" + n;
                        continue;
                    }
                    if (!os_tag.startsWith("rh") || (n = Integer.parseInt(os_tag.substring(2)) - 1) <= 0) break;
                    os_tag = "rh" + n;
                }
                if (url == null) {
                    throw new Exception("Unsupported target OS or CPU");
                }
                inp = url.openStream();
                this.send("which base64", true);
                s = this.waitPrompt();
                if (s.indexOf(58) < 0) {
                    this.send("base64 -di >" + fnm, true);
                    this.sendBase64(inp);
                    this.shell.write("\u0004");
                    s = this.waitPrompt();
                    if (s.length() > 0) {
                        throw new Exception(s);
                    }
                } else {
                    this.send("which uudecode", true);
                    s = this.waitPrompt();
                    if (s.indexOf(58) < 0) {
                        this.send("uudecode", true);
                        this.send("begin-base64 644 " + fnm, true);
                        this.sendBase64(inp);
                        this.send("====", true);
                        s = this.waitPrompt();
                        if (s.length() > 0) {
                            throw new Exception(s);
                        }
                    } else {
                        throw new Exception("No base64 or uudecode commands available");
                    }
                }
                inp.close();
                this.send("rpm -e --quiet tcf-agent", true);
                this.waitPrompt();
                this.exec("rm -f /etc/init.d/tcf-agent*");
                this.exec("rpm -i --quiet " + fnm);
                this.exec("rm -f " + fnm);
                File certs = TCFSecurityManager.getCertificatesDirectory();
                File local_cert = new File(certs, "local.cert");
                File local_priv = new File(certs, "local.priv");
                if (!local_cert.exists() || !local_priv.exists()) {
                    this.copyRemoteSecret("local.cert", local_cert);
                    this.copyRemoteSecret("local.priv", local_priv);
                    this.exec("/usr/sbin/tcf-agent -c");
                }
                this.copyRemoteSecret("local.cert", new File(certs, String.valueOf(this.host) + ".cert"));
                this.copyLocalSecret(local_cert, String.valueOf(InetAddress.getLocalHost().getHostName()) + ".cert");
                if (!this.user.equals("root")) {
                    this.send("exit", true);
                    this.waitPrompt();
                }
            }
            catch (Throwable x) {
                error = x;
            }
            if (this.shell != null) {
                try {
                    this.shell.close();
                    this.shell = null;
                }
                catch (Throwable x) {
                    if (error == null) break block31;
                    error = x;
                }
            }
        }
        this.done(error);
    }

    private void sendBase64(InputStream inp) throws Exception {
        byte[] buf = new byte[768];
        while (true) {
            int len = 0;
            while (len < buf.length) {
                int rd = inp.read(buf, len, buf.length - len);
                if (rd < 0) break;
                len += rd;
            }
            if (len == 0) break;
            this.send(new String(Base64.toBase64((byte[])buf, (int)0, (int)len)), false);
        }
    }

    private void copyRemoteSecret(String from, File to) throws Exception {
        this.send("cat /etc/tcf/ssl/" + from, true);
        String s = this.waitPrompt();
        if (s.indexOf("-----BEGIN ") != 0) {
            throw new Exception(s);
        }
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), "ASCII"));
        wr.write(s);
        wr.close();
    }

    private void copyLocalSecret(File from, String to) throws Exception {
        String s;
        this.send("cat >/etc/tcf/ssl/" + to, true);
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(from), "ASCII"));
        while ((s = rd.readLine()) != null) {
            this.send(s, true);
        }
        this.shell.write("\u0004");
        s = this.waitPrompt();
        if (s.length() > 0) {
            throw new Exception(s);
        }
    }

    private void send(final String s, boolean log) throws IOException {
        if (log) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (WizardLogPage.this.log_text.isDisposed()) {
                        return;
                    }
                    WizardLogPage.this.log_text.append("Send: ");
                    WizardLogPage.this.log_text.append(s);
                    if (!s.endsWith("\n")) {
                        WizardLogPage.this.log_text.append("\n");
                    }
                }
            });
        }
        this.shell.write(s);
        this.shell.write("\n");
        if (log) {
            this.shell.expect(s);
        }
        this.shell.expect("\n");
    }

    private void expect(final String s, boolean log) throws IOException {
        if (log) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (WizardLogPage.this.log_text.isDisposed()) {
                        return;
                    }
                    WizardLogPage.this.log_text.append("Expect: ");
                    WizardLogPage.this.log_text.append(s);
                    if (!s.endsWith("\n")) {
                        WizardLogPage.this.log_text.append("\n");
                    }
                }
            });
        }
        this.shell.expect(s);
    }

    private String waitPrompt() throws IOException {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (WizardLogPage.this.log_text.isDisposed()) {
                    return;
                }
                WizardLogPage.this.log_text.append("Wait for shell prompt\n");
            }
        });
        final String s = this.shell.waitPrompt();
        if (s.length() > 0) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (WizardLogPage.this.log_text.isDisposed()) {
                        return;
                    }
                    WizardLogPage.this.log_text.append("Got: ");
                    WizardLogPage.this.log_text.append(s);
                    if (!s.endsWith("\n")) {
                        WizardLogPage.this.log_text.append("\n");
                    }
                }
            });
        }
        return s;
    }

    private void exec(String cmd) throws Exception {
        this.send(cmd, true);
        String s = this.waitPrompt();
        if (s.length() > 0) {
            throw new Exception(s);
        }
    }

    private void done(final Throwable error) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                WizardLogPage.this.thread = null;
                WizardLogPage.this.protocol = null;
                WizardLogPage.this.host = null;
                WizardLogPage.this.user = null;
                WizardLogPage.this.user_password = null;
                WizardLogPage.this.root_password = null;
                if (WizardLogPage.this.log_text.isDisposed()) {
                    return;
                }
                if (error != null) {
                    StringWriter buf = new StringWriter();
                    PrintWriter pwr = new PrintWriter(buf);
                    error.printStackTrace(pwr);
                    pwr.flush();
                    WizardLogPage.this.log_text.append(buf.toString());
                    WizardLogPage.this.setErrorMessage(String.valueOf(error.getClass().getName()) + ": " + error.getLocalizedMessage());
                } else {
                    WizardLogPage.this.log_text.append("Done\n");
                    WizardLogPage.this.setErrorMessage(null);
                }
                WizardLogPage.this.getContainer().updateButtons();
            }
        });
    }

    public IWizardPage getPreviousPage() {
        if (this.thread != null) {
            return null;
        }
        return this.wizard.getPage("LoginPage");
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean canFinish() {
        return this.thread == null && this.getErrorMessage() == null;
    }
}

