/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IExpressions;

public class TCFChildrenExpressions
extends TCFChildren {
    private final TCFNodeStackFrame node;
    private final IExpressionManager exp_manager;
    private final IExpressionsListener listener = new IExpressionsListener(){
        int generation;

        public void expressionsAdded(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsChanged(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsRemoved(IExpression[] expressions) {
            final int g = ++this.generation;
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    TCFChildrenExpressions.this.reset();
                    if (g != generation) {
                        return;
                    }
                    TCFChildrenExpressions.this.node.addModelDelta(1024);
                }
            });
        }
    };

    TCFChildrenExpressions(TCFNodeStackFrame node) {
        super(node.channel, 128);
        this.node = node;
        this.exp_manager = DebugPlugin.getDefault().getExpressionManager();
        this.exp_manager.addExpressionListener(this.listener);
    }

    public void dispose() {
        this.exp_manager.removeExpressionListener(this.listener);
        super.dispose();
    }

    void onSuspended() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended();
        }
    }

    private TCFNodeExpression findScript(String text) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!text.equals(e.getScript())) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        IExpressions exps = (IExpressions)this.node.model.getLaunch().getService(IExpressions.class);
        if (exps == null) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        int cnt = 0;
        IExpression[] iExpressionArray = this.exp_manager.getExpressions();
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression e = iExpressionArray[n2];
            String text = e.getExpressionText();
            TCFNodeExpression n3 = this.findScript(text);
            if (n3 == null) {
                n3 = new TCFNodeExpression(this.node, text, null, null, -1, false);
                this.add(n3);
            }
            n3.setSortPosition(cnt++);
            data.put(n3.id, n3);
            ++n2;
        }
        this.set(null, null, data);
        return true;
    }
}

