/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFDebugTask;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;

class TCFMemoryBlockRetrieval
implements IMemoryBlockRetrievalExtension {
    private final TCFNodeExecContext exec_ctx;

    TCFMemoryBlockRetrieval(TCFNodeExecContext exec_ctx) {
        this.exec_ctx = exec_ctx;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(final String expression, Object context) throws DebugException {
        return (IMemoryBlockExtension)new TCFDebugTask<IMemoryBlockExtension>(){

            public void run() {
                this.done((Object)new MemoryBlock(expression));
            }
        }.getD();
    }

    public IMemoryBlock getMemoryBlock(long address, long length) throws DebugException {
        return this.getExtendedMemoryBlock("0x" + Long.toHexString(address), this.exec_ctx);
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    private class MemoryBlock
    extends PlatformObject
    implements IMemoryBlockExtension {
        private final String expression;
        private final Set<Object> connections = new HashSet<Object>();
        private final TCFDataCache<IExpressions.Expression> remote_expression;
        private final TCFDataCache<IExpressions.Value> expression_value;
        private final TCFDataCache<ISymbols.Symbol> expression_type;
        private boolean disposed;

        MemoryBlock(final String expression) {
            this.expression = expression;
            final TCFLaunch launch = TCFMemoryBlockRetrieval.this.exec_ctx.getModel().getLaunch();
            IChannel channel = launch.getChannel();
            this.remote_expression = new TCFDataCache<IExpressions.Expression>(channel){

                protected boolean startDataRetrieval() {
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    if (exps == null) {
                        this.set(null, new Exception("Expressions service not available"), null);
                        return true;
                    }
                    this.command = exps.create(((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.id, null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                            if (MemoryBlock.this.disposed) {
                                IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                                exps.dispose(context.getID(), new IExpressions.DoneDispose(){

                                    public void doneDispose(IToken token, Exception error) {
                                        if (error == null) {
                                            return;
                                        }
                                        if (channel.getState() != 1) {
                                            return;
                                        }
                                        Activator.log("Error disposing remote expression evaluator", error);
                                    }
                                });
                                return;
                            }
                            this.set(token, error, context);
                        }
                    });
                    return false;
                }
            };
            this.expression_value = new TCFDataCache<IExpressions.Value>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.remote_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression ctx = (IExpressions.Expression)MemoryBlock.this.remote_expression.getData();
                    if (ctx == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    this.command = exps.evaluate(ctx.getID(), new IExpressions.DoneEvaluate(){

                        public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                            this.set(token, error, value);
                        }
                    });
                    return false;
                }
            };
            this.expression_type = new TCFDataCache<ISymbols.Symbol>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.expression_value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                    if (val == null) {
                        this.set(null, MemoryBlock.this.expression_value.getError(), null);
                        return true;
                    }
                    TCFDataCache<ISymbols.Symbol> type_cache = TCFMemoryBlockRetrieval.this.exec_ctx.getModel().getSymbolInfoCache(val.getTypeID());
                    if (type_cache == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    if (!type_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                    return true;
                }
            };
        }

        public synchronized void connect(Object client) {
            this.connections.add(client);
        }

        public synchronized void disconnect(Object client) {
            this.connections.remove(client);
        }

        public synchronized Object[] getConnections() {
            return this.connections.toArray(new Object[this.connections.size()]);
        }

        public void dispose() throws DebugException {
            new TCFDebugTask<Boolean>(){

                public void run() {
                    IChannel channel;
                    MemoryBlock.this.disposed = true;
                    MemoryBlock.this.expression_value.dispose();
                    MemoryBlock.this.expression_type.dispose();
                    if (MemoryBlock.this.remote_expression.isValid() && MemoryBlock.this.remote_expression.getData() != null && (channel = ((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.channel).getState() == 1) {
                        IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                        exps.dispose(((IExpressions.Expression)MemoryBlock.this.remote_expression.getData()).getID(), new IExpressions.DoneDispose(){

                            public void doneDispose(IToken token, Exception error) {
                                if (error == null) {
                                    return;
                                }
                                if (channel.getState() != 1) {
                                    return;
                                }
                                Activator.log("Error disposing remote expression evaluator", error);
                            }
                        });
                    }
                    this.done(Boolean.TRUE);
                }
            }.getD();
        }

        public int getAddressSize() throws DebugException {
            return (Integer)new TCFDebugTask<Integer>(){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                    } else {
                        TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                        if (mem == null) {
                            this.error("Context does not provide memory access");
                        } else {
                            this.done(mem.getAddressSize());
                        }
                    }
                }
            }.getD();
        }

        public int getAddressableSize() throws DebugException {
            return 1;
        }

        private BigInteger toBigInteger(byte[] data, boolean big_endian, boolean sign_extension) {
            byte[] temp = null;
            if (sign_extension) {
                temp = new byte[data.length];
            } else {
                temp = new byte[data.length + 1];
                temp[0] = 0;
            }
            if (big_endian) {
                System.arraycopy(data, 0, temp, sign_extension ? 0 : 1, data.length);
            } else {
                int i = 0;
                while (i < data.length) {
                    temp[temp.length - i - 1] = data[i];
                    ++i;
                }
            }
            return new BigInteger(temp);
        }

        public BigInteger getBigBaseAddress() throws DebugException {
            return (BigInteger)new TCFDebugTask<BigInteger>(){

                public void run() {
                    if (!MemoryBlock.this.expression_value.validate()) {
                        MemoryBlock.this.expression_value.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_value.getError() != null) {
                        this.error(MemoryBlock.this.expression_value.getError());
                    } else if (MemoryBlock.this.expression_value.getData() == null) {
                        this.error("Address expression evaluation failed");
                    } else if (!MemoryBlock.this.expression_type.validate()) {
                        MemoryBlock.this.expression_type.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_type.getError() != null) {
                        this.error(MemoryBlock.this.expression_type.getError());
                    } else {
                        IExpressions.Value value = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                        byte[] data = value.getValue();
                        if (data == null || data.length == 0) {
                            this.error("Address expression value is empty (void)");
                        } else {
                            ISymbols.Symbol type = (ISymbols.Symbol)MemoryBlock.this.expression_type.getData();
                            boolean signed = type != null && type.getTypeClass() == ISymbols.TypeClass.integer;
                            this.done(MemoryBlock.this.toBigInteger(data, value.isBigEndian(), signed));
                        }
                    }
                }
            }.getD();
        }

        public MemoryByte[] getBytesFromAddress(final BigInteger address, final long units) throws DebugException {
            return (MemoryByte[])new TCFDebugTask<MemoryByte[]>(){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                    } else {
                        TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        final IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                        if (mem == null) {
                            this.error("Context does not provide memory access");
                        } else {
                            int size = (int)units;
                            int mode = 3;
                            final byte[] buf = new byte[size];
                            mem.get((Number)address, 1, buf, 0, size, mode, new IMemory.DoneMemory(){

                                public void doneMemory(IToken token, IMemory.MemoryError error) {
                                    MemoryByte[] res = new MemoryByte[buf.length];
                                    int big_endian = 0;
                                    if (mem.getProperties().get("BigEndian") != null) {
                                        big_endian |= 0x20;
                                        if (mem.isBigEndian()) {
                                            big_endian |= 0x10;
                                        }
                                    }
                                    int i = 0;
                                    while (i < buf.length) {
                                        int flags = big_endian;
                                        if (error instanceof IMemory.ErrorOffset) {
                                            IMemory.ErrorOffset ofs = (IMemory.ErrorOffset)error;
                                            if (ofs.getStatus(i) == 0) {
                                                flags = 3;
                                            }
                                        } else if (error == null) {
                                            flags = 3;
                                        }
                                        res[i] = new MemoryByte(buf[i], (byte)flags);
                                        ++i;
                                    }
                                    this.done(res);
                                }
                            });
                        }
                    }
                }
            }.getD();
        }

        public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
            return this.getBytesFromAddress(this.getBigBaseAddress().add(offset), units);
        }

        public String getExpression() {
            return this.expression;
        }

        public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
            return TCFMemoryBlockRetrieval.this;
        }

        public long getStartAddress() {
            return 0L;
        }

        public long getLength() {
            return -1L;
        }

        public BigInteger getMemoryBlockStartAddress() throws DebugException {
            return null;
        }

        public BigInteger getMemoryBlockEndAddress() throws DebugException {
            return null;
        }

        public BigInteger getBigLength() throws DebugException {
            return BigInteger.valueOf(-1L);
        }

        public void setBaseAddress(BigInteger address) throws DebugException {
        }

        public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        }

        public boolean supportBaseAddressModification() throws DebugException {
            return false;
        }

        public boolean supportsChangeManagement() {
            return false;
        }

        public byte[] getBytes() throws DebugException {
            return null;
        }

        public void setValue(long offset, byte[] bytes) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return TCFMemoryBlockRetrieval.this.exec_ctx.getModel().getLaunch();
        }

        public String getModelIdentifier() {
            return "org.eclipse.tm.tcf.debug";
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IMemoryBlockRetrieval.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            if (adapter == IMemoryBlockRetrievalExtension.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            return super.getAdapter(adapter);
        }
    }
}

