/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class CaseBreakChecker
extends AbstractIndexAstChecker
implements ICheckerWithPreferences {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.CaseBreakProblem";
    public static final String PARAM_LAST_CASE = "last_case_param";
    public static final String PARAM_EMPTY_CASE = "empty_case_param";
    public static final String PARAM_NO_BREAK_COMMENT = "no_break_comment";
    public static final String DEFAULT_NO_BREAK_COMMENT = "no break";
    private Boolean _checkLastCase;
    private Boolean _checkEmptyCase;
    private String _noBreakComment;

    public String getTrimmedComment(IASTComment comment) {
        String str = new String(comment.getComment());
        str = comment.isBlockComment() ? str.substring(2, str.length() - 2) : str.substring(2);
        str = str.trim();
        return str;
    }

    public IASTComment getLeadingComment(IASTStatement statement) {
        return this.getCommentMap().getLastLeadingCommentForNode((IASTNode)statement);
    }

    public IASTComment getFreestandingComment(IASTStatement statement) {
        return this.getCommentMap().getLastFreestandingCommentForNode((IASTNode)statement);
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_NO_BREAK_COMMENT, CheckersMessages.CaseBreakChecker_DefaultNoBreakCommentDescription, DEFAULT_NO_BREAK_COMMENT);
        this.addPreference(problem, PARAM_LAST_CASE, CheckersMessages.CaseBreakChecker_LastCaseDescription, Boolean.TRUE);
        this.addPreference(problem, PARAM_EMPTY_CASE, CheckersMessages.CaseBreakChecker_EmptyCaseDescription, Boolean.FALSE);
    }

    public void processAst(IASTTranslationUnit ast) {
        this._checkLastCase = (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_LAST_CASE);
        this._checkEmptyCase = (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_EMPTY_CASE);
        this._noBreakComment = (String)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_NO_BREAK_COMMENT);
        SwitchFindingVisitor visitor = new SwitchFindingVisitor();
        ast.accept((ASTVisitor)visitor);
    }

    class SwitchFindingVisitor
    extends ASTVisitor {
        SwitchFindingVisitor() {
            this.shouldVisitStatements = true;
        }

        protected boolean isBreakOrExitStatement(IASTStatement statement) {
            CxxAstUtils utils = CxxAstUtils.getInstance();
            return statement instanceof IASTBreakStatement || statement instanceof IASTReturnStatement || statement instanceof IASTContinueStatement || statement instanceof IASTGotoStatement || utils.isThrowStatement((IASTNode)statement) || utils.isExitStatement((IASTNode)statement);
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTSwitchStatement && !this.isProducedMyMacroExpansion(statement)) {
                IASTSwitchStatement switchStmt = (IASTSwitchStatement)statement;
                IASTStatement body = switchStmt.getBody();
                if (body instanceof IASTCompoundStatement) {
                    IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
                    IASTStatement prevCase = null;
                    int i = 0;
                    while (i < statements.length) {
                        IASTStatement curr = statements[i];
                        if (curr instanceof IASTSwitchStatement) {
                            this.visit(curr);
                        }
                        IASTStatement next = null;
                        if (i < statements.length - 1) {
                            next = statements[i + 1];
                        }
                        if (this.isCaseStatement(curr)) {
                            prevCase = curr;
                        }
                        if (!(prevCase == null || !this.isCaseStatement(next) && next != null || !CaseBreakChecker.this._checkEmptyCase.booleanValue() && this.isCaseStatement(curr) && next != null || !CaseBreakChecker.this._checkLastCase.booleanValue() && next == null || !this.isFallThroughStamement(curr))) {
                            String str;
                            IASTComment comment = null;
                            if (next != null) {
                                comment = CaseBreakChecker.this.getLeadingComment(next);
                            } else {
                                comment = CaseBreakChecker.this.getFreestandingComment(statement);
                                if (comment == null) {
                                    comment = CaseBreakChecker.this.getFreestandingComment(body);
                                }
                            }
                            if (comment == null || !(str = CaseBreakChecker.this.getTrimmedComment(comment)).equalsIgnoreCase(CaseBreakChecker.this._noBreakComment)) {
                                CaseBreakChecker.this.reportProblem(CaseBreakChecker.ER_ID, (IASTNode)prevCase, new Object[]{null});
                            }
                        }
                        ++i;
                    }
                }
                return 1;
            }
            return 3;
        }

        public boolean isCaseStatement(IASTStatement statement) {
            return statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement;
        }

        public boolean isFallThroughStamement(IASTStatement body) {
            if (body == null) {
                return true;
            }
            if (body instanceof IASTCompoundStatement) {
                IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
                return this.isFallThroughStamement(statements[statements.length - 1]);
            }
            if (this.isBreakOrExitStatement(body)) {
                return false;
            }
            if (body instanceof IASTExpressionStatement) {
                return true;
            }
            if (body instanceof IASTIfStatement) {
                IASTIfStatement ifs = (IASTIfStatement)body;
                return this.isFallThroughStamement(ifs.getThenClause()) || this.isFallThroughStamement(ifs.getElseClause());
            }
            return true;
        }

        private boolean isProducedMyMacroExpansion(IASTStatement statement) {
            IASTNodeLocation[] locations = statement.getNodeLocations();
            return locations.length > 0 && locations[0] instanceof IASTMacroExpansionLocation && (locations.length == 1 || locations.length == 2 && locations[1].getNodeLength() == 1);
        }
    }
}

