/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.cxx;

import org.eclipse.cdt.codan.core.cxx.internal.model.CxxCodanReconciler;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodanCReconciler
implements ICReconcilingListener {
    private CxxCodanReconciler reconsiler = new CxxCodanReconciler();

    void install(ITextEditor editor) {
        if (editor instanceof CEditor) {
            this.initialize();
            ((CEditor)editor).addReconcileListener((ICReconcilingListener)this);
        }
    }

    void uninstall(ITextEditor editor) {
        if (editor instanceof CEditor) {
            this.initialize();
            ((CEditor)editor).removeReconcileListener((ICReconcilingListener)this);
        }
    }

    private void initialize() {
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (ast == null) {
            return;
        }
        ITranslationUnit tu = ast.getOriginatingTranslationUnit();
        if (tu == null) {
            return;
        }
        IResource resource = tu.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        IPreferenceStore store = CodanUIActivator.getDefault().getPreferenceStore(project);
        if (store.getBoolean("inEditor")) {
            this.reconsiler.reconciledAst(ast, resource, progressMonitor);
        }
    }
}

