/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.IReferenceType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.debug.edc.symbols.VariableLocationFactory;
import org.eclipse.core.runtime.CoreException;

public class FieldReference
extends CompoundInstruction {
    private final IASTFieldReference refExpression;

    public FieldReference(IASTFieldReference expression, int start) {
        super(start);
        this.refExpression = expression;
    }

    public void execute() throws CoreException {
        OperandValue operand = this.popValue();
        if (operand == null) {
            return;
        }
        IType variableType = TypeUtils.getStrippedType(operand.getValueType());
        IVariableLocation location = null;
        boolean referenceType = variableType instanceof IReferenceType;
        if (this.refExpression.isPointerDereference()) {
            boolean validPointerType = variableType instanceof IPointerType;
            if (!validPointerType) {
                throw EDCDebugger.newCoreException(ASTEvalMessages.FieldReference_InvalidPointerDeref);
            }
            IPointerType pointer = (IPointerType)variableType;
            IType pointedTo = pointer.getType();
            variableType = TypeUtils.getStrippedType(pointedTo);
        } else if (referenceType) {
            IReferenceType pointer = (IReferenceType)variableType;
            IType pointedTo = pointer.getType();
            variableType = TypeUtils.getStrippedType(pointedTo);
        }
        if (!TypeUtils.isCompositeType(variableType)) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.FieldReference_InvalidDotDeref);
        }
        ICompositeType compositeType = (ICompositeType)variableType;
        String fieldName = this.refExpression.getFieldName().toString();
        IField[] fields = compositeType.findFields(fieldName);
        if (fields == null) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.FieldReference_InvalidMember, fieldName));
        }
        if (fields.length > 1) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.FieldReference_AmbiguousMember, fieldName, operand.getValueType().getName()));
        }
        IField field = fields[0];
        IType typeOfField = field.getType();
        location = this.refExpression.isPointerDereference() || !this.refExpression.isPointerDereference() && referenceType ? VariableLocationFactory.createMemoryVariableLocation(this.fInterpreter.getServicesTracker(), this.fInterpreter.getContext(), operand.getValue()) : operand.getValueLocation();
        location = location.addOffset(field.getFieldOffset());
        OperandValue varValue = new OperandValue(typeOfField, field.getBitSize() > 0);
        if ((typeOfField = TypeUtils.getStrippedType(typeOfField)) instanceof ICPPBasicType || typeOfField instanceof IPointerType || typeOfField instanceof IEnumeration || typeOfField instanceof IReferenceType) {
            int byteSize = typeOfField.getByteSize();
            if (!(byteSize == 1 || byteSize == 2 || byteSize == 4 || byteSize == 8 || typeOfField instanceof IPointerType && byteSize == 0)) {
                throw EDCDebugger.newCoreException(String.valueOf(ASTEvalMessages.FieldReference_UnhandledOperandSize) + byteSize);
            }
            Number newValue = varValue.getValueByType(typeOfField, location);
            if (field.getBitSize() > 0) {
                int bitSize = field.getBitSize();
                int bitOffset = field.getBitOffset();
                boolean isSignedInt = false;
                if (typeOfField instanceof ICPPBasicType) {
                    isSignedInt = ((ICPPBasicType)typeOfField).isSigned();
                } else if (typeOfField instanceof IEnumeration) {
                    isSignedInt = true;
                }
                newValue = TypeUtils.extractBitField(newValue, byteSize, bitSize, bitOffset, isSignedInt);
            }
            varValue.setValue(newValue);
            varValue.setValueLocation(location);
        } else if (typeOfField instanceof IAggregate) {
            varValue.setAddressValue(location);
            varValue.setValueLocation(location);
        } else {
            throw EDCDebugger.newCoreException(ASTEvalMessages.FieldReference_CannotDereferenceType);
        }
        this.push(varValue);
    }
}

