/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section
implements ISection {
    private final int id;
    private final long size;
    private final IAddress linkAddress;
    private final Map<String, Object> properties;

    public Section(int id, long size, IAddress linkAddress, Map<String, Object> properties) {
        this.id = id;
        this.size = size;
        this.linkAddress = linkAddress;
        this.properties = new HashMap<String, Object>(properties);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public IAddress getLinkAddress() {
        return this.linkAddress;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        return MessageFormat.format("[sectionID={0}, link address={1}]", this.id, this.linkAddress.toHexAddressString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Section other = (Section)obj;
        if (this.linkAddress != other.linkAddress) {
            return false;
        }
        return this.id == other.id;
    }
}

