/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import org.eclipse.cdt.debug.edc.internal.symbols.IForwardTypeReference;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.core.runtime.IPath;

public class Variable
implements IVariable {
    protected String name;
    protected IScope scope;
    protected IType type;
    protected ILocationProvider locationProvider;
    protected long startScope;
    protected boolean isDeclared;
    protected IPath definingFile;

    public Variable(String name, IScope scope, IType type, ILocationProvider locationProvider, boolean isDeclared, IPath definingFile) {
        this.name = name;
        this.scope = scope;
        this.type = type;
        this.locationProvider = locationProvider;
        this.isDeclared = isDeclared;
        this.definingFile = definingFile;
    }

    public void dispose() {
        this.type = null;
        this.locationProvider = null;
        this.scope = null;
    }

    public String getName() {
        return this.name;
    }

    public IScope getScope() {
        return this.scope;
    }

    public IType getType() {
        if (this.type instanceof IForwardTypeReference) {
            this.type = ((IForwardTypeReference)this.type).getReferencedType();
        }
        return this.type;
    }

    public ILocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public void setStartScope(long start) {
        this.startScope = start;
    }

    public long getStartScope() {
        return this.startScope;
    }

    public boolean isDeclared() {
        return this.isDeclared;
    }

    public IPath getDefiningFile() {
        return this.definingFile;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Var [");
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.scope != null) {
            builder.append(", ");
            builder.append("scope=");
            builder.append(this.scope.getName());
        }
        builder.append("]");
        return builder.toString();
    }
}

