/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.commands.ISelectPrevTraceRecordHandler;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbSelectPrevTraceRecordCommand
extends AbstractDebugCommand
implements ISelectPrevTraceRecordHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSession fSession;

    public GdbSelectPrevTraceRecordCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
        this.fSession = session;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return;
        }
        Query<Object> selectRecordQuery = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> rm) {
                final IGDBTraceControl traceControl = (IGDBTraceControl)GdbSelectPrevTraceRecordCommand.this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.getCurrentTraceRecordContext(dmc, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext>((Executor)GdbSelectPrevTraceRecordCommand.this.fExecutor, rm){

                        protected void handleSuccess() {
                            final IGDBTraceControl.ITraceRecordDMContext prevDmc = traceControl.createPrevRecordContext((IGDBTraceControl.ITraceRecordDMContext)this.getData());
                            traceControl.selectTraceRecord(prevDmc, new RequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                                protected void handleSuccess() {
                                    GdbSelectPrevTraceRecordCommand.this.fSession.dispatchEvent((Object)new GDBTraceControl_7_2.TraceRecordSelectedChangedEvent(prevDmc), new Hashtable());
                                    rm.done();
                                }
                            });
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)selectRecordQuery);
            selectRecordQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return false;
        }
        Query<Boolean> canSelectRecordQuery = new Query<Boolean>(){

            public void execute(final DataRequestMonitor<Boolean> rm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)GdbSelectPrevTraceRecordCommand.this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.getTraceStatus(dmc, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceStatusDMData>((Executor)GdbSelectPrevTraceRecordCommand.this.fExecutor, rm){

                        protected void handleSuccess() {
                            if (((IGDBTraceControl.ITraceStatusDMData)this.getData()).getNumberOfCollectedFrame() > 0) {
                                IGDBTraceControl traceControl = (IGDBTraceControl)GdbSelectPrevTraceRecordCommand.this.fTracker.getService(IGDBTraceControl.class);
                                if (traceControl != null) {
                                    traceControl.isTracing(dmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbSelectPrevTraceRecordCommand.this.fExecutor, (RequestMonitor)rm){

                                        protected void handleSuccess() {
                                            rm.setData((Object)((Boolean)this.getData() == false ? 1 : 0));
                                            rm.done();
                                        }
                                    });
                                } else {
                                    rm.setData((Object)false);
                                    rm.done();
                                }
                            } else {
                                rm.setData((Object)false);
                                rm.done();
                            }
                        }
                    });
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canSelectRecordQuery);
            return (Boolean)canSelectRecordQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }
}

