/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.KVStringPair;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SCDOptionsEnum;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCommandDSC {
    protected static final String SINGLE_SPACE = " ";
    protected static final String CMD_DESCRIPTION_ELEM = "commandDescription";
    protected static final String CMD_SI_ELEM = "commandScannerInfo";
    protected static final String OPTION_ELEM = "option";
    protected static final String SI_ITEM_ELEM = "siItem";
    protected static final String KEY_ATTR = "key";
    protected static final String VALUE_ATTR = "value";
    protected static final String QUOTE_INCLUDE_ATTR = "quote";
    protected static final String KIND_ATTR = "kind";
    protected int commandId;
    protected List<KVStringPair> compilerCommand = new ArrayList<KVStringPair>();
    protected boolean discovered = false;
    protected boolean cppFileType;
    protected IProject project;
    protected List<String> symbols;
    protected List<String> includes;
    protected List<String> quoteIncludes;

    public CCommandDSC(boolean cppFileType) {
        this(cppFileType, null);
    }

    public CCommandDSC(boolean cppFileType, IProject project) {
        this.cppFileType = cppFileType;
        this.symbols = new ArrayList<String>();
        this.includes = new ArrayList<String>();
        this.quoteIncludes = new ArrayList<String>();
        this.project = project;
    }

    public boolean appliesToCPPFileType() {
        return this.cppFileType;
    }

    public void addSCOption(KVStringPair option) {
        if (this.project != null && (option.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString()) || option.getKey().equals(SCDOptionsEnum.INCLUDE.toString()) || option.getKey().equals(SCDOptionsEnum.ISYSTEM.toString()) || option.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString()) || option.getKey().equals(SCDOptionsEnum.IQUOTE.toString()))) {
            String value = option.getValue();
            value = CygpathTranslator.translateIncludePaths(this.project, Collections.singletonList(value)).get(0);
            value = SafeStringInterner.safeIntern((String)CCommandDSC.makeRelative(this.project, (IPath)new Path(value)).toOSString());
            option = new KVStringPair(option.getKey(), value);
        }
        this.compilerCommand.add(option);
    }

    public Integer getCommandIdAsInteger() {
        return new Integer(this.getCommandId());
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public String toString() {
        String commandAsString = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            String value = optionPair.getValue();
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + value + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public int getId() {
        return this.commandId;
    }

    public String getSCDRunnableCommand(boolean quoteIncludePaths, boolean quoteDefines) {
        String commandAsString = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (optionPair.getKey().equals(SCDOptionsEnum.COMMAND.toString())) {
                commandAsString = String.valueOf(commandAsString) + optionPair.getValue() + SINGLE_SPACE;
                continue;
            }
            if (optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString()) || optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            String value = optionPair.getValue();
            if (optionPair.getKey().equals(SCDOptionsEnum.INCLUDE.toString()) || optionPair.getKey().equals(SCDOptionsEnum.ISYSTEM.toString()) || optionPair.getKey().equals(SCDOptionsEnum.IQUOTE.toString())) {
                value = CCommandDSC.makeAbsolute(this.project, value);
                if (quoteIncludePaths) {
                    value = "\"" + value + "\"";
                }
            } else if (quoteDefines && optionPair.getKey().equals(SCDOptionsEnum.DEFINE.toString())) {
                if (value.indexOf(39) == -1) {
                    value = "'" + value + "'";
                } else {
                    value = value.replaceAll("\"", "\\\\\"");
                    value = "\"" + value + "\"";
                }
            }
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + value + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public String getCompilerName() {
        String compiler = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.COMMAND.toString())) continue;
            compiler = optionPair.getValue();
            break;
        }
        return compiler.trim();
    }

    public List<String> getImacrosFile() {
        ArrayList<String> imacrosFiles = new ArrayList<String>();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString())) continue;
            imacrosFiles.add(CCommandDSC.makeAbsolute(this.project, optionPair.getValue()));
        }
        return imacrosFiles;
    }

    public List<String> getIncludeFile() {
        ArrayList<String> includeFiles = new ArrayList<String>();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            includeFiles.add(CCommandDSC.makeAbsolute(this.project, optionPair.getValue()));
        }
        return includeFiles;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0.getClass().equals(this.getClass())) {
            CCommandDSC other = (CCommandDSC)arg0;
            return this.compilerCommand.equals(other.compilerCommand) && this.cppFileType == other.cppFileType;
        }
        return false;
    }

    public int hashCode() {
        return this.compilerCommand.hashCode();
    }

    public List<String> getIncludes() {
        return CCommandDSC.makeAbsolute(this.project, this.includes);
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getQuoteIncludes() {
        return CCommandDSC.makeAbsolute(this.project, this.quoteIncludes);
    }

    public void setQuoteIncludes(List<String> includes) {
        this.quoteIncludes = includes;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<String> symbols) {
        this.symbols = symbols;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    public void serialize(Element cmdElem) {
        Element siItem;
        Document doc = cmdElem.getOwnerDocument();
        Element cmdDescElem = doc.createElement(CMD_DESCRIPTION_ELEM);
        Iterator<KVStringPair> i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            Element optionElem = doc.createElement(OPTION_ELEM);
            KVStringPair option = i.next();
            optionElem.setAttribute(KEY_ATTR, option.getKey());
            optionElem.setAttribute(VALUE_ATTR, option.getValue());
            cmdDescElem.appendChild(optionElem);
        }
        cmdElem.appendChild(cmdDescElem);
        Element siElem = doc.createElement(CMD_SI_ELEM);
        Iterator<String> j = this.quoteIncludes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, j.next());
            siItem.setAttribute(QUOTE_INCLUDE_ATTR, "true");
            siElem.appendChild(siItem);
        }
        j = this.includes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, j.next());
            siElem.appendChild(siItem);
        }
        j = this.symbols.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "SYMBOL_DEFINITION");
            siItem.setAttribute(VALUE_ATTR, j.next());
            siElem.appendChild(siItem);
        }
        cmdElem.appendChild(siElem);
    }

    public void deserialize(Element cmdElem) {
        NodeList siList;
        NodeList descList = cmdElem.getElementsByTagName(CMD_DESCRIPTION_ELEM);
        if (descList.getLength() > 0) {
            Element descElem = (Element)descList.item(0);
            NodeList optionList = descElem.getElementsByTagName(OPTION_ELEM);
            int i = 0;
            while (i < optionList.getLength()) {
                Element optionElem = (Element)optionList.item(i);
                String key = SafeStringInterner.safeIntern((String)optionElem.getAttribute(KEY_ATTR));
                String value = SafeStringInterner.safeIntern((String)optionElem.getAttribute(VALUE_ATTR));
                KVStringPair option = new KVStringPair(key, value);
                this.addSCOption(option);
                ++i;
            }
        }
        if ((siList = cmdElem.getElementsByTagName(CMD_SI_ELEM)).getLength() > 0) {
            Element siElem = (Element)siList.item(0);
            NodeList siItemList = siElem.getElementsByTagName(SI_ITEM_ELEM);
            int i = 0;
            while (i < siItemList.getLength()) {
                Element siItemElem = (Element)siItemList.item(i);
                String kind = siItemElem.getAttribute(KIND_ATTR);
                String value = siItemElem.getAttribute(VALUE_ATTR);
                String quote = siItemElem.getAttribute(QUOTE_INCLUDE_ATTR);
                if (kind.equals("INCLUDE_PATH")) {
                    if (quote.equals("true")) {
                        this.quoteIncludes.add(SafeStringInterner.safeIntern((String)value));
                    } else {
                        this.includes.add(value);
                    }
                } else if (kind.equals("SYMBOL_DEFINITION")) {
                    this.symbols.add(SafeStringInterner.safeIntern((String)value));
                }
                ++i;
            }
            this.setDiscovered(true);
        }
    }

    public void resolveOptions(IProject project) {
        if (!this.isDiscovered()) {
            ArrayList<String> symbols = new ArrayList<String>();
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> quoteincludes = new ArrayList<String>();
            for (KVStringPair optionPair : this.compilerCommand) {
                String key = optionPair.getKey();
                String value = optionPair.getValue();
                if (key.equals(SCDOptionsEnum.INCLUDE.toString()) || key.equals(SCDOptionsEnum.ISYSTEM.toString())) {
                    includes.add(SafeStringInterner.safeIntern((String)value));
                    continue;
                }
                if (key.equals(SCDOptionsEnum.IQUOTE.toString())) {
                    quoteincludes.add(SafeStringInterner.safeIntern((String)value));
                    continue;
                }
                if (!key.equals(SCDOptionsEnum.DEFINE.toString())) continue;
                symbols.add(SafeStringInterner.safeIntern((String)value));
            }
            this.setIncludes(includes);
            this.setQuoteIncludes(quoteincludes);
            this.setSymbols(symbols);
        }
        this.setDiscovered(true);
    }

    public static IPath makeRelative(IProject project, IPath path) {
        IResource resource = CCommandDSC.findResource(project, path);
        if (resource != null && resource.getProject() == project) {
            path = resource.getProjectRelativePath();
        }
        return path;
    }

    protected static IResource findResource(IProject project, IPath path) {
        IWorkspaceRoot root;
        IResource resource = project.findMember(path, false);
        if (resource == null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path, false)) == null) {
            resource = ResourceLookup.selectFileForLocation((IPath)path, (IProject)project);
        }
        return resource;
    }

    public static List<String> makeRelative(IProject project, List<String> paths) {
        ArrayList<String> list = new ArrayList<String>(paths.size());
        for (String path : paths) {
            path = CCommandDSC.makeRelative(project, (IPath)new Path(path)).toOSString();
            list.add(SafeStringInterner.safeIntern((String)path));
        }
        return list;
    }

    public static final String makeAbsolute(IProject project, String path) {
        IResource res;
        Path ppath = new Path(path);
        if (project != null && !ppath.isAbsolute() && (res = project.findMember((IPath)ppath)) != null && (ppath = res.getLocation()) != null) {
            path = ppath.toOSString();
        }
        return SafeStringInterner.safeIntern((String)path);
    }

    public static List<String> makeAbsolute(IProject project, List<String> paths) {
        ArrayList<String> list = new ArrayList<String>(paths.size());
        for (String path : paths) {
            path = CCommandDSC.makeAbsolute(project, path);
            list.add(SafeStringInterner.safeIntern((String)path));
        }
        return list;
    }
}

