/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChainModificationTests
extends TestCase {
    private static final String PROJ_NAME_PREFIX = "TCM_";

    public static Test suite() {
        TestSuite suite = new TestSuite(ToolChainModificationTests.class);
        return suite;
    }

    public void testRootToolChainStatus() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p1");
        BuildSystemTestHelper.createDescription(project, "tcm.pt");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        IToolChain[] ctcs = cfgM.getCompatibleToolChains();
        HashSet<IHoldsOptions> set = new HashSet<IHoldsOptions>();
        FolderInfo foInfo = (FolderInfo)cfg.getRootFolderInfo();
        ToolChain tc = (ToolChain)foInfo.getToolChain();
        IToolChain[] allSys = ManagedBuildManager.getRealToolChains();
        this.filterPropsSupported(foInfo, tc, allSys, set);
        set.remove(ManagedBuildManager.getRealToolChain((IToolChain)tc));
        IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc2");
        incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
        set.remove(incompatibleTc);
        this.compare(Arrays.asList(ctcs), set);
        HashSet<IToolChain> incomp = new HashSet<IToolChain>(Arrays.asList(allSys));
        incomp.removeAll(Arrays.asList(ctcs));
        ToolChainModificationTests.assertTrue((boolean)incomp.contains(incompatibleTc));
        IBuilder[] cbs = cfgM.getCompatibleBuilders();
        HashSet<IHoldsOptions> bSet = new HashSet<IHoldsOptions>();
        IBuilder[] allSysB = ManagedBuildManager.getRealBuilders();
        this.filterPropsSupported(cfg, allSysB, bSet);
        IBuilder incompatibleB = ManagedBuildManager.getExtensionBuilder((String)"tcm.tc4.b1");
        incompatibleB = ManagedBuildManager.getRealBuilder((IBuilder)incompatibleB);
        bSet.remove(cfgM.getRealBuilder());
        bSet.remove(incompatibleB);
        this.compare(Arrays.asList(cbs), bSet);
        HashSet<IBuilder> incompB = new HashSet<IBuilder>(Arrays.asList(allSysB));
        incompB.removeAll(Arrays.asList(cbs));
        ToolChainModificationTests.assertTrue((boolean)incompB.contains(incompatibleB));
        IToolChain tc3 = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc3");
        cfgM.setToolChain(tc3);
        ToolChainModificationTests.assertEquals((Object)tc3, (Object)cfgM.getToolChain());
        ToolChainModificationTests.assertEquals((Object)tc3.getBuilder(), (Object)cfgM.getBuilder());
        IBuilder b5 = ManagedBuildManager.getExtensionBuilder((String)"tcm.tc5.b1");
        cfgM.setBuilder(b5);
        ToolChainModificationTests.assertEquals((Object)tc3, (Object)cfgM.getToolChain());
        ToolChainModificationTests.assertEquals((Object)b5, (Object)cfgM.getBuilder());
        project.delete(true, null);
    }

    private HashSet<IHoldsOptions> filterSupportedToolChains(IFolderInfo foInfo, IToolChain tc) {
        HashSet<IHoldsOptions> set = new HashSet<IHoldsOptions>();
        IToolChain[] allSys = ManagedBuildManager.getRealToolChains();
        this.filterPropsSupported((FolderInfo)foInfo, (ToolChain)tc, allSys, set);
        set.remove(ManagedBuildManager.getRealToolChain((IToolChain)tc));
        return set;
    }

    public void testChildToolChainStatus() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p2");
        BuildSystemTestHelper.createDescription(project, "tcm.pt2");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        HashSet<IHoldsOptions> set = this.filterSupportedToolChains(cfg.getRootFolderInfo(), cfg.getToolChain());
        IToolChain[] tcs = cfgM.getCompatibleToolChains();
        this.compare(Arrays.asList(tcs), set);
        tcs = foM.getCompatibleToolChains();
        set = this.filterSupportedToolChains(foInfo, foInfo.getToolChain());
        IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc3");
        incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
        set.remove(incompatibleTc);
        this.compare(Arrays.asList(tcs), set);
        foM.setToolChain(incompatibleTc);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        foInfo.changeToolChain(incompatibleTc, CDataUtil.genId((String)"blah.blah"), incompatibleTc.getName());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        project.delete(true, null);
    }

    public void testChildToolChainStatus2() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p3");
        BuildSystemTestHelper.createDescription(project, "tcm.pt.derive1");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        HashSet<IHoldsOptions> set = this.filterSupportedToolChains(cfg.getRootFolderInfo(), cfg.getToolChain());
        IToolChain[] tcs = cfgM.getCompatibleToolChains();
        this.compare(Arrays.asList(tcs), set);
        tcs = foM.getCompatibleToolChains();
        set = this.filterSupportedToolChains(foInfo, foInfo.getToolChain());
        this.rmToolChains(set, new String[]{"tcm.base2.tc", "tcm.derive2.tc1", "tcm.derive2.tc2", "tcm2.tc2", "tcm2.tc", "tcm2.tc.derive"});
        this.compare(Arrays.asList(tcs), set);
        foM.setToolChain(ManagedBuildManager.getExtensionToolChain((String)"tcm.derive2.tc1"));
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        foInfo.changeToolChain(ManagedBuildManager.getExtensionToolChain((String)"tcm.derive2.tc1"), CDataUtil.genId((String)"blah.blah"), null);
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        project.delete(true, null);
    }

    private void rmToolChains(Set<IHoldsOptions> set, String[] ids) {
        int i = 0;
        while (i < ids.length) {
            IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)ids[i]);
            ToolChainModificationTests.assertNotNull((String)("no tool-chain of id " + ids[i]), (Object)incompatibleTc);
            incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
            ToolChainModificationTests.assertTrue((String)("set does not contain tc \"" + incompatibleTc.getId() + "\" which is a real tc for \"" + ids[i] + "\""), (boolean)set.remove(incompatibleTc));
            ++i;
        }
    }

    private void compare(Collection<? extends IHoldsOptions> c1, Collection<IHoldsOptions> c2) {
        HashSet<? extends IHoldsOptions> s1 = new HashSet<IHoldsOptions>(c1);
        HashSet<? extends IHoldsOptions> s1c = new HashSet<IHoldsOptions>(s1);
        HashSet<IHoldsOptions> s2 = new HashSet<IHoldsOptions>(c2);
        s1.removeAll(s2);
        s2.removeAll(s1c);
        StringBuffer buf = new StringBuffer();
        buf.append("checking c1..\n");
        boolean fail = this.checkEmpty(s1, buf);
        buf.append("checking c2..\n");
        if (fail |= this.checkEmpty(s2, buf)) {
            ToolChainModificationTests.fail((String)buf.toString());
        }
    }

    private boolean checkEmpty(Collection<? extends IBuildObject> c, StringBuffer buf) {
        if (c.size() != 0) {
            buf.append("non-empty dump:\n");
            for (IBuildObject iBuildObject : c) {
                buf.append("\t ").append(iBuildObject.getId()).append('\n');
            }
            buf.append("end\n");
            return true;
        }
        return false;
    }

    private Collection<IHoldsOptions> filterPropsSupported(FolderInfo foInfo, ToolChain tc, IToolChain[] tcs, Collection<IHoldsOptions> c) {
        if (c == null) {
            c = new ArrayList<IHoldsOptions>();
        }
        int i = 0;
        while (i < tcs.length) {
            if (foInfo.isToolChainCompatible(tc, tcs[i])) {
                c.add((IHoldsOptions)tcs[i]);
            }
            ++i;
        }
        return c;
    }

    private Collection<IHoldsOptions> filterPropsSupported(IConfiguration cfg, IBuilder[] bs, Collection<IHoldsOptions> c) {
        if (c == null) {
            c = new ArrayList<IHoldsOptions>();
        }
        int i = 0;
        while (i < bs.length) {
            if (cfg.isBuilderCompatible(bs[i])) {
                c.add((IHoldsOptions)bs[i]);
            }
            ++i;
        }
        return c;
    }

    private boolean getReplacementToolInfo(IModificationOperation[] ops, Set<ITool> set) {
        boolean removable = false;
        int i = 0;
        while (i < ops.length) {
            ITool tool = ops[i].getReplacementTool();
            if (tool == null) {
                removable = true;
            } else {
                set.add(tool);
            }
            ++i;
        }
        return removable;
    }

    public void testToolModificationWithChild() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p4");
        BuildSystemTestHelper.createDescription(project, "tcm.pt");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChain tc4 = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc4");
        cfg.getRootFolderInfo().changeToolChain(tc4, CDataUtil.genId(null), null);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        ITool tool41 = ManagedBuildManager.getExtensionTool((String)"tcm.tc4.t1");
        IToolModification tm = cfgM.getToolModification(tool41);
        ToolChainModificationTests.assertTrue((boolean)tm.isProjectTool());
        IModificationOperation[] ops = tm.getSupportedOperations();
        ITool tool31 = ManagedBuildManager.getExtensionTool((String)"tcm.tc3.t1");
        HashSet<Object> replacement = new HashSet<ITool>();
        boolean removable = this.getReplacementToolInfo(ops, replacement);
        ToolChainModificationTests.assertFalse((boolean)removable);
        ToolChainModificationTests.assertTrue((boolean)replacement.contains(tool31));
        tm = foM.getToolModification(tool41);
        ToolChainModificationTests.assertTrue((boolean)tm.isProjectTool());
        ops = tm.getSupportedOperations();
        replacement = new HashSet();
        removable = this.getReplacementToolInfo(ops, replacement);
        ToolChainModificationTests.assertFalse((boolean)removable);
        ToolChainModificationTests.assertFalse((boolean)replacement.contains(tool31));
        project.delete(true, null);
    }
}

