/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.projectmodel.tests;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;

public class BackwardCompatiblityTests
extends TestCase {
    private static final String TEST_3X_STD_MAKE_PROJECTS = "test3xStdMakeProjects";
    private List<IProject> projList = new LinkedList<IProject>();

    public static Test suite() {
        return new TestSuite(BackwardCompatiblityTests.class);
    }

    public void test3xStdMakeProject() {
        String PROJ_NAME = "std_cpp_1";
        IProject project = this.loadStdProject(PROJ_NAME);
        this.projList.add(project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        BackwardCompatiblityTests.assertFalse((boolean)mngr.isNewStyleProject(project));
        ICProjectDescription des = mngr.getProjectDescription(project, false);
        this.checkDescription(des);
        des = mngr.getProjectDescription(project, true);
        this.checkDescription(des);
    }

    private void checkDescription(ICProjectDescription des) {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        BackwardCompatiblityTests.assertFalse((boolean)mngr.isNewStyleProject(des));
        BackwardCompatiblityTests.assertFalse((boolean)des.isCdtProjectCreating());
        BackwardCompatiblityTests.assertEquals((int)1, (int)des.getConfigurations().length);
    }

    private IProject loadStdProject(String name) {
        return ManagedBuildTestHelper.loadProject(name, TEST_3X_STD_MAKE_PROJECTS);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        Iterator<IProject> iter = this.projList.iterator();
        while (iter.hasNext()) {
            IProject proj = iter.next();
            try {
                proj.delete(true, null);
            }
            catch (Exception exception) {}
            iter.remove();
        }
        super.tearDown();
    }
}

